'TY2KG001 03MAR00 - V1.1

SCREEN 9: COLOR 15, 1: DIM cap(55), cap$(55), res(217), res$(217)
DIM hres%(380), vres%(380), hcap%(200), vcap%(1380), r(10), col(15)
DIM wave(190), volts$(50), c(4), dot%(200), rand(180)

DIM h%(1000), menu$(40): version$ = "V1.1": ' CLS

DATA "OP.AMP - SIMPLE INVERTING AMP     0 TY2KG001"
DATA "OP.AMP - 2-INPUT MIXER            1 TY2KG001"
DATA "OP.AMP - SIMPLE NON-INVERTING AMP 2 TY2KG001"
DATA "OP.AMP - COMPARATOR NON-INVERTING 3 TY2KG001"
DATA "OP.AMP - COMPARATOR + HYSTERISIS  4 TY2KG001"
DATA "MAIN MENU                         5 TY2KMENU"
DATA *

LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15: COLOR 14

GOSUB clearit
dotmake: CIRCLE (103, 104), 3, 15: PAINT (103, 104), 15, 15
GET (100, 100)-(108, 108), dot%

GOSUB clearit: selftest = 0: LOCATE 10, 35: PRINT "SETTING UP"
LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15

sp$ = "                                                                    "
sp$ = sp$ + "          "
CONST pi = 3.141592653589# / 180

OPEN "TY2KCAP1" FOR INPUT AS #1
FOR a = 1 TO 55: INPUT #1, a$:
cap$(a) = RTRIM$(LEFT$(a$, 4)) + MID$(a$, 6, 1)
cap$(a) = LEFT$(cap$(a) + "   ", 6)
NEXT: CLOSE
OPEN "TY2KCAP2" FOR INPUT AS #1
FOR a = 1 TO 55: INPUT #1, a$: cap(a) = VAL(a$): NEXT: CLOSE

OPEN "TY2KRES1" FOR INPUT AS #1: FOR a = 1 TO 217
INPUT #1, a$: B$ = MID$(a$, 6, 1): IF B$ = "o" THEN B$ = " "
res$(a) = LEFT$(RTRIM$(LEFT$(a$, 5)) + B$ + "   ", 4): NEXT: CLOSE
OPEN "TY2KRES2" FOR INPUT AS #1
FOR a = 1 TO 217: INPUT #1, a$: res(a) = VAL(a$): NEXT: CLOSE

volts$(0) = "0.0V": FOR v = 1 TO 50: a = v / 10
volts$ = LTRIM$(STR$(a)): IF a < 1 THEN volts$ = "0" + volts$
IF a = INT(a) THEN volts$ = volts$ + ".0"
volts$(v) = volts$ + "V": NEXT

r(1) = 97: '10k
r(2) = 97: '10k
r(3) = 97: '10k
r(4) = 97: '10k
r(5) = 109: '33k
r(6) = 97: '10k
r(7) = 73 + 48: '100k
pan = 2

col = 15
ltab = ac + 21: ttab = 5: GOSUB hresistor
ltab = ac + 21: ttab = 10: GOSUB vresistor
ltab = ac + 2: rtab = ac + 6: ttab = 5.5 + .5: btab = 6 + .5
ltab = ac + 13: rtab = ac + 6: ttab = 5.5 + .5: btab = 6 + .5
GOSUB capacitor: GOSUB clearit: a = 0

setmenu: READ menu$(a): IF menu$(a) <> "*" THEN a = a + 1: GOTO setmenu
maxmenu = a - 1: menucolumn = CINT(maxmenu / 2) + 1: l = LEN(menu$(0)) - 10
menu$(a) = ""

menu: GOSUB clearit
LOCATE 2, 25: PRINT "TEACH-IN 2000 OP.AMPS MENU "; version$: COLOR 15
LINE (154 + 16, 35 - 26)-(456 + 16 - 14, 63 - 30), 15, B: LINE (157 + 16, 38 - 26)-(453 + 16 - 14, 60 - 30), 15, B
PAINT (155 + 16, 36 - 26), 7, 15: COLOR 11

FOR a = 0 TO menucolumn - 1: LOCATE a + 4, 4: PRINT LEFT$(menu$(a), l)
LOCATE a + 4, 43: PRINT LEFT$(menu$(a + menucolumn), l): NEXT

COLOR 14: LOCATE 23, 19: PRINT "SELECT WITH CURSOR ARROWS THEN PRESS <ENTER>"
COLOR 14: LOCATE 24, 27: PRINT "M"; : COLOR 11: PRINT " AND "; : COLOR 14
PRINT "Q "; : COLOR 11: PRINT "ALSO CALL MAIN MENU"; : LOCATE 1, 1

ac = (band \ menucolumn) * 39 + 3: dn = band MOD menucolumn + 3: GOSUB highlight

getkey: a$ = INKEY$: IF a$ = "" THEN GOTO getkey
IF UCASE$(a$) = "M" THEN menupath = 6: GOTO 30
IF UCASE$(a$) = "Q" THEN menupath = 6: GOTO 30
IF a$ = CHR$(13) THEN GOTO 20
a$ = UCASE$(MID$(a$, 2)): IF a$ = "" THEN GOTO getkey
IF a$ = "M" THEN band = band + menucolumn: GOTO 10:  'right
IF a$ = "K" THEN band = band - menucolumn: GOTO 10: 'left
IF a$ = "P" THEN band = band + 1: GOTO 10: 'down
IF a$ = "H" THEN band = band - 1: GOTO 10: 'up
IF a$ = "G" THEN band = 0: GOTO 10: 'home
IF a$ = "O" THEN band = maxmenu: GOTO 10: 'end
IF a$ = "Q" THEN band = menucolumn - 1: GOTO 10: 'page down
IF a$ = "I" THEN band = 0: GOTO 10: 'page up
GOTO getkey

10 : IF band > maxmenu THEN band = maxmenu ELSE IF band < 0 THEN band = 0

GOSUB highlight: ac = (band \ menucolumn) * 39 + 3
dn = band MOD menucolumn + 3: GOSUB highlight: GOTO getkey

20 :
menu$ = RIGHT$(menu$(band), 8): menu = VAL(RIGHT$(menu$(band), 10))
menupath = menu + 1

30 : IF menupath = 6 THEN CHAIN "TY2KMENU"
GOSUB commonscreen
ON menupath GOTO 300, 200, 100, 400, 500: ' , 600: ' 501: '600

'....................

sine: angle = angle + tri: IF ABS(angle) > 45 THEN tri = -tri
sine1 = angle * volts: RETURN

sinea: angle = angle + freq(0): ' IF ABS(angle) > 45 THEN freq(0) = -freq(0)
IF ABS(angle) >= 45 THEN angle = 45 * (SGN(angle)): freq(0) = -freq(0): ' COLOR 14: PRINT angle;
sine1 = angle * volts(0): IF sine1 > 115 THEN sine1 = 115
IF sine1 < -115 THEN sine1 = -115
RETURN

sineb: angle = angle + freq(0):
IF ABS(angle) > 45 THEN angle = 45 * (SGN(angle)): freq(0) = -freq(0)
sine1 = angle * volts(0):
IF sine1 > 115 THEN sine1 = 115
IF sine1 < -115 THEN sine1 = -115
RETURN

sined: angle = angle + freq(0):
IF ABS(angle) >= 45 THEN angle = 45 * (SGN(angle)): freq(0) = -freq(0): ' COLOR 14: PRINT angle;
sine1 = angle * volts(0): IF sine1 > 115 THEN sine1 = 115
IF sine1 < -115 THEN sine1 = -115
RETURN

sinex: angle2 = angle2 + freq(1): IF ABS(angle2) > 45 THEN freq(1) = -freq(1)
sine2 = angle2 * volts(1): RETURN

'.........

hold: IF INKEY$ = "" THEN GOTO hold ELSE RETURN

'.............

clearit: LINE (6, 6)-(633, 343), 0, BF: RETURN

hresistor: v = (ltab + .5) * 8 - 1: h = (ttab + .5) * 14
w = 16: x = 8: PSET (v - 8, h), col: v = v + x
LINE -(v, h), 15:  h = h - (w / 2): v = v + (x / 2): FOR a = 1 TO 2
LINE -(v, h), col: h = h + w: v = v + x
LINE -(v, h), col: h = h - w: v = v + x: NEXT
LINE -(v, h), col: h = h + (w / 2): v = v + (x / 2)
LINE -(v, h), col: v = v + x: LINE -(v + 8, h), 15
GET (ltab * 8, ttab * 14 - 4)-(ltab * 8 + 62, ttab * 14 + 18), hres%
RETURN

vresistor: v = (ltab + .5) * 8 - 1: h = (ttab + .5) * 14
w = 16: x = 8: PSET (v, h + 0), col: h = h + x - 0
LINE -(v, h), 15: h = h + (x / 2): v = v + x: FOR a = 1 TO 2
LINE -(v, h), col: h = h + x: v = v - w
LINE -(v, h), col: h = h + x: v = v + w: NEXT
LINE -(v, h), col: h = h + (x / 2): v = v - (w / 2)
LINE -(v, h), col: h = h + x: LINE -(v, h + 0), 15:
GET (ltab * 8 - 8, ttab * 14 + 7)-(ltab * 8 + 14, ttab * 14 + 63), vres%
RETURN

capacitor: x = 440: y = 35 + 6
LINE (x + 8, y - 15)-(x + 8, y + 14), 15
LINE (x + 8, y + 29)-(x + 8, y + 43 + 15), 15
LINE (x, y + 14)-(x + 16, y + 19), 15, BF
LINE (x, y + 23)-(x + 16, y + 29), 15, BF
GET (x, y - 5)-(x + 16, y + 43 + 9), vcap%

x = 90: y = 42
LINE (x, y)-(x + 5, y + 14), 15, BF
LINE (x + 9, y)-(x + 9 + 5, y + 14), 15, BF
LINE (x, y + 7)-(x - 12, y + 7), 15
LINE (x + 14, y + 7)-(x + 14 + 8, y + 7), 15
GET (x - 14, y)-(x + 14 + 8, y + 14), hcap%: RETURN

opamp:
LOCATE dn, ac + 4: PRINT "+5V"
LOCATE dn + 4, ac + 5: PRINT "0V"
COLOR 15
LOCATE dn + 1, ac + 2: PRINT "-"
LOCATE dn + 3, ac + 2: PRINT "+"
x1 = ac * 8 + 4: x2 = (ac + 6) * 8 + 4
y1 = dn * 14 - 7: y2 = (dn + 2) * 14 - 7
LINE (x1, y1)-(x2, y2): LINE -(x1, y2 + 28)
LINE -(x1, y1): PAINT (x1 + 2, y1 + 2), 12, 15
LINE (x1 + 15 + 16, y1 + 7)-(x1 + 15 + 16, y1 + 9 + 9)
LINE (x1 + 15 + 16, y1 - 9 + 56 - 9)-(x1 + 15 + 16, y1 + 56 - 7)
RETURN

'..............

cap1: x1 = ac * 8 - 124: y1 = dn * 14 + 1: PUT (x1, y1), hcap%, PSET
COLOR 11: LOCATE dn, ac - 13: PRINT "C1": COLOR 15: ya = y1 + 7
LINE (x1 - 24, ya)-(x1 + 2, ya): RETURN

cap2: x1 = ac * 8 - 124: y1 = (dn - 3) * 14 + 1: PUT (x1, y1), hcap%, PSET
COLOR 11: LOCATE dn - 3, ac - 13: PRINT "C2": COLOR 15: yc = y1 + 7
LINE (x1 - 24, yc)-(x1 + 2, yc): RETURN

cap3: x1 = ac * 8 - 124: y1 = (dn + 2) * 14 - 2: PUT (x1, y1), hcap%, PSET
COLOR 11: LOCATE dn + 4, ac - 13: PRINT "C3": COLOR 15: ya = y1 + 7
LINE (x1 - 24, ya)-(x1 + 2, ya): LINE (x1 + 36, ya)-(x1 + 127, ya): RETURN

cap4: x1 = ac * 8 + 2: y1 = (dn - 6) * 14 + 2: PUT (x1, y1), hcap%, PSET
COLOR 11: LOCATE dn - 6, ac + 2: PRINT "C4": COLOR 15
LINE (x1 - 15, y1 + 7)-(x1 + 2, y1 + 7)
LINE (x1 + 36, y1 + 7)-(x1 + 65, y1 + 7)
LINE (x1 - 15, y1 + 7)-(x1 - 15, y1 + 47)
LINE (x1 + 65, y1 + 7)-(x1 + 65, y1 + 47): RETURN

res1: x1 = ac * 8 - 78: y1 = dn * 14 - 3: PUT (x1, y1), hres%, PSET
LINE (x1 - 9, y1 + 11)-(x1, y1 + 11)
LINE (x1 + 63, y1 + 11)-(x1 + 81, y1 + 11): RETURN

res2: x1 = ac * 8 - 8: y1 = (dn - 3) * 14 - 3: PUT (x1, y1), hres%, PSET
LINE (x1 - 5, y1 + 12)-(x1 - 5, y1 + 39 + 42 - 28)
LINE (x1 - 5, y1 + 11)-(x1, y1 + 11)
LINE (x1 + 63, y1 + 11)-(x1 + 75, y1 + 11)
LINE (x1 + 75, y1 + 11)-(x1 + 75, y1 + 94 - 28): RETURN

res3: x1 = ac * 8 - 78: y1 = (dn + 2) * 14 - 6: PUT (x1, y1), hres%, PSET
LINE (x1 + 63, y1 + 11)-(x1 + 81, y1 + 11)
LINE (x1 - 6, y1 + 11)-(x1, y1 + 11): RETURN

res4: x1 = ac * 8 - 24: y1 = (dn + 6) * 14 - 7: PUT (x1, y1), vres%, PSET
COLOR 11: LOCATE dn + 11, ac - 1: PRINT "0V": COLOR 15
x1 = ac * 8 - 13: y1 = (dn + 3) * 14 - 6
LINE (x1, y1 - 3)-(x1, y1 + 40): LINE (x1, y1 + 97)-(x1, y1 + 108): RETURN

res5: x1 = ac * 8 - 8: y1 = (dn + 5) * 14 - 3 - 3: PUT (x1, y1), hres%, PSET
LINE (x1 - 5, y1 + 11)-(x1, y1 + 11)
LINE (x1 - 5, y1 + 11)-(x1 - 5, y1 - 17 - 14)
LINE (x1 + 63, y1 + 11)-(x1 + 71, y1 + 11)
LINE (x1 + 71, y1 + 11)-(x1 + 71, y1 - 42): RETURN

res6: x1 = ac * 8 - 78: y1 = (dn - 3) * 14 - 3: PUT (x1, y1), hres%, PSET
LINE (x1 - 9, y1 + 11)-(x1, y1 + 11)
LINE (x1 + 63, y1 + 11)-(x1 + 65, y1 + 11)
LINE (x1 + 65, y1 + 11)-(x1 + 65, y1 + 53 - 28): RETURN

'........

300 : COLOR 10: LOCATE 23, 18: PRINT "OP.AMP SIMPLE INVERTER": COLOR 11
y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
ac = 44: dn = 12: x1 = ac * 8 + 53: y1 = (dn - 2) * 14 + 49: yb = y1: vw = 1

GOSUB cap1: GOSUB res1: GOSUB res2: GOSUB res3: GOSUB res4
ax = 42 * 8: ay = 12 * 14 + 4
PUT (ax, ay), dot%, OR
PUT (ax, ay + 25), dot%, OR
PUT (ax + 48 + 32, ay + 13), dot%, OR

COLOR 11: LOCATE dn + 3, ac - 13: PRINT "+5V"
LOCATE 6, 58: PRINT "GAIN = R2/R1 ="
LOCATE 7, 58: PRINT "BIAS=R4/(R3+R4)=":
COLOR 15

volts(0) = .5: freq(0) = 5: freq$(0) = "5"
GOSUB voltshow3: GOSUB showresval3

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
y = y + 70 - 21 - 50: yx = y - 40
angle = 0: angle2 = 0: GOSUB sinea: prevsine = sine1
angle2 = 0: y2 = sine1: lastsine1 = sine1: lastsine2 = sine1

310 : prevsine = sine1: prevx = x1 + 1: prevsinex = sine2

FOR x = 1 TO 179: GOSUB sinea: y2 = sine1
LINE (x + x1, yy - y1 + 28)-(x + x1, yy + y1 - 24), 0
LINE (prevx, y - prevsine + 3)-(x + x1, y - y2 + 3), cola
prevx = x + x1: prevsine = y2: NEXT

LINE (x1 + 181, y - lastsine1 + 3)-(x1 + 190, y - lastsine1 + 3), 0
LINE -(x1 + 190, ya), 0
LINE (x1 + 181, y - y2 + 3)-(x1 + 190, y - y2 + 3), 10
LINE -(x1 + 190, ya), 10: lastsine1 = y2

320 : prevx = x2 + 1: y3 = -sine1 * gain + bias2
IF y3 > 69 THEN y3 = 69 ELSE IF y3 < -69 THEN y3 = -69
prevsine2 = y3
LINE (x2 - 1, y - lastsine2 + 8)-(x2 - 5, y - lastsine2 + 8), 0
LINE -(x2 - 5, yb), 0: LINE (x2 - 1, y - y3 + 8)-(x2 - 5, y - y3 + 8), 10
LINE -(x2 - 5, yb), 10: lastsine2 = y3

FOR x = 1 TO 179: y3 = -sine1 * gain: GOSUB sinea
y3 = y3 + bias2: IF y3 > 69 THEN y3 = 69 ELSE IF y3 < -69 THEN y3 = -69
LINE (x + x2, yy - y1 + 79)-(x + x2, yy + y1 - 65), 0
LINE (prevx, y - prevsine2 + 8)-(x + x2, y - y3 + 8), 10
prevx = x + x2: prevsine2 = y3: NEXT

335 : z$ = INKEY$: IF z$ = "" THEN GOTO 310
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo3: GOTO 310

'.............

demo3:
z = VAL(z$):
IF z > 0 AND z < 8 AND z <> 5 THEN pan = z: vw = 0: GOSUB showresval3
IF UCASE$(z$) <> "V" THEN GOTO demo3a
pan = 8: GOSUB showresval3
demo3a:
IF UCASE$(z$) <> "F" THEN GOTO demo3b
pan = 10: GOSUB showresval3
demo3b:
IF z$ = "+" THEN GOSUB resinc3: RETURN
IF z$ = "-" THEN GOSUB resdec3: RETURN
IF z$ = "*" THEN GOSUB resmult3: RETURN
IF z$ = "/" THEN GOSUB resdivide3: RETURN
RETURN

showresval3: ac = 44: dn = 12
FOR a = 1 TO 7: col(a) = 11: NEXT: col(8) = 10: col(9) = 10
col(10) = 10: col(11) = 10: col(pan) = 14
cola = col(8) OR col(10): colb = col(9) OR col(11)
COLOR (col(1)): LOCATE dn, ac - 8: PRINT "R1 "; res$(r(1))
COLOR (col(2)): LOCATE dn - 3, ac + 1: PRINT "R2 "; res$(r(2))
COLOR (col(3)): LOCATE dn + 4, ac - 8: PRINT "R3 "; res$(r(3))
COLOR (col(4)): LOCATE dn + 8, ac + 1: PRINT "R4 "; res$(r(4))

gain = res(r(2)) / res(r(1)): IF gain >= 100 THEN gain = INT(gain)
outrange = CINT(volts(0) * 2 * 10) / 10
outrange = outrange * gain
IF outrange > 3 THEN outrange = 3
outrange$ = volts$(outrange * 10)

bias = 5 * res(r(4)) / (res(r(3)) + res(r(4)))
bias2 = (bias - 2.5) * 47
gain2$ = " MAX  ": gain$ = " MAX  "
IF gain <= 100000 THEN gain$ = STR$(INT(gain * 10) / 10)
bias$ = LTRIM$(STR$(CINT(bias * 10) / 10))
gain$ = LEFT$(gain$ + "   ", 7)
bias$ = LEFT$(bias$ + "V  ", 5): COLOR 10
LOCATE 6, 72: PRINT gain$
LOCATE 7, 74: PRINT bias$: ' STOP
LOCATE 4, 58: PRINT "OUTPUT PK-PK = "; outrange$
GOSUB voltshow3: RETURN

voltshow3:
IF volts(0) > 2.5 THEN volts(0) = 2.5
IF volts(0) < 0 THEN volts(0) = 0
volt$(0) = LTRIM$(STR$(CINT(volts(0) * 200) / 100))
IF volts(0) < .5 AND volts(0) > 0 THEN volt$(0) = "0" + volt$(0)
volt$(0) = LEFT$(volt$(0) + "V  ", 4)
COLOR col(8): LOCATE 4, 6: PRINT "INPUT PK-PK = "; volt$(0)
COLOR col(10): LOCATE 5, 6: PRINT "CYCLE COUNT = "; freq$(0)

bias = INT(bias * 10) / 10: bias$ = LTRIM$(STR$(bias)) + "V"
bias$ = LEFT$(bias$ + "   ", 4): RETURN

resinc3: IF pan = 8 OR pan = 9 THEN GOTO voltinc3
IF pan = 10 OR pan = 11 THEN GOTO freqinc3
r(pan) = r(pan) + 1: IF r(pan) > 217 THEN r(pan) = 217
GOTO showresval3
resdec3: IF pan = 8 OR pan = 9 THEN GOTO voltdec3
IF pan = 10 OR pan = 11 THEN GOTO freqdec3
r(pan) = r(pan) - 1: IF r(pan) < 1 THEN r(pan) = 1
GOTO showresval3
resmult3: IF pan = 8 OR pan = 9 THEN GOTO voltmult3
IF pan = 10 OR pan = 11 THEN GOTO freqmult3
r(pan) = r(pan) + 24: IF r(pan) > 217 THEN r(pan) = 217
GOTO showresval3
resdivide3: IF pan = 8 OR pan = 9 THEN GOTO voltdivide3
IF pan = 10 OR pan = 11 THEN GOTO freqdivide3
r(pan) = r(pan) - 24: IF r(pan) < 1 THEN r(pan) = 1
GOTO showresval3

voltinc3: volts(0) = volts(0) + .05: GOTO voltshow3
voltdec3: volts(0) = volts(0) - .05: GOTO voltshow3
voltmult3: volts(0) = volts(0) + .5: GOTO voltshow3
voltdivide3: volts(0) = volts(0) - .5: GOTO voltshow3

freqinc3: freq(0) = ABS(freq(0)) + .1: GOTO freqshow3
freqdec3: freq(0) = ABS(freq(0)) - .1: GOTO freqshow3
freqmult3: freq(0) = ABS(freq(0)) + 1: GOTO freqshow3
freqdivide3: freq(0) = ABS(freq(0)) - 1: GOTO freqshow3

freqshow3: ' LOCATE 1, 1: PRINT TIME$;
IF freq(0) > 22 THEN freq(0) = 22
IF freq(0) < .1 THEN freq(0) = .1
freq$(0) = LTRIM$(STR$(CINT(freq(0) * 10) / 10))
freq$(0) = LEFT$(freq$(0) + "  ", 4)
angle = 0: angle2 = 0: GOTO voltshow3

'..............

200 : COLOR 10: LOCATE 23, 18: PRINT "OP.AMP MIXER DEMO": COLOR 11
LOCATE 11, 27: PRINT "A"
LOCATE 14, 27: PRINT "B": COLOR 10
LOCATE 5, 27: PRINT "INPUT A"
LOCATE 6, 27: PRINT "INPUT B": COLOR 11

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
ac = 44: dn = 12: x1 = ac * 8 + 53: y1 = (dn - 2) * 14 + 49:
yb = y1: vw = 1

GOSUB cap1: GOSUB cap2:
GOSUB res1: GOSUB res2: GOSUB res3: GOSUB res4: GOSUB res6
ax = 42 * 8: ay = 12 * 14 + 4
PUT (ax, ay), dot%, OR
PUT (ax, ay + 25), dot%, OR
PUT (ax + 48 + 32, ay + 13), dot%, OR
PUT (ax, ay - 42), dot%, OR

COLOR 11: LOCATE dn + 3, ac - 13: PRINT "+5V"
LOCATE 4, 7: PRINT "INPUTS A AND B"
LOCATE 4, 62: PRINT "MIXED OUTPUT"
LOCATE 5, 58: PRINT "GAIN A= R2/R6="
LOCATE 6, 58: PRINT "GAIN B= R2/R1="
LOCATE 7, 58: PRINT "BIAS=R4/(R3+R4)="
COLOR 15

volts = .5: volts(0) = .5: volts(1) = .5: gain = 1: gain2 = 1: range = volts * 2
freq(0) = 2: freq(1) = 9.2: freq$(0) = "2": freq$(1) = "9.2"
GOSUB voltshow2: GOSUB showresval2

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
y = y + 70 - 21 - 50: yx = y - 40
angle = 0: GOSUB sinea: prevsine = sine1
angle2 = 0: y2 = sine1: lastsine1 = sine1: lastsine2 = sine1

210 : GOSUB sinea: GOSUB sinea: GOSUB sinea: GOSUB sinea
GOSUB sinea: GOSUB sinea: GOSUB sinea: GOSUB sinea
prevsine = sine1: prevx = x1 + 1: prevsinex = sine2
max = 0
FOR x = 1 TO 179: GOSUB sinea: y2 = sine1: GOSUB sinex: y4 = sine2
LINE (x + x1, yy - y1 + 56 - 30 - 1)-(x + x1, yy + y1 - 28 + 1), 0
LINE (prevx, y - prevsine)-(x + x1, y - y2 + 20), cola
IF y4 > 74 THEN y4 = 74

LINE (prevx, yx - prevsinex)-(x + x1, yx - y4), colb
prevx = x + x1: prevsine = y2 - 20: prevsinex = y4: NEXT

LINE (x1 + 181, y - lastsine1)-(x1 + 190, y - lastsine1), 0
LINE -(x1 + 190, ya), 0
LINE (x1 + 181, y - y2 + 20)-(x1 + 190, y - y2 + 20), 10
LINE -(x1 + 190, ya), 10

LINE (x1 + 181, yx - lastsinex)-(x1 + 189, yx - lastsinex), 0
LINE -(x1 + 189, yc), 0
LINE (x1 + 181, yx - y4)-(x1 + 189, yx - y4), 10
LINE -(x1 + 189, yc), 10: lastsine1 = y2 - 20: lastsinex = y4

220 : prevx = x2 + 1: y3 = -sine1 * gain + bias2: y4 = -sine2 * gain2
y3 = y3 + y4: : IF y3 > 69 THEN y3 = 69 ELSE IF y3 < -69 THEN y3 = -69
prevsine2 = y3
LINE (x2 - 2 + 1, y - lastsine2 + 8)-(x2 - 18 + 8 + 5, y - lastsine2 + 8), 0
LINE -(x2 - 10 + 5, yb), 0: LINE (x2 - 1, y - y3 + 8)-(x2 - 10 + 5, y - y3 + 8), 10
LINE -(x2 - 10 + 5, yb), 10: lastsine2 = y3

FOR x = 1 TO 179: y3 = -sine1 * gain: GOSUB sinea
y4 = -sine2 * gain2: GOSUB sinex
y3 = y3 + y4 + bias2: IF y3 > 69 THEN y3 = 69 ELSE IF y3 < -69 THEN y3 = -69
LINE (x + x2, yy - y1 + 71 + 8)-(x + x2, yy + y1 - 73 + 8), 0
LINE (prevx, y - prevsine2 + 8)-(x + x2, y - y3 + 8), 10
prevx = x + x2: prevsine2 = y3: NEXT

235 : z$ = INKEY$: IF z$ = "" THEN GOTO 210
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo2: GOTO 210

'.............

demo2: z = VAL(z$)
IF z > 0 AND z < 8 AND z <> 5 THEN pan = z: vw = 0: GOSUB showresval2
IF UCASE$(z$) <> "V" THEN GOTO demo2a
IF pan = 8 OR pan = 9 THEN vw = (vw + 1) AND 1
pan = 8 + vw: GOSUB showresval2
demo2a:
IF UCASE$(z$) <> "F" THEN GOTO demo2b
IF pan > 9 THEN vw = (vw + 1) AND 1
pan = 10 + vw: GOSUB showresval2
demo2b:
IF z$ = "+" THEN GOSUB resinc2: RETURN
IF z$ = "-" THEN GOSUB resdec2: RETURN
IF z$ = "*" THEN GOSUB resmult2: RETURN
IF z$ = "/" THEN GOSUB resdivide2: RETURN
RETURN

showresval2: ac = 44: dn = 12
FOR a = 1 TO 7: col(a) = 11: NEXT: col(8) = 10: col(9) = 10
col(10) = 10: col(11) = 10: col(pan) = 14
cola = col(8) OR col(10): colb = col(9) OR col(11)
COLOR (col(1)): LOCATE dn, ac - 8: PRINT "R1 "; res$(r(1))
COLOR (col(2)): LOCATE dn - 3, ac + 1: PRINT "R2 "; res$(r(2))
COLOR (col(3)): LOCATE dn + 4, ac - 8: PRINT "R3 "; res$(r(3))
COLOR (col(4)): LOCATE dn + 8, ac + 1: PRINT "R4 "; res$(r(4))
COLOR (col(6)): LOCATE dn - 3, ac - 8: PRINT "R6 "; res$(r(6))

gain = res(r(2)) / res(r(1)): IF gain >= 100 THEN gain = INT(gain)
gain2 = res(r(2)) / res(r(6)): IF gain2 >= 100 THEN gain2 = INT(gain2)
bias = 5 * res(r(4)) / (res(r(3)) + res(r(4))): bias2 = (bias - 2.5) * 47
gain2$ = " MAX  ": gain$ = " MAX  "
IF gain2 <= 100000 THEN gain2$ = STR$(INT(gain2 * 10) / 10)
IF gain <= 100000 THEN gain$ = STR$(INT(gain * 10) / 10)
bias$ = LTRIM$(STR$(CINT(bias * 10) / 10))
gain2$ = LEFT$(gain2$ + "   ", 7)
gain$ = LEFT$(gain$ + "   ", 7)
bias$ = LEFT$(bias$ + "V  ", 5): COLOR 10
LOCATE 5, 72: PRINT gain2$
LOCATE 6, 72: PRINT gain$
LOCATE 7, 74: PRINT bias$
GOSUB voltshow2
RETURN

voltshow2:
IF volts(0) > 2 THEN volts(0) = 2
IF volts(0) < 0 THEN volts(0) = 0
IF volts(1) > 1.6 THEN volts(1) = 1.6
IF volts(1) < 0 THEN volts(1) = 0
volt$(0) = LTRIM$(STR$(CINT(volts(0) * 200) / 100))
volt$(1) = LTRIM$(STR$(CINT(volts(1) * 200) / 100))
IF volts(1) < .5 AND volts(1) > 0 THEN volt$(1) = "0" + volt$(1)
IF volts(0) < .5 AND volts(0) > 0 THEN volt$(0) = "0" + volt$(0)
volt$(0) = LEFT$(volt$(0) + "V  ", 4)
volt$(1) = LEFT$(volt$(1) + "V  ", 4)
COLOR col(9): LOCATE 5, 46: PRINT "PK-PK "; volt$(1)
COLOR col(8): LOCATE 6, 46: PRINT "PK-PK "; volt$(0)
COLOR col(11): LOCATE 5, 36: PRINT "FREQ "; freq$(1)
COLOR col(10): LOCATE 6, 36: PRINT "FREQ "; freq$(0)

bias = INT(bias * 10) / 10: bias$ = LTRIM$(STR$(bias)) + "V"
bias$ = LEFT$(bias$ + "   ", 4): RETURN

resinc2: IF pan = 8 OR pan = 9 THEN GOTO voltinc2
IF pan = 10 OR pan = 11 THEN GOTO freqinc
r(pan) = r(pan) + 1: IF r(pan) > 217 THEN r(pan) = 217
GOTO showresval2
resdec2: IF pan = 8 OR pan = 9 THEN GOTO voltdec2
IF pan = 10 OR pan = 11 THEN GOTO freqdec
r(pan) = r(pan) - 1: IF r(pan) < 1 THEN r(pan) = 1
GOTO showresval2
resmult2: IF pan = 8 OR pan = 9 THEN GOTO voltmult2
IF pan = 10 OR pan = 11 THEN GOTO freqmult
r(pan) = r(pan) + 24: IF r(pan) > 217 THEN r(pan) = 217
GOTO showresval2
resdivide2: IF pan = 8 OR pan = 9 THEN GOTO voltdivide2
IF pan = 10 OR pan = 11 THEN GOTO freqdivide
r(pan) = r(pan) - 24: IF r(pan) < 1 THEN r(pan) = 1
GOTO showresval2

voltinc2: volts(vw) = volts(vw) + .05: GOTO voltshow2
voltdec2: volts(vw) = volts(vw) - .05: GOTO voltshow2
voltmult2: volts(vw) = volts(vw) + .5: GOTO voltshow2
voltdivide2: volts(vw) = volts(vw) - .5: GOTO voltshow2

freqinc: freq(vw) = ABS(freq(vw)) + .1: GOTO freqshow2
freqdec: freq(vw) = ABS(freq(vw)) - .1: GOTO freqshow2
freqmult: freq(vw) = ABS(freq(vw)) + 1: GOTO freqshow2
freqdivide: freq(vw) = ABS(freq(vw)) - 1: GOTO freqshow2

freqshow2: ' LOCATE 1, 1: PRINT TIME$;
IF freq(vw) > 24 THEN freq(vw) = 24
IF freq(vw) < .1 THEN freq(vw) = .1
freq$(vw) = LTRIM$(STR$(CINT(freq(vw) * 10) / 10))
freq$(vw) = LEFT$(freq$(vw) + "  ", 4)
angle = 0: angle2 = 0: GOTO voltshow2

'.........

100 : COLOR 10: LOCATE 23, 13: PRINT "NON-INVERTING OP.AMP": COLOR 11
y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
ac = 44: dn = 12: x1 = ac * 8 + 53: y1 = (dn - 2) * 14 + 49: yb = y1: vw = 1
bias = 2.5

GOSUB cap3: GOSUB res1: GOSUB res2: GOSUB res4: 'GOSUB res3
ax = 42 * 8: ay = 12 * 14 + 4
PUT (ax, ay), dot%, OR
PUT (ax, ay + 25), dot%, OR
PUT (ax + 48 + 32, ay + 13), dot%, OR

COLOR 11: LOCATE dn + 1, ac - 15: PRINT "+2.5V"
LOCATE 6, 58: PRINT "GAIN ="
LOCATE 7, 58: PRINT "(R2/R1) + 1 ="
LOCATE 23, 41: PRINT "+2.5V (BIAS = B)"; : COLOR 15:
LOCATE 23, 55: PRINT "B"
COLOR 15

volts(0) = .5: volt$(0) = "1V": freq(0) = 5: freq$(0) = "5"
GOSUB showval1

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
y = y + 70 - 21 - 50: yx = y - 40
angle = 0: angle2 = 0: GOSUB sinea: prevsine = sine1
angle2 = 0: y2 = sine1: lastsine1 = sine1: lastsine2 = sine1

110 : prevsine = sine1: prevx = x1 + 1: prevsinex = sine2

FOR x = 1 TO 179: GOSUB sinea: y2 = sine1
LINE (x + x1, yy - y1 + 28)-(x + x1, yy + y1 - 24), 0
LINE (prevx, y - prevsine + 3)-(x + x1, y - y2 + 3), cola
prevx = x + x1: prevsine = y2: NEXT

LINE (x1 + 181, y - lastsine1 + 3)-(x1 + 190, y - lastsine1 + 3), 0
LINE -(x1 + 190, ya), 0
LINE (x1 + 181, y - y2 + 3)-(x1 + 190, y - y2 + 3), 10
LINE -(x1 + 190, ya), 10: lastsine1 = y2

120 : prevx = x2 + 1: y3 = (sine1 + bias2) * gain
IF y3 > 69 THEN y3 = 69 ELSE IF y3 < -69 THEN y3 = -69
prevsine2 = y3
LINE (x2 - 1, y - lastsine2 + 8)-(x2 - 5, y - lastsine2 + 8), 0
LINE -(x2 - 5, yb), 0: LINE (x2 - 1, y - y3 + 8)-(x2 - 5, y - y3 + 8), 10
LINE -(x2 - 5, yb), 10: lastsine2 = y3

FOR x = 1 TO 179: y3 = (sine1 + bias2) * gain: GOSUB sinea
IF y3 > 69 THEN y3 = 69 ELSE IF y3 < -69 THEN y3 = -69
LINE (x + x2, yy - y1 + 79)-(x + x2, yy + y1 - 65), 0
LINE (prevx, y - prevsine2 + 8)-(x + x2, y - y3 + 8), 10
prevx = x + x2: prevsine2 = y3: NEXT

135 : z$ = INKEY$: IF z$ = "" THEN GOTO 110
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo1: GOTO 110

'.............

demo1: z = VAL(z$)
IF z > 0 AND z < 3 THEN pan = z: vw = 0: GOTO showval1
IF UCASE$(z$) <> "V" THEN GOTO demo1a
pan = 8: GOTO showval1
demo1a: IF UCASE$(z$) <> "F" THEN GOTO demo1b
pan = 10: GOTO showval1
demo1b: IF UCASE$(z$) <> "B" THEN GOTO demo1c
pan = 12: GOTO showval1
demo1c:
IF z$ = "+" THEN GOTO resinc1
IF z$ = "-" THEN GOTO resdec1
IF z$ = "*" THEN GOTO resmult1
IF z$ = "/" THEN GOTO resdivide1
RETURN

resinc1: IF pan = 8 OR pan = 9 THEN GOTO voltinc1
IF pan = 10 OR pan = 11 THEN GOTO freqinc1
IF pan = 12 THEN GOTO biasinc1
r(pan) = r(pan) + 1: IF r(pan) > 217 THEN r(pan) = 217
GOTO showval1
resdec1: IF pan = 8 OR pan = 9 THEN GOTO voltdec1
IF pan = 10 OR pan = 11 THEN GOTO freqdec1
IF pan = 12 THEN GOTO biasdec1
r(pan) = r(pan) - 1: IF r(pan) < 1 THEN r(pan) = 1
GOTO showval1
resmult1: IF pan = 8 OR pan = 9 THEN GOTO voltmult1
IF pan = 10 OR pan = 11 THEN GOTO freqmult1
IF pan = 12 THEN GOTO biasmult1
r(pan) = r(pan) + 24: IF r(pan) > 217 THEN r(pan) = 217
GOTO showval1
resdivide1: IF pan = 8 OR pan = 9 THEN GOTO voltdivide1
IF pan = 10 OR pan = 11 THEN GOTO freqdivide1
IF pan = 12 THEN GOTO biasdivide1
r(pan) = r(pan) - 24: IF r(pan) < 1 THEN r(pan) = 1
GOTO showval1

voltinc1: volts(0) = volts(0) + .05: GOTO voltcheck1
voltdec1: volts(0) = volts(0) - .05: GOTO voltcheck1
voltmult1: volts(0) = volts(0) + .5: GOTO voltcheck1
voltdivide1: volts(0) = volts(0) - .5: GOTO voltcheck1

voltcheck1:
IF volts(0) > 2.5 THEN volts(0) = 2.5
IF volts(0) < 0 THEN volts(0) = 0
volt$(0) = LTRIM$(STR$(CINT(volts(0) * 200) / 100))
IF volts(0) < .5 AND volts(0) > 0 THEN volt$(0) = "0" + volt$(0)
volt$(0) = LEFT$(volt$(0) + "V  ", 4)
GOTO showval1

freqinc1: freq(0) = ABS(freq(0)) + .1: GOTO freqcheck1
freqdec1: freq(0) = ABS(freq(0)) - .1: GOTO freqcheck1
freqmult1: freq(0) = ABS(freq(0)) + 1: GOTO freqcheck1
freqdivide1: freq(0) = ABS(freq(0)) - 1: GOTO freqcheck1

freqcheck1:
IF freq(0) > 22 THEN freq(0) = 22
IF freq(0) < .1 THEN freq(0) = .1
freq$(0) = LTRIM$(STR$(CINT(freq(0) * 10) / 10))
freq$(0) = LEFT$(freq$(0) + "  ", 4)
angle = 0: angle2 = 0: GOTO showval1

biasinc1: bias = bias + .05: GOTO biasshow1
biasdec1: bias = bias - .05: GOTO biasshow1
biasmult1: bias = bias + .5: GOTO biasshow1
biasdivide1: bias = bias - .5: GOTO biasshow1

biasshow1:
IF bias > 5 THEN bias = 5
IF bias < 0 THEN bias = 0
bias2 = (bias - 2.5) * 47
bias$ = LTRIM$(STR$(CINT(bias * 100) / 100))
bias$ = LEFT$(bias$ + "V  ", 5): COLOR 10
GOTO showval1

showval1: ac = 44: dn = 12
FOR a = 1 TO 7: col(a) = 11: NEXT: col(8) = 10: col(9) = 10
col(10) = 10: col(11) = 10: col(12) = 11: col(pan) = 14
cola = col(8) OR col(10): colb = col(9) OR col(11)
COLOR (col(1)): LOCATE dn, ac - 8: PRINT "R1 "; res$(r(1))
COLOR (col(2)): LOCATE dn - 3, ac + 1: PRINT "R2 "; res$(r(2))
COLOR (col(4)): LOCATE dn + 8, ac + 1: PRINT "R4"

gain = (res(r(2)) / res(r(1))) + 1: IF gain >= 100 THEN gain = INT(gain)
outrange = CINT(volts(0) * 2 * 10) / 10: outrange = outrange * gain
IF outrange > 3 THEN outrange = 3
outrange$ = volts$(outrange * 10)

bias2 = (bias - 2.5) * 47
bias$ = LTRIM$(STR$(CINT(bias * 100) / 100))
bias$ = LEFT$(bias$ + "V   ", 6): COLOR 10

gain$ = " MAX  "
IF gain <= 100000 THEN gain$ = LTRIM$(STR$(INT(gain * 10) / 10))
gain$ = LEFT$(gain$ + "   ", 6)
COLOR 10:
LOCATE 4, 58: PRINT "OUTPUT PK-PK = "; outrange$: ' COLOR 11
LOCATE 7, 73: PRINT gain$
COLOR col(12): LOCATE 23, 41: PRINT bias$
COLOR col(8): LOCATE 4, 6: PRINT "INPUT PK-PK = "; volt$(0)
COLOR col(10): LOCATE 5, 6: PRINT "CYCLE COUNT = "; freq$(0)
RETURN

'.............

400 : COLOR 10: LOCATE 23, 29: PRINT "NON-INVERTING COMPARATOR": COLOR 11
y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
ac = 44: dn = 12: x1 = ac * 8 + 53: y1 = (dn - 2) * 14 + 49: yb = y1: vw = 1
bias = 2.5: LOCATE 2, 37: PRINT "                      ": COLOR 15

x1 = ac * 8 - 124: y1 = (dn + 2) * 14 - 2: ya = y1 + 7
LINE (x1 + 4, ya - 24)-(x1 + 40 + 88, ya - 24)
LINE (x1 - 24, ya)-(x1 + 40 + 88, ya)

LOCATE 23, 15: PRINT "S = "; : COLOR 11: PRINT "STEP": COLOR 15
LOCATE 2, 37: PRINT "N = "; : COLOR 11: PRINT "NOISE = 0": noise = 0
noise$ = "0"
LOCATE dn, ac - 15: PRINT "BIAS"; : COLOR 15:
LOCATE dn - 1, ac - 15: PRINT "B ="
COLOR 10: LOCATE 4, 65: PRINT "OUTPUT"
COLOR 11: LOCATE 6, 63: PRINT "GAIN = MAX": COLOR 15

volts(0) = .5: volt$(0) = "1V": freq(0) = 2: freq$(0) = "2"
pan = 12: GOSUB showval4

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
y = y + 70 - 21 - 50: yx = y - 40
angle = -32: angle2 = -32: GOSUB sinea: prevsine = sine1
angle2 = -32: y2 = sine1: lastsine1 = sine1: lastsine2 = sine1

410 : angle = -32: angle2 = -32: GOSUB sinea: prevsine = sine1
angle = -32: angle2 = -32: y2 = sine1
prevsine = sine1: prevx = x1 + 1: prevsinex = sine2
b2 = (bias - 2.5) * 45 - 3

prevx2 = x2 + 1: prevsine2 = y3
LINE (x2 - 1, y - lastsine2 + 8)-(x2 - 5, y - lastsine2 + 8), 0
LINE -(x2 - 5, yb), 0: LINE (x2 - 1, y - y3 + 8)-(x2 - 5, y - y3 + 8), 10
LINE -(x2 - 5, yb), 10: lastsine2 = y3

FOR x = 1 TO 179: rand = (RND(1) - .5) * noise + sine1
y2 = INT(rand): IF y2 > 110 THEN y2 = 110
IF y2 < -110 THEN y2 = -110

GOSUB sinea: LINE (x + x1, yy - y1 + 28)-(x + x1, yy + y1 - 24), 0
LINE (prevx, y - prevsine + 3)-(x + x1, y - y2 + 3), cola
prevx = x + x1: prevsine = y2

IF y2 > bias2 THEN y3 = 69 ELSE y3 = -69
LINE (x + x2, yy - y1 + 79)-(x + x2, yy + y1 - 65), 0
LINE (prevx2, y - prevsine2 + 8)-(x + x2, y - y3 + 8), 10
prevx2 = x + x2: prevsine2 = y3: NEXT

LINE (x1 + 1, y - b2)-(x1 + 179, y - b2), 11

LINE (x1 + 181, y - lastsine1 + 3)-(x1 + 190, y - lastsine1 + 3), 0
LINE -(x1 + 190, ya), 0
LINE (x1 + 181, y - y2 + 3)-(x1 + 190, y - y2 + 3), 10
LINE -(x1 + 190, ya), 10: lastsine1 = y2

435 : z$ = INKEY$: IF z$ = "" THEN GOTO 435
IF UCASE$(z$) = "S" THEN GOTO 410
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo4: GOTO 410

'.............

demo4: z = VAL(z$)
IF UCASE$(z$) <> "V" THEN GOTO demo4a
pan = 8: GOTO showval4
demo4a: IF UCASE$(z$) <> "F" THEN GOTO demo4b
pan = 10: GOTO showval4
demo4b: IF UCASE$(z$) <> "B" THEN GOTO demo4c
pan = 12: GOTO showval4
demo4c: IF UCASE$(z$) <> "N" THEN GOTO demo4d
pan = 14: GOTO showval4
demo4d:
IF z$ = "+" THEN GOTO resinc4
IF z$ = "-" THEN GOTO resdec4
IF z$ = "*" THEN GOTO resmult4
IF z$ = "/" THEN GOTO resdivide4
RETURN

resinc4: IF pan = 8 OR pan = 9 THEN GOTO voltinc4
IF pan = 10 OR pan = 11 THEN GOTO freqinc4
IF pan = 12 THEN GOTO biasinc4
IF pan = 14 THEN GOTO noiseinc4
r(pan) = r(pan) + 1: IF r(pan) > 217 THEN r(pan) = 217
GOTO showval4
resdec4: IF pan = 8 OR pan = 9 THEN GOTO voltdec4
IF pan = 10 OR pan = 11 THEN GOTO freqdec4
IF pan = 12 THEN GOTO biasdec4
IF pan = 14 THEN GOTO noisedec4
r(pan) = r(pan) - 1: IF r(pan) < 1 THEN r(pan) = 1
GOTO showval4
resmult4: IF pan = 8 OR pan = 9 THEN GOTO voltmult4
IF pan = 10 OR pan = 11 THEN GOTO freqmult4
IF pan = 12 THEN GOTO biasmult4
IF pan = 14 THEN GOTO noisemult4
r(pan) = r(pan) + 24: IF r(pan) > 217 THEN r(pan) = 217
GOTO showval4
resdivide4: IF pan = 8 OR pan = 9 THEN GOTO voltdivide4
IF pan = 10 OR pan = 11 THEN GOTO freqdivide4
IF pan = 12 THEN GOTO biasdivide4
IF pan = 14 THEN GOTO noisedivide4
r(pan) = r(pan) - 24: IF r(pan) < 1 THEN r(pan) = 1
GOTO showval4

voltinc4: volts(0) = volts(0) + .05: GOTO voltcheck4
voltdec4: volts(0) = volts(0) - .05: GOTO voltcheck4
voltmult4: volts(0) = volts(0) + .5: GOTO voltcheck4
voltdivide4: volts(0) = volts(0) - .5: GOTO voltcheck4

voltcheck4:
IF volts(0) > 2.5 THEN volts(0) = 2.5
IF volts(0) < 0 THEN volts(0) = 0
volt$(0) = LTRIM$(STR$(CINT(volts(0) * 200) / 100))
IF volts(0) < .5 AND volts(0) > 0 THEN volt$(0) = "0" + volt$(0)
volt$(0) = LEFT$(volt$(0) + "V  ", 4)
GOTO showval4

freqinc4: freq(0) = ABS(freq(0)) + .1: GOTO freqcheck4
freqdec4: freq(0) = ABS(freq(0)) - .1: GOTO freqcheck4
freqmult4: freq(0) = ABS(freq(0)) + 1: GOTO freqcheck4
freqdivide4: freq(0) = ABS(freq(0)) - 1: GOTO freqcheck4

freqcheck4:
IF freq(0) > 22 THEN freq(0) = 22
IF freq(0) < .1 THEN freq(0) = .1
freq$(0) = LTRIM$(STR$(CINT(freq(0) * 10) / 10))
freq$(0) = LEFT$(freq$(0) + "  ", 4)
angle = 0: angle2 = 0: GOTO showval4

biasinc4: bias = bias + .1: GOTO biasshow4
biasdec4: bias = bias - .1: GOTO biasshow4
biasmult4: bias = bias + 1: GOTO biasshow4
biasdivide4: bias = bias - 1: GOTO biasshow4

biasshow4:
IF bias > 5 THEN bias = 5
IF bias < 0 THEN bias = 0
bias2 = CINT((bias - 2.5) * 45)
bias$ = LTRIM$(STR$(CINT(bias * 100) / 100))
bias$ = LEFT$(bias$ + "V  ", 5): COLOR 10
GOTO showval4

noiseinc4: noise = noise + 1: GOTO noiseshow4
noisedec4: noise = noise - 1: GOTO noiseshow4
noisemult4: noise = noise + 10: GOTO noiseshow4
noisedivide4: noise = noise - 10: GOTO noiseshow4

noiseshow4:
IF noise > 50 THEN noise = 50
IF noise < 0 THEN noise = 0
noise$ = LTRIM$(STR$(INT(noise * 100) / 100))
noise$ = LEFT$(noise$ + "    ", 5): COLOR 10
GOTO showval4

showval4: ac = 44: dn = 12
FOR a = 1 TO 7: col(a) = 11: NEXT: col(8) = 10: col(9) = 10
col(10) = 10: col(11) = 10: col(12) = 11: col(14) = 11: col(pan) = 14
cola = col(8) OR col(10): colb = col(9) OR col(11)

voltshi = 2.5 + volts(0): voltslo = 2.5 - volts(0)
voltshi$ = LTRIM$(STR$(CINT(voltshi * 1000) / 1000)) + "V"
voltslo$ = LTRIM$(STR$(CINT(voltslo * 1000) / 1000)) + "V"
range$ = LEFT$(voltslo$ + " TO " + voltshi$ + "       ", 14)
COLOR col(8): LOCATE 4, 4: PRINT "RANGE= "; range$

bias2 = INT((bias - 2.5) * 45): ' 47
bias$ = LTRIM$(STR$(CINT(bias * 100) / 100))
bias$ = LEFT$(bias$ + "V   ", 6): COLOR 10

COLOR col(12): LOCATE dn + 1, ac - 15: PRINT bias$
COLOR col(10): LOCATE 5, 6: PRINT "CYCLE COUNT = "; freq$(0)
COLOR col(14): LOCATE 2, 41: PRINT "NOISE = "; noise$: RETURN

'...........

500 : COLOR 10: LOCATE 23, 25
PRINT "INVERTING COMPARATOR + HYSTERISIS": COLOR 11
y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
ac = 44: dn = 12: x1 = ac * 8 + 53: y1 = (dn - 2) * 14 + 49: yb = y1: vw = 1
bias = 2.5: pan = 8

COLOR 15: GOSUB res3: GOSUB res5: ax = 42 * 8: ay = 12 * 14 + 4
PUT (ax, ay + 25), dot%, OR: PUT (ax + 48 + 28, ay + 13), dot%, OR

x1 = ac * 8 - 124: y1 = (dn) * 14 + 1: ya = y1 + 7
LINE (x1 - 24, ya)-(x1 + 40 + 88, ya)

COLOR 11: LOCATE dn + 3, ac - 15: PRINT "BIAS"; : COLOR 15
LOCATE dn + 2, ac - 15: PRINT "B ="
COLOR 10: LOCATE 4, 65: PRINT "OUTPUT"
LOCATE 5, 27: PRINT "REFERENCE HIGH = "
LOCATE 6, 27: PRINT "R3/(R3+R5) * (4V - BIAS)"
LOCATE 9, 27: PRINT "REFERENCE LOW = "
LOCATE 10, 27: PRINT "R5/(R3+R5) * (BIAS - 1V)"
COLOR 11: LOCATE 6, 63: PRINT "GAIN = MAX": COLOR 15
LOCATE 23, 15: PRINT "S = "; : COLOR 11: PRINT "STEP": COLOR 15
LOCATE 24, 3: PRINT "N = "; : COLOR 11: PRINT "NOISE = 0"; : noise = 0
noise$ = "0": LOCATE 1, 1

volts(0) = .5: volt$(0) = "1V": freq(0) = 2: freq$(0) = "2"
pan = 12: GOSUB showval5

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
y = y + 70 - 21 - 50: yx = y - 40
angle = 45: angle2 = 45: GOSUB sinea: prevsine = sine1
angle2 = 45: y2 = sine1: lastsine1 = sine1: lastsine2 = sine1

510 :
angle = 45: angle2 = 45: GOSUB sinea: prevsine = sine1
angle = 45: angle2 = 45: y2 = sine1:
prevsine = sine1: prevx = x1 + 1: prevsinex = sine2
prevx2 = x2 + 1: prevsine2 = y3
'lastsine1 = sine1:
'lastsine2 = sine1
lastsine2 = -69: y3 = -69

LINE (x2 - 1, y - lastsine2 + 8)-(x2 - 5, y - lastsine2 + 8), 0
LINE -(x2 - 5, yb), 0: LINE (x2 - 1, y - y3 + 8)-(x2 - 5, y - y3 + 8), 10
LINE -(x2 - 5, yb), 10

FOR x = 1 TO 179: rand(x) = (RND(1) - .5) * noise + sine1
y2 = INT(rand(x)): IF y2 > 110 THEN y2 = 110
IF y2 < -110 THEN y2 = -110
IF y2 > biashi THEN y3 = -69
IF y2 < biaslo THEN y3 = 69

GOSUB sinea: LINE (x + x1, yy - y1 + 28)-(x + x1, yy + y1 - 24), 0
LINE (prevx, y - prevsine + 3)-(x + x1, y - y2 + 3), cola
prevx = x + x1: prevsine = y2:

LINE (x + x2, yy - y1 + 79)-(x + x2, yy + y1 - 65), 0
LINE (prevx2, y - prevsine2 + 8)-(x + x2, y - y3 + 8), 10
prevx2 = x + x2: prevsine2 = y3: NEXT

b2 = biashi - 3: LINE (x1 + 1, y - b2)-(x1 + 179, y - b2), 11
b2 = biaslo - 3: LINE (x1 + 1, y - b2)-(x1 + 179, y - b2), 12

LINE (x1 + 181, y - lastsine1 + 3)-(x1 + 190, y - lastsine1 + 3), 0
LINE -(x1 + 190, ya), 0
LINE (x1 + 181, y - y2 + 3)-(x1 + 190, y - y2 + 3), 10
LINE -(x1 + 190, ya), 10: lastsine1 = y2

535 : z$ = INKEY$: IF z$ = "" THEN GOTO 535
IF UCASE$(z$) = "S" THEN GOTO 510
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo5: GOTO 510

'.............

demo5: z = VAL(z$)
IF z = 3 OR z = 5 THEN pan = z: vw = 0: GOTO showval5
IF UCASE$(z$) <> "V" THEN GOTO demo5a
pan = 8: GOTO showval5
demo5a: IF UCASE$(z$) <> "F" THEN GOTO demo5b
pan = 10: GOTO showval5
demo5b: IF UCASE$(z$) <> "B" THEN GOTO demo5c
pan = 12: GOTO showval5
demo5c: IF UCASE$(z$) <> "N" THEN GOTO demo5d
pan = 14: GOTO showval5
demo5d:

IF z$ = "+" THEN GOTO resinc5
IF z$ = "-" THEN GOTO resdec5
IF z$ = "*" THEN GOTO resmult5
IF z$ = "/" THEN GOTO resdivide5
RETURN

resinc5: IF pan = 8 OR pan = 9 THEN GOTO voltinc5
IF pan = 10 OR pan = 11 THEN GOTO freqinc5
IF pan = 12 THEN GOTO biasinc5
IF pan = 14 THEN GOTO noiseinc5
r(pan) = r(pan) + 1: IF r(pan) > 217 THEN r(pan) = 217
GOTO showval5
resdec5: IF pan = 8 OR pan = 9 THEN GOTO voltdec5
IF pan = 10 OR pan = 11 THEN GOTO freqdec5
IF pan = 12 THEN GOTO biasdec5
IF pan = 14 THEN GOTO noisedec5
r(pan) = r(pan) - 1: IF r(pan) < 1 THEN r(pan) = 1
GOTO showval5
resmult5: IF pan = 8 OR pan = 9 THEN GOTO voltmult5
IF pan = 10 OR pan = 11 THEN GOTO freqmult5
IF pan = 12 THEN GOTO biasmult5
IF pan = 14 THEN GOTO noisemult5
r(pan) = r(pan) + 24: IF r(pan) > 217 THEN r(pan) = 217
GOTO showval5
resdivide5: IF pan = 8 OR pan = 9 THEN GOTO voltdivide5
IF pan = 10 OR pan = 11 THEN GOTO freqdivide5
IF pan = 12 THEN GOTO biasdivide5
IF pan = 14 THEN GOTO noisedivide5
r(pan) = r(pan) - 24: IF r(pan) < 1 THEN r(pan) = 1
GOTO showval5

voltinc5: volts(0) = volts(0) + .05: GOTO voltcheck5
voltdec5: volts(0) = volts(0) - .05: GOTO voltcheck5
voltmult5: volts(0) = volts(0) + .5: GOTO voltcheck5
voltdivide5: volts(0) = volts(0) - .5: GOTO voltcheck5

voltcheck5:
IF volts(0) > 2.5 THEN volts(0) = 2.5
IF volts(0) < 0 THEN volts(0) = 0
volt$(0) = LTRIM$(STR$(CINT(volts(0) * 200) / 100))
IF volts(0) < .5 AND volts(0) > 0 THEN volt$(0) = "0" + volt$(0)
volt$(0) = LEFT$(volt$(0) + "V  ", 4)
GOTO showval5

freqinc5: freq(0) = ABS(freq(0)) + .1: GOTO freqcheck5
freqdec5: freq(0) = ABS(freq(0)) - .1: GOTO freqcheck5
freqmult5: freq(0) = ABS(freq(0)) + 1: GOTO freqcheck5
freqdivide5: freq(0) = ABS(freq(0)) - 1: GOTO freqcheck5

freqcheck5:
IF freq(0) > 22 THEN freq(0) = 22
IF freq(0) < .1 THEN freq(0) = .1
freq$(0) = LTRIM$(STR$(CINT(freq(0) * 10) / 10))
freq$(0) = LEFT$(freq$(0) + "  ", 4)
angle = 0: angle2 = 0: GOTO showval5

biasinc5: bias = bias + .05: GOTO biasshow5
biasdec5: bias = bias - .05: GOTO biasshow5
biasmult5: bias = bias + .5: GOTO biasshow5
biasdivide5: bias = bias - .5: GOTO biasshow5

biasshow5:
IF bias > 5 THEN bias = 5
IF bias < 0 THEN bias = 0
bias2 = (bias - 2.5) * 47
bias$ = LTRIM$(STR$(CINT(bias * 100) / 100))
bias$ = LEFT$(bias$ + "V  ", 5): COLOR 10
GOTO showval5

noiseinc5: noise = noise + 1: GOTO noiseshow5
noisedec5: noise = noise - 1: GOTO noiseshow5
noisemult5: noise = noise + 10: GOTO noiseshow5
noisedivide5: noise = noise - 10: GOTO noiseshow5

noiseshow5:
IF noise > 50 THEN noise = 50
IF noise < 0 THEN noise = 0
noise$ = LTRIM$(STR$(INT(noise * 100) / 100))
noise$ = LEFT$(noise$ + "    ", 5): COLOR 10
GOTO showval5

showval5: ac = 44: dn = 12
FOR a = 1 TO 7: col(a) = 11: NEXT: col(8) = 10: col(9) = 10
col(10) = 10: col(11) = 10: col(12) = 11: col(14) = 11: col(pan) = 14
cola = col(8) OR col(10): colb = col(9) OR col(11)
COLOR (col(3)): LOCATE dn + 4, ac - 8: PRINT "R3 "; res$(r(3))
COLOR (col(5)): LOCATE dn + 7, ac + 1: PRINT "R5 "; res$(r(5))

gain = 10000
outrange = CINT(volts(0) * 2 * 10) / 10: outrange = outrange * gain
IF outrange > 3 THEN outrange = 3
outrange$ = volts$(outrange * 10)

bias2 = (bias - 2.5) * 45
bias$ = LTRIM$(STR$(CINT(bias * 100) / 100))
bias$ = LEFT$(bias$ + "V   ", 6): COLOR 10

COLOR col(12): LOCATE dn + 4, ac - 15: PRINT bias$
voltshi = 2.5 + volts(0)
voltslo = 2.5 - volts(0)
voltshi$ = LTRIM$(STR$(CINT(voltshi * 100) / 100)) + "V"
voltslo$ = LTRIM$(STR$(CINT(voltslo * 100) / 100)) + "V"
range$ = LEFT$(voltslo$ + " TO " + voltshi$ + "       ", 14)

COLOR col(8): LOCATE 4, 4: PRINT "RANGE= "; range$

COLOR col(10): LOCATE 5, 6: PRINT "CYCLE COUNT = "; freq$(0)
v = 4 - bias: v1 = res(r(3)) / (res(r(3)) + res(r(5))) * v
biashi = (v1 + bias): biashi$ = LTRIM$(STR$(CINT(biashi * 100) / 100))
biashi$ = LEFT$(biashi$ + "V   ", 6): 'biashi = (biashi * 5.7)
biashi = (biashi - 2.5) * 45
v = bias - 1: v1 = res(r(5)) / (res(r(3)) + res(r(5))) * v
biaslo = (v1 + 1): biaslo$ = LTRIM$(STR$(CINT(biaslo * 100) / 100))
biaslo$ = LEFT$(biaslo$ + "V   ", 6):  biaslo = -(2.5 - biaslo) * 45
COLOR 11: LOCATE 7, 27: PRINT "= "; biashi$
LOCATE 11, 27: PRINT "= "; biaslo$:
COLOR col(14): LOCATE 24, 7: PRINT "NOISE = "; noise$; : LOCATE 1, 1
RETURN

'..........

600 : RETURN: COLOR 11: LOCATE 23, 18: PRINT "OP.AMP BANDPASS FILTER": COLOR 11

' THIS SECTION NOT AVAILABLE - NOT COMPLETE AND WITH MANY BUGS!

COLOR 11
LOCATE 2, 3: PRINT "CONTROLS (WHITE):  FREQ   VOLTS   CAPS   ";
PRINT "R1   R2         + - * / = VALUES"
COLOR 15
LOCATE 2, 22: PRINT "F"
LOCATE 2, 29: PRINT "V"
LOCATE 2, 37: PRINT "C"
LOCATE 2, 45: PRINT "1"
LOCATE 2, 50: PRINT "2"
LOCATE 2, 60: PRINT "+ - * /"

601
y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
ac = 44: dn = 12: x1 = ac * 8 + 53: y1 = (dn - 2) * 14 + 49: yb = y1: vw = 1
timescale = 10:
t = 0: tscale = .005 * 2.5: '.01 * 2.5
tscale = 1.225
a = timescale - 10: B = 10 ^ a: tval = tscale * B
v = 280: bot = 315: vscale = 1
pan = 1: vw = 0

cap(0) = 49: ' 100uF
cap(1) = 31 + 6: '100n

r(1) = 97 + 48: '1M
r(2) = 97 + 48: '1M
GOSUB cap1: GOSUB cap4: GOSUB res1: GOSUB res2: GOSUB res3: GOSUB res4
COLOR 11: LOCATE dn + 3, ac - 13: PRINT "+5V"
LOCATE 6, 58: PRINT "GAIN = R2/R1 ="
LOCATE 7, 58: PRINT "BIAS=R4/(R3+R4)=":
COLOR 15

volts(0) = .5: freq(0) = 5: freq$(0) = "5"
GOSUB voltshow6: GOSUB showval6

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
y = y + 70 - 21 - 50: yx = y - 40
angle = 0: angle2 = 0: GOSUB sined: prevsine = sine1
angle2 = 0: y2 = sine1: lastsine1 = sine1: lastsine2 = sine1
v = sine1: vc = 0

610 :
c = cap(cap(0)) / 1000000: r = res(r(1)) / 1000000: cr = c * r / 100: '00
LOCATE 1, 1: PRINT c, r, "TIME CONSTANT"; cr; "   "

prevsine = sine1: prevx = x1 + 1: prevsinex = sine2
angle = 0: freq(0) = ABS(freq(0)): t = 0

v = 0
FOR x = 1 TO 179: GOSUB sined: y2 = sine1: IF y2 > v THEN v = y2
IF mode <> SGN(freq(0)) THEN t = 0: ' v = -vc: ta = 0
mode = SGN(freq(0))

IF mode = 1 THEN vc = v * (1 - EXP(-t / cr)): 'charge
IF mode = -1 THEN vc = v * (EXP(-t / cr)): 'discharge
t = t + tval: colj = 12

615 :
LINE (x + x1, yy - y1 + 28)-(x + x1, yy + y1 - 24), 0
LINE (prevx, y - prevsine + 3)-(x + x1, y - y2 + 3), cola
prevx = x + x1: prevsine = y2: NEXT

LINE (x1 + 181, y - lastsine1 + 3)-(x1 + 190, y - lastsine1 + 3), 0
LINE -(x1 + 190, ya), 0
LINE (x1 + 181, y - y2 + 3)-(x1 + 190, y - y2 + 3), 10
LINE -(x1 + 190, ya), 10: lastsine1 = y2

620 : prevx = x2 + 1:
y3 = -sine1 * gain + bias2
IF y3 > 69 THEN y3 = 69 ELSE IF y3 < -69 THEN y3 = -69
prevsine2 = y3
LINE (x2 - 1, y - lastsine2 + 8)-(x2 - 5, y - lastsine2 + 8), 0
LINE -(x2 - 5, yb), 0: LINE (x2 - 1, y - y3 + 8)-(x2 - 5, y - y3 + 8), colj
LINE -(x2 - 5, yb), 10: lastsine2 = y3
vc = v
prevj = sine1

'OUTPUT WAVEFORM
FOR x = 1 TO 179: GOSUB sined
IF mode <> SGN(freq(0)) THEN t = 0: ' v = -vc: ta = 0
mode = SGN(freq(0))

IF sine1 <> prevj THEN vc = vc + (cr * freq(0)): GOTO 630: 't = 0

IF mode = 1 THEN vc = ((1 - EXP(-t / cr)) * sine1): colj = 11: 'charge
IF mode = -1 THEN vc = -((EXP(-t / cr)) * sine1): colj = 12: 'discharge
t = t + tval:

630 : y3 = (vc * gain): IF y3 > 69 THEN y3 = 69
IF y3 < -69 THEN y3 = -69
LINE (x + x2, yy - y1 + 79)-(x + x2, yy + y1 - 65), 0
LINE (prevx, y + prevsine2 + 8)-(x + x2, y + y3 + 8), colj
prevj = sine1: prevx = x + x2: ' prevsined = sine1:
prevsine2 = y3: NEXT

635 : z$ = INKEY$: IF z$ = "" THEN GOTO 610
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo6: GOTO 610

'.............

demo6: z = VAL(z$):
IF z > 0 AND z < 8 AND z <> 5 THEN pan = z: vw = 0: GOTO showval6
IF UCASE$(z$) <> "V" THEN GOTO demo6a
pan = 8: GOTO showval6
demo6a: IF UCASE$(z$) <> "F" THEN GOTO demo6b
pan = 10: GOTO showval6
demo6b: IF UCASE$(z$) <> "C" THEN GOTO demo6c
IF pan > 10 THEN vw = (vw + 1) AND 1
pan = 11 + vw: GOTO showval6
demo6c:
IF UCASE$(z$) <> "T" THEN GOTO demo6d
pan = 13: GOTO showval6

demo6d:
IF z$ = "+" THEN GOSUB resinc6: RETURN
IF z$ = "-" THEN GOSUB resdec6: RETURN
IF z$ = "*" THEN GOSUB resmult6: RETURN
IF z$ = "/" THEN GOSUB resdivide6: RETURN
RETURN

resinc6: IF pan = 8 OR pan = 9 THEN GOTO voltinc6
IF pan = 10 THEN GOTO freqinc6
IF pan = 11 OR pan = 12 THEN GOTO capinc6
IF pan = 13 THEN GOTO timeinc6
r(pan) = r(pan) + 1: IF r(pan) > 153 THEN r(pan) = 153
IF pan = 1 THEN r(2) = r(2) + 1: IF r(2) > 153 THEN r(2) = 153
GOTO showval6
resdec6: IF pan = 8 OR pan = 9 THEN GOTO voltdec6
IF pan = 10 THEN GOTO freqdec6
IF pan = 11 OR pan = 12 THEN GOTO capdec6
IF pan = 13 THEN GOTO timedec6
r(pan) = r(pan) - 1: IF r(pan) < 1 THEN r(pan) = 1
IF pan = 1 THEN r(2) = r(2) - 1: IF r(2) < 1 THEN r(2) = 1
GOTO showval6
resmult6: IF pan = 8 OR pan = 9 THEN GOTO voltmult3
IF pan = 10 THEN GOTO freqmult6
IF pan = 11 OR pan = 12 THEN GOTO capmult6
IF pan = 13 THEN GOTO timemult6
r(pan) = r(pan) + 24: IF r(pan) > 153 THEN r(pan) = 153
IF pan = 1 THEN r(2) = r(2) + 24: IF r(2) > 153 THEN r(2) = 153
GOTO showval6
resdivide6: IF pan = 8 OR pan = 9 THEN GOTO voltdivide6
IF pan = 10 THEN GOTO freqdivide6
IF pan = 11 OR pan = 12 THEN GOTO capdivide6
IF pan = 13 THEN GOTO timedivide6
r(pan) = r(pan) - 24: IF r(pan) < 1 THEN r(pan) = 1
IF pan = 1 THEN r(2) = r(2) - 24: IF r(2) < 1 THEN r(2) = 1
GOTO showval6

voltinc6: volts(0) = volts(0) + .05: GOTO voltshow6
voltdec6: volts(0) = volts(0) - .05: GOTO voltshow6
voltmult6: volts(0) = volts(0) + .5: GOTO voltshow6
voltdivide6: volts(0) = volts(0) - .5: GOTO voltshow6

freqinc6: freq(0) = ABS(freq(0)) + .1: GOTO freqshow6
freqdec6: freq(0) = ABS(freq(0)) - .1: GOTO freqshow6
freqmult6: freq(0) = ABS(freq(0)) + 1: GOTO freqshow6
freqdivide6: freq(0) = ABS(freq(0)) - 1: GOTO freqshow6

freqshow6:
IF freq(0) > 22 THEN freq(0) = 22
IF freq(0) < .1 THEN freq(0) = .1
freq$(0) = LTRIM$(STR$(CINT(freq(0) * 10) / 10))
freq$(0) = LEFT$(freq$(0) + "  ", 4)
angle = 0: angle2 = 0: GOTO voltshow6

capinc6: cap(vw) = cap(vw) + 1: GOTO capshow6
capdec6: cap(vw) = cap(vw) - 1: GOTO capshow6
capmult6: cap(vw) = cap(vw) + 6: GOTO capshow6
capdivide6: cap(vw) = cap(vw0) - 6: GOTO capshow6

capshow6:
IF cap(vw) > 55 THEN cap(vw) = 55: ' 49
IF cap(vw) < 1 THEN cap(vw) = 1
GOTO showval6

timeinc6: tscale = tscale + .001: GOTO timeshow6
timedec6: tscale = tscale - .001: GOTO timeshow6
timemult6: tscale = tscale + .1: GOTO timeshow6
timedivide6: tscale = tscale - .1: GOTO timeshow6

timeshow6:
IF tscale < .001 THEN tscale = .001
a = timescale - 10: B = 10 ^ a: tval = tscale * B
LOCATE 3, 40: PRINT tval; "   "
GOTO showval6

showval6: ac = 44: dn = 12
FOR a = 1 TO 7: col(a) = 11: NEXT: col(8) = 10: col(9) = 10
col(10) = 10: col(11) = 11: col(12) = 11: col(pan) = 14
cola = col(8) OR col(10): colb = col(9) OR col(11)

COLOR (col(1)): LOCATE dn, ac - 8: PRINT "R1 "; res$(r(1))
IF pan = 1 OR pan = 2 THEN COLOR (col(2)): LOCATE dn - 3, ac + 1: PRINT "R2 "; res$(r(2))
COLOR (col(3)): LOCATE dn + 4, ac - 8: PRINT "R3 "; res$(r(3))
COLOR (col(4)): LOCATE dn + 8, ac + 1: PRINT "R4 "; res$(r(4))
COLOR (col(11)): LOCATE dn, ac - 17: PRINT "C1 "; cap$(cap(0))
COLOR (col(12)): LOCATE dn - 6, ac - 1: PRINT "C4 "; cap$(cap(1))

gain = res(r(2)) / res(r(1)): IF gain >= 100 THEN gain = INT(gain)
outrange = CINT(volts(0) * 2 * 10) / 10
outrange = outrange * gain
IF outrange > 3 THEN outrange = 3
outrange$ = volts$(outrange * 10)

bias = 5 * res(r(4)) / (res(r(3)) + res(r(4)))
bias2 = (bias - 2.5) * 47
gain2$ = " MAX  ": gain$ = " MAX  "
IF gain <= 100000 THEN gain$ = STR$(INT(gain * 10) / 10)
bias$ = LTRIM$(STR$(CINT(bias * 10) / 10))
gain$ = LEFT$(gain$ + "   ", 7)
bias$ = LEFT$(bias$ + "V  ", 5): COLOR 10
LOCATE 6, 72: PRINT gain$
LOCATE 7, 74: PRINT bias$: ' STOP
LOCATE 4, 58: PRINT "OUTPUT PK-PK = "; outrange$
'GOSUB voltshow6: RETURN

voltshow6:
IF volts(0) > 2.5 THEN volts(0) = 2.5
IF volts(0) < 0 THEN volts(0) = 0
volt$(0) = LTRIM$(STR$(CINT(volts(0) * 200) / 100))
IF volts(0) < .5 AND volts(0) > 0 THEN volt$(0) = "0" + volt$(0)
volt$(0) = LEFT$(volt$(0) + "V  ", 4)
COLOR col(8): LOCATE 4, 6: PRINT "INPUT PK-PK = "; volt$(0)
COLOR col(10): LOCATE 5, 6: PRINT "CYCLE COUNT = "; freq$(0)

bias = INT(bias * 10) / 10: bias$ = LTRIM$(STR$(bias)) + "V"
bias$ = LEFT$(bias$ + "   ", 4): RETURN

'..............

highlight:
ax = ac * 8 - 1: dx = dn * 14 + 1: ay = (ac + 33) * 8: dy = dx + 14 - 2
GET (ax, dx)-(ay, dy), h%: PUT (ax, dx), h%, PRESET: RETURN

'**********

commonscreen:

r(1) = 97: '10k
r(2) = 97: '10k
r(3) = 97: '10k
r(4) = 97: '10k
r(5) = 109: '33k
r(6) = 97: '10k
r(7) = 73 + 48: '100k

COLOR 11: GOSUB clearit
LOCATE 2, 3: PRINT "           F = FREQ   V = VOLTS   ";
PRINT "NUMERALS = RESISTORS   + - * / = VALUES"
COLOR 15
LOCATE 2, 14: PRINT "F"
LOCATE 2, 25: PRINT "V"
LOCATE 2, 37: PRINT "NUMERALS"
LOCATE 2, 60: PRINT "+ - * /"
COLOR 11
LOCATE 9, 54: PRINT "4V"
LOCATE 19, 54: PRINT "1V"
LOCATE 3, 27: PRINT "VALUE CHANGEABLE WHEN YELLOW": COLOR 15
LOCATE 23, 3: PRINT "M "; : COLOR 11: PRINT "= MENU"

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8 - 1: y1 = 141
LINE (x1, y - y1 - 7)-(x1 + 180, y + y1 - 21), 15, B: 'box 1
LINE (x2, y - y1 - 7)-(x2 + 180, y + y1 - 21), 15, B: 'box 5
LINE (x2 - 4, y - y1 + 78)-(x2 + 180, y - y1 + 78), 12
LINE (x2 - 4, y + y1 - 72 + 8)-(x2 + 180, y + y1 - 72 + 8), 12

ac = 44: dn = 12: GOSUB opamp: COLOR 15

x1 = ac * 8 + 53: y1 = (dn - 2) * 14 + 49: ' opamp output
LINE (x1, y1)-(x1 + 30 + 5, y1), 15: yb = y1: vw = 1
RETURN

