'TY2KD001 21FEB00 - TEACH-IN TRANSISTORS
WIDTH 80, 25: SCREEN 9: COLOR 15, 1: RANDOMIZE TIMER
CONST pi = 3.141592653589# / 180
DIM a%(3200), B%(1700), npn%(1700), pnp%(1700), hres%(380), vres%(380)
DIM hcap%(200), vcap%(1380), v%(2, 300), angle(300), pan(16), R(6)
DIM res(217), decival%(12), R$(9), res$(217), col(13), dot%(200)

DIM h%(1000), menu$(40): version$ = "V1.1": ' CLS
DIM arrowright%(70), arrowleft%(70), arrowup%(70), arrowdown%(70)

DATA "TRANSISTORS - PRINCIPLE           0 TY2KD001"
DATA "NPN DC VOLTAGE AMPLIFIER          1 TY2KD001"
DATA "NPN AC VOLTAGE AMPLIFIER          2 TY2KD001"
DATA "NPN DC CURRENT AMPLIFIER          3 TY2KD001"
DATA "NPN PHASE-SPLIT AMPLIFIER         4 TY2KD001"
DATA "MAIN MENU                         6 TY2KMENU"
DATA *

GOSUB clearit: LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15: COLOR 14: GOSUB setup

GOSUB clearit: GOSUB dotmake: LOCATE 10, 35: PRINT "SETTING UP"

LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15
LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15

LOCATE 10, 35: PRINT "          ": a = 0

setmenu: READ menu$(a): IF menu$(a) <> "*" THEN a = a + 1: GOTO setmenu
maxmenu = a - 1: menucolumn = CINT(maxmenu / 2) + 1: l = LEN(menu$(0)) - 10
menu$(a) = ""

menu: GOSUB clearit: COLOR 14:  menupath = 3: 'GOTO 500
LOCATE 2, 23:  PRINT "TEACH-IN 2000 TRANSISTORS MENU  "; version$: COLOR 15
LINE (154 + 16, 35 - 26)-(456 + 16 - 14 + 10, 63 - 30), 15, B
LINE (157 + 16, 38 - 26)-(453 + 16 - 14 + 10, 60 - 30), 15, B
PAINT (155 + 16, 36 - 26), 7, 15: COLOR 11

FOR a = 0 TO menucolumn - 1: LOCATE a + 4, 4: PRINT LEFT$(menu$(a), l)
LOCATE a + 4, 43: PRINT LEFT$(menu$(a + menucolumn), l): NEXT

COLOR 14: LOCATE 9, 19: PRINT "SELECT WITH CURSOR ARROWS THEN PRESS <ENTER>"
COLOR 14: LOCATE 10, 27: PRINT "M"; : COLOR 11: PRINT " AND "; : COLOR 14
PRINT "Q "; : COLOR 11: PRINT "ALSO CALL MAIN MENU"; : LOCATE 1, 1

ac = (band \ menucolumn) * 39 + 3: dn = band MOD menucolumn + 3
GOSUB highlight2: COLOR 10

LOCATE 13, 4
PRINT "In the screens that follow the Principles, the QuickBASIC program used to"
LOCATE 14, 4
PRINT "calculate the display results is shown at the top. It should be noted that"
LOCATE 15, 4
PRINT "real transistors do not have responses that can be predicted as precisely"
LOCATE 16, 4
PRINT "as the program would imply. For example, the quoted transistor turn-on and"
LOCATE 17, 4
PRINT "turn-off level of 0.6V is less rigid than this, there is in fact a voltage"
LOCATE 18, 4
PRINT "somewhat below it at which a transistor just begins to start turning on,"
LOCATE 19, 4
PRINT "at 0.55V perhaps; the turn-on becomes greater as the voltage continues to"
LOCATE 20, 4
PRINT "rise, until full turn-on occurs, at 0.65V or higher. The demos should be"
LOCATE 21, 4
PRINT "treated, therefore, as a very generalised guide to transistor behaviour."
LOCATE 22, 4
PRINT "The Teach-In 2000 text discusses transistor characteristics."

getkey: a$ = INKEY$: IF a$ = "" THEN GOTO getkey
IF UCASE$(a$) = "M" THEN CHAIN "TY2KMENU"
IF UCASE$(a$) = "Q" THEN CHAIN "TY2KMENU"
IF a$ = CHR$(13) THEN GOTO 20
a$ = UCASE$(MID$(a$, 2)): IF a$ = "" THEN GOTO getkey
IF a$ = "M" THEN band = band + menucolumn: GOTO 10:  'right
IF a$ = "K" THEN band = band - menucolumn: GOTO 10: 'left
IF a$ = "P" THEN band = band + 1: GOTO 10: 'down
IF a$ = "H" THEN band = band - 1: GOTO 10: 'up
IF a$ = "G" THEN band = 0: GOTO 10: 'home
IF a$ = "O" THEN band = maxmenu: GOTO 10: 'end
IF a$ = "Q" THEN band = menucolumn - 1: GOTO 10: 'page down
IF a$ = "I" THEN band = 0: GOTO 10: 'page up
GOTO getkey

10 : IF band > maxmenu THEN band = maxmenu ELSE IF band < 0 THEN band = 0
GOSUB highlight2: ac = (band \ menucolumn) * 39 + 3
dn = band MOD menucolumn + 3: GOSUB highlight2: GOTO getkey

20 : menu$ = RIGHT$(menu$(band), 8): menu = VAL(RIGHT$(menu$(band), 10))
menupath = menu + 1

IF menupath = 7 THEN CHAIN "TY2KMENU"
ON menupath GOTO 100, 200, 300, 400, 500: ', 600: ' mainmenu

cursorcodes: ' mid$(inkey$,2)
'ARROWS: K left, M right, P dn, H up,'home G, end O, page up I, page down Q

hold: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO hold ELSE RETURN

'............

100 : GOSUB clearit
COLOR 11: LOCATE 2, 26: PRINT "TRANSISTORS - BASIC PRINCIPLES"
LOCATE 2, 70: PRINT "MENU "; : COLOR 14: PRINT "<M>"
COLOR 10: LOCATE 24, 4: PRINT "CONTROLS:  ";
COLOR 11: PRINT "BASE CURRENT:"; : COLOR 14: PRINT " * / + -   ";
COLOR 11: PRINT " hfe: "; : COLOR 14: PRINT "up/dn arrows   ";
COLOR 11: PRINT " hfe SET FOR "; : COLOR 14: PRINT "100";

COLOR 10: LOCATE 3, 4:
PRINT "A transistor's gain factor"; : COLOR 14: PRINT " (hfe) "; : COLOR 10:
PRINT "is the ratio of the current flowing into"
LOCATE 4, 4: COLOR 14: PRINT "(NPN type)"; : COLOR 10:
PRINT " or out of "; : COLOR 14: PRINT "(PNP type)"; : COLOR 10: PRINT " its base "; :
COLOR 14: PRINT "(b)"; : COLOR 10: PRINT " and that flowing between its"
LOCATE 5, 4: PRINT "collector "; : COLOR 14: PRINT "(c)"; : COLOR 10
PRINT " and emitter "; : COLOR 14: PRINT "(e)"; : COLOR 10
PRINT ", e.g.: an hfe of 100 means that a base": LOCATE 6, 4
PRINT "current of 1mA will cause a collector-emitter current of 100mA. Transistor"
LOCATE 7, 4:
PRINT "gain and power handling are fixed during manufacture and vary between"
LOCATE 8, 4:
PRINT "types. Note the different current flow directions for NPN and PNP."
LOCATE 9, 4: PRINT "Arrows "; : COLOR 14: PRINT "Vc, Vb, Ve"; : COLOR 10
PRINT " are voltage notations. Red arrows are current direction."

COLOR 10: LOCATE 19, 4: PRINT "For transistors manufactured from";
COLOR 14: PRINT " silicon:": LOCATE 20, 4: COLOR 10
PRINT "Collector-emitter current will only flow if the voltage on the base is"
LOCATE 21, 4
COLOR 14: PRINT "(NPN type):"; : COLOR 10: PRINT " about 0.6V";
COLOR 14: PRINT " above"; : COLOR 10: PRINT " the emitter voltage"
LOCATE 22, 4
COLOR 14: PRINT "(PNP type):"; : COLOR 10: PRINT " about 0.6V";
COLOR 14: PRINT " below"; : COLOR 10: PRINT " the emitter voltage"

'npn:
a = 5: ac = 10 - a: dn = 12: hfe = 100: amps = 1: s = 0:
PUT ((ac + 32 - 7) * 8 - 2 - 2 + 2, dn * 14 - 6 + 2 - 6), npn%, PSET

COLOR 11: LOCATE 9 + 2, 10 - a: PRINT "Current through   to  "
LOCATE 12 + 2, 10 - a: PRINT "Current through   to  "
LOCATE 17, 10 - a: PRINT "Total current     +  "
COLOR 14
LOCATE 10 + 2, 10 - a: PRINT "(Ic)"
LOCATE 13 + 2, 10 - a: PRINT "(Ib)"
LOCATE 18, 10 - a: PRINT "(Ie)"
COLOR 11
LOCATE 10 + 2, 30 - a: PRINT "mA"
LOCATE 13 + 2, 30 - a: PRINT "mA"
LOCATE 18, 30 - a: PRINT "mA"

COLOR 14: LOCATE 9 + 2, 26 - a: PRINT "c":
LOCATE 9 + 2, 31 - a: PRINT "e":
LOCATE 12 + 2, 26 - a: PRINT "b":
LOCATE 12 + 2, 31 - a: PRINT "e":
LOCATE 17, 25 - a: PRINT "ce":
LOCATE 17, 30 - a: PRINT "be":
LOCATE 10, 30: PRINT "NPN TYPE"

LINE (3 * 8, 10 * 14)-(27 * 8, 12 * 14), 15, B: 'c-e box
LINE (27 * 8, 11 * 14)-(37 * 8 - 4, 11 * 14), 15: 'c-e right
LINE -(37 * 8 - 4, 12 * 14), 15: 'c-e down
PUT (29 * 8 - 3, 11 * 14 - 8), arrowright%, PSET: 'c-e arrow

LINE (3 * 8, 13 * 14)-(27 * 8, 15 * 14), 15, B: 'b-e box
LINE (27 * 8, 14 * 14)-(29 * 8 + 5, 14 * 14), 15: 'b-e right
PUT (29 * 8 - 3, 14 * 14 - 8), arrowright%, PSET: 'b-e arrow

LINE (3 * 8, 16 * 14)-(27 * 8, 18 * 14), 15, B: 'e box
LINE (27 * 8, 17 * 14)-(37 * 8 - 4, 17 * 14), 15: 'e right
LINE -(37 * 8 - 4, 16 * 14), 15: 'e up
PUT (29 * 8 - 3, 16 * 14 + 6), arrowleft%, PSET: 'e arrow

'pnp
a = -33: B = 38: ac = 10 - a: dn = 12:
PUT ((ac + 32 - 7) * 8 - 2 - 2 + 2, dn * 14 - 6 + 2 + 2 - 6), pnp%, PSET

COLOR 11: LOCATE 9 + 2, 10 - a: PRINT "Total current     +  "
LOCATE 12 + 2, 10 - a: PRINT "Current through   to  "
LOCATE 17, 10 - a: PRINT "Current through   to  "
COLOR 14
LOCATE 10 + 2, 10 - a: PRINT "(Ie)"
LOCATE 13 + 2, 10 - a: PRINT "(Ib)"
LOCATE 18, 10 - a: PRINT "(Ic)"
COLOR 11
LOCATE 10 + 2, 30 - a: PRINT "mA"
LOCATE 13 + 2, 30 - a: PRINT "mA"
LOCATE 18, 30 - a: PRINT "mA"

COLOR 14: LOCATE 9 + 2, 26 - a - 1: PRINT "ec":
LOCATE 9 + 2, 31 - a - 1: PRINT "eb":
LOCATE 12 + 2, 26 - a: PRINT "e":
LOCATE 12 + 2, 31 - a: PRINT "b":
LOCATE 17, 25 - a + 1: PRINT "e":
LOCATE 17, 30 - a + 1: PRINT "c":
LOCATE 10, 68: PRINT "PNP TYPE"

LINE ((3 + B) * 8, 10 * 14)-((27 + B) * 8, 12 * 14), 15, B: 'c-e box
LINE ((27 + B) * 8, 11 * 14)-((37 + B) * 8 - 4, 11 * 14), 15: 'c-e right
LINE -((37 + B) * 8 - 4, 12 * 14), 15: 'c-e down
PUT ((29 + B) * 8 - 3, 10 * 14 + 6), arrowright%, PSET: 'e-c arrow

LINE ((3 + B) * 8, 13 * 14)-((27 + B) * 8, 15 * 14), 15, B: 'b-e box
LINE ((27 + B) * 8, 14 * 14)-((29 + B) * 8 + 5, 14 * 14), 15: 'b-e right
PUT ((29 + B) * 8 - 3, 13 * 14 + 6), arrowleft%, PSET: 'e-b arrow

LINE ((3 + B) * 8, 16 * 14)-((27 + B) * 8, 18 * 14), 15, B: 'e box
LINE ((27 + B) * 8, 17 * 14)-((37 + B) * 8 - 4, 17 * 14), 15: 'e right
LINE -((37 + B) * 8 - 4, 16 * 14), 15: 'e up
PUT ((29 + B) * 8 - 3, 16 * 14 + 6), arrowleft%, PSET: 'e arrow
GOTO 120

110 : z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO 110
IF z$ = "M" THEN GOTO menu
IF z$ = "+" THEN s = 1: GOTO 120
IF z$ = "-" THEN s = -1: GOTO 120
IF z$ = "*" THEN s = 10: GOTO 120
IF z$ = "/" THEN s = -10: GOTO 120
z$ = MID$(z$, 2): IF z$ = "" THEN GOTO 110

IF z$ = "H" THEN hfe = hfe + 10: GOTO 130: 'up
IF z$ = "P" THEN hfe = hfe - 10: GOTO 130: 'down
GOTO 110

120
amps = amps + s: IF amps < 0 THEN amps = 0
amp$ = RIGHT$("        " + STR$(amps), 8)
ice = amps * hfe: ice$ = RIGHT$("        " + STR$(ice), 8)
Ie = amps + ice: Ie$ = RIGHT$("        " + STR$(Ie), 8)
COLOR 14: a = 5
LOCATE 10 + 2, 21 - a: PRINT ice$
LOCATE 13 + 2, 21 - a: PRINT amp$
LOCATE 18, 21 - a: PRINT Ie$

LOCATE 10 + 2, 21 - a + B: PRINT Ie$
LOCATE 13 + 2, 21 - a + B: PRINT amp$
LOCATE 18, 21 - a + B: PRINT ice$
GOTO 110

130 : IF hfe > 1000 THEN hfe = 1000
IF hfe < 10 THEN hfe = 10
COLOR 14: LOCATE 24, 72: PRINT hfe; "  "; : LOCATE 1, 1: s = 0: GOTO 120

'.................

200 : GOSUB clearit: COLOR 10: LOCATE 2, 27: PRINT "NPN DC VOLTAGE AMPLIFIER"
Vs = 12000: GOSUB commonscreen: COLOR 15: ac = 10: dn = 12: dc = 560: pan = 7
R(1) = 121: '100k
R(2) = 97: ' 10k
R1 = res(R(1)): R2 = res(R(2))

LOCATE 12, 68: PRINT "       "
LOCATE 13, 68: PRINT "       "
LOCATE 14, 68: PRINT "       "
COLOR 11
LOCATE 16, 28: PRINT "R1"
LOCATE 9, 37: PRINT "R2"
LOCATE 23, 3: PRINT "DC bias"
LOCATE 24, 48: PRINT "DC Vout/Vin GAIN";

COLOR 14
LOCATE 3, 3: PRINT "Icmax = Vs / R2 =            Rx = 1000";
COLOR 11: PRINT " (see Teach-In text)": COLOR 14
LOCATE 4, 3: PRINT "Ib = (Vin - 0.6) / (R1 + Rx): IF Ib < 0 then Ib = 0"
LOCATE 5, 3: PRINT "Ic = hfe * Ib: IF Ic > Icmax THEN Ic = Icmax"
LOCATE 6, 3: PRINT "Vc = Vs - (Ic * R2)"
LOCATE 3, 64: PRINT "RESULTS:"

COLOR 11
LOCATE 7, 3: PRINT "CAUTION - SIMPLIFIED EQUATIONS!"
LOCATE 4, 64: PRINT "Ib"
LOCATE 5, 64: PRINT "Ic"
LOCATE 6, 64: PRINT "Vc": COLOR 15

ax = 62 * 8: ay = 78 * 8: dx = 2 * 14 - 4: dy = 6 * 14 + 4
LINE (ax, dx)-(ay, dy), 15, B

c = dc / 1000: GOSUB stringit
LOCATE 23, 11: a$ = RTRIM$(a$) + "V     ": PRINT LEFT$(a$, 7);
a$ = res$(R(1)): LOCATE 17, 26: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(2)): LOCATE 10, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
GOSUB highlight3

PUT (25 * 8 + 7, 13 * 14 + 12), hres%, PSET: 'R1
LINE (29 * 8 + 2, 14 * 14 + 2)-(34 * 8 + 2, 14 * 14 + 2), 15: 'R1 right

PUT (38 * 8 - 1, 7 * 14 + 8), vres%, PSET: 'R2
LINE (39 * 8 + 2, 10 * 14 - 7)-(39 * 8 + 2, 12 * 14 - 7), 15: 'R2 dn
LINE (21 * 8 + 4, 14 * 14 + 2)-(25 * 8 + 6, 14 * 14 + 2), 15
LINE (39 * 8 + 2, 20 * 14 - 7)-(39 * 8 + 2, 22 * 14 - 7), 15: 'R3 dn
LINE (39 * 8 + 2, 17 * 14 - 7)-(39 * 8 + 2, 22 * 14 - 7), 15: 'R3 dn
PUT (38 * 8 + 7, 7 * 14 + 3), dot%, OR
PUT (38 * 8 + 7, 11 * 14 + 0), dot%, OR
PUT (38 * 8 + 7, 21 * 14 + 3), dot%, OR

GOSUB graphit0

graphmode2:
GOSUB graphit1: FOR x = 1 TO 145: GOSUB vingraph: GOSUB vcgraph
NEXT: GOSUB calcit: GOSUB showcalc2: GOSUB tranlinesb: GOSUB tranlinesc

IF runit = 1 THEN phase = phase - 1: IF phase < 1 THEN phase = 144

keymode2: z$ = UCASE$(INKEY$): IF z$ = "" AND runit = 0 THEN GOTO keymode2
IF z$ = "M" THEN GOTO menu
GOSUB routeit

IF z$ = "D" THEN s = 7: GOSUB changepan0: 'dc
s = VAL(z$): IF s = 1 OR s = 2 THEN s = s - 1: GOSUB changepan0

c = dc / 1000: GOSUB stringit
LOCATE 23, 11: a$ = RTRIM$(a$) + "V     ": PRINT LEFT$(a$, 6)
COLOR 15
a$ = res$(R(1)): LOCATE 17, 26: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(2)): LOCATE 10, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
R1 = res(R(1)): R2 = res(R(2)): GOTO graphmode2

calcmode2:
Icmax = Vs / R2: ib = (Vin - 600) / (R1 + 1000): IF ib < 0 THEN ib = 0
ic = hfe * ib: IF ic > Icmax THEN ic = Icmax
Vc = Vs - (ic * R2): RETURN

showcalc2: COLOR 15
c = INT(Icmax * 1000 + .5) / 1000: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "mA    ", 8): LOCATE 3, 20: PRINT a$
c = INT(ib * 1000) / 1000: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "mA    ", 8): LOCATE 4, 69: PRINT a$
c = INT(ic * 1000) / 1000: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "mA    ", 8): LOCATE 5, 69: PRINT a$
c = INT(Vc / 10) / 100: IF c < 0 THEN c = 0
GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 8): LOCATE 6, 69: PRINT a$
GOSUB showvals:
a$ = LEFT$(LTRIM$(a$) + "          ", 12): LOCATE 24, 65: PRINT a$;
LOCATE 1, 1

c = INT(gain * 1000) / 1000: IF c > 0 THEN c = -c
GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "     ", 7): LOCATE 23, 72: PRINT a$
RETURN

'...............

300 : GOSUB clearit: COLOR 10: LOCATE 2, 32: PRINT "NPN AC VOLTAGE AMPLIFIER"
Vs = 6000: GOSUB commonscreen: COLOR 15: ac = 10: dn = 12: pan = 6: Ve = 0
R(2) = 73: ' 1k
R(4) = 127: ' 180k
R(5) = 105: ' 22k
R2 = res(R(2)): R4 = res(R(4)): R5 = res(R(5))

LOCATE 10, 68: PRINT "      "
LOCATE 12, 68: PRINT "      "
LOCATE 15, 68: PRINT "          "
COLOR 14

LOCATE 2, 4: PRINT "Icmax = Vs / R2 ="
LOCATE 3, 4: PRINT "Vbias = Vs * (R5 / (R4 + R5)): Rx = 1000"; : COLOR 11
PRINT " (see Teach-In)": COLOR 14
LOCATE 4, 4: PRINT "Ibias = (Vs - 0.6)/(R4+Rx): IF Vbias < 0.6 THEN Ibias = 0"
LOCATE 5, 4: PRINT "Ivin = Vin / Rx: Ib = Ibias + Ivin: IF Ib < 0 THEN Ib = 0"
LOCATE 6, 4: PRINT "Ic = hfe * Ib: IF Ic > Icmax THEN Ic = Icmax"
LOCATE 7, 4: PRINT "Vc = Vs - (Ic * R2): IF Vc < 0 THEN Vc = 0"
LOCATE 23, 16: PRINT "CAUTION - SIMPLIFIED EQUATIONS!"

LOCATE 2, 64: PRINT "RESULTS:"
COLOR 11
LOCATE 16, 24: PRINT "C1"
LOCATE 9, 37: PRINT "R2":
LOCATE 9, 28: PRINT "R4"
LOCATE 19, 30: PRINT "R5"

LOCATE 3, 64: PRINT "Vbias"
LOCATE 4, 64: PRINT "Ibias"
LOCATE 5, 64: PRINT "Ib"
LOCATE 6, 64: PRINT "Ic"
LOCATE 7, 64: PRINT "Vc":

COLOR 15
ax = 62 * 8: ay = 78 * 8: dx = 1 * 14 - 4: dy = 7 * 14 + 4
LINE (ax, dx)-(ay, dy), 15, B

c = Vs / 1000: GOSUB stringit
LOCATE 8, 23: a$ = "     " + LTRIM$(RTRIM$(a$)) + "V": PRINT ; RIGHT$(a$, 6)
a$ = res$(R(2)): LOCATE 10, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(4)): LOCATE 10, 26: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(5)): LOCATE 20, 28: PRINT RIGHT$("   " + RTRIM$(a$), 4)

GOSUB highlight3:
LINE (21 * 8 + 4, 14 * 14 + 2)-(32 * 8 + 6, 14 * 14 + 2), 15
PUT (21 * 8 + 2, 13 * 14 + 9), hcap%, PSET

PUT (38 * 8 - 1, 7 * 14 + 8), vres%, PSET: 'R2
LINE (39 * 8 + 2, 10 * 14 - 7)-(39 * 8 + 2, 12 * 14 - 7), 15: 'R2 dn
LINE (39 * 8 + 2, 17 * 14 - 7)-(39 * 8 + 2, 22 * 14 - 7), 15: 'R3 dn
PUT (38 * 8 + 7, 7 * 14 + 3), dot%, OR
PUT (38 * 8 + 7, 11 * 14 + 0), dot%, OR
PUT (38 * 8 + 7, 21 * 14 + 3), dot%, OR

PUT (29 * 8, 7 * 14 + 8), vres%, PSET: ' R4
LINE (31 * 8 - 5, 10 * 14 - 7)-(31 * 8 - 5, 14 * 14 + 2), 15: 'R4 dn
PUT (31 * 8 + 0, 17 * 14 + 6), vres%, PSET: ' R5
LINE (33 * 8 - 5, 14 * 14 + 3)-(33 * 8 - 5, 18 * 14 - 4), 15: ' R5 dn
LINE (33 * 8 - 5, 20 * 14 - 7)-(33 * 8 - 5, 22 * 14 - 7), 15: 'R5 dn
PUT (30 * 8, 7 * 14 + 3), dot%, OR
PUT (30 * 8, 14 * 14 - 2), dot%, OR
PUT (32 * 8, 14 * 14 - 2), dot%, OR
PUT (32 * 8, 21 * 14 + 3), dot%, OR

GOSUB graphit0

graphmode3:
GOSUB graphit1: FOR x = 1 TO 145: GOSUB vingraph: GOSUB vcgraph
NEXT: GOSUB calcmode3: GOSUB showcalc3: GOSUB tranlinesb: GOSUB tranlinesc

IF runit = 1 THEN phase = phase - 1: IF phase < 1 THEN phase = 144

keymode3: z$ = UCASE$(INKEY$): IF z$ = "" AND runit = 0 THEN GOTO keymode3
IF z$ = "M" THEN GOTO menu
GOSUB routeit
s = VAL(z$): IF s = 2 OR s = 4 OR s = 5 THEN s = s - 1: GOSUB changepan0

a$ = res$(R(2)): LOCATE 10, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(4)): LOCATE 10, 26: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(5)): LOCATE 20, 28: PRINT RIGHT$("   " + RTRIM$(a$), 4)
R2 = res(R(2)): R4 = res(R(4)): R5 = res(R(5)): GOTO graphmode3

calcmode3:
Icmax = Vs / R2: Rx = 1000: Vbias = Vs * (R5 / (R4 + R5))
ibias = (Vs - 600) / (R4 + 100): IF Vbias < 600 THEN ibias = 0
ivin = Vin / Rx: ib = ibias + ivin: IF ib < 0 THEN ib = 0
ic = hfe * ib: IF ic > Icmax THEN ic = Icmax
Vc = Vs - (ic * R2): IF Vc < 0 THEN Vc = 0
RETURN

showcalc3:
c = INT(Icmax * 100) / 100: IF c >= 1000 THEN c = INT(c)
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "mA    ", 9): LOCATE 2, 21: PRINT a$

c = INT(Icmax * 100) / 100: IF c >= 1000 THEN c = INT(c)
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "mA    ", 9): LOCATE 2, 21: PRINT a$
c = INT(Vbias / 1) / 1000: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 9): LOCATE 3, 69: PRINT a$
c = INT(ibias * 1000) / 1000: IF c >= 1000 THEN c = INT(c)
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "mA    ", 9): LOCATE 4, 69: PRINT a$
c = INT(ib * 1000) / 1000: IF c >= 1000 THEN c = INT(c)
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "mA    ", 9): LOCATE 5, 69: PRINT a$
c = INT(ic * 1000) / 1000: IF c >= 1000 THEN c = INT(c)
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "mA    ", 9): LOCATE 6, 69: PRINT a$
c = INT(Vc / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 9): LOCATE 7, 69: PRINT a$
GOSUB showvals:
c = INT(gain * 1000 + .5) / 1000: IF c > 0 THEN c = -c
GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "     ", 7): LOCATE 23, 72: PRINT a$: RETURN

'............

400 : GOSUB clearit: COLOR 10: LOCATE 2, 30: PRINT "NPN DC CURRENT AMPLIFIER"
Vs = 12000: GOSUB commonscreen: COLOR 11: ac = 10: dn = 12: pan = 7: dc = 580

R(1) = 97: ' 10k
R(3) = 73: ' 1k
R1 = res(R(1)): R3 = res(R(3))

COLOR 10: LOCATE 22, 45: PRINT "Ve": COLOR 15
scale(0) = 1: scale(1) = 1
LOCATE 11, 68: PRINT "       "
LOCATE 13, 68: PRINT "       "
LOCATE 14, 68: PRINT "       "

COLOR 14
LOCATE 2, 4: PRINT "Iemax = Vs / R3 ="
LOCATE 3, 4: PRINT "Rx = R3 * hfe * 100"; : COLOR 11
PRINT " (see Teach-In text)": COLOR 14
LOCATE 4, 4: PRINT "Vb = Vin * (Rx / (R1 + Rx)): Ve = Vb - 600"
LOCATE 5, 4: PRINT "IF Ve < 0 THEN Ve = 0: Ie = 0 ELSE Ie = Ve / R3"
LOCATE 6, 4: PRINT "IF Ie > Iemax THEN Ie = Iemax"

LOCATE 2, 64: PRINT "RESULTS:"

COLOR 11
LOCATE 7, 4: PRINT "CAUTION - SIMPLIFIED EQUATIONS!"
LOCATE 3, 64: PRINT "Vb"
LOCATE 4, 64: PRINT "Vc"
LOCATE 5, 64: PRINT "Ve"
LOCATE 6, 64: PRINT "Ie"
LOCATE 7, 64: PRINT "Rx"
LOCATE 16, ac + 23 - 5: PRINT "R1"
LOCATE 19, ac + 34 - 7: PRINT "R3"
LOCATE 23, 3: PRINT "DC bias  ="
LOCATE 24, 48: PRINT "DC Vout/Vin GAIN";
COLOR 15

ax = 62 * 8: ay = 78 * 8: dx = 1 * 14 - 4: dy = 7 * 14 + 4
LINE (ax, dx)-(ay, dy), 15, B

c = dc / 1000: GOSUB stringit
LOCATE 23, 11: a$ = RTRIM$(a$) + "V     ": PRINT LEFT$(a$, 7);
COLOR 15
a$ = res$(R(1)): LOCATE 17, 26: PRINT RIGHT$("   " + RTRIM$(a$), 4)
GOSUB highlight3

PUT (25 * 8 + 7, 13 * 14 + 12), hres%, PSET: 'R1
LINE (29 * 8 + 2, 14 * 14 + 2)-(34 * 8 + 2, 14 * 14 + 2), 15: 'R1 right

a$ = res$(R(3))
LOCATE 20, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
PUT ((ac + 35 - 7) * 8 - 1, (dn + 5) * 14 + 6), vres%, PSET: 'R3
LINE ((ac + 36 - 7) * 8 + 2, (dn + 5) * 14 - 7)-((ac + 36 - 7) * 8 + 2, (dn + 6) * 14 - 7), 15: 'R3 dn
LINE ((ac + 36 - 7) * 8 + 2, (dn + 8) * 14 - 7)-((ac + 36 - 7) * 8 + 2, (dn + 10) * 14 - 7), 15: 'R3 dn

LINE (39 * 8 + 2, 8 * 14 - 7)-(39 * 8 + 2, 12 * 14 - 7), 15: 'R2 dn
LINE (21 * 8 + 4, 14 * 14 + 2)-(25 * 8 + 6, 14 * 14 + 2), 15: 'R1
LINE (39 * 8 + 2, 20 * 14 - 7)-(39 * 8 + 2, 22 * 14 - 7), 15: 'R3 dn
PUT (38 * 8 + 7, 7 * 14 + 3), dot%, OR
PUT (38 * 8 + 7, 17 * 14 + 0), dot%, OR
PUT (38 * 8 + 7, 21 * 14 + 3), dot%, OR

GOSUB graphit0

graphmode4:
GOSUB graphit1: FOR x = 1 TO 145: GOSUB vingraph: GOSUB calcmode4
GOSUB vegraph
NEXT: GOSUB calcmode4: GOSUB showcalc4: GOSUB tranlinesb: GOSUB tranlinese

IF runit = 1 THEN phase = phase - 1: IF phase < 1 THEN phase = 144
 
keymode4: z$ = UCASE$(INKEY$): IF z$ = "" AND runit = 0 THEN GOTO keymode4
IF z$ = "M" THEN GOTO menu
GOSUB routeit

IF z$ = "D" THEN s = 7: GOSUB changepan0: 'dc
s = VAL(z$): IF s = 1 OR s = 3 THEN s = s - 1: GOSUB changepan0
IF pan = 7 THEN dc = dc + s

c = dc / 1000: GOSUB stringit
LOCATE 23, 11: a$ = RTRIM$(a$) + "V     ": PRINT LEFT$(a$, 6);
a$ = res$(R(1)): LOCATE 17, 26: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(3)): LOCATE 20, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
R3 = res(R(3)): R1 = res(R(1)): GOTO graphmode4

calcmode4:
Iemax = Vs / R3: Rx = R3 * hfe * 100
Vb = Vin * (Rx / (R1 + Rx)): Ve = Vb - 600
IF Ve < 0 THEN Ve = 0: Ie = 0 ELSE Ie = Ve / R3
IF Ie > Iemax THEN Ie = Iemax
RETURN

showcalc4: COLOR 15
c = INT(Iemax * 1000) / 1000: IF c >= 1000 THEN c = INT(c)
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "mA    ", 9): LOCATE 2, 21: PRINT a$

c = INT(Vb / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 8): LOCATE 3, 69: PRINT a$
c = INT(Vs / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 8): LOCATE 4, 69: PRINT a$
c = INT(Ve / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 8): LOCATE 5, 69: PRINT a$
c = INT(Ie * 1000) / 1000: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "mA     ", 9): LOCATE 6, 69: PRINT a$
c = INT(Rx): GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "      ", 8): LOCATE 7, 69: PRINT a$
GOSUB showvals:
a$ = LEFT$(LTRIM$(a$) + "          ", 12): LOCATE 24, 65: PRINT a$;
LOCATE 1, 1: c = ABS(INT(gain * 1000 + .5) / 1000): GOSUB stringit
a$ = LEFT$(LTRIM$(a$) + "        ", 7): LOCATE 23, 72: PRINT a$
COLOR 15: RETURN

'...............

500 : GOSUB clearit: COLOR 10: LOCATE 2, 34: PRINT "NPN PHASE-SPLIT AMPLIFIER"
Vs = 5000: GOSUB commonscreen: COLOR 15: ac = 10: dn = 12: pan = 6
R(2) = 97: '10k
R(4) = 118: ' 75k
R(5) = 101: ' 15k
R(3) = 73: ' 1k
R2 = res(R(2)): R3 = res(R(3)): R4 = res(R(4)): R5 = res(R(5))

LOCATE 10, 68: PRINT "      "
LOCATE 15, 68: PRINT "          "
COLOR 14
LOCATE 23, 20: PRINT "MAX GAIN = R2/R3 ="

LOCATE 2, 4: PRINT "Icmax = Vs/(R2+R3) ="
LOCATE 3, 4: PRINT "Rx = R3 * hfe * 100: Rb = 1 / ((1 / R5) + (1 / Rx))"
LOCATE 4, 4: PRINT "Vb = Vs * (Rb / (R4 + Rb)) + Vin: Ve = Vb - 0.6"
LOCATE 5, 4: PRINT "Vc = Vs - ((Vb - 0.6) * (R2 / R3)): IF Ve < 0 THEN Ve = 0"
LOCATE 6, 4: PRINT "IF (Ve > Vc) AND (Vc < Vs) THEN Vc = Ve"
LOCATE 7, 4: PRINT "IF Vc > Vs THEN Vc = Vs   "; : COLOR 11
PRINT "CAUTION - SIMPLIFIED EQUATIONS!"

COLOR 14: LOCATE 2, 64: PRINT "RESULTS:": COLOR 11
LOCATE 3, 64: PRINT "Vb"
LOCATE 4, 64: PRINT "Vc"
LOCATE 5, 64: PRINT "Ve"
LOCATE 6, 64: PRINT "Rx"
LOCATE 7, 64: PRINT "Rb"
LOCATE 16, 24: PRINT "C1"
LOCATE 9, 37: PRINT "R2"
LOCATE 19, 37: PRINT "R3"
LOCATE 9, 28: PRINT "R4"
LOCATE 19, 30: PRINT "R5":
COLOR 10: LOCATE 24, 45: PRINT "Ve "; : COLOR 11: PRINT "MIN";
LOCATE 24, 60: PRINT "MAX";
LOCATE 1, 1: COLOR 15

ax = 62 * 8: ay = 78 * 8: dx = 1 * 14 - 4: dy = 7 * 14 + 4
LINE (ax, dx)-(ay, dy), 15, B

a$ = res$(R(2)): LOCATE 10, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(3)): LOCATE 20, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(4)): LOCATE 10, 26: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(5)): LOCATE 20, 28: PRINT RIGHT$("   " + RTRIM$(a$), 4)

GOSUB highlight3:
LINE (21 * 8 + 4, 14 * 14 + 2)-(32 * 8 + 6, 14 * 14 + 2), 15
PUT (21 * 8 + 2, 13 * 14 + 9), hcap%, PSET

PUT (38 * 8 - 1, 7 * 14 + 8), vres%, PSET: 'R2
LINE (39 * 8 + 2, 10 * 14 - 7)-(39 * 8 + 2, 12 * 14 - 7), 15: 'R2 dn
LINE (39 * 8 + 2, 17 * 14 - 7)-(39 * 8 + 2, 22 * 14 - 7), 15: 'R3 dn
PUT (38 * 8 + 7, 7 * 14 + 3), dot%, OR
PUT (38 * 8 + 7, 11 * 14 + 0), dot%, OR
PUT (38 * 8 + 7, 21 * 14 + 3), dot%, OR

PUT (29 * 8, 7 * 14 + 8), vres%, PSET: ' R4
LINE (31 * 8 - 5, 10 * 14 - 7)-(31 * 8 - 5, 14 * 14 + 2), 15: 'R4 dn

PUT (31 * 8 + 0, 17 * 14 + 6), vres%, PSET: ' R5
LINE (33 * 8 - 5, 14 * 14 + 3)-(33 * 8 - 5, 18 * 14 - 4), 15: ' R5 dn
LINE (33 * 8 - 5, 20 * 14 - 7)-(33 * 8 - 5, 22 * 14 - 7), 15: 'R5 dn
PUT (30 * 8, 7 * 14 + 3), dot%, OR
PUT (30 * 8, 14 * 14 - 2), dot%, OR
PUT (32 * 8, 14 * 14 - 2), dot%, OR
PUT (32 * 8, 21 * 14 + 3), dot%, OR

PUT ((ac + 35 - 7) * 8 - 1, (dn + 5) * 14 + 6), vres%, PSET: 'R3
LINE ((ac + 36 - 7) * 8 + 2, (dn + 5) * 14 - 7)-((ac + 36 - 7) * 8 + 2, (dn + 6) * 14 - 7), 15: 'R3 dn
LINE ((ac + 36 - 7) * 8 + 2, (dn + 8) * 14 - 7)-((ac + 36 - 7) * 8 + 2, (dn + 10) * 14 - 7), 15: 'R3 dn

PUT (38 * 8 + 7, 17 * 14 + 0), dot%, OR

GOSUB graphit0:

graphmode5: GOSUB graphit1

FOR x = 1 TO 145: GOSUB vingraph: GOSUB vcgraph: GOSUB vegraph
NEXT: GOSUB calcmode5: GOSUB showcalc5
GOSUB tranlinesb: GOSUB tranlinesc: GOSUB tranlinese

IF runit = 1 THEN phase = phase - 1: IF phase < 1 THEN phase = 144

keymode5: z$ = UCASE$(INKEY$): IF z$ = "" AND runit = 0 THEN GOTO keymode5
IF z$ = "M" THEN GOTO menu
GOSUB routeit
s = VAL(z$): IF s > 1 AND s < 6 THEN s = s - 1: GOSUB changepan0

a$ = res$(R(2)): LOCATE 10, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(3)): LOCATE 20, 35: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(4)): LOCATE 10, 26: PRINT RIGHT$("   " + RTRIM$(a$), 4)
a$ = res$(R(5)): LOCATE 20, 28: PRINT RIGHT$("   " + RTRIM$(a$), 4)
R2 = res(R(2)): R3 = res(R(3)): R4 = res(R(4)): R5 = res(R(5))
GOTO graphmode5

calcmode5:
Icmax = Vs / (R2 + R3)
Rx = R3 * hfe * 100: Rb = 1 / ((1 / R5) + (1 / Rx))
Vb = Vs * (Rb / (R4 + Rb)) + Vin: Ve = Vb - 600: IF Ve < 0 THEN Ve = 0
Vc = Vs - ((Vb - 600) * (R2 / R3)): IF (Ve > Vc) AND (Vc < Vs) THEN Vc = Ve
IF Vc > Vs THEN Vc = Vs
RETURN

showcalc5:
c = INT(Icmax * 100) / 100: IF c >= 1000 THEN c = INT(c)
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "mA    ", 9): LOCATE 2, 24: PRINT a$

c = INT(Vb / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 8): LOCATE 3, 69: PRINT a$
c = INT(Vc / 10 + .5) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 8): LOCATE 4, 69: PRINT a$
c = INT(Ve / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 8): LOCATE 5, 69: PRINT a$
c = INT(Rx * 10000) / 10000: IF c >= 100 THEN c = INT(c)
a$ = STR$(Rx): a$ = LEFT$(RTRIM$(a$) + "       ", 9): LOCATE 6, 69: PRINT a$
c = INT(Rb * 10000) / 10000: IF c >= 100 THEN c = INT(c)
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "       ", 9): LOCATE 7, 69: PRINT a$
c = INT(Vemin / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 6): LOCATE 24, 52: PRINT a$;
c = INT(Vemax / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 7): LOCATE 24, 64: PRINT a$; : LOCATE 1, 1
GOSUB showvals: c = INT(gain * 1000) / 1000: IF c > 0 THEN c = -c
GOSUB stringit: a$ = LEFT$(RTRIM$(a$) + "     ", 7): LOCATE 23, 72: PRINT a$
c = R2 / R3: c = INT(c * 100) / 100: GOSUB stringit
LOCATE 23, 38: PRINT a$
RETURN

'............

vinlevelset: vinlevel = s * 10 + vinlevel: IF vinlevel < 0 THEN vinlevel = 0
RETURN

scale0: scale(0) = scale(0) + s: IF scale(0) < 1 THEN scale(0) = 1

res6: R6 = res(R(6)) * rx6: COLOR col(5)
LOCATE 7, 74: a$ = res$(R(6)): PRINT a$: COLOR 15 * rx6
LOCATE 11, ac + 33 - 7: PRINT RIGHT$("   " + RTRIM$(a$), 4): RETURN: '
resend: COLOR 15: STOP: ' GOTO mainloop1

changepan: GOSUB highlight: pan = s: GOSUB highlight: ' GOTO mainloop1
STOP
'...............

stringit: B = ABS(c): a$ = MID$(STR$(B), 2): IF B < 1 AND B <> 0 THEN a$ = "0" + a$
IF c < 0 THEN a$ = "-" + a$ ELSE a$ = " " + a$
a$ = LEFT$(a$ + "        ", 8): RETURN

stringit2: B = ABS(c): a$ = MID$(STR$(B), 2): IF B < 1 AND B <> 0 THEN a$ = "0" + a$
IF c < 0 THEN a$ = "-" + a$ ELSE a$ = " " + a$
a$ = LEFT$(a$ + "          ", 14): RETURN

'.........................SET UP

hresistor: v = (ltab + .5) * 8 - 1: h = (ttab + .5) * 14
v1 = v: LINE (v - 4, h)-(v, h)
v = v + 2: LINE -(v, h - 4): v = v + 4: LINE -(v, h + 4)
v = v + 4: LINE -(v, h - 4): v = v + 4: LINE -(v, h + 4)
v = v + 4: LINE -(v, h - 4): v = v + 2: LINE -(v, h): LINE -(v + 4, h)
GET (v1 - 4, h - 4)-(v1 + 24, h + 4), hres%: RETURN

vresistor: COLOR 14: v = (ltab + .5) * 8 - 1: h = (ttab + .5) * 14
h1 = h: LINE (v, h - 4)-(v, h)
h = h + 2: LINE -(v + 4, h): h = h + 4: LINE -(v - 4, h)
h = h + 4: LINE -(v + 4, h): h = h + 4: LINE -(v - 4, h)
h = h + 4: LINE -(v + 4, h): h = h + 2: LINE -(v, h): LINE -(v, h + 4)
GET (ltab * 8 - 8, h1 - 4)-(ltab * 8 + 14, h1 + 24), vres%: RETURN

npntran: col = 14
LOCATE ttab + 1, ltab + 2: PRINT "c"
LOCATE ttab + 2, ltab - 3: PRINT "b"
LOCATE ttab + 5, ltab + 2: PRINT "e"
COLOR 10
LOCATE ttab + 1, ltab - 2: PRINT "Vc"
LOCATE ttab + 4, ltab - 4: PRINT "Vb"
LOCATE ttab + 5, ltab - 2: PRINT "Ve": COLOR 14

v = ltab * 8 + 2: h = ttab * 14 + 2 + 2
LINE (v - 8, h + 4)-(v - 2, h + 4), 15: ' Ve arrow
LINE (v - 4, h + 2)-(v - 2, h + 4), 15: LINE -(v - 4, h + 6), 15
LINE (v - 8, h + 4 + 56)-(v - 2, h + 4 + 56), 15: ' Vc arrow
LINE (v - 4, h + 2 + 56)-(v - 2, h + 4 + 56), 15: LINE -(v - 4, h + 6 + 56), 15
LINE (v - 34, h + 38)-(v - 34, h + 34), 15: ' Vb arrow
LINE (v - 36, h + 36)-(v - 34, h + 34), 15: LINE -(v - 32, h + 36), 15

w = 16: x = 16: PSET (v, h - 8), col
h = h + x: LINE -(v, h), col: h = h + x: v = v - w
LINE -(v, h), col: h = h + x: v = v + w
LINE -(v, h), col: h = h + x: LINE -(v, h - 10), col
LINE -(v, h + 8), 15: h = h - 32: v = v - 8
LINE (v - 8, h)-(v - 48, h), col: 'base
CIRCLE (v + 3, h), 18, 14, , , 1: '.72
GET (ltab * 8 - 50 + 16, ttab * 14 + 14 - 4)-(ltab * 8 - 40 + 16, ttab * 14 + 27), a%
PUT (ltab * 8 - 50 + 16, ttab * 14 + 14 - 4 + 6), a%, PSET: ' move "b" a bit

v = v + 8: h = h + 8: LINE (v, h)-(v, h + 7), 14
LINE -(v - 8, h + 7), 14: LINE -(v, h - 1), 14: PAINT (v - 4, h + 5), 14, 14: '+4
PAINT (v - 1, h + 3), 14, 14
GET (ltab * 8 - 52, ttab * 14 - 2)-(ltab * 8 + 28, ttab * 14 + 70), npn%
RETURN

pnptran: col = 14

LOCATE ttab + 1, ltab + 2: PRINT "e"
LOCATE ttab + 2, ltab - 3: PRINT "b"
LOCATE ttab + 5, ltab + 2: PRINT "c"

GET (ltab * 8 - 50, ttab * 14 + 14 - 4)-(ltab * 8 - 40, ttab * 14 + 27), a%
PUT (ltab * 8 - 50, ttab * 14 + 14), a%, PSET: ' move "e" a bit
GET (ltab * 8 + 6, ttab * 14 + 59)-(ltab * 8 + 16, ttab * 14 + 96), a%
PUT (ltab * 8 + 6, ttab * 14 + 55), a%, PSET: ' move "c" a bit
GET (ltab * 8 + 6 - 40, ttab * 14)-(ltab * 8 + 16 - 40, ttab * 14 + 28), a%
PUT (ltab * 8 + 6 - 40, ttab * 14 + 6), a%, PSET: ' move "b" a bit

COLOR 10
LOCATE ttab + 1, ltab - 2: PRINT "Ve"
LOCATE ttab + 4, ltab - 4: PRINT "Vb"
LOCATE ttab + 5, ltab - 2: PRINT "Vc": COLOR 14

v = ltab * 8 + 2 - 2: h = ttab * 14 + 2 + 2
LINE (v - 8, h + 4)-(v - 2, h + 4), 15: ' Vc arrow
LINE (v - 4, h + 2)-(v - 2, h + 4), 15: LINE -(v - 4, h + 6), 15
LINE (v - 8, h + 4 + 56)-(v - 2, h + 4 + 56), 15: ' Ve arrow
LINE (v - 4, h + 2 + 56)-(v - 2, h + 4 + 56), 15: LINE -(v - 4, h + 6 + 56), 15
LINE (v - 34, h + 38)-(v - 34, h + 34), 15: ' Vb arrow
LINE (v - 36, h + 36)-(v - 34, h + 34), 15: LINE -(v - 32, h + 36), 15

v = ltab * 8: h = ttab * 14 + 2: w = 16: x = 16: PSET (v, h - 8), col: h = h + x
LINE -(v, h), col: h = h + x: v = v - w
LINE -(v, h), col: h = h + x: v = v + w
LINE -(v, h), col: h = h + x: LINE -(v, h + 8), col
h = h - 32: v = v - 8: ' CIRCLE (v, h), 30, col, , , .75
CIRCLE (v + 3, h), 18, 14, , , 1: '.72
LINE (v - 8, h)-(v - 48, h), col: 'base
h = h - 17 + 2: v = v + 2 - 2: LINE (v, h)-(v, h + 7), 14
LINE -(v + 8, h + 7), 14: LINE -(v, h - 1), 14: ' arrow
PAINT (v + 2, h + 2), 14, 14: '+4
PAINT (v + 4, h + 4), 14, 14:
GET (ltab * 8 - 52 - 2, ttab * 14 - 2)-(ltab * 8 + 28, ttab * 14 + 70), pnp%
RETURN

capacitor: x = 440: y = 35 + 6
LINE (x + 8, y - 15)-(x + 8, y + 14), 15
LINE (x + 8, y + 29)-(x + 8, y + 43 + 15), 15
LINE (x, y + 14)-(x + 16, y + 19), 14, BF
LINE (x, y + 23)-(x + 16, y + 29), 14, BF
GET (x, y - 5)-(x + 16, y + 43 + 9), vcap%

x = 90: y = 42
LINE (x, y)-(x + 5, y + 14), 14, BF
LINE (x + 9, y)-(x + 9 + 5, y + 14), 14, BF
LINE (x, y + 7)-(x - 12, y + 7), 15
LINE (x + 14, y + 7)-(x + 14 + 8, y + 7), 15
GET (x - 14, y)-(x + 14 + 8, y + 14), hcap%: RETURN

rs6: rx6 = (rx6 + 1) AND 1
IF rx6 = 1 THEN COLOR 15: col(5) = 15 ELSE COLOR 0: col(5) = 7
LOCATE 11, ac + 30 - 7: PRINT "R6": a$ = res$(R(6))
LOCATE 11, ac + 33 - 7: PRINT RIGHT$("   " + RTRIM$(a$), 4)
COLOR col(5): LOCATE 7, 74: PRINT a$
COLOR 15: R6 = res(R(6)) * rx6: IF R6 = 0 THEN GOTO rs6a
PUT ((ac + 27 - 5) * 8 + 7, (dn - 1) * 14 - 2 + 7), hres%, PSET
LINE ((ac + 35 - 8) * 8 + 2 - 6, (dn - 0) * 14 - 5)-((ac + 36 - 7) * 8 + 1, (dn - 0) * 14 - 5), 15: 'R6 right
LINE ((ac + 27 - 7) * 8 + 3, (dn - 0) * 14 - 5)-((ac + 28 - 6) * 8 + 6, (dn - 0) * 14 - 5), 15: 'R6 left
LINE ((ac + 27 - 7) * 8 + 2 + 1, (dn + 0) * 14 - 5)-((ac + 27 - 7) * 8 + 2 + 1, (dn + 2) * 14 + 1), 15: 'R6 dn
GOTO rs6b
rs6a: PUT ((ac + 27 - 5) * 8 + 7, (dn - 1) * 14 - 2 + 7), hres%, XOR
LINE ((ac + 35 - 8) * 8 + 2 - 6, (dn - 0) * 14 - 5)-((ac + 36 - 7) * 8 + 1, (dn - 0) * 14 - 5), 0: 'R6 right
LINE ((ac + 27 - 7) * 8 + 4, (dn - 0) * 14 - 5)-((ac + 28 - 6) * 8 + 6, (dn - 0) * 14 - 5), 0: 'R6 left
IF rx4 = 1 THEN GOTO rs6b
LINE ((ac + 27 - 7) * 8 + 2 + 1, (dn + 0) * 14 - 5 + 0)-((ac + 27 - 7) * 8 + 2 + 1, (dn + 2) * 14 + 1), 0: 'R6 dn
rs6b: STOP: 'GOTO formula

highlight: a = pan \ 3: d = pan - (a * 3) + 1
IF a = 0 THEN x = 4: h = 2
IF a = 1 THEN x = 13: h = 2
IF a = 2 THEN x = 22: h = 9
IF a = 3 THEN x = 39: h = 10
IF a = 4 THEN x = 56: h = 4
IF a = 5 THEN x = 68: h = 4
x = 70 - 1: d = pan + 1: h = 4
ax = x * 8 - 2: ay = (x + h) * 8 - 1: dx = d * 14 - 1: dy = (d + 1) * 14 - 1
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET: RETURN

setup:
sp$ = "                                                    "
sp$ = LEFT$(sp$ + sp$, 74)

OPEN "TY2KRES1" FOR INPUT AS #1: FOR a = 1 TO 217
INPUT #1, a$: B$ = MID$(a$, 6, 1): IF B$ = "o" THEN B$ = " "
res$(a) = LEFT$(RTRIM$(LEFT$(a$, 5)) + B$ + "   ", 4): NEXT: CLOSE
OPEN "TY2KRES2" FOR INPUT AS #1
FOR a = 1 TO 217: INPUT #1, a$: res(a) = VAL(a$): NEXT: CLOSE

col = 15: ac = 10
ltab = ac + 21: ttab = 5: GOSUB hresistor
ltab = ac + 21: ttab = 10: GOSUB vresistor
ltab = ac + 2: rtab = ac + 6: ttab = 5.5 + .5: btab = 6 + .5: GOSUB npntran
ltab = ac + 13: rtab = ac + 6: ttab = 5.5 + .5: btab = 6 + .5: GOSUB pnptran
GOSUB capacitor: GOSUB arrows1: GOSUB clearit: RETURN

'..................

clearit: LINE (6, 6)-(633, 343), 0, BF: RETURN

dotmake: CIRCLE (103, 104), 3, 15: PAINT (103, 104), 15, 15
GET (100, 100)-(108, 108), dot%: GOSUB clearit: RETURN

highlight2:
ax = ac * 8 - 1: dx = dn * 14 + 1: ay = (ac + 33) * 8: dy = dx + 14 - 2
GET (ax, dx)-(ay, dy), h%: PUT (ax, dx), h%, PRESET: RETURN

arrows1:
col = 12: COLOR col
ltab = ac + 18: rtab = ac + 26: ttab = 5: btab = 8

dc = 30.5: PSET (dc * 8 - 1, 3.5 * 14 + 2), col: DRAW "f8 l16 e8": 'up arrow
PAINT (dc * 8, 4 * 14), col: ', 14
GET (dc * 8 - 9, 3.5 * 14 + 2)-((dc + 2) * 8 - 9, 4.5 * 14 - 3), arrowup%

dc = 39: PSET (dc * 8 - 1, 3 * 14 + 6), col: DRAW "f8 g8 u16": 'right arrow
PAINT (dc * 8, 3 * 14 + 8), col: ', 14
GET (dc * 8 - 2, 3 * 14 + 6)-((dc + 2) * 8 - 9, 4.5 * 14 + 1), arrowright%

dc = 48.5: PSET (dc * 8 - 1, 5.5 * 14 - 1), col: DRAW "e8 l16 f8": 'down arrow
PAINT (dc * 8, 5.5 * 14 - 3), col: ', 14
GET (dc * 8 - 9, 5 * 14 - 3)-((dc + 2) * 8 - 9, 5.5 * 14 - 2), arrowdown%

ac = 40: PSET (ac * 8 - 1, 10 * 14 + 6), col: DRAW "g8 f8 u16": 'left arrow
PAINT (ac * 8 - 4, 11 * 14 + 2), col: ', 14
GET (ac * 8 - 8, 10 * 14 + 6)-((ac) * 8 + 0, 11.5 * 14 + 1), arrowleft%
RETURN

'...............

commonscreen:
ac = 10: vinlevel = 0: angle = 90: dc = 0: hfe = 100: phase = 0: c1 = 1
outit = 3: runit = 0
R1 = res(R(1)): R2 = res(R(2)): R3 = res(R(3)): R4 = res(R(4))
R5 = res(R(5)): R6 = res(R(6)):

COLOR 11: LOCATE 9, 68: PRINT "CONTROLS:": COLOR 10
scale(0) = 1: scale(1) = 1

LOCATE 10, 71: PRINT "R1"
LOCATE 11, 71: PRINT "R2"
LOCATE 12, 71: PRINT "R3"
LOCATE 13, 71: PRINT "R4"
LOCATE 14, 71: PRINT "R5"
LOCATE 15, 71: PRINT "DC bias"
LOCATE 16, 71: PRINT "AC pk-pk"
LOCATE 17, 71: PRINT "Vs"
LOCATE 18, 71: PRINT "hfe"
LOCATE 19, 71: PRINT "STEP"
LOCATE 20, 71: PRINT "MENU"

COLOR 14
LOCATE 10, 68: PRINT "1"
LOCATE 11, 68: PRINT "2"
LOCATE 12, 68: PRINT "3"
LOCATE 13, 68: PRINT "4"
LOCATE 14, 68: PRINT "5"
LOCATE 15, 68: PRINT "D"
LOCATE 16, 68: PRINT "A"
LOCATE 17, 68: PRINT "V"
LOCATE 18, 68: PRINT "H"
LOCATE 19, 68: PRINT "S"
LOCATE 20, 68: PRINT "M"
LOCATE 21, 68: PRINT "* / + -"

ac = 10: dn = 12: din = (dn + 2) * 14 + 2: prevvin = din
dout = (dn + 8) * 14 + 10
xin = (ac - 4) * 8 - 1 - 32: xout = (ac + 46 - 9) * 8: xout2 = (ac + 46 - 9) * 8 - 1
PUT ((ac + 30 - 7) * 8 - 2 - 2, dn * 14 - 6 - 2), npn%, PSET

LINE ((ac + 19) * 8 + 1 - 4, (dn - 4) * 14 - 7)-((ac + 43 - 11) * 8, (dn - 4) * 14 - 7), 15: '+V line
LINE ((ac + 21) * 8 + 1, (dn + 9) * 14 + 7)-((ac + 31) * 8, (dn + 9) * 14 + 7), 15: '0V line
LINE ((ac - 9) * 8 + 5, 112)-((ac + 11) * 8 - 6, (dn + 9) * 14 - 2), 11, B: 'left box
LINE ((ac + 45 - 9) * 8 + 6, 112)-((ac + 65 - 9) * 8 - 6 + 1, (dn + 9) * 14 - 2), 11, B: 'right box

scale(0) = 1: scale(1) = 1

LOCATE 8, ac + 17 + 17: COLOR 11: PRINT "Vs": COLOR 15

LOCATE 22, ac + 19: PRINT "0V"
LOCATE 13, 23: PRINT "Vin"
ax = 23 * 8 - 5: ay = 13 * 14 - 6
LINE (ax, ay + 6)-(ax, ay + 14), 15: 'vin arrow
LINE (ax - 2, ay + 12)-(ax, ay + 14), 15
LINE -(ax + 2, ay + 12), 15

COLOR 10
LOCATE 22, 45: PRINT "Vc "; : COLOR 11: PRINT "MIN"
LOCATE 22, 60: PRINT "MAX"
LOCATE 23, 48: PRINT "DIFF"
LOCATE 23, 60: PRINT "AC GAIN p-p"

COLOR 10: LOCATE 24, 3: PRINT "Vin "; : COLOR 11: PRINT "MIN";
LOCATE 24, 18: PRINT "MAX";
LOCATE 24, 29: PRINT "DIFF";
LOCATE 22, 3: PRINT "AC AMPLITUDE"
LOCATE 8, 48: PRINT "hfe"
RETURN

'..........

tranlinesb:
LINE ((ac + 15) * 8 - 5 - 32, yx)-((ac + 16) * 8 - 4 - 32, yx), 0: ' line to TR1b
LINE -((ac + 16) * 8 - 4 - 32, din), 0: y = v%(0, x - 1): ' PRINT din: STOP
LINE ((ac + 15) * 8 - 5 - 32, y)-((ac + 16) * 8 - 4 - 32, y), 10
LINE -((ac + 16) * 8 - 4 - 32, din), 10: RETURN

tranlinesc:
LINE ((ac + 45 - 9) * 8 + 4, yz)-((ac + 43 - 9) * 8 + 4, yz), 0: 'line from TR1c
LINE -((ac + 43 - 9) * 8 + 4, dn * 14 - 10), 0: y = v%(1, 1)
LINE ((ac + 45 - 9) * 8 + 4, y)-((ac + 43 - 9) * 8 + 4, y), 10
LINE -((ac + 43 - 9) * 8 + 4, dn * 14 - 10), 10
LINE -((ac + 36 - 7) * 8 + 2, dn * 14 - 10), 15: RETURN

tranlinese:
LINE ((ac + 45 - 9) * 8 + 4, yz2)-((ac + 44 - 9) * 8 + 4 + 4, yz2), 0: 'line from TR1e
LINE -((ac + 44 - 9) * 8 + 4 + 4, (dn + 6) * 14 - 10), 0: y = v%(2, 1)
LINE ((ac + 45 - 9) * 8 + 4, y)-((ac + 44 - 9) * 8 + 4 + 4, y), 13
LINE -((ac + 44 - 9) * 8 + 4 + 4, (dn + 6) * 14 - 10), 13
LINE -((ac + 36 - 7) * 8 + 3, (dn + 6) * 14 - 10), 15: RETURN

highlight3:
IF pan = 0 THEN x = 27: x1 = 29: y = 15: GOTO high3: ' R1
IF pan = 1 THEN x = 36: x1 = 38: y = 8: GOTO high3:  ' R2
IF pan = 2 THEN x = 36: x1 = 38: y = 18: GOTO high3: ' R2
IF pan = 3 THEN x = 27: x1 = 29: y = 8: GOTO high3:  ' R4
IF pan = 4 THEN x = 29: x1 = 31: y = 18: GOTO high3: ' R5

IF pan = 6 THEN x = 2: x1 = 14: y = 21: GOTO high3: 'ac
IF pan = 7 THEN x = 2: x1 = 9: y = 22: GOTO high3: 'dc
IF pan = 8 THEN x = 47: x1 = 50: y = 7: GOTO high3: 'hfe
IF pan = 9 THEN x = 26 + 17: x1 = 28 + 17: y = 7: GOTO high3
RETURN

high3:
ax = x * 8 - 2: ay = x1 * 8 + 1: dx = y * 14 + 1: dy = dx + 14 - 2
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET: RETURN

'...........

showvals:
c = Vs / 1000: GOSUB stringit
LOCATE 8, 23: a$ = "     " + LTRIM$(RTRIM$(a$)) + "V": PRINT ; RIGHT$(a$, 6)
LOCATE 8, 52: c = hfe: GOSUB stringit: PRINT LEFT$(LTRIM$(a$), 5)

c = INT(Vin / 10) / 100: GOSUB stringit: COLOR 15
a$ = LEFT$(RTRIM$(a$) + "V     ", 7): LOCATE 12, 22: PRINT a$
IF menupath <> 4 THEN GOTO showval1

c = INT(Vemin / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 6): LOCATE 22, 52: PRINT a$
c = INT(Vemax / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 7): LOCATE 22, 64: PRINT a$
c = ABS(INT((Vemax - Vemin) / 10) / 100): GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 7): LOCATE 23, 52: PRINT a$
IF vinlevel > 0 THEN gain = (Vemax - Vemin) / (vinlevel * 2) ELSE gain = 0
GOTO showv0

showval1:
c = INT(min / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 6): LOCATE 22, 52: PRINT a$
c = INT(max / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 7): LOCATE 22, 64: PRINT a$
c = ABS(INT((max - min) / 10) / 100): GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 7): LOCATE 23, 52: PRINT a$
IF vinlevel > 0 THEN gain = (max - min) / (vinlevel * 2) ELSE gain = 0

showv0:
c = INT(inmin / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 6): LOCATE 24, 11: PRINT a$;
c = INT(inmax / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 7): LOCATE 24, 22: PRINT a$;
c = INT((inmax - inmin) / 10) / 100: GOSUB stringit
a$ = LEFT$(RTRIM$(a$) + "V     ", 7): LOCATE 24, 33: PRINT a$;

d = Vin - 600:
IF menupath <> 4 THEN GOTO showv1
IF d > 0 THEN c = INT(Ve * 1000 / d + .5) / 1000 ELSE c = 0
IF Ve > 0 THEN GOSUB stringit ELSE a$ = "UNDETERMINED"
GOTO showv2

showv1:
IF d > 0 THEN c = -INT((Vs - Vc) * 1000 / d + .5) / 1000 ELSE c = 0
IF menupath = 3 OR menupath = 5 THEN a$ = "0       ": GOTO showv2
IF Vc > 0 AND Vc < Vs THEN GOSUB stringit ELSE a$ = "UNDETERMINED"

showv2: RETURN

'........

calcit:
ON menupath - 1 GOTO calcmode2, calcmode3, calcmode4, calcmode5
STOP

graphit0:
FOR a = 1 TO 300: angle(a) = SIN(angle * pi): angle = (angle + 5) MOD 360
NEXT

FOR x = 1 TO 300: Vin = (angle(x) * vinlevel)
y = INT(-(Vin + dc) / 100 * scale(0)) + din: IF c1 = 0 THEN Vin = Vin + dc
v%(0, x - 1) = y: GOSUB calcit

y = INT(-Vc / 100) * scale(1) + dout: IF y < 113 THEN y = 113
v%(1, x - 1) = y: y = dout - INT(Ve / 100) * scale(1)
IF y < 113 THEN y = 113
v%(2, x - 1) = y: NEXT: a = 0: x = 145: RETURN

graphit1:
emax = 0: min = Vs: max = 0: inmin = Vs: inmax = -Vs: Vemin = Vs: Vemax = 0

Vin = SIN(90 * pi) * vinlevel: Vin = Vin + dc: GOSUB calcit: emax = Ve

yx = v%(0, 145): yz = v%(1, 145): yz2 = v%(2, 145)
LINE (xin, v%(0, 0))-(xin + 1, v%(0, 1)), 0
LINE (47 * 8 - 1, 9 * 14 - 13)-(47 * 8 + 2, 21 * 14 - 4), 0, BF

Vin = (angle(phase + 1) * vinlevel)
y = INT(-Vin / 100 * scale(0)) + din - (dc / 100)
IF y < 113 THEN y = 113
Vin = Vin + dc: IF y >= 291 THEN y = 291
v%(0, 0) = y: GOSUB calcit

y = INT(-Vc / 100) * scale(1) + dout: IF y < 113 THEN y = 113
v%(1, 0) = y: y = dout - INT(Ve / 100) * scale(1):
IF y < 113 THEN y = 113
v%(2, 0) = y: RETURN

vingraph:
LINE (x + xin, v%(0, x))-(x + xin + 1, v%(0, x + 1)), 0
Vin = (angle(phase + x) * vinlevel)
y = INT(-Vin / 100 * scale(0)) + din - (dc / 100)
IF v%(0, x - 1) > (109 + 4) THEN col = 10 ELSE col = 0
IF y >= 113 THEN col = 10 ELSE y = 113
prevcol = col: IF v%(0, x - 1) >= 291 THEN col = 0 ELSE col = prevcol
IF y < 291 THEN col = prevcol ELSE y = 291
LINE (x + xin - 1, v%(0, x - 1))-(x + xin, y), col: v%(0, x) = y
Vin = Vin + dc
IF Vin > inmax THEN inmax = Vin
IF Vin < inmin THEN inmin = Vin
RETURN

vcgraph:
LINE (x + xout, v%(1, x))-(x + 1 + xout, v%(1, x + 1)), 0
GOSUB calcit
IF Vc > max THEN max = Vc
IF Vc < min THEN min = Vc
y = INT(-Vc / 100 * scale(1)) + dout
IF v%(1, x - 1) > 113 THEN col = 10 ELSE col = 0
IF y >= 113 THEN col = 10 ELSE y = 113
LINE (x + xout - 1, v%(1, x - 1))-(x + xout, y), col: v%(1, x) = y
RETURN

vegraph:
IF Ve > Vemax THEN Vemax = Ve
IF Ve < Vemin THEN Vemin = Ve
y = INT(-Vc / 100 * scale(1)) + dout
LINE (x + xout2, v%(2, x))-(x + 1 + xout2, v%(2, x + 1)), 0
y = dout - INT(Ve / 100 * scale(1))
IF v%(2, x - 1) > (109 + 4) THEN col = 13 ELSE col = 0
IF y >= (109 + 4) THEN col = 13 ELSE y = 109 + 4
LINE (x + xout2 - 1, v%(2, x - 1))-(x + xout2, y), col: v%(2, x) = y
RETURN

routeit:
IF z$ = "+" THEN s = 1: GOTO routemode0
IF z$ = "-" THEN s = -1: GOTO routemode0
IF z$ = "*" THEN s = 10: GOTO routemode0
IF z$ = "/" THEN s = -10: GOTO routemode0

IF z$ = "A" THEN s = 6: GOTO changepan0: 'AC pk-pk
IF z$ = "H" THEN s = 8: GOTO changepan0: 'hfe
IF z$ = "V" THEN s = 9: GOTO changepan0: 'power voltage
IF z$ = "S" THEN runit = 1 ELSE runit = 0
RETURN

routemode0: IF pan < 6 THEN GOTO resmode0
IF pan = 6 THEN GOSUB vinlevelset
IF pan = 7 THEN dc = dc + s
IF pan = 8 THEN hfe = hfe + s: IF hfe < 10 THEN hfe = 10 ELSE IF hfe > 1000 THEN hfe = 1000
IF pan = 9 THEN Vs = s * 100 + Vs: IF Vs < 1000 THEN Vs = 1000
RETURN

resmode0: IF ABS(s) = 10 THEN s = (24 * SGN(s))
R(pan + 1) = R(pan + 1) + s
IF R(pan + 1) > 217 THEN R(pan + 1) = 217
IF R(pan + 1) < 1 THEN R(pan + 1) = 1
RETURN

changepan0: GOSUB highlight3: pan = s: GOSUB highlight3: RETURN

