'TY2KC001 28SEP99 - TEACH-IN LOGIC V1.0
SCREEN 9: COLOR 15, 1: RANDOMIZE TIMER
CONST pi = 3.141592653589# / 180: DEFDBL V
DIM a%(1200), bin%(32), s(4, 32), deci%(11), bin$(280), hx$(280), dec$(280)

cursorcodes: ' mid$(inkey$,2)
'ARROWS - K left, M right, P down, H up
'home G, end O, page up I, page down Q

DATA 0,1,2,3,4,5,6,7,9,10,11,12,13,14,15,16,18,19,20,21,22,23,24,25,27,28
DATA 29,30,31,32,33,34,-1: 'binary steps
DATA 1,5,10,14,19,23,28,32,-1: 'nibble steps
DATA 3,4,12,13,21,22,30,31,-1: 'byte steps
DATA 0,1,2,3,4,5,6,7,-1: 'full hex steps
DATA 0,1,2,4,5,6,8,9,10,12,13,14,-1: 'decimal steps

CLS : LOCATE 10, 35: PRINT "SETTING UP"
FOR a = 0 TO 4: b = 0
set1: READ s(a, b): IF s(a, b) > -1 THEN b = b + 1: GOTO set1
NEXT

g$(0) = "OR": g$(1) = "NOR": g$(2) = "XOR": g$(3) = "XNOR": g$(4) = "AND"
g$(5) = "NAND"
c$(0) = "0111": c$(1) = "1000": c$(2) = "0110": c$(3) = "1001": c$(4) = "0001"
c$(5) = "1110"

CLS : COLOR 11

selftest1 = 0: st = 0

LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15

OPEN "TY2KPATH.TXT" FOR INPUT AS #1: INPUT #1, a$: CLOSE
menupath = VAL(a$) + 1: ON menupath GOTO gate1, gate2, gate3, 400

menu: CHAIN "TY2KMENU"

'1  2-INPUT GATES
'2  8-BIT LOGIC
'3  BINARY, HEX AND DECIMAL

hold: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO hold ELSE RETURN

'.................

gate1: CLS : selftest1 = 0: c$ = "": g$ = "": z$ = ""
gate1a: IF c$ = "M" OR g$ = "M" OR z$ = "M" THEN GOTO menu
col = 3: COLOR 15: GOSUB clearall
FOR gate = 0 TO 5: GOSUB showgates: NEXT
LINE (0, 161)-(640, 161), 14: ac = 20
FOR a = 1 TO 3: ax = ac * 8: LINE (ax, 0)-(ax, 350), 14: ac = ac + 20: NEXT

LOCATE 13, 66: COLOR 11: PRINT "M "; : COLOR 15: PRINT "MENU"
LOCATE 14, 66: COLOR 11: PRINT "S "; : COLOR 15: PRINT "SELFTEST"

ax = 60 * 8: dx = 14 * 14 + 7: LINE (ax, dx)-(640, dx), 14

highlightcall:
FOR gate = 0 TO 5: dn = 7: IF gate > 3 THEN dn = 19
ac = 6 + ((gate AND 3) * 20): GOSUB highlight
dn = 3: IF gate > 3 THEN dn = 15
ac = 1 + ((gate AND 3) * 20): GOSUB logicshow
NEXT: gate = 0: dn = 6: ac = 6: col = 9: GOSUB paintit

gate1mode: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO gate1mode

IF z$ = "M" THEN GOTO menu
IF z$ = "S" THEN GOTO selftest100

z$ = MID$(z$, 2): IF z$ = "" THEN GOTO gate1mode
dn = 6: IF gate > 3 THEN dn = 18
ac = 6 + ((gate AND 3) * 20): col = 0: GOSUB paintit
IF z$ = "M" THEN gate = gate + 1: IF gate > 5 THEN gate = 0: 'AND 3
IF z$ = "K" THEN gate = gate - 1: IF gate < 0 THEN gate = 5
dn = 6: IF gate > 3 THEN dn = 18
ac = 6 + ((gate AND 3) * 20): col = 9: GOSUB paintit
dn = 7 + count(gate): IF gate > 3 THEN dn = dn + 12
ac = 6 + ((gate AND 3) * 20): GOSUB highlight
IF z$ = "P" THEN count(gate) = (count(gate) + 1) AND 3
IF z$ = "H" THEN count(gate) = count(gate) - 1
IF count(gate) < 0 THEN count(gate) = 3
dn = 7 + count(gate): IF gate > 3 THEN dn = dn + 12
ac = 6 + ((gate AND 3) * 20): GOSUB highlight
dn = 3: IF gate > 3 THEN dn = 15
ac = 1 + ((gate AND 3) * 20): GOSUB logicshow: GOTO gate1mode

orsymbol: Y = dn * 14 + 11
angle1 = 25: angle2 = 90: s = angle1 * pi: e = angle2 * pi
CIRCLE (x, Y), 60, 15, s, e: 'top curve
angle1 = 270: angle2 = 335: s = angle1 * pi: e = angle2 * pi
CIRCLE (x, Y - 36), 60, 15, s, e: ' bottom curve
angle1 = 320: angle2 = 40: s = angle1 * pi: e = angle2 * pi
CIRCLE (x - 44, Y - 18), 56, 15, s, e: ' end curve
PAINT (x + 16, Y - 19), col, 15
ax = (ac - 2) * 8 + 2: dx = dn * 14: ay = ax + 22
LINE (ax, dx - 21)-(ay, dx - 21), 14: 'A
LINE (ax, dx + 7)-(ay, dx + 7), 14: 'B
LINE (ax + 68, dx - 7)-(ay + 68, dx - 7), 14: ' Y
LOCATE dn - 1, ac - 2: PRINT "A": LOCATE dn, ac + 11: PRINT "Y"
LOCATE dn + 1, ac - 2: PRINT "B": RETURN

orgate: x = ac * 8: GOSUB orsymbol
IF st = 0 THEN LOCATE dn - 3, ac + 1: PRINT "OR GATE":
RETURN

norgate: x = ac * 8: Y = dn * 14 + 12: GOSUB orsymbol
CIRCLE ((ac + 7) * 8 + 4, dn * 14 - 7), 4, 15
PAINT ((ac + 7) * 8 + 4, dn * 14 - 7), col, 15
IF st = 0 THEN LOCATE dn - 3, ac + 1: PRINT "NOR GATE"
RETURN

xorgate: x = ac * 8: Y = dn * 14 + 12: GOSUB orsymbol
CIRCLE (x - 51, Y - 18), 56, 15, s, e: ' xor curve
IF st = 0 THEN LOCATE dn - 3, ac + 1: PRINT "XOR GATE"
RETURN

xnorgate: x = ac * 8: Y = dn * 14 + 12: GOSUB orsymbol
CIRCLE (x - 51, Y - 18), 56, 15, s, e: ' xor curve
CIRCLE ((ac + 7) * 8 + 4, dn * 14 - 7), 4, 15
PAINT ((ac + 7) * 8 + 4, dn * 14 - 7), col, 15
IF st = 0 THEN LOCATE dn - 3, ac: PRINT "XNOR GATE"
RETURN

andsymbol: Y = dn * 14 - 7
angle1 = 270: angle2 = 90: s = angle1 * pi: e = angle2 * pi
CIRCLE (x, Y), 40, 15, s, e: 'top curve
LINE (ac * 8 + 9, dn * 14 + 21)-(ac * 8 + 9, dn * 14 - 35), 15: 'end line
PAINT (ac * 8 + 16, dn * 14 - 7), col, 15
LINE (ac * 8 - 14, dn * 14 - 21)-(ac * 8 + 8, dn * 14 - 21), 14: 'A
LINE (ac * 8 - 14, dn * 14 + 7)-(ac * 8 + 8, dn * 14 + 7), 14: 'B
LINE ((ac + 7) * 8 - 5, dn * 14 - 7)-((ac + 8) * 8 + 12, dn * 14 - 7), 14: ' Y
LOCATE dn - 1, ac - 2: PRINT "A": LOCATE dn, ac + 11: PRINT "Y"
LOCATE dn + 1, ac - 2: PRINT "B": RETURN

andgate: x = ac * 8 + 10: GOSUB andsymbol
IF st = 0 THEN LOCATE dn - 3, ac + 1: PRINT "AND GATE"
RETURN

nandgate: x = ac * 8 + 10: GOSUB andsymbol
CIRCLE ((ac + 7) * 8, dn * 14 - 7), 4, 15
PAINT ((ac + 7) * 8, dn * 14 - 7), col, 15
IF st = 0 THEN LOCATE dn - 3, ac + 1: PRINT "NAND GATE"
RETURN

tablebox:
COLOR 14: LOCATE dn + 3, ac + 1: PRINT "B  A  Y": COLOR 15
LOCATE dn + 4, ac + 1: PRINT "0  0": LOCATE dn + 5, ac + 1: PRINT "0  1"
LOCATE dn + 6, ac + 1: PRINT "1  0": LOCATE dn + 7, ac + 1: PRINT "1  1"
ax = (ac - 1) * 8: dx = (dn + 2) * 14
LINE (ax, dx)-((ac + 8) * 8, dx + 70), 14, B
LINE (ax, dx + 14)-((ac + 8) * 8, dx + 14), 14
LINE ((ac + 5) * 8, dx)-((ac + 5) * 8, dx + 70), 14
RETURN

ortable: ax = ac + 7
LOCATE dn + 4, ax: PRINT "0"
LOCATE dn + 5, ax: PRINT "1"
LOCATE dn + 6, ax: PRINT "1"
LOCATE dn + 7, ax: PRINT "1": RETURN

nortable: ax = ac + 7
LOCATE dn + 4, ax: PRINT "1"
LOCATE dn + 5, ax: PRINT "0"
LOCATE dn + 6, ax: PRINT "0"
LOCATE dn + 7, ax: PRINT "0": RETURN

xortable: ax = ac + 7
LOCATE dn + 4, ax: PRINT "0"
LOCATE dn + 5, ax: PRINT "1"
LOCATE dn + 6, ax: PRINT "1"
LOCATE dn + 7, ax: PRINT "0": RETURN

xnortable: ax = ac + 7
LOCATE dn + 4, ax: PRINT "1"
LOCATE dn + 5, ax: PRINT "0"
LOCATE dn + 6, ax: PRINT "0"
LOCATE dn + 7, ax: PRINT "1": RETURN

andtable: ax = ac + 7
LOCATE dn + 4, ax: PRINT "0"
LOCATE dn + 5, ax: PRINT "0"
LOCATE dn + 6, ax: PRINT "0"
LOCATE dn + 7, ax: PRINT "1": RETURN

nandtable: ax = ac + 7
LOCATE dn + 4, ax: PRINT "1"
LOCATE dn + 5, ax: PRINT "1"
LOCATE dn + 6, ax: PRINT "1"
LOCATE dn + 7, ax: PRINT "0": RETURN

highlight:
ax = ac * 8 - 7: dx = dn * 14 + 1: ay = (ac + 8) * 8 - 1: dy = dx + 14 - 2
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET: RETURN

paintit:
ax = ac * 8 - 7: dx = dn * 14: PAINT (ax, dx + 1), col, 14
PAINT (ax + 11, dx + 5), col, 14: PAINT (ax + 35, dx + 6), col, 14
PAINT (ax + 11, dx + 8), col, 14: PAINT (ax + 48, dx + 1), col, 14:
RETURN

logicshow: col = 12: b = count(gate) \ 2: a = count(gate) AND 1
ON gate + 1 GOTO ls1, ls2, ls3, ls4, ls5, ls6
STOP
ls1: Y = a OR b: GOTO ls10
ls2: Y = ((a OR b) + 1) AND 1: GOTO ls10
ls3: Y = a XOR b: GOTO ls10
ls4: Y = ((a XOR b) + 1) AND 1: GOTO ls10
ls5: Y = a AND b: GOTO ls10
ls6: Y = ((a AND b) + 1) AND 1

ls10:
LOCATE dn, ac + 1: PRINT MID$(STR$(a), 2)
LOCATE dn + 2, ac + 1: PRINT MID$(STR$(b), 2)
LOCATE dn + 1, ac + 18: PRINT MID$(STR$(Y), 2)
ac = ac + 4.5: ax = ac * 8 - 10: ay = dn * 14 - 14

hi = col * a: lo = col * ((a + 1) AND 1)
LINE (ax, ay)-(ax + 8, ay + 6), hi, BF
ay = ay + 7: LINE (ax, ay + 1)-(ax + 8, ay + 7), lo, BF

dn = dn + 2: ay = dn * 14 - 14
hi = col * b: lo = col * ((b + 1) AND 1)
LINE (ax, ay)-(ax + 8, ay + 6), hi, BF
ay = ay + 7: LINE (ax, ay + 1)-(ax + 8, ay + 7), lo, BF

dn = dn - 1: ay = dn * 14 - 14: ac = ac + 9: ax = ac * 8
hi = col * Y: lo = col * ((Y + 1) AND 1)
LINE (ax, ay)-(ax + 8, ay + 6), hi, BF
ay = ay + 7: LINE (ax, ay + 1)-(ax + 8, ay + 7), lo, BF: RETURN

selftest100:
selftest1 = (selftest1 + 1) AND 1: IF selftest1 = 0 THEN GOTO gate1a
GOSUB clearall: FOR a = 0 TO 5: test(a) = 0: NEXT: test = 0

st101: gate = INT(RND(1) * 6): IF test(gate) = 1 THEN GOTO st101
col = 3: test(gate) = 1: test = test + 1: ac = 46: dn = 16
st = 1: ON gate + 1 GOTO test0, test1, test2, test3, test4, test5
STOP
test0: GOSUB orgate: GOSUB tablebox: GOTO st102
test1: GOSUB norgate: GOSUB tablebox: GOTO st102
test2: GOSUB xorgate: GOSUB tablebox: GOTO st102
test3: GOSUB xnorgate: GOSUB tablebox: GOTO st102
test4: GOSUB andgate: GOSUB tablebox: GOTO st102
test5: GOSUB nandgate: GOSUB tablebox

st102: st = 0: COLOR 15
LOCATE 20, 62: PRINT "                 "
LOCATE 21, 62: PRINT "                 "
LOCATE 23, 62: COLOR 14: PRINT "A "; : COLOR 15: PRINT "ANSWER"
COLOR 11: LOCATE 16, 74: PRINT "****": COLOR 15
LOCATE 16, 62: PRINT "GATE TYPE "; : INPUT g$: g$ = UCASE$(g$): COLOR 14
IF g$ = "M" OR g$ = "S" THEN selftest1 = 0: GOTO gate1a
IF g$ = "A" THEN g$ = g$(gate): GOTO st108
LOCATE 18, 64: IF g$ <> g$(gate) THEN PRINT "TRY AGAIN": GOTO st102
st108: LOCATE 18, 64: PRINT "         "
LOCATE 13, 47: PRINT g$; " GATE"
LOCATE 16, 74: COLOR 11: PRINT g$; "  "
LOCATE 21, 62: PRINT "(TOP TO BOTTOM)"

st103: COLOR 11: LOCATE 20, 75: PRINT "****": COLOR 15
LOCATE 20, 62: PRINT "LOGIC ORDER"; : INPUT c$: c$ = UCASE$(c$): COLOR 14
IF c$ = "M" OR c$ = "S" THEN selftest1 = 0: GOTO gate1a
IF c$ = "A" THEN GOTO st109
LOCATE 22, 64: IF c$ <> c$(gate) THEN PRINT "TRY AGAIN": GOTO st103
st109: LOCATE 22, 64: PRINT "            ":
COLOR 14: GOSUB showgates
ax = 1 + 161 + 161: dx = 164: LINE (ax, dx)-(ax + 156, dx + 163), 0, BF
ax = ax + 161: LINE (ax, dx + 42)-(ax + 156, dx + 158), 0, BF:
COLOR 14: LOCATE 23, 65: PRINT "ANOTHER Y/N ": COLOR 15: count(gate) = 0
dn = 7: IF gate > 3 THEN dn = 19
dn = dn + count(gate)
ac = 6 + ((gate AND 3) * 20): GOSUB highlight: t$ = TIME$
dn = 3: IF gate > 3 THEN dn = 15
ac = 1 + ((gate AND 3) * 20): GOSUB logicshow

st104a: IF TIME$ = t$ THEN GOTO st104a ELSE t$ = TIME$
st104: z$ = UCASE$(INKEY$):
IF z$ <> "" THEN GOTO st105
IF test < 6 THEN IF TIME$ = t$ THEN GOTO st104 ELSE t$ = TIME$
IF test < 6 THEN GOTO st104b
FOR ajb = 0 TO 5: gate = gate + 1: IF gate > 5 THEN gate = 0
st104b:
dn = 7: IF gate > 3 THEN dn = 19
dn = dn + count(gate)
ac = 6 + ((gate AND 3) * 20): GOSUB highlight
count(gate) = (count(gate) + 1) AND 3
dn = 3: IF gate > 3 THEN dn = 15
ac = 1 + ((gate AND 3) * 20): GOSUB logicshow
dn = 7: IF gate > 3 THEN dn = 19
dn = dn + count(gate): ac = 6 + ((gate AND 3) * 20): GOSUB highlight
IF test < 6 THEN GOTO st104
NEXT: GOTO st104

st105: col = 11
LOCATE 23, 64: PRINT "            "
IF z$ = "N" OR z$ = "M" GOTO gate1a
IF z$ = "S" THEN selftest1 = 0: GOTO selftest100
IF test < 6 THEN GOTO st101 ELSE GOTO gate1a

showgates: ON gate + 1 GOTO sg0, sg1, sg2, sg3, sg4, sg5
STOP
sg0: ac = 6: dn = 4: GOSUB orgate: GOSUB ortable: GOTO tablebox
sg1: ac = 26: dn = 4: GOSUB norgate: GOSUB nortable: GOTO tablebox
sg2: ac = 46: dn = 4: GOSUB xorgate: GOSUB xortable: GOTO tablebox
sg3: ac = 66: dn = 4: GOSUB xnorgate: GOSUB xnortable: GOTO tablebox
sg4: ac = 6: dn = 16: GOSUB andgate: GOSUB andtable: GOTO tablebox
sg5: ac = 26: dn = 16: GOSUB nandgate: GOSUB nandtable: GOTO tablebox

clearall:
ax = 1: dx = 1: LINE (ax, dx)-(ax + 156, dx + 158), 0, BF
ax = ax + 161: LINE (ax, dx)-(ax + 154, dx + 158), 0, BF
ax = ax + 161: LINE (ax, dx)-(ax + 154, dx + 158), 0, BF
ax = ax + 161: LINE (ax, dx)-(ax + 154, dx + 158), 0, BF
ax = 1: dx = 164: LINE (ax, dx)-(ax + 156, dx + 158), 0, BF
ax = ax + 161: LINE (ax, dx)-(ax + 156, dx + 158), 0, BF
ax = ax + 161: LINE (ax, dx)-(ax + 156, dx + 158), 0, BF
ax = ax + 161: LINE (ax, dx + 42)-(ax + 156, dx + 158), 0, BF: RETURN

'......................END GATE 1

'......................START GATE 2

gate2: CLS : selftest1 = 0: restart = 0
'COLOR 14: LOCATE 1, 36: PRINT "8-BIT LOGIC"

LOCATE 14, 70: COLOR 11: PRINT "M "; : COLOR 15: PRINT "MENU"
LOCATE 15, 70: COLOR 11: PRINT "S "; : COLOR 15: PRINT "SELFTEST"

gate2restart:
ac = 6: dn = 2: '3

FOR gate = 0 TO 5: IF gate = 4 THEN dn = 14: ac = 6: '13
COLOR 15: LOCATE dn, ac + 1: PRINT "8-BIT "; g$(gate)
COLOR 11: LOCATE dn + 2, ac: PRINT "Y = A "; g$(gate); " B"
LOCATE dn + 4, ac - 3: PRINT "A": LOCATE dn + 5, ac - 3: PRINT "B"
LOCATE dn + 7, ac - 3: PRINT "Y"; :
IF restart = 0 THEN ga(0, gate) = 213: ga(1, gate) = 93

ax = (ac - 5) * 8: ay = (ac + 13) * 8: dx = (dn - 1) * 14: dy = (dn + 9) * 14
LINE (ax, dx - 4)-(ay + 6, dy + 8), 14, B
LINE (ax, dx + 18)-(ay + 6, dx + 18), 14
LINE (ax, dx + 18 + 32)-(ay + 6, dx + 18 + 32), 14
LINE (ax, dx + 18 + 64 + 8)-(ay + 6, dx + 18 + 64 + 8), 14
LINE (ax, dx + 18 + 64 + 8 + 32)-(ay + 6, dx + 18 + 64 + 8 + 32), 14

COLOR 15
z = ga(0, gate): GOSUB decibin: LOCATE dn + 4, ac - 1: PRINT b$: ' A
z = ga(1, gate): GOSUB decibin: LOCATE dn + 5, ac - 1: PRINT b$: ' B
COLOR 14: GOSUB logicroute: LOCATE dn + 7, ac - 1: PRINT b$: ' Y
gatea$ = LEFT$("A" + STR$(ga(0, gate)) + "   ", 5)
gateb$ = LEFT$("B" + STR$(ga(1, gate)) + "   ", 5)
gatey$ = LEFT$("Y" + STR$(z) + "   ", 5): COLOR 10
LOCATE dn + 9, ac - 3: PRINT gatea$; " "; gateb$; " "; gatey$: COLOR 11
ac = ac + 20: NEXT: gate = 0: ga = 0: dn = 2: ac = 6: GOSUB highlight2: '3
restart = 0

g21: COLOR 11: LOCATE 14, 43: PRINT "CONTROLS:": COLOR 14
LOCATE 15, 43: PRINT "+ - * / ": LOCATE 16, 43: PRINT "plus arrows"
LOCATE 17, 43: PRINT "plus numerals 0 to 7": COLOR 15

gate2mode: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO gate2mode

IF z$ = "M" THEN GOTO menu
IF z$ = "S" THEN GOTO selftest200
IF selftest1 = 1 THEN z$ = ""

IF z$ = "+" THEN ga(ga, gate) = ga(ga, gate) + 1: GOTO gm2
IF z$ = "-" THEN ga(ga, gate) = ga(ga, gate) - 1: GOTO gm2
IF z$ = "*" THEN ga(ga, gate) = ga(ga, gate) * 2: GOTO gm2
IF z$ = "/" THEN ga(ga, gate) = ga(ga, gate) \ 2: GOTO gm2

IF z$ < "0" OR z$ > "7" THEN GOTO gm4

gm3: b = 2 ^ VAL(z$): c = ga(ga, gate) AND b: e = (c + b) AND b
f = ga(ga, gate) AND (255 - c): ga(ga, gate) = e OR f

gm2: dn = 2: ac = 6: IF gate > 3 THEN dn = 14: '13 '3
ax = (gate AND 3) * 20 + ac - 1
ga(ga, gate) = ABS(ga(ga, gate)) AND 255: z = ga(ga, gate): GOSUB decibin
COLOR 15: LOCATE dn + 4 + ga, ax: PRINT b$
gatea$ = LEFT$("A" + STR$(ga(0, gate)) + "   ", 5)
gateb$ = LEFT$("B" + STR$(ga(1, gate)) + "   ", 5)
GOSUB logicroute: COLOR 14: IF selftest1 = 1 THEN COLOR 0
LOCATE dn + 7, ax: PRINT b$: COLOR 15:
gatey$ = LEFT$("Y" + STR$(z) + "   ", 5)
LOCATE dn + 9, ax - 2: PRINT gatea$; " "; gateb$; " "; gatey$
GOTO gate2mode

gm4: z$ = MID$(z$, 2): IF z$ = "" THEN GOTO gate2mode
GOSUB highlight2:
IF z$ = "M" THEN gate = gate + 1: IF gate > 5 THEN gate = 0: 'AND 3
IF z$ = "K" THEN gate = gate - 1: IF gate < 0 THEN gate = 5
dn = 2: ac = 6: IF gate > 3 THEN dn = 14: '13 '3
IF z$ = "P" OR z$ = "H" THEN ga = (ga + 1) AND 1
GOSUB highlight2: GOSUB logicroute: GOTO gm2

logicroute:
a = ga(0, gate): b = ga(1, gate):
ON gate + 1 GOTO lg0, lg1, lg2, lg3, lg4, lg5
lg0: Y = a OR b: z = Y: GOTO decibin
lg1: Y = a OR b: z = 255 - Y: GOTO decibin
lg2: Y = a XOR b: z = Y: GOTO decibin
lg3: Y = a XOR b: z = 255 - Y: GOTO decibin
lg4: Y = a AND b: z = Y: GOTO decibin
lg5: Y = a AND b: z = 255 - Y

decibin:
d = z: b$ = "": FOR t = 7 TO 0 STEP -1: c = 2 ^ t: w = d / c
IF w >= 1 THEN d = d - c: x = 1 ELSE x = 0
b$ = b$ + STR$(x): NEXT: b$ = MID$(b$, 2): RETURN

highlight2:
ax = ((gate AND 3) * 20 + ac - 4) * 8 - 4: ay = ax + 14
dx = (dn + 3 + ga) * 14 + 2: dy = dx + 14 - 3
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET: RETURN

selftest200: selftest1 = (selftest1 + 1) AND 1
GOSUB highlight2: IF selftest1 = 0 THEN GOTO gate2mode

st201:
dn = 2: ac = 6: FOR gate = 0 TO 5: ga(0, gate) = INT(RND(1) * 256): '3
ga(1, gate) = INT(RND(1) * 256): IF gate > 3 THEN dn = 14: '13
ax = (gate AND 3) * 20 + ac - 1
z = ga(0, gate): GOSUB decibin: LOCATE dn + 4, ax: PRINT b$: ' A
z = ga(1, gate): GOSUB decibin: LOCATE dn + 5, ax: PRINT b$: ' B
COLOR 0: GOSUB logicroute: LOCATE dn + 7, ax: PRINT b$: ' Y
LOCATE dn + 9, ax - 2: PRINT "                 "
b$(gate) = b$: COLOR 15:
gatey$(gate) = LEFT$("Y" + STR$(z) + "   ", 5): ' LOCATE 1, 1: PRINT gatey$: STOP
NEXT: COLOR 11

ax = 41 * 8: ay = 67 * 8 + 4: dx = 13 * 14 - 4: dy = 20 * 14 + 4: '12 19
LINE (ax, dx)-(ay, dy), 0, BF: LINE (ax, dx)-(ay, dy), 3, B

LOCATE 14, 43: PRINT "ENTER THE VALUE REQUESTED"
LOCATE 15, 43: PRINT "(WITH OR WITHOUT SPACES) "
LOCATE 16, 43: PRINT "THEN PRESS <ENTER>       "
COLOR 11: LOCATE 20, 43: PRINT "A         FOR ANSWER  "
COLOR 7: LOCATE 20, 45: PRINT "<ENTER>": COLOR 15

dn = 2: ac = 6: FOR gate = 0 TO 5: COLOR 15: IF gate > 3 THEN dn = 14: '13 3
ax = (gate AND 3) * 20 + ac - 1: LOCATE dn + 7, ax + 2: PRINT "VALUE"
'LOCATE 16, 43: PRINT B$(gate)

st1: LOCATE dn + 7, ax - 2: INPUT a$: IF a$ = "" THEN GOTO st1
ok = 0: IF UCASE$(a$) = "A" THEN GOTO st2
IF UCASE$(a$) = "M" THEN GOTO menu
d$ = "": FOR c = 1 TO LEN(a$)
c$ = MID$(a$, c, 1): IF c$ <> " " THEN d$ = d$ + c$ + " "
NEXT

IF UCASE$(a$) = "S" THEN selftest1 = 0: restart = 1: GOTO st5
IF d$ = b$(gate) + " " THEN ok = 1: GOTO st2
COLOR 14: LOCATE 17, 43: PRINT "                    "
LOCATE 17, 43: PRINT "NOT "; d$: LOCATE 18, 43: PRINT "TRY AGAIN!       "
LOCATE dn + 7, ax - 2: PRINT "                ": COLOR 15: GOTO st1

st2: LOCATE dn + 7, ax - 2: COLOR 11: PRINT "Y "; : COLOR 14
LOCATE 17, 43: PRINT "Y = "; b$(gate)

gatea$ = LEFT$("A" + STR$(ga(0, gate)) + "   ", 5)
gateb$ = LEFT$("B" + STR$(ga(1, gate)) + "   ", 5)
'gatey$ = LEFT$("Y" + STR$(z) + "   ", 5): COLOR 10
LOCATE dn + 9, ax - 2: PRINT gatea$; " "; gateb$; " "; gatey$(gate): COLOR 11

LOCATE dn + 7, ax - 2: COLOR 11: PRINT "Y "; : COLOR 14
PRINT b$(gate): LOCATE 18, 43: IF ok = 1 THEN PRINT "OK - ";
PRINT "NOW THE NEXT     ": NEXT

COLOR 11: LOCATE 18, 43: PRINT "OK                    ": COLOR 14
LOCATE 19, 43: PRINT "WANT MORE TESTS Y/N ?": COLOR 15

st4: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO st4
IF z$ = "Y" THEN GOTO st201

st5: ax = 41 * 8: ay = 67 * 8 + 4: dx = 13 * 14 - 4: dy = 20 * 14 + 4: '12 19
LINE (ax, dx)-(ay, dy), 0, BF
gate = 0: ga = 0: dn = 2: ac = 6: selftest1 = 0: ' GOSUB highlight2:
'IF UCASE$(a$) = "S" THEN selftest1 = 0: GOTO gate2restart: 'st5
IF restart = 1 THEN GOTO gate2restart: 'st5
GOSUB highlight2:
GOTO g21: '3


'......................END GATE 2

'......................START GATE 3


gate3: CLS : selftest1 = 0: col = 11
COLOR 14: LOCATE 1, 29: PRINT "BINARY, HEX AND DECIMAL"

LOCATE 6, 6: COLOR 14: PRINT "M "; : COLOR 15: PRINT "MENU"
LOCATE 7, 6: COLOR 14: PRINT "S "; : COLOR 15: PRINT "SELFTEST"
COLOR 11: LOCATE 8, 6: PRINT "CONTROLS:": COLOR 15
LOCATE 9, 6: PRINT "+ -"
LOCATE 10, 6: PRINT "0-9 A-F"
LOCATE 11, 6: PRINT "HOME, END"
LOCATE 12, 6: PRINT "PAGE UP/DOWN"
LOCATE 13, 6: PRINT "ARROWS"
LOCATE 14, 6: PRINT "SPACE BAR"
LOCATE 15, 6: PRINT "LEFT DELETE"
LOCATE 16, 6: PRINT "<ENTER>": COLOR 15

ac = 4: dn = 5
ax = ac * 8: ay = (ac + 13) * 8: dx = dn * 14: dy = (dn + 11) * 14
LINE (ax, dx - 7)-(ay + 6, dy + 7), 11, B

zero$ = "00000000": zero1$ = "        "

valdecimal = 3339722116#
'valdecimal = 9722175#
'valdecimal = 75#
'valdecimal = 65535: '32767
'valdecimal = 2 ^ 35
'valdecimal = 128

ac = 21: dn = 5

LOCATE dn - 1, ac + 3: v = 2 ^ bit(0)
PRINT "2 ^"; bit(0); "= "; v
LOCATE dn + 1, ac + 3: PRINT "31 - 24"
LOCATE dn + 1, ac + 12: PRINT "23 - 16"
LOCATE dn + 1, ac + 21: PRINT "15 - 8"
LOCATE dn + 1, ac + 31: PRINT "7 - 0"

LOCATE dn - 1, ac + 40: PRINT "BIT VALUE"
LOCATE dn + 1, ac + 40: PRINT "BIT NUMBERS"
LOCATE dn + 3, ac + 40: PRINT "BINARY"
LOCATE dn + 5, ac + 40: PRINT "HEX NIBBLES"
LOCATE dn + 7, ac + 40: PRINT "HEX BYTES"
LOCATE dn + 9, ac + 40: PRINT "HEX"
LOCATE dn + 11, ac + 40: PRINT "DECIMAL"

ax = ac * 8: ay = (ac + 36) * 8: dx = dn * 14: dy = (dn + 11) * 14
LINE (ax, dx - 7 - 28)-(ay + 6, dy + 7), 11, B
LINE (316 - 1, dx - 7)-(316 - 1, dx + 21), 11
LINE (316 + 72 - 1, dx - 7)-(316 + 72 - 1, dx + 21), 11
LINE (316 - 72 - 1, dx - 7)-(316 - 72 - 1, dx + 21), 11

LINE (316 - 1, dx + 49 + 28)-(316 - 1, dx + 49 + 28 + 28), 11
LINE (316 + 72 - 1, dx + 49 + 28)-(316 + 72 - 1, dx + 49 + 28 + 28), 11
LINE (316 - 72 - 1, dx + 49 + 28)-(316 - 72 - 1, dx + 49 + 28 + 28), 11
FOR a = ax + 3 + 36 TO ay + 6 - 36 STEP 36
LINE (a, dx + 49)-(a, dx + 49 + 28), 11: NEXT

FOR a = 1 TO 6: LINE (ax, dx - 7)-(ay + 6, dx - 7), 11: dx = dx + 28: NEXT

max(0) = 31: max(1) = 7: max(2) = 7: max(3) = 7: max(4) = 9
FOR a = 0 TO 4: mode(a) = s(a, 0): NEXT
GOSUB decimalorig: GOSUB highlight3: GOSUB highlight3a

gate3mode: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO gate3mode
z0 = 0: IF z$ = "M" THEN GOTO menu
IF z$ = "S" THEN GOTO selftest300
IF z$ >= "0" AND z$ <= "9" THEN z0 = 1: GOTO gm3a
IF z$ >= "A" AND z$ < "G" THEN z0 = 1: GOTO gm3a
IF z$ = " " OR z$ = CHR$(8) THEN GOTO gm3a: ' CHR$(8) = left delete
IF z$ = CHR$(13) THEN GOSUB enterval
IF z$ <> "+" AND z$ <> "-" THEN GOTO gm3b

gm3a: ON mode + 1 GOSUB bininc, nibinc, nibinc, nibinc, decinc
IF z$ = " " OR z0 = 1 THEN z$ = " M": GOTO gm3b
IF z$ = CHR$(8) THEN z$ = " K": GOTO gm3b
GOTO gate3mode

gm3b: z$ = MID$(z$, 2): IF z$ = "" OR selftest1 = 1 THEN GOTO gate3mode
GOSUB highlight3: GOSUB highlight3a
IF z$ = "K" THEN bit(mode) = bit(mode) + 1: ' left
IF bit(mode) > max(mode) THEN bit(mode) = max(mode)
IF z$ = "M" THEN bit(mode) = bit(mode) - 1: ' right
IF bit(mode) < 0 THEN bit(mode) = 0
IF z$ = "P" THEN mode = mode + 1: IF mode > 4 THEN mode = 4: ' down
IF z$ = "H" THEN mode = mode - 1: IF mode < 0 THEN mode = 0: ' up
IF z$ = "G" THEN bit(mode) = max(mode): ' home
IF z$ = "O" THEN bit(mode) = 0: ' end
IF z$ = "I" THEN mode = 0: ' page up
IF z$ = "Q" THEN mode = 4: ' page down
IF mode = 0 THEN COLOR 15 ELSE COLOR 0
LOCATE dn - 1, ac + 3: v = 2 ^ bit(0)
a$ = LTRIM$(STR$(v)): c$ = "": b = 0
FOR a = LEN(a$) TO 1 STEP -1: c$ = MID$(a$, a, 1) + c$
b = b + 1: IF b \ 3 = b / 3 THEN c$ = "," + c$
NEXT: IF LEFT$(c$, 1) = "," THEN c$ = MID$(c$, 2)
a$ = LEFT$(c$ + "                       ", 16)
PRINT "2 ^"; bit(0); "= "; a$: COLOR 15
GOSUB highlight3: GOSUB highlight3a: GOTO gate3mode

decimalorig: ax = 25: v = valdecimal: GOSUB decibin2
a$ = MID$(STR$(valdecimal), 2): c$ = "": b = 0
FOR a = LEN(a$) TO 1 STEP -1: c$ = MID$(a$, a, 1) + c$
b = b + 1: IF b \ 3 = b / 3 THEN c$ = "," + c$
NEXT: IF LEFT$(c$, 1) = "," THEN c$ = MID$(c$, 2)
deci$ = RIGHT$("                       " + c$, 16)
LOCATE 16, ax + 17: PRINT deci$: LOCATE 16, ax + 44
IF valdecimal = (2 ^ 32) - 1 THEN PRINT "MAX" ELSE PRINT "   "
splitdeci: v = valdecimal: FOR t = 9 TO 0 STEP -1: v2 = 10 ^ t
vw = v / v2: v = v - (v2 * INT(vw)): deci%(t) = INT(vw): NEXT

binline: LOCATE 8, 23:
b = 0: c = 0: FOR a = 1 TO 32 STEP 8: byte$(b) = MID$(b$, a, 8):
IF b = 3 THEN c = 1
IF c = 0 AND byte$(b) = zero$ THEN PRINT zero1$;  ELSE c = 1: PRINT byte$(b);
IF b < 3 THEN PRINT " ";
b = b + 1: NEXT: PRINT

hexbyteline:
ax = 26: c = 0: FOR a = 0 TO 3: a$ = byte$(a): h$ = hexbyte$(a)
IF a = 3 THEN c = 1
IF c = 0 AND a$ = zero$ THEN hexbyte$(a) = "00": h$ = "  ": GOTO g3 ELSE c = 1
GOSUB bindeci: hexbyte$(a) = RIGHT$("0" + HEX$(v), 2): h$ = hexbyte$(a)
g3: LOCATE 12, ax: PRINT h$: LOCATE 10, ax - 1: PRINT LEFT$(h$, 1)
LOCATE 10, ax + 3: PRINT RIGHT$(h$, 1): ax = ax + 9: NEXT
bin$ = "": b = 4: c = 0: FOR a = 0 TO 3: a$ = hexbyte$(a):
IF c = 0 AND a < 3 AND a$ = "00" THEN a$ = "  ": b = b - 1 ELSE c = 1
bin$ = bin$ + a$: NEXT: bin$ = RIGHT$("        " + bin$, 8)
b = b * 8: LOCATE 14, ax + 2: PRINT STR$(b); "-BIT ":
LOCATE 14, ax - 12: PRINT bin$: RETURN

bininc: c = bin%(bit(0))
IF z$ = " " OR z$ = CHR$(8) THEN c = 0: GOTO bin2
IF z$ = "+" OR z$ = "-" THEN c = (c + 1) AND 1: GOTO bin2
IF z$ = "0" OR z$ = "1" THEN c = VAL(z$) ELSE RETURN
bin2: f$ = MID$(STR$(c), 2): bin%(bit(0)) = c: GOSUB highlight3a
ax = ac + 36 - s(mode, bit(mode)): dx = dn + 3 + (mode * 2)
LOCATE dx, ax: PRINT f$: v = 0: FOR a = 0 TO 31
v = v + (bin%(a) * (2 ^ a)): NEXT: valdecimal = v
GOSUB decimalorig: GOSUB highlight3a: RETURN

nibinc: a = bit(mode) \ 2: a$ = hexbyte$(3 - a)
a$(0) = LEFT$(a$, 1): a$(1) = RIGHT$(a$, 1)
b = (bit(mode) + 1) AND 1
IF z$ = "0" OR z$ = " " OR z$ = CHR$(8) THEN c = 0: GOTO nib2
d = VAL("&H" + z$): IF d > 0 AND d < 16 THEN c = d: GOTO nib2
c = VAL("&H" + a$(b)): IF z$ = "+" THEN c = (c + 1) AND 15: GOTO nib2
IF z$ = "-" THEN c = (c - 1): IF c < 0 THEN c = 15
nib2: a$(b) = HEX$(c): hexbyte$(3 - a) = a$(0) + a$(1)
c$ = "&H" + hexbyte$(0) + hexbyte$(1)
d$ = "&H" + hexbyte$(2) + hexbyte$(3)
a = VAL(c$): IF a < 0 THEN a = a + 65536
b = VAL(d$): IF b < 0 THEN b = b + 65536
valdecimal = a * 65536 + b: GOSUB highlight3: GOSUB highlight3a
GOSUB decimalorig: GOSUB highlight3: GOSUB highlight3a: RETURN

decinc: c = deci%(bit(4)): v = 0
IF z$ = " " OR z$ = CHR$(8) THEN c = 0
IF z$ >= "0" AND z$ <= "9" THEN c = VAL(z$)
IF z$ = "+" THEN c = c + 1: IF c > 9 THEN c = 0
IF z$ = "-" THEN c = c - 1: IF c < 0 THEN c = 9
deci%(bit(4)) = c: FOR t = 9 TO 0 STEP -1: v1 = deci%(t) * (10 ^ t)
v = v + v1: NEXT: IF v >= (2 ^ 32) THEN v = (2 ^ 32) - 1
valdecimal = v: GOSUB highlight3: GOSUB highlight3a
GOSUB decimalorig: GOSUB highlight3: GOSUB highlight3a: RETURN

decibin2: b$ = "": FOR t = 31 TO 0 STEP -1: v2 = 2 ^ t: w = v / v2
IF w >= 1 THEN v = v - v2: x = 1 ELSE x = 0
b$ = b$ + MID$(STR$(x), 2): bin%(t) = x: NEXT: RETURN

bindeci: v = 0: w = LEN(a$) - 1: FOR t = 1 TO w + 1
e = VAL(MID$(a$, t, 1)) * (2 ^ w): v = v + e: w = w - 1: NEXT: RETURN

hexdeci: e$ = "": v = 0: w = LEN(a$) - 1: FOR t = 1 TO w + 1
c$ = MID$(a$, t, 1): IF c$ >= "0" AND c$ <= "9" THEN GOTO hd2
IF c$ >= "A" AND c$ <= "F" THEN GOTO hd2
e$ = "NOT A VALID HEX VALUE": e = 0: v = 0: EXIT FOR
hd2: e = VAL("&h" + c$) * (16 ^ w): v = v + e: w = w - 1: NEXT: RETURN

highlight3:
ax = (ac + 39) * 8 - 4: ay = ax + (12 * 8)
dx = (dn + 2 + (mode * 2)) * 14 + 2: dy = dx + 14 - 3
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET: RETURN

highlight3a: ' LOCATE 1, 1: PRINT s(mode, bit(mode)), bit(mode)
ax = (ac + 35 - s(mode, bit(mode))) * 8 - 1: ay = ax + 8
dx = (dn + 2 + (mode * 2)) * 14 + 2: dy = dx + 14 - 3
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET: RETURN

enterval:
COLOR 11: LOCATE 18, 32: PRINT "VALUE CONVERSION": COLOR 15
ON mode + 1 GOSUB ev0, ev1, ev1, ev1, ev2
GOSUB clear300: LOCATE 18, 32: PRINT "                ": COLOR 15
RETURN

ev0: LOCATE 20, 22: PRINT "ENTER BINARY VALUE THEN PRESS <ENTER>"
LOCATE 21, 22: INPUT a$: IF a$ = "" THEN GOTO ev0b
a$ = LEFT$(a$, 32)
GOSUB bindeci: valdecimal = v: GOSUB decimalorig: GOSUB highlight3a
ev0b: RETURN

ev1: LOCATE 20, 22: PRINT "ENTER HEX VALUE THEN PRESS <ENTER>"
ev1a: LOCATE 21, 22: PRINT "                                     "
LOCATE 21, 22: INPUT a$: IF a$ = "" THEN GOTO ev1b
a$ = UCASE$(a$): IF LEFT$(a$, 2) = "&H" THEN a$ = MID$(a$, 3)
LOCATE 22, 22: PRINT "                                     "
IF LEN(a$) > 8 THEN LOCATE 22, 22: PRINT a$; " IS TOO LONG": GOTO ev1a
a$ = RIGHT$("00000000" + a$, 8): GOSUB hexdeci
IF e$ <> "" THEN LOCATE 22, 22: PRINT a$; " "; e$: GOTO ev1a
IF v >= 2 ^ 32 THEN LOCATE 22, 22: PRINT "VALUE IS TOO GREAT": GOTO ev1a
GOSUB highlight3: GOSUB highlight3a: valdecimal = v: GOSUB decimalorig
GOSUB highlight3: GOSUB highlight3a
ev1b: RETURN

ev2: LOCATE 20, 22: PRINT "ENTER DECIMAL VALUE THEN PRESS <ENTER>"
ev2a: LOCATE 21, 22: PRINT "                                     "
LOCATE 21, 22: INPUT a$: IF a$ = "" THEN GOTO ev2b
a$ = LEFT$(a$, 12): v = VAL(a$)
IF v >= 2 ^ 32 THEN LOCATE 22, 22: PRINT v; "IS TOO GREAT": GOTO ev2a
GOSUB highlight3: GOSUB highlight3a
valdecimal = v: GOSUB decimalorig: GOSUB highlight3: GOSUB highlight3a
ev2b: RETURN

selftest300: selftest1 = (selftest1 + 1) AND 1: ' test = 0: st = 0
LOCATE 18, 30: IF selftest1 = 0 THEN PRINT "          ": GOTO gate3mode
COLOR 14: PRINT "      SELFTEST    ": COLOR 11
LOCATE 23, 30: PRINT "A"; : COLOR 7: PRINT " <ENTER>"; : COLOR 11
PRINT " FOR ANSWER": COLOR 15

st3: test = (test + 1) AND 1:
'test = 1:
st = test + 1

GOSUB highlight3: GOSUB highlight3a
COLOR 0: valdecimal = INT(RND(1) * (2 ^ 16)): GOSUB decimalorig: COLOR 15
IF st = 1 THEN GOSUB 310: GOSUB 320: GOSUB 330
IF st = 2 THEN GOSUB 340: GOSUB 350: GOSUB 310: GOSUB 330

LOCATE 23, 22: PRINT "                                                  "
COLOR 15: GOSUB decimalorig:  GOSUB highlight3: GOSUB highlight3a
st3a: selftest1 = 0: LOCATE 18, 31: PRINT "                 ": GOTO gate3mode

310 LOCATE 8, 23:
'binlin$ = ""
b = 0: c = 0: FOR a = 1 TO 32 STEP 8: byte$(b) = MID$(b$, a, 8)
IF b = 3 THEN c = 1
IF c = 0 AND byte$(b) = zero$ THEN PRINT zero1$; : GOTO 311
c = 1: PRINT byte$(b); : ' binlin$ = byte$(b) + binlin$
311 : IF b < 3 THEN PRINT " ";
b = b + 1: NEXT: PRINT : RETURN

320 b$ = LTRIM$(bin$)
'LOCATE 1, 1: PRINT bin$; valdecimal; "               ":
GOSUB clear300
LOCATE 20, 22: PRINT "ENTER HEX VALUE THEN PRESS <ENTER>                "
321 LOCATE 21, 22: PRINT "                                      "
LOCATE 21, 22: INPUT a$: IF a$ = "" THEN GOTO 321
a$ = UCASE$(LTRIM$(a$)): IF a$ = "A" THEN GOTO 325
a$ = RTRIM$(a$): a$ = RIGHT$("0" + a$, LEN(b$))
IF a$ = b$ THEN GOTO 325
LOCATE 22, 22: PRINT "NOT "; a$; " TRY AGAIN": GOTO 321
325 GOSUB hexbyteline: RETURN

330 GOSUB clear300: mode = 4
LOCATE 20, 22: PRINT "ENTER DECIMAL VALUE THEN PRESS <ENTER>            "
331 LOCATE 21, 22: PRINT "                                      "
LOCATE 21, 22: INPUT a$: IF a$ = "" THEN GOTO 331
a$ = UCASE$(LTRIM$(a$)): IF a$ = "A" THEN GOTO 335
LOCATE 22, 22: IF VAL(a$) = valdecimal THEN GOTO 335
PRINT "NOT "; a$; " TRY AGAIN       ": GOTO 331
335 LOCATE 16, ac + 21: PRINT deci$: LOCATE 16, ac + 48
IF valdecimal = (2 ^ 32) - 1 THEN PRINT "MAX" ELSE PRINT "   "
GOTO clear300

340 GOSUB hexbyteline: binlin$ = ""
b = 0: c = 0: FOR a = 1 TO 32 STEP 8: j$ = MID$(b$, a, 8)
IF b = 3 THEN c = 1
IF c = 0 AND j$ = zero$ THEN GOTO 341
c = 1: binlin$ = binlin$ + LEFT$(j$, 4) + " " + RIGHT$(j$, 4) + " "
341 : b = b + 1: NEXT: binlin$ = RTRIM$(binlin$): RETURN

350 GOSUB clear300
LOCATE 20, 22:
PRINT "ENTER BINARY VALUE (IN NIBBLES) THEN PRESS <ENTER>"
351 LOCATE 21, 22: PRINT "                                      "
LOCATE 21, 22: INPUT a$: IF a$ = "" THEN GOTO 351
a$ = UCASE$(LTRIM$(a$)): IF a$ = "A" THEN GOTO 355
a$ = RTRIM$(a$)
LOCATE 22, 22: IF a$ = binlin$ THEN GOTO 355
PRINT "NOT "; a$; " TRY AGAIN       ": GOTO 351
355 RETURN

clear300:
LOCATE 20, 22: PRINT "                                      "
LOCATE 21, 22: PRINT "                                      "
LOCATE 22, 22: PRINT "                                      ": RETURN

'.............

400 : ' binary, hex, decimal table

COLOR 15: LOCATE 10, 35: PRINT "SETTING UP"

OPEN "TY2KBIN2" FOR INPUT AS #1: FOR a = 0 TO 255: INPUT #1, bin$(a)
NEXT: CLOSE
OPEN "TY2KHEX1" FOR INPUT AS #1: FOR a = 0 TO 255: INPUT #1, hx$(a)
NEXT: CLOSE
OPEN "TY2KDEC1" FOR INPUT AS #1: FOR a = 0 TO 255: INPUT #1, a$
dec$(a) = RIGHT$("   " + a$, 3) + " ": NEXT: CLOSE
FOR a = 256 TO 264: dec$(a) = "                  ": NEXT

LOCATE 2, 11: COLOR 10: PRINT "DECIMAL, BINARY, HEXADECIMAL TABLE PAGE ";
PRINT "  NEXT "; : COLOR 14: PRINT "<BAR>"

COLOR 11: LOCATE 2, 67: PRINT "MENU "; : COLOR 14: PRINT "<M>"

410 : LOCATE 2, 51: COLOR 14: PRINT "1"
FOR a = 0 TO 21: LOCATE a + 3, 5
COLOR 15: PRINT dec$(a); : COLOR 14: PRINT bin$(a); " "; : COLOR 11: PRINT hx$(a); "  ";
COLOR 15: PRINT dec$(a + 22); : COLOR 14: PRINT bin$(a + 22); " "; : COLOR 11: PRINT hx$(a + 22); "  ";
COLOR 15: PRINT dec$(a + 44); : COLOR 14: PRINT bin$(a + 44); " "; : COLOR 11: PRINT hx$(a + 44); "  ";
COLOR 15: PRINT dec$(a + 66); : COLOR 14: PRINT bin$(a + 66); " "; : COLOR 11: PRINT hx$(a + 66); "  ";
NEXT: LOCATE 1, 1: GOSUB hold: IF z$ = "M" THEN GOTO menu

LOCATE 2, 51: COLOR 14: PRINT "2": a = 87
FOR b = 0 TO 21: LOCATE b + 3, 5: a = a + 1
COLOR 15: PRINT dec$(a); : COLOR 14: PRINT bin$(a); " "; : COLOR 11: PRINT hx$(a); "  ";
COLOR 15: PRINT dec$(a + 22); : COLOR 14: PRINT bin$(a + 22); " "; : COLOR 11: PRINT hx$(a + 22); "  ";
COLOR 15: PRINT dec$(a + 44); : COLOR 14: PRINT bin$(a + 44); " "; : COLOR 11: PRINT hx$(a + 44); "  ";
COLOR 15: PRINT dec$(a + 66); : COLOR 14: PRINT bin$(a + 66); " "; : COLOR 11: PRINT hx$(a + 66); "  ";
NEXT: LOCATE 1, 1: GOSUB hold: IF z$ = "M" THEN GOTO menu

LOCATE 2, 51: COLOR 14: PRINT "3": a = 176
FOR b = 0 TO 21: LOCATE b + 3, 5: a = a + 1
COLOR 15: PRINT dec$(a); : COLOR 14: PRINT bin$(a); " "; : COLOR 11: PRINT hx$(a); "  ";
COLOR 15: PRINT dec$(a + 22); : COLOR 14: PRINT bin$(a + 22); " "; : COLOR 11: PRINT hx$(a + 22); "  ";
COLOR 15: PRINT dec$(a + 44); : COLOR 14: PRINT bin$(a + 44); " "; : COLOR 11: PRINT hx$(a + 44); "  ";
COLOR 15: PRINT dec$(a + 66); : COLOR 14: PRINT bin$(a + 66); " "; : COLOR 11: PRINT hx$(a + 66); "  ";
NEXT: LOCATE 1, 1: GOSUB hold: IF z$ = "M" THEN GOTO menu
GOTO 410

