; TEACHINX15.ASM 28JAN08 - TEACH IN 2008 PTx

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file

           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'
RSLINE
STORE
LOOP
LOOPA
CLKCNT
COUNTLSB
COUNTMSB
RANDOM1
RANDOM2
RANDOM3
RANDOM4
XORGATE1
XORGATE2

DCOUNT        ; used by BIN2DEC routines
DSIGN
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10

REGA0
REGA1
REGA2
REGA3
REGB0
REGB1
REGB2
REGB3
REGC0
REGC1
REGC2
REGC3
MTEMP
MCOUNT
	   ENDC

           __config  $3F30     ; internal 4MHz oscillator

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

MESSAG     addwf PCL,F
           retlw 'R'
           retlw 'A'
           retlw 'N'
           retlw 'D'
           retlw 'O'
           retlw 'M'
           retlw ' '
           retlw ' '

MESSAG2    addwf PCL,F
           retlw 'C'
           retlw 'O'
           retlw 'U'
           retlw 'N'
           retlw 'T'
           retlw 'I'
           retlw 'N'
           retlw 'G'

STARTIT    clrf PORTA          ; clear PORTA's outputs if any
           clrf PORTB          ; clear PORTB's output if any
           movlw $07           ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1
           movlw b'00000111'   ; RA0-RA2 as input
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0

           call PAUSIT
           call LCDSET
	   call PAUSIT

           call LCDMSG

MAIN       btfss PORTA,0
           goto MAIN
           call CLRLINE1
           call LCDMSG2

;           call BYTECOUNT7
;           call BYTECOUNT15
;           call BYTECOUNT255
;           call BYTE2COUNT
;           call BYTECOUNT50
;           call BYTECOUNT7A
           call RANDOMISE

           goto MAIN

; **** One byte counter with AND 7 output to LCD ****

BYTECOUNT7 incf COUNTLSB,F
           btfsc PORTA,0
           goto BYTECOUNT7
           call CLRLINE1
           call LCD1
           bsf RSLINE,4
           movf COUNTLSB,W
           andlw 7
           iorlw 48
           call LCDOUT
           return

; **** One byte counter with bit 3 clearance ****

BYTECOUNT7A incf COUNTLSB,F
           bcf COUNTLSB,3
           btfsc PORTA,0
           goto BYTECOUNT7
           call CLRLINE1
           call LCD1
           bsf RSLINE,4
           movf COUNTLSB,W
           iorlw 48
           call LCDOUT
           return

; **** One byte counter with AND 15 output to LCD ****

BYTECOUNT15 incf COUNTLSB,F
           btfsc PORTA,0
           goto BYTECOUNT15
           call CLRLINE1
           call LCD1
           bsf RSLINE,4
           movf COUNTLSB,W
           andlw 15
           movwf REGA0
           clrf REGA1
           clrf REGA2
           clrf REGA3
           call BIN2DEC
           call SHOWDIGIT9
           return

; **** One byte counter with full output to LCD ****

BYTECOUNT255 incf COUNTLSB,F

;          call PAUSIT

           btfsc PORTA,0
           goto BYTECOUNT255
           call CLRLINE1
           call LCD1
           bsf RSLINE,4
           movf COUNTLSB,W
           movwf REGA0
           clrf REGA1
           clrf REGA2
           clrf REGA3
           call BIN2DEC
           call SHOWDIGIT7
           return

; **** One byte counter with 0-49 range ****

BYTECOUNT50 incf COUNTLSB,F
           movf COUNTLSB,W
           xorlw 50
           btfsc STATUS,Z
           clrf COUNTLSB
           call PAUSIT
           btfsc PORTA,0
           goto BYTECOUNT50
           call CLRLINE1
           call LCD1
           bsf RSLINE,4
           movf COUNTLSB,W
           movwf REGA0
           clrf REGA1
           clrf REGA2
           clrf REGA3
           call BIN2DEC
           call SHOWDIGIT9
           return

; **** Two byte counter with full output to LCD ****

BYTE2COUNT incfsz COUNTLSB,F
           goto BYTE2
           incf COUNTMSB,F

BYTE2      btfsc PORTA,0
           goto BYTE2COUNT
           call CLRLINE1
           call LCD1
           bsf RSLINE,4
           movf COUNTLSB,W
           movwf REGA0
           movf COUNTMSB,W
           movwf REGA1
           clrf REGA2
           clrf REGA3
           call BIN2DEC
           call SHOWDIGIT6
           return

; **** RANDOMISED counter with full output to LCD ****

RANDOMISE  call SETRANDOM
           call LCD1
           bsf RSLINE,4
           movf RANDOM1,W
           movwf REGA0
           movf RANDOM2,W
           movwf REGA1
           movf RANDOM3,W
           movwf REGA2
           movf RANDOM4,W
           movwf REGA3
           call BIN2DEC
           call SHOWDIGIT1
           return

PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

LCDMSG     clrf LOOP               ; clear loop
           call LCD1
           bsf RSLINE,4

LCDMS2     movf LOOP,W             ; get table address
           call MESSAG             ; get message letter
           call LCDOUT             ; show it
           incf LOOP,F             ; inc loop
           btfss LOOP,3            ; has last LCD letter been sent?
           goto LCDMS2             ; no, so repeat for next one
	   return                  ; return to the main program

LCDMSG2    clrf LOOP               ; clear loop
           call LCD1
           bsf RSLINE,4

LCDMS3     movf LOOP,W             ; get table address
           call MESSAG2            ; get message letter
           call LCDOUT             ; show it
           incf LOOP,F             ; inc loop
           btfss LOOP,3            ; has last LCD letter been sent?
           goto LCDMS3             ; no, so repeat for next one
	   return                  ; return to the main program

           include LCDroutines.inc

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;*** SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add:    movf    REGA3,w         ;Compare signs
	xorwf	REGB3,w
	movwf	MTEMP

	call	addba		;Add REGB to REGA

	clrc			;Check signs
	movf	REGB3,w		;If signs are same
	xorwf	REGA3,w		;so must result sign
	btfss	MTEMP,7		;else overflow
	addlw	0x80
	return

; **********

;*** SIGNED 32 BIT INTEGER MATHS ROUTINES FOR PIC16 SERIES BY PETER HEMSLEY JAN 2003 ***

;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply32
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;UTILITY ROUTINES

;Add REGB to REGA
;Used by add, multiply

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incf	REGB3,w
	addwf	REGA3,f
	return

;Move REGA to REGC
;Used by multiply, sqrt

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by multiply, divide, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

;Check sign of REGB and negative convert to positive
;Used by multiply, divide

chksgnb	rlf	REGB3,w
	skpc
	return

;Negate REGB
;Used by subtract, multiply, divide

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return

;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

SHOWDIGIT1 movf DIGIT1,W         ; show decimal values
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT8 movf DIGIT8,W
           call LCDOUT
SHOWDIGIT9 movf DIGIT9,W
           call LCDOUT
SHOWDIGIT10 movf DIGIT10,W
           call LCDOUT
	   return

SETRANDOM: clrf XORGATE1
        clrf XORGATE2
        btfsc RANDOM1,2
        bsf XORGATE1,0
        btfsc RANDOM4,6
        bsf XORGATE2,0
        bcf STATUS,C
        movf XORGATE1,W
        xorwf XORGATE2,W
        btfsc STATUS,Z
        bsf STATUS,C
        rrf RANDOM1,F
        rrf RANDOM2,F
        rrf RANDOM3,F
        rrf RANDOM4,F
        return

           END
