; TEACHING02.ASM 01FEB08 - TEACH IN 2008 PT7
; demo for using PCLATH

#DEFINE BANK0 BCF STATUS,5  ; clear STATUS bit 5 (RP0)
#DEFINE BANK1 BSF STATUS,5  ; set   STATUS bit 5 (RP0)

           include p16f628.inc

           __config  h'3F30'    ; internal 4MHz oscillator

        CBLOCK h'20'
DCOUNT
DSIGN 
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10
REGA0
REGA1
REGA2
REGA3
MTEMP
MCOUNT

LOOP
LOOPA
STORE
RSLINE
CLKCNT
        ENDC


           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

           include LCDheader.inc

STARTIT
           clrf PCLATH         ; Page and sub-page 0.
           clrf STATUS         ; Bank 0 and clear all flags.

           clrf PORTA          ; clear PORTA's outputs if any
           clrf PORTB          ; clear PORTB's output if any
           movlw 7             ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1               ; set for Bank 1
           movlw b'00001111'   ; RA0-RA3 as inputs
           movwf TRISA
           CLRF TRISB          ; set PORTB for all outputs
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0               ; set for Bank 0

           call PAUSIT
           call LCDSET
           call PAUSIT

        clrf PCLATH     ; Set up for page and sub-page 0.

LOOP1   btfsc PORTA,0   ; is S1 pressed?
        call TEST1      ; yes
        btfsc PORTA,1   ; is S2 pressed?
        call TEST2      ; yes
        btfsc PORTA,2   ; is S3 pressed?
        call TEST3      ; yes
        btfsc PORTA,3   ; is S3 pressed?
        call TEST4      ; yes
        goto LOOP1      ; no

TEST1   movlw 1         ;Set up for sub-page 1
        movwf PCLATH
        movlw 2         ;Get 2nd line from
        call TABLE1     ;1st table
        call PREPBIN2DEC
        call LCD1
        bsf RSLINE,4
        call SHOWPAGE

        movlw 3         ;Get 3rd line from
        call TABLE1     ;1st table
        call PREPBIN2DEC
        call LCD21
        bsf RSLINE,4
        call SHOWPAGE
        clrf PCLATH     ;Set up for page and sub-page 0
        return

TEST2   movlw 2         ;Set up for sub-page 2
        movwf PCLATH
        movlw 1         ;Get 1st line from
        call TABLE3     ;3rd table
        call PREPBIN2DEC
        call LCD1
        bsf RSLINE,4
        call SHOWPAGE

        movlw 4         ;Get 4th line from
        call TABLE3     ;3rd table
        call PREPBIN2DEC
        call LCD21
        bsf RSLINE,4
        call SHOWPAGE
        clrf PCLATH     ;Set up for page and sub-page 0
        return

TEST3   movlw 4         ;Set up for sub-page 4
        movwf PCLATH
        movlw 0         ;Get 0th line from
        call TABLE4     ;4th table
        call PREPBIN2DEC
        call LCD1
        bsf RSLINE,4
        call SHOWPAGE

        movlw 3         ;Get 3rd line from
        call TABLE4     ;4th table
        call PREPBIN2DEC
        call LCD21
        bsf RSLINE,4
        call SHOWPAGE
        clrf PCLATH     ;Set up for page and sub-page 0
        return

TEST4   movlw 7         ;Set up for sub-page 7
        movwf PCLATH
        movlw 1         ;Get 1st line from
        call TABLE5     ;5th table
        call PREPBIN2DEC
        call LCD1
        bsf RSLINE,4
        call SHOWPAGE

        movlw 7         ;Get 7th line from
        call TABLE5     ;5th table
        call PREPBIN2DEC
        call LCD21
        bsf RSLINE,4
        call SHOWPAGE
	clrf PCLATH	;Set up for page and sub-page 0.
        return

; *********

PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

           include LCDroutines.inc

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
        call    chksgna         ;Make REGA positive
	skpnc
        call    negatea         ;Negative

        movlw   D'32'           ;Loop counter
        movwf   MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

        movlw   DIGIT10
        movwf   FSR             ;Pointer to digits
        movlw   D'10'           ;10 digits to do
        movwf   DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
        movwf   INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
        goto    adjlp

	decfsz	MCOUNT,f	;Next bit
        goto    b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
        return

;UTILITY ROUTINES

;Check sign of REGA and convert negative to positive
;Used by bin2dec

chksgna	rlf	REGA3,w
	skpc
        return

;Negate REGA
;Used by bin2dec

negatea movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
        goto    nega1
        incfsz  REGA1,f
        goto    nega1
        incfsz  REGA2,f
        goto    nega1
        incf    REGA3,f
nega1
        incf    MTEMP,f         ;flip sign flag
        addwf   REGA3,w         ;return carry set if -2147483648
        return

PREPBIN2DEC movwf REGA0
         clrf REGA1
         clrf REGA2
         clrf REGA3
         call BIN2DEC
         return

SHOWPAGE movlw 'T'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'B'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'J'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        return

        org 300  ; h'12C'

TABLE1  addwf PCL,F
        retlw 10
        retlw 11
        retlw 12
        retlw 13
        retlw 14

        org 400 ; h'190'

TABLE2  addwf PCL,F
        retlw 20
        retlw 21
        retlw 22
        retlw 23
        retlw 24

        org 513   ; h'201'

TABLE3  addwf PCL,F
        retlw 30
        retlw 31
        retlw 32
        retlw 33
        retlw 34

        org 1024    ; h'400'

TABLE4  addwf PCL,F
        retlw 40
        retlw 41
        retlw 42
        retlw 43
        retlw 44

        org 2000    ; h'7D0'

TABLE5  addwf PCL,F
        retlw 50
        retlw 51
        retlw 52
        retlw 53
        retlw 54
        retlw 55
        retlw 56
        retlw 57
        retlw 58

        END


