; TeachInJ03.ASM 07FEB08
; A simple program which makes use of an externally switch generated
; interrupt to increment a count on PORTA is as follows:

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

              include p16f628.inc

              __config  h'3F30'  ; internal 4MHz oscillator

              ORG 0              ; reset vector
              goto STARTIT
              ORG 4              ; Interrupt vector address
              goto ISR
              ORG 5              ; PIC program memory location at which to start 

STARTIT       clrf PORTA         ; clear PORTA's outputs if any
              clrf PORTB         ; clear PORTB's output if any
              movlw 7            ; needed by some PICs, including PIC16F628
              movwf CMCON        ; so that PORTA is treated as digital port

              BANK1              ; set for Bank 1
              clrf TRISA         ; PORTA as output
              movlw %00000001
              movwf TRISB        ; RB0 as input
              clrf OPTION_REG    ; pullups on (bit 7 = 0)
              BANK0
              MOVLW b'10010000'  ; enable GIE (bit 7), RB0 change (bit 4)
              MOVWF INTCON

START         nop
              GOTO START

TEST          movlw b'11111110'
              movwf PORTB
              goto START

ISR           incf PORTA,F       ; inc LED count
ISR2          btfsc PORTB,0      ; wait switch release
              goto ISR2
              bcf INTCON,1        ; clear RB0 interrupt flag
              RETFIE

              END


