'select-mph - also converted to hex
'SW1 - in2 - toggles autosensing
'SW2 - in1 - channel 1 select
'SW3 - in0 - channel 2 select
'SW4 - in7 - channel 3 select
'SW5 - in6 - channel 4 select

'D1 - out2 - shows when autosensing is on
'   - out7 hi = jam off i.e. autosensing on
'   - out7 lo = jam on i.e. autosensing off

'D2 - out3 - channel 1 selected
'D3 - out4 - channel 2 selected
'D4 - out5 - channel 3 selected
'D5 - out6 - channel 4 selected

'out0 & out1 = binary control output


start: 
	if pin2=1 then auto	'jump to auto if auto-switch is pressed	

	if pin1=1 then chan1	'these lines select active channel
	if pin0=1 then chan2
	if pin7=1 then chan3
	if pin6=1 then chan4

	goto start
	
chan1:
	if b1 = 1 then jump1	'if b1=1 then select auto-sense mode
	let pins = %00001000	'non auto-sense mode, only channel 1 LED is lit
	goto start
jump1:	let pins = %10001100	'auto-sense mode, channel 1 LED lit, plus auto-sense LED, and jam output high
	goto start

chan2:
	if b1 = 1 then jump2
	let pins = %00010001	'as jump1 except channel 2 LED lit, and binary output set to 01
	goto start
jump2:	let pins = %10010101	'as jump2, plus auto sense LED and jam output high
	goto start

chan3:
	if b1 = 1 then jump3
	let pins = %00100010	'as before, for channel 3, and binary output set to 10
	goto start
jump3:	let pins = %10100110
	goto start

chan4:
	if b1 = 1 then jump4
	let pins = %01000011	'as before, for channel 4, and binary output set to 11
	goto start
jump4:	let pins = %11000111
	goto start

auto:
	if b1 = 1 then autooff	'the use of b1 enables the toggle action

	high 2			'switches on auto-sense LED
	high 7			'switches jam output high, i.e. auto-sense on
	let b1 = 1		'sets variable b1 so that system knows that auto-sense is set
	pause 500		'pauses for half a second
	goto start

autooff:
	low 2			'switches off auto-sense LED
	low 7			'switches jamp output low i.e. auto-sense off
	let b1 = 0		'clears variable b1 so that system knows that auto sense is off
	pause 500		'pauses for half a second
	goto start








