                                        ; Listing 3.9

           include "16F627.PLC"         ; Defines PLC instructions
                                        ; Latch controls shift direction
                                        ; (direction changes when 1 reaches end)
           ld      SHIFT0, 7            ; MSb of working register = Set input
           latch   AUX0, 0, SHIFT0, 0   ; AUX0, 0 = Q output
                                        ; LSb of working register = Reset input
           eqi     PORTB, 0x00          ; Input a logic-1 if Port B = 00000000
           shift   0, OSCL, 0, PORTA, 0, AUX0, 0
                                        ; Shift register 0, clock = OSCL bit 0,
                                        ; Reset using Port A bit 0 = 1
                                        ; Direction = Q output of latch
           putr    SHIFT0, PORTB        ; Copy SHIFT0 working register to Port B

           endp                         ; Marks end of PLC program