/* 
 * File:   main.c
 * Author: mike hibbett
 *
 * Created on 12 February 2014, 21:49
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18f27j13.h>
#include "config.h"
#include "lplc-adc.h"
#include "timers.h"
#include "LCD-Graphic-ST7735S.h"


/*
 * 
 */
int main(int argc, char** argv)
{
    char strBig[10];
    char str[10];
    char strSmall[10];
    unsigned short lpx, lpy;
    int val;
    int valBig = 0;
    int valSmall = 9999;

    timer0Init();

    // Power up delay
    delayms(50);

    adc_init(ADC_FOSC_RC & ADC_RIGHT_JUST & ADC_12_TAD, ADC_CH0 & ADC_INT_OFF & ADC_REF_VDD_VSS,
             0, ADC_0ANA);

    LCDST7735sInit();
    LCD_Clear(BLACK);
    LCD_ShowString(107,20,"ADC Library Test");
    LCD_ShowString(87,20,"Max Value: ");
    LCD_ShowString(67,20,"    Value: ");
    LCD_ShowString(47,20,"Min Value: ");

    while (1) {
        convert_adc();
        do {} while (busy_adc());

        val = getval_adc();
        valBig = val > valBig ? val : valBig;
        valSmall = val < valSmall ? val : valSmall;

        itoa(strBig, valBig, 10);
        itoa(str, val, 10);
        itoa(strSmall, valSmall, 10);

        POINT_COLOR=WHITE;
        LCD_ShowString(87,86,strBig);
        LCD_ShowString(67,86,str);
        LCD_ShowString(47,86,strSmall);

        delayms(1000);

        POINT_COLOR=BLACK;
        LCD_ShowString(87,86,strBig);
        LCD_ShowString(67,86,str);
        LCD_ShowString(47,86,strSmall);
    }

    // Should never reach this point

    return (EXIT_SUCCESS);
}

