;******************************************************************************
;Software License Agreement                                         
;                                                                    
;The software supplied herewith by Microchip Technology             
;Incorporated (the "Company") is intended and supplied to you, the  
;Companys customer, for use solely and exclusively on Microchip    
;products. The software is owned by the Company and/or its supplier,
;and is protected under applicable copyright laws. All rights are   
;reserved. Any use in violation of the foregoing restrictions may   
;subject the user to criminal sanctions under applicable laws, as   
;well as to civil liability for the breach of the terms and         
;conditions of this license.                                        
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
; *******************************************************************
; PICkit 2 Debug Express mTouch implementation
;
; 
;
; *******************************************************************
; *   See 44-pin Demo Board User's Guide for additional information *
; *******************************************************************

        radix   dec
        processor 16f887

        include <p16F887.inc>
        include "variables.inc"

	__CONFIG    _CONFIG1, _LVP_OFF & _FCMEN_OFF & _IESO_OFF & _BOR_OFF & _CPD_OFF & _CP_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	__CONFIG    _CONFIG2, _WRT_OFF & _BOR21V

avdepth         equ     .6      ; averaging depth
                                ;    (2 ^ n)-1 x oldvalue + newvalue
                                ; = ---------------------------------
                                ;               (2 ^ n)

triplo          equ     .0      ; difference between average and current
triphi          equ     .2      ; frequency value for a key to be detected. (512 counts)

debounce        equ     .30

        org     .0      ; reset vector

reset
        call    init
        goto    main

;********************************************************
;* interrupt service routine                            *
;********************************************************
;{

        org     .4
interrupt
        movwf   w_temp          ;copy w to temp register
        swapf   STATUS,w        ;swap STATUS to be saved into w
        clrf    STATUS          ;bank 0, regardless of current bank, clears irp,rp1,rp0
        movwf   status_temp     ;save STATUS to bank zero STATUS_temp register

        btfsc   INTCON,T0IF
        call    getmeasurement

        swapf   status_temp,w   ;swap STATUS_temp register into w
                                ;(sets bank to original state)
        movwf   STATUS          ;move w into STATUS register
        swapf   w_temp,f        ;swap w_temp
        swapf   w_temp,w        ;swap w_temp into w

        retfie
;}
;********************************************************
;* subroutine: getmeasurement
;* descr: 
;*
;* in:    freqhi, freqlo                                *
;********************************************************
getmeasurement
        bcf     T1CON,TMR1ON    ; stop timer1

        btfsc   sysflag,getfirst
        call    getfirstmeasurement ; take a reading for the first average value
        
        movf    TMR1L,w
        movwf   freqlo
        movf    TMR1H,w
        movwf   freqhi          ; get the current value
        
        clrf    TMR1L
        clrf    TMR1H           ; clear the current value
        
        call    average
        call    checkdifference

        bsf     T1CON,TMR1ON    ; restart the timer
        bcf     INTCON,T0IF

        return

getfirstmeasurement
        movf    TMR1L,w
        movwf   averagelo
        movf    TMR1H,w
        movwf   averagehi       ; use the first value as the starting
                                ;   point for the average value
        bcf     sysflag,getfirst

        return
;};********************************************************
;* subroutine delay                                     *
;* descr: causes a timing delay in mSecs                *
;*                                                      *
;* in:    w - value in mSecs                            *
;********************************************************
;{
delay
        movwf   temp1
wait
        movlw   .249
        movwf   temp2
           nop
           decfsz  temp2
           goto    $-2

        decfsz  temp1
        goto    wait
        return
;}
;********************************************************
;* subroutine init                                      *
;********************************************************
;{
init
        banksel OSCCON
        movlw   b'01110000'
        movwf   OSCCON          ; 8 MHz
        
        banksel OSCTUNE
        movlw   .0
        movwf   OSCTUNE

        banksel TRISA           ; select bank 1
        movlw   b'00010101'     ; was b'11011100'     ; 1=input
        movwf   TRISA

        movlw   b'00000011'     ; was b'11000111'
        movwf   TRISC
        
        clrf    TRISD           ; LEDs are connected to PORTE

        banksel PORTA
        clrf    STATUS
        clrf    PORTA           ; all pins low

; setup timer 1
        banksel T1CON
        movlw   b'00000010'
        movwf   T1CON           ; initialise timer 1

; setup mTouch
        banksel CM1CON0
        movlw   b'10010100'
        movwf   CM1CON0          ; comparators connected to CVref

        movlw   b'10100000'
        movwf   CM2CON0          ; comparators connected to CVref

        movlw   b'00110010'
        movwf   CM2CON1          ; comparators connected to CVref

        banksel SRCON
        movlw   b'11110000'
        movwf   SRCON

        banksel VRCON
        movlw   b'10000111'
        movwf   VRCON           ; turn on voltage reference
        
        banksel ANSEL           ; enable analog inputs
        movlw   b'00000111'     ; an0, an2 are analog inputs
        movwf   ANSEL

        movlw   b'00000000'
        movwf   ANSELH

; ---
        banksel OPTION_REG
        movlw   b'10000111'     ; pull ups disabled, falling edge, internal instruction, prescaler t0, 1:256
        movwf   OPTION_REG      ; prescaler to tmr0, rate 1:8
        
        clrf    STATUS          ; back to bank 0      

        clrf    sysflag
        ; clrf    debouncecounter

        bsf     INTCON,GIE

        return
;}
;********************************************************
;* subroutine: average
;* descr: 
;*
;* in:    freqhi, freqlo                                *
;********************************************************
;{
average
        movf    averagehi,w
        movwf   avhitemp
        movf    averagelo,w
        movwf   avlotemp
        clrf    avfractemp      ; make a copy of the original value

        call    divideby2pwrn   ; divide the copy by 2^n
;******
        movf    avfractemp,w
        subwf   averagefraction ; and subtract the result from the original
        btfsc   STATUS,C
        goto    hopover
        decf    averagelo
        movlw   .255
        xorwf   averagelo,w
        btfsc   STATUS,Z
        decf    averagehi           
hopover
        movf    avlotemp,w
        subwf   averagelo
        btfss   STATUS,C
        decf    averagehi

        movf    avhitemp,w
        subwf   averagehi       ; average - 1/(2^n)
;******
        movf    freqhi,w
        movwf   avhitemp
        movf    freqlo,w
        movwf   avlotemp        ; make a copy of the original value
        clrf    avfractemp

        call    divideby2pwrn   ; divide by 2^n

        movf    avfractemp,w
        addwf   averagefraction
        btfss   STATUS,C
        goto    hopover2
        incf    averagelo
        btfsc   STATUS,Z
        incf    averagehi
hopover2
        movf    avlotemp,w
        addwf   averagelo
        btfsc   STATUS,C
        incf    averagehi
        movf    avhitemp,w
        addwf   averagehi

        return

divideby2pwrn
        movlw   avdepth
        movwf   avcounter
shift1
        bcf     STATUS,C
        rrf     avhitemp
        rrf     avlotemp
        rrf     avfractemp
        decfsz  avcounter
        goto    shift1
        return
;}
;********************************************************
;* subroutine: checkdifference                          *
;* descr: subtracts actual value from average           *
;*                                                      *
;* out:   freqhi:freqlo  with frequency                 *
;********************************************************
;{
checkdifference
        movf    averagehi,w
        movwf   differencehi
        movf    averagelo,w
        movwf   differencelo    ; make a copy of the averagevalue

        movf    freqlo,w
        subwf   differencelo
        btfss   STATUS,C
        decf    differencehi
        movf    freqhi,w
        subwf   differencehi    ; averagevalue - currentvalue

        btfsc   STATUS,C        ; is the difference negative?
        goto    evaldifference  ; no positive, check if it exceeds the trip point
        movf    freqhi,w        ; yes, key is released
        movwf   averagehi       ; average should follow actual value
        movf    freqlo,w
        movwf   averagelo
        clrf    differencehi
        clrf    differencelo
        bcf     sysflag,keydown

        retlw   .0

evaldifference
        bcf     sysflag,keydown

        movlw   triphi
        subwf   differencehi,w
        btfss   STATUS,Z        ; are hi bytes equal?
        goto    results

        movlw   triplo          ; yes, compare lower bytes
        subwf   differencelo,w
results

        btfss   STATUS,C        ; was the difference > trip point?
        retlw   .0              ; no, return

        bsf     sysflag,keydown ; yes, set the keydown flag

        retlw   .0

;}
;********************************************************
;* main                                                 *
;********************************************************
;{
main
        movlw   .100
        call    delay           ; wait 100mSec
        bsf     sysflag,getfirst

        clrf    TMR1L
        clrf    TMR1H           ; clear the timer value
        clrf    TMR0            ; clear timer 0

        bsf     INTCON,T0IE     ; turn on timer tick
        bsf     T1CON,TMR1ON    ; turn on timer 1

        movlw   b'10101010'
        movwf   PORTD

mainloop
        btfss   sysflag,keydown
        clrf    PORTD

        movlw   .255
        btfsc   sysflag,keydown
        movwf   PORTD

        goto    mainloop
        ;fill    (goto  reset),(0x7ff - $)+1
;}

;*******************************************************
        
        end
