/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs 

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs  - 1.45
        Device            :  PIC16LF1829
        Driver Version    :  2.00
    The generated drivers are tested against the following:
        Compiler          :  XC8 1.35
        MPLAB             :  MPLAB X 3.40
*/

/*
    (c) 2016 Microchip Technology Inc. and its subsidiaries. You may use this
    software and any derivatives exclusively with Microchip products.

    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
    WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
    PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION
    WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION.

    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
    BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
    FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
    ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
    THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.

    MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE
    TERMS.
*/


#include "mcc_generated_files/mcc.h"
#include "functions.h"


volatile uint8_t seconds = 0;
volatile uint8_t half_second = 0;

uint8_t debugEnabled = 0;           // Set to 1 to enable debug mode

//volatile uint8_t digits[4];
/*
                         Main application
 */
void main(void)
{
    uint8_t maxseconds = 2;
    uint16_t KeypadVal = 1000;
    uint16_t disVal = 0;
    uint8_t temp = 1;
    uint8_t temp1 = 1;
    uint8_t temp2 = 1;
    uint8_t temp3 = 1;
    uint16_t mathAnswer = 0;
    uint16_t maxADC = 850;
    
    digits[0] = 0x12;
    digits[1] = 0x12;
    digits[2] = 0x12;
    digits[3] = 0x12;
 
    // initialize the device
    SYSTEM_Initialize();

    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();

//    KeypadVal = ADC_GetConversion(0);
//    disVal = getKeyPress(KeypadVal);
    __delay_ms(100);
    
    clrDisplay();

    calcstate = 1;
    
    while (1) {
        
        // State Machine works here
        // Uses calcstate
       
        // Get ADC value
        if (!debugEnabled) {
            KeypadVal = ADC_GetConversion(0);
            disVal = getKeyPress(KeypadVal);
        }
        
        // Simulate Keypress Sequence for debug purposes
        if (debugEnabled) {
            KeypadVal = 0;
            switch(temp) { 
                case 1:
                    if(temp1 == 1) {
                        disVal = 0x1;
                        temp1++;
                    } else if (temp1 == 2) {
                        disVal = 0x2;
                        temp1++;
                    } else if (temp1 == 3) {
                        disVal = 0x8;
                        temp++;
                    }
                    break;
                case 2:
                    calcstate = 2;
                    setMathSign(1);
                    temp++;
                    break;
                case 3:
                    if(temp2 == 1) {
                        disVal = 0x7;
                        temp2++; 
                    } else if (temp2 == 2) {
                        disVal = 0x2;
                        temp++;
                    } 
                    break;
                case 4: 
                    calcstate = 4;
                    disVal = 0xA;
                    temp++;
                    break;
                default:
                    break;
            }
            if (temp >= 6) {
                while(1);
            }
            
            // Answer should be 9216
        }

        switch(calcstate) {
            case 1:
                // Capture and display the first number as it is entered
                if(mathSign > 0) {
                    calcstate = 2;
                    break;
                }
                if(KeypadVal < maxADC) {
                    pushToDisplay(disVal);
                }
                break;
            case 2:
                getDisplayNumber();
                clrDisplay();
                __delay_ms(100);
                calcstate = 3;
                break;
            case 3: 
                if(disVal == 0xA) {
                    calcstate = 4;
                    break;
                }
                if(KeypadVal < maxADC) {
                    pushToDisplay(disVal);
                }
                break;
            case 4: 
                // Convert the second displayed Number
                getDisplayNumber();
                // Perform the Maths and Display answer
                clrDisplay();
                mathAnswer = performMath();
                convertDisplayNum(mathAnswer);
                calcstate = 5;
                break;
            case 5:
                // Do nothing here
                break;
            default:
                calcstate = 1;
                break;
        }
    }
}
/**
 End of File
*/