/* 
 * File:   functions.h
 * Author: Mike
 *
 * Created on November 1, 2017, 4:59 PM
 */

#ifndef FUNCTIONS_H
#define	FUNCTIONS_H

#ifdef	__cplusplus
extern "C" {
#endif
    
extern volatile uint8_t seconds;
extern volatile uint8_t half_second;

extern volatile uint8_t currentdigit;
extern volatile uint8_t currentdigitval;
extern volatile uint8_t digits[4];
extern volatile uint8_t calcstate;
extern volatile uint8_t mathSign;

//extern volatile uint8_t digits[4];

// Define new functions here
uint8_t displayNumber(uint16_t number);
uint8_t displayNumberFast(uint16_t number);
uint8_t clrNumber(void);
uint8_t clrNumberFast(void);
uint8_t displayDigit(uint8_t digit, uint16_t number);
uint8_t displayDigitFast(uint8_t digit, uint16_t number);
uint8_t clearDigits();
uint8_t updateDigits(void);
uint8_t updateTime(void);
uint16_t getKeyPress(uint16_t adcKeypadValue);
void showADC(uint16_t adcVal);
void setDigit(uint8_t digit, uint8_t value);

void getDisplayNumber(void);
void clrDisplay(void);
uint16_t performMath(void);
void displayError(void);
void convertDisplayNum(uint16_t num);
uint8_t pushToDisplay(uint8_t number);
void setMathSign(uint8_t num);

#ifdef	__cplusplus
}
#endif

#endif	/* FUNCTIONS_H */

