; TEACHIND02.ASM 27MAY07 - TEACH IN 2008 PT4

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file

           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'

; registers needed for main progran
RSLINE
STORE
LOOP
LOOPA
CLKCNT
COUNTA
COUNTB
COUNTC
SWITCH
COUNT

; registers needed for Conversion routines
CONVDIGIT1
CONVDIGIT2
CONVDIGIT3
CONVDIGIT4
CONVDIGIT5
CONVDIGIT6
CONVCOUNT0
CONVCOUNT1
CONVCOUNT2

; registers needed for BIN2DEC facility
REGA0
REGA1
REGA2
REGA3
MTEMP
COUNT0
COUNT1
COUNT2
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
BITCNT
DIGCNT
          ENDC

           __config  $3F30     ; internal 4MHz oscillator

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

OVERTABLE  addwf PCL,F
	   retlw 'O' ; 0
	   retlw 'V' ; 1
	   retlw 'E' ; 2
	   retlw 'R' ; 3
	   retlw 'F' ; 4
	   retlw 'L' ; 5
	   retlw 'O' ; 6
	   retlw 'W' ; 7

STARTIT    clrf PORTA          ; clear PORTA's output if any
           clrf PORTB          ; clear PORTB's output if any
           movlw $07           ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

	   clrf COUNTA
           clrf COUNTB
           clrf COUNTC

           BANK1
           movlw b'00000011'   ; PORTA 0 & 1 as input
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0

           call PAUSIT

           call LCDSET
	   call PAUSIT

MAIN       bcf PORTA,2         ; no, turn off LED D1
           bcf PORTA,3         ; no, turn off LED D2
           btfsc PORTA,0       ; is switch S1 pressed?
           goto MAIN1          ; yes
           btfsc PORTA,1       ; is switch S2 pressed?
           goto DECIT          ; yes

           goto MAIN           ; no

MAIN1:     bsf PORTA,2         ; yes, turn on LED D1

MAIN2    ;  call PAUSIT
	   incfsz COUNTA,F     ; yes, inc COUNTA, is it = zero?
	   goto MAIN2A         ; no, goto MAIN2A
           incfsz COUNTB,F     ; yes, so inc the next counter byte (MSB), is it = zero
	   goto MAIN2A         ; no
           incfsz COUNTC,F     ; yes, so inc the next counter byte (MSB), is it = zero
           goto MAIN2A         ; no
           call OVERFLOW
           goto WAITRELEASE

MAIN2A     call LCD1           ; set LCD for display from line 1 cell 1
           call SHOWHEXVAL
           call LCD21          ; set LCD for display from line 2 cell 1
           call SHOWDECIMAL

MAIN3      btfsc PORTA,0       ; is S1 still pressed?
           goto MAIN2          ; yes, inc COUNTA again
;           goto MAIN3          ; yes, wait till released

;           bcf PORTA,2         ; no, turn off LED
           call PAUSIT         ; allow for switch bounce
           call PAUSIT         ; allow for switch bounce
           goto MAIN           ; go back and wait next press of S1

OVERFLOW   call LCD1
           clrf LOOP           ; clear loop
           bsf RSLINE,4        ; set RS for data send
OFL2       movf LOOP,W         ; get table address
           call OVERTABLE      ; get message letter
           call LCDOUT         ; show it
           incf LOOP,F         ; inc loop
           btfss LOOP,3        ; has last LCD letter been sent?
           goto OFL2           ; no, so repeat for next one
	   return              ; return to the main program

WAITRELEASE  btfsc PORTA,0     ; is S1 still pressed?
           goto WAITRELEASE    ; yes, wait until released
           call CLRLINE1
           call CLRLINE2
	   goto MAIN           ; and start again

WAITRELEASE2  btfsc PORTA,1    ; is S2 still pressed?
           goto WAITRELEASE2   ; yes, wait until released
           call CLRLINE1
           call CLRLINE2
	   goto MAIN           ; and start again


PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

; ***********

DECIT      bsf PORTA,3
           decfsz COUNTA,F     ; inc COUNTA, is it = zero?
           goto DEC2           ; no
           decfsz COUNTB,F     ; dec the next counter byte (MSB), is it = zero
           goto DEC2           ; no
           decfsz COUNTC,F     ; inc the next counter byte (MSB), is it = zero
DEC2       goto MAIN2A

; ***********

SHOWHEXVAL movf COUNTA,W       ; get count value LSB
	   movwf CONVCOUNT0    ; and place in CONVCOUNT0
           movf COUNTB,W       ; get count value NMSB
	   movwf CONVCOUNT1    ; and place in CONVCOUNT1
           movf COUNTC,W       ; get count value MSB
           movwf CONVCOUNT2    ; and place in CONVCOUNT2

           call BIN2HEX        ; convert binary count to hex
	   call SHOWHEX        ; and show on LCD
  	   return

SHOWDECIMAL movf COUNTA,W       ; get count value LSB
           movwf COUNT0        ; and place in COUNT0
           movf COUNTB,W       ; get count value NMSB
           movwf COUNT1        ; and place in COUNT1
           movf COUNTC,W       ; get count value LSB
           movwf COUNT2        ; and place in COUNT2
           call BIN2DEC        ; bin to dec conversion
	   call BLANKIT        ; blank leading zeros
           call LCD21          ; set LCD for display from line 2 cell 1
           bsf RSLINE,4        ; set LCD for data mode
           call SHOWDIGIT8
	   return

           include LCDroutines.inc

           include LCDconversions.inc

  	   include mathsbin2dec.inc

           END
