/* 
 * File:   main.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 25 February 2014, 13:47
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18.h>
#include "config.h"
#include "lplc-adc.h"
#include "timers.h"
#include "LCD-Graphic-ST7735S.h"
#include "interrupts.h"
#include "hardware.h"
#include "lcd.h"

/*
 * 
 */
int main(int argc, char** argv)
{
    // Initialise any low level hardware features
    HardwareInit();

    // Initialise the Interrupt sub-system
    InterruptInit();

    // Initialise the Interrupt sub-system
    timer0Init();
    timer1Init();

    // Power up delay
    delayms(50);

    adc_init(ADC_FOSC_RC & ADC_RIGHT_JUST & ADC_12_TAD, ADC_CH0 & ADC_INT_OFF & ADC_REF_VDD_VSS,
             0, ADC_0ANA);

    LCDST7735sInit();
    LCD_Clear(BLACK);
    LCD_ShowString(107,20,"ADC Library Test");
    LCD_ShowString(87,20,"Max Value: ");
    LCD_ShowString(67,20,"    Value: ");
    LCD_ShowString(47,20,"Min Value: ");

    // user application - main loop
    // Code here is called either
    //    a) continuously
    //    b) once per interrupt, if the sleep instruction is present

    // Enable adc interrupts, and kick the conversion off.
    // After these two lines of code, all adc work is done in the
    // interrupt
    int_enable_adc();
    convert_adc();

    while (1) {
        // The sleep instruction will cause the processor to halt, and enter
        // a low power state. Timer1 interrupts will still wake the processor.
        // SLEEP();
    }

    // Should never reach this point
    return (EXIT_SUCCESS);
}

