/*
 * File:    lplc-adc.c
 *
 *          Support for analogue to digital conversion library.
 *          This makes use of the Microchip Library functions.
 *
 * Author: mike
 *
 * Created on 27th September 2014, 21:49
 */

#include <stdio.h>
#include <stdlib.h>
#include "lplc-adc.h"
#include "LCD-Graphic-ST7735S.h"
#include "timers.h"

void adc_init(unsigned char param1, unsigned char param2, unsigned char param3, unsigned int param4)
{
    // For now, we simply 'wrap' the peripheral library's function
    OpenADC(param1, param2, param3, param4);
}

void convert_adc(void)
{
    // start a conversion
    ConvertADC();
}

char busy_adc(void)
{
    // Return true if the ADC is currently converting an input
    return BusyADC();
}

void close_adc(void)
{
    PIR1bits.ADIF = 0;
    PIE1bits.ADIE = 0;
    CloseADC();
}

int getval_adc(void)
{
    return ReadADC();
}

void int_enable_adc(void)
{
    PIR1bits.ADIF = 0;
    PIE1bits.ADIE = 1;
}

void handle_int_adc(void)
{
    // read the ADC value from ADRESH/L, store it somewhere
    // Set a variable to tell the main program that a value has been received
    // and restart the conversion.

    int val;

    val = ReadADC();

    // Do something with val...
    {
        char strBig[10];
        char str[10];
        char strSmall[10];
        unsigned short lpx, lpy;
        int val;
        static int previousVal = 9999;
        static int valBig = 0;
        static int valSmall = 9999;

        val = getval_adc();

        // Only do something if the value has changed a lot, say by a count of 5
        if ( ((val - previousVal) > 5) || ((val - previousVal) < -5)) {
            itoa(strBig, valBig, 10);
            itoa(str, previousVal, 10);
            itoa(strSmall, valSmall, 10);

            POINT_COLOR=BLACK;
            LCD_ShowString(87,86,strBig);
            LCD_ShowString(67,86,str);
            LCD_ShowString(47,86,strSmall);

            valBig = val > valBig ? val : valBig;
            valSmall = val < valSmall ? val : valSmall;

            itoa(strBig, valBig, 10);
            itoa(str, val, 10);
            itoa(strSmall, valSmall, 10);

            POINT_COLOR=WHITE;
            LCD_ShowString(87,86,strBig);
            LCD_ShowString(67,86,str);
            LCD_ShowString(47,86,strSmall);

            previousVal = val;
        }
    }

    // restart the conversion
    ConvertADC();
}