	NOLIST 
;Macro to decrement a variable to zero, 8 bit. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

;****** ******* ******* ******* ******* ******* ******* *** * 
;EXPLANATION 
;------ ------- ------- ------- ------- ------- ------- --- - 

;When incrementing, 
;it is often useful to stop at some maximum. 
;A simple test uses xor to detect equality. 
;Testing >= is safer, but harder. 
;The macros below do: 
;if v > x 
;then v = x 
;if v < x 
;then v = v +1 

;General explanation of using carry with the PIC. 
;Algebraically, there are two useful operations: 
;Max-Variable 
;Variable-Max 
;Remembering that the PIC subtract instructions 
;are back to front to most other computers, 
;I have the following cases: 

;	mov.. Max,w 
;	sub.. Variable,w 
;Does Variable-Max v<x v=x v>x 
;Carry =            0   1   1 

;	mov.. Variable,w 
;	sub.. Max,w 
;Does Max-Variable v<x v=x v>x 
;Carry =            1   1   0 

;Note that the carry is always set after 
;two equal unsigned integers have been subtracted. 

;If I can examine only carry, then: 
;To discriminate v<x from v>=x, I must do Variable-Max 
;To discriminate v>x from v<=x, I must do Max-Variable 
;These are properties more of algebra than of the PIC; 
;the property of the PIC that makes this important 
;is that with the PIC, it is difficult to examine more 
;than just the carry bit. 

;The DecTo macros are a little more complicated 
;than the IncTo macros 
;They implement: 
;	if v > max then v = max 
;	if v < min then v = min 
;	if v > min then v = v -1 
;The instructions are done in that order, 
;so, provided max > min, then 
;on exit v is constrained to be >= min and <= max. 
;If max <= min, then on exit, v = min 

;****** ******* ******* ******* ******* ******* ******* *** * 
;DecToZ8 
;------ ------- ------- ------- ------- ------- ------- --- - 

;Decrement whole byte to but not past zero. 

;Although this is simple for a whole byte, 
;a macro helps to protect us from blunders. 

DecToZ8 MACRO Var1 
	movf Var1,f 
	btfss STATUS,Z 
	decf Var1,f 
	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

	LIST 



