const unsigned int font[][12] PROGMEM ={
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},  //
  {0x0000,0x0000,0x0000,0x007C,0x33FF,0x33FF,0x007C,0x0000,0x0000,0x0000,0x0000,0x0000},  //!
  {0x0000,0x0000,0x003C,0x003C,0x0000,0x0000,0x003C,0x003C,0x0000,0x0000,0x0000,0x0000},  //"
  {0x0200,0x1E10,0x1F90,0x03F0,0x027E,0x1E1E,0x1F90,0x03F0,0x027E,0x001E,0x0010,0x0000},  //#
  {0x0000,0x0478,0x0CFC,0x0CCC,0x3FFF,0x3FFF,0x0CCC,0x0FCC,0x0788,0x0000,0x0000,0x0000},  //$
  {0x3000,0x3838,0x1C38,0x0E38,0x0700,0x0380,0x01C0,0x38E0,0x3870,0x3838,0x001C,0x0000},  //%
  {0x0000,0x1F00,0x3FB8,0x31FC,0x21C6,0x37E2,0x1E3E,0x1C1C,0x3600,0x2200,0x0000,0x0000},  //&
  {0x0000,0x0000,0x0000,0x0027,0x003F,0x001F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},  //'
  {0x0000,0x0000,0x03F0,0x0FFC,0x1FFE,0x3807,0x2001,0x2001,0x0000,0x0000,0x0000,0x0000},  //(
  {0x0000,0x0000,0x2001,0x2001,0x3807,0x1FFE,0x0FFC,0x03F0,0x0000,0x0000,0x0000,0x0000},  //)
  {0x0000,0x0C98,0x0EB8,0x03E0,0x0FF8,0x0FF8,0x03E0,0x0EB8,0x0C98,0x0000,0x0000,0x0000},  //*
  {0x0000,0x0180,0x0180,0x0180,0x0FF0,0x0FF0,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000},  //+
  {0x0000,0x0000,0x0000,0xB800,0xF800,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},  //
  {0x0000,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000},  //-
  {0x0000,0x0000,0x0000,0x3800,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},  //.
  {0x1800,0x1C00,0x0E00,0x0700,0x0380,0x01C0,0x00E0,0x0070,0x0038,0x001C,0x000E,0x0000},  ///
  {0x07F8,0x1FFE,0x1E06,0x3303,0x3183,0x30C3,0x3063,0x3033,0x181E,0x1FFE,0x07F8,0x0000},  //0
  {0x0000,0x0000,0x300C,0x300C,0x300E,0x3FFF,0x3FFF,0x3000,0x3000,0x3000,0x0000,0x0000},  //1
  {0x301C,0x381E,0x3C07,0x3E03,0x3703,0x3383,0x31C3,0x30E3,0x3077,0x303E,0x301C,0x0000},  //2
  {0x0C0C,0x1C0E,0x3807,0x30C3,0x30C3,0x30C3,0x30C3,0x30C3,0x39E7,0x1F7E,0x0E3C,0x0000},  //3
  {0x03C0,0x03E0,0x0370,0x0338,0x031C,0x030E,0x0307,0x3FFF,0x3FFF,0x0300,0x0300,0x0000},  //4
  {0x0C3F,0x1C7F,0x3863,0x3063,0x3063,0x3063,0x3063,0x3063,0x38E3,0x1FC3,0x0F83,0x0000},  //5
  {0x0FC0,0x1FF0,0x39F8,0x30DC,0x30CE,0x30C7,0x30C3,0x30C3,0x39C3,0x1F80,0x0F00,0x0000},  //6
  {0x0003,0x0003,0x0003,0x3003,0x3C03,0x0F03,0x03C3,0x00F3,0x003F,0x000F,0x0003,0x0000},  //7
  {0x0F00,0x1FBC,0x39FE,0x30E7,0x30C3,0x30C3,0x30C3,0x30E7,0x39FE,0x1FBC,0x0F00,0x0000},  //8
  {0x003C,0x007E,0x30E7,0x30C3,0x30C3,0x38C3,0x1CC3,0x0EC3,0x07E7,0x03FE,0x00FC,0x0000},  //9
  {0x0000,0x0000,0x0000,0x1C70,0x1C70,0x1C70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},  //:
  {0x0000,0x0000,0x0000,0x9C70,0xFC70,0x7C70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},  //;
  {0x0000,0x00C0,0x01E0,0x03F0,0x0738,0x0E1C,0x1C0E,0x3807,0x3003,0x0000,0x0000,0x0000},  //<
  {0x0000,0x0660,0x0660,0x0660,0x0660,0x0660,0x0660,0x0660,0x0660,0x0660,0x0000,0x0000},  //=
  {0x0000,0x3003,0x3807,0x1C0E,0x0E1C,0x0738,0x03F0,0x01E0,0x00C0,0x0000,0x0000,0x0000},  //>
  {0x001C,0x001E,0x0007,0x0003,0x3783,0x37C3,0x00E3,0x0077,0x003E,0x001C,0x0000,0x0000},  //?
  {0x0FF8,0x1FFE,0x1807,0x33F3,0x37FB,0x361B,0x37FB,0x37FB,0x3607,0x03FE,0x01F8,0x0000},  //@
  {0x3800,0x3F00,0x07E0,0x06FC,0x061F,0x061F,0x06FC,0x07E0,0x3F00,0x3800,0x0000,0x0000},  //A
  {0x3FFF,0x3FFF,0x30C3,0x30C3,0x30C3,0x30C3,0x30E7,0x39FE,0x1FBC,0x0F00,0x0000,0x0000},  //B
  {0x03F0,0x0FFC,0x1C0E,0x3807,0x3003,0x3003,0x3003,0x3807,0x1C0E,0x0C0C,0x0000,0x0000},  //C
  {0x3FFF,0x3FFF,0x3003,0x3003,0x3003,0x3003,0x3807,0x1C0E,0x0FFC,0x03F0,0x0000,0x0000},  //D
  {0x3FFF,0x3FFF,0x30C3,0x30C3,0x30C3,0x30C3,0x30C3,0x30C3,0x3003,0x3003,0x0000,0x0000},  //E
  {0x3FFF,0x3FFF,0x00C3,0x00C3,0x00C3,0x00C3,0x00C3,0x00C3,0x0003,0x0003,0x0000,0x0000},  //F
  {0x03F0,0x0FFC,0x1C0E,0x3807,0x3003,0x30C3,0x30C3,0x30C3,0x3FC7,0x3FC6,0x0000,0x0000},  //G
  {0x3FFF,0x3FFF,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x00C0,0x3FFF,0x3FFF,0x0000,0x0000},  //H
  {0x0000,0x0000,0x3003,0x3003,0x3FFF,0x3FFF,0x3003,0x3003,0x0000,0x0000,0x0000,0x0000},  //I
  {0x0E00,0x1E00,0x3800,0x3000,0x3000,0x3000,0x3000,0x3800,0x1FFF,0x07FF,0x0000,0x0000},  //J
  {0x3FFF,0x3FFF,0x00C0,0x01E0,0x03F0,0x0738,0x0E1C,0x1C0E,0x3807,0x3003,0x0000,0x0000},  //K
  {0x3FFF,0x3FFF,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000},  //L
  {0x3FFF,0x3FFF,0x001E,0x0078,0x01E0,0x01E0,0x0078,0x001E,0x3FFF,0x3FFF,0x0000,0x0000},  //M
  {0x3FFF,0x3FFF,0x000E,0x0038,0x00F0,0x03C0,0x0700,0x1C00,0x3FFF,0x3FFF,0x0000,0x0000},  //N
  {0x03F0,0x0FFC,0x1C0E,0x3807,0x3003,0x3003,0x3807,0x1C0E,0x0FFC,0x03F0,0x0000,0x0000},  //O
  {0x3FFF,0x3FFF,0x0183,0x0183,0x0183,0x0183,0x0183,0x01C7,0x00FE,0x007C,0x0000,0x0000},  //P
  {0x03F0,0x0FFC,0x1C0E,0x3807,0x3003,0x3603,0x3E07,0x1C0E,0x3FFC,0x33F0,0x0000,0x0000},  //Q
  {0x3FFF,0x3FFF,0x0183,0x0183,0x0383,0x0783,0x0F83,0x1DC7,0x38FE,0x307C,0x0000,0x0000},  //R
  {0x0C3C,0x1C7E,0x38E7,0x30C3,0x30C3,0x30C3,0x30C3,0x39C7,0x1F8E,0x0F0C,0x0000,0x0000},  //S
  {0x0000,0x0003,0x0003,0x0003,0x3FFF,0x3FFF,0x0003,0x0003,0x0003,0x0000,0x0000,0x0000},  //T
  {0x07FF,0x1FFF,0x3800,0x3000,0x3000,0x3000,0x3000,0x3800,0x1FFF,0x07FF,0x0000,0x0000},  //U
  {0x0007,0x003F,0x01F8,0x0FC0,0x3E00,0x3E00,0x0FC0,0x01F8,0x003F,0x0007,0x0000,0x0000},  //V
  {0x3FFF,0x3FFF,0x1C00,0x0600,0x0380,0x0380,0x0600,0x1C00,0x3FFF,0x3FFF,0x0000,0x0000},  //W
  {0x3003,0x3C0F,0x0E1C,0x0330,0x01E0,0x01E0,0x0330,0x0E1C,0x3C0F,0x3003,0x0000,0x0000},  //X
  {0x0003,0x000F,0x003C,0x00F0,0x3FC0,0x3FC0,0x00F0,0x003C,0x000F,0x0003,0x0000,0x0000},  //Y
  {0x3003,0x3C03,0x3E03,0x3303,0x31C3,0x30E3,0x3033,0x301F,0x300F,0x3003,0x0000,0x0000},  //Z
  {0x0000,0x0000,0x3FFF,0x3FFF,0x3003,0x3003,0x3003,0x3003,0x0000,0x0000,0x0000,0x0000},  //[
  {0x000E,0x001C,0x0038,0x0070,0x00E0,0x01C0,0x0380,0x0700,0x0E00,0x1C00,0x1800,0x0000},  //backslash
  {0x0000,0x0000,0x3003,0x3003,0x3003,0x3003,0x3FFF,0x3FFF,0x0000,0x0000,0x0000,0x0000},  //]
  {0x0060,0x0070,0x0038,0x001C,0x000E,0x0007,0x000E,0x001C,0x0038,0x0070,0x0060,0x0000},  //^
  {0xC000,0xC000,0xC000,0xC000,0xC000,0xC000,0xC000,0xC000,0xC000,0xC000,0xC000,0x0000},  //_
  {0x0000,0x0000,0x0000,0x0000,0x003E,0x007E,0x004E,0x0000,0x0000,0x0000,0x0000,0x0000},  //`
  {0x1C00,0x3E40,0x3360,0x3360,0x3360,0x3360,0x3360,0x3360,0x3FE0,0x3FC0,0x0000,0x0000},  //a
  {0x3FFF,0x3FFF,0x30C0,0x3060,0x3060,0x3060,0x3060,0x38E0,0x1FC0,0x0F80,0x0000,0x0000},  //b
  {0x0F80,0x1FC0,0x38E0,0x3060,0x3060,0x3060,0x3060,0x3060,0x18C0,0x0880,0x0000,0x0000},  //c
  {0x0F80,0x1FC0,0x38E0,0x3060,0x3060,0x3060,0x30E0,0x30C0,0x3FFF,0x3FFF,0x0000,0x0000},  //d
  {0x0F80,0x1FC0,0x3BE0,0x3360,0x3360,0x3360,0x3360,0x3360,0x13C0,0x0180,0x0000,0x0000},  //e
  {0x00C0,0x00C0,0x3FFC,0x3FFE,0x00C7,0x00C3,0x00C3,0x0003,0x0000,0x0000,0x0000,0x0000},  //f
  {0x0380,0xC7C0,0xCEE0,0xCC60,0xCC60,0xCC60,0xCC60,0xE660,0x7FE0,0x3FE0,0x0000,0x0000},  //g
  {0x3FFF,0x3FFF,0x00C0,0x0060,0x0060,0x0060,0x00E0,0x3FC0,0x3F80,0x0000,0x0000,0x0000},  //h
  {0x0000,0x0000,0x3000,0x3060,0x3FEC,0x3FEC,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000},  //i
  {0x0000,0x0000,0x6000,0xE000,0xC000,0xC060,0xFFEC,0x7FEC,0x0000,0x0000,0x0000,0x0000},  //j
  {0x0000,0x3FFF,0x3FFF,0x0300,0x0780,0x0FC0,0x1CE0,0x3860,0x3000,0x0000,0x0000,0x0000},  //k
  {0x0000,0x0000,0x3000,0x3003,0x3FFF,0x3FFF,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000},  //l
  {0x3FE0,0x3FC0,0x00E0,0x00E0,0x3FC0,0x3FC0,0x00E0,0x00E0,0x3FC0,0x3F80,0x0000,0x0000},  //m
  {0x0000,0x3FE0,0x3FE0,0x0060,0x0060,0x0060,0x0060,0x00E0,0x3FC0,0x3F80,0x0000,0x0000},  //n
  {0x0F80,0x1FC0,0x38E0,0x3060,0x3060,0x3060,0x3060,0x38E0,0x1FC0,0x0F80,0x0000,0x0000},  //o
  {0xFFE0,0xFFE0,0x0C60,0x1860,0x1860,0x1860,0x1860,0x1CE0,0x0FC0,0x0780,0x0000,0x0000},  //p
  {0x0780,0x0FC0,0x1CE0,0x1860,0x1860,0x1860,0x1860,0x0C60,0xFFE0,0xFFE0,0x0000,0x0000},  //q
  {0x0000,0x3FE0,0x3FE0,0x00C0,0x0060,0x0060,0x0060,0x0060,0x00E0,0x00C0,0x0000,0x0000},  //r
  {0x11C0,0x33E0,0x3360,0x3360,0x3360,0x3360,0x3F60,0x1E40,0x0000,0x0000,0x0000,0x0000},  //s
  {0x0060,0x0060,0x1FFE,0x3FFE,0x3060,0x3060,0x3060,0x3000,0x0000,0x0000,0x0000,0x0000},  //t
  {0x0FE0,0x1FE0,0x3800,0x3000,0x3000,0x3000,0x3000,0x1800,0x3FE0,0x3FE0,0x0000,0x0000},  //u
  {0x0060,0x01E0,0x0780,0x1E00,0x3800,0x3800,0x1E00,0x0780,0x01E0,0x0060,0x0000,0x0000},  //v
  {0x07E0,0x1FE0,0x3800,0x1C00,0x0FE0,0x0FE0,0x1C00,0x3800,0x1FE0,0x07E0,0x0000,0x0000},  //w
  {0x3060,0x38E0,0x1DC0,0x0F80,0x0700,0x0F80,0x1DC0,0x38E0,0x3060,0x0000,0x0000,0x0000},  //x
  {0x0000,0x0060,0x81E0,0xE780,0x7E00,0x1E00,0x0780,0x01E0,0x0060,0x0000,0x0000,0x0000},  //y
  {0x3060,0x3860,0x3C60,0x3660,0x3360,0x31E0,0x30E0,0x3060,0x3020,0x0000,0x0000,0x0000},  //z
  {0x0000,0x0080,0x01C0,0x1FFC,0x3F7E,0x7007,0x6003,0x6003,0x6003,0x0000,0x0000,0x0000},  //{
  {0x0000,0x0000,0x0000,0x0000,0x3FFF,0x3FFF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},  //|
  {0x0000,0x6003,0x6003,0x6003,0x7007,0x3F7E,0x1FFC,0x01C0,0x0080,0x0000,0x0000,0x0000},  //}
  {0x0010,0x0018,0x000C,0x0004,0x000C,0x0018,0x0010,0x0018,0x000C,0x0004,0x0000,0x0000},  //~
  {0x0100,0x0700,0x1E00,0x7800,0x7800,0x1E00,0x0780,0x01E0,0x0078,0x001C,0x0006,0x0003}   //tick
};

#define BLACK 0x0000
#define BLUE 0x001F
#define RED 0xF800
#define GREEN 0x07E0
#define CYAN 0x07FF
#define MAGENTA 0xF81F
#define YELLOW 0xFFE0  
#define WHITE 0xFFFF
#define GREY 0x8410

#define RSTPIN A4
#define CSPIN A3
#define RSPIN A2
#define WRPIN A1
#define RDPIN A0

#define TOUCHXDIG 6
#define TOUCHYDIG 7
#define TOUCHXAN  A2
#define TOUCHYAN  A1

int width,height,rotation;

void setup() {
  displaySetup();
  Serial.begin(9600);
  setrotation(1);
  clear(BLACK);
  characterarray(width/2,5,"TOP",GREEN,BLUE);
  character(width/2,height-24,',',WHITE,BLACK);
  crosshairs(width/4,height/4,40,WHITE);
  crosshairs(width/4,(height/4)*3,40,WHITE);
  crosshairs((width/4)*3,height/4,40,WHITE);
  crosshairs((width/4)*3,(height/4)*3,40,WHITE);
}

void loop() {
  int x,y;
  x=getTouchX();
  y=getTouchY();  
  Serial.print(x);
  Serial.print(",");
  Serial.println(y);
  unsint(width/2-60,height-24,x,WHITE,BLACK);
  unsint(width/2+12,height-24,y,WHITE,BLACK);
  delay(100);
}

void crosshairs(int x, int y, int s,unsigned long c){
  line(x,y-s,x,y+s,c);
  line(x-s,y,x+s,y,c);
}

void unsint(int x, int y, int c, unsigned long f, unsigned long b){
  character(x+48,y,(c%10)+'0',f,b);
  c=c/10;
  if(c>0){character(x+36,y,(c%10)+'0',f,b);}else{character(x+36,y,' ',f,b);}
  c=c/10;
  if(c>0){character(x+24,y,(c%10)+'0',f,b);}else{character(x+24,y,' ',f,b);}
  c=c/10;
  if(c>0){character(x+12,y,(c%10)+'0',f,b);}else{character(x+12,y,' ',f,b);}
  c=c/10;
  if(c>0){character(x,y,(c%10)+'0',f,b);}else{character(x,y,' ',f,b);}
}

void displaySetup(){
  int i;
  width=320;
  height=480;
  rotation=0;//default
  pinMode(RSTPIN,OUTPUT);
  pinMode(CSPIN,OUTPUT);
  pinMode(RSPIN,OUTPUT);
  pinMode(WRPIN,OUTPUT);
  pinMode(RDPIN,OUTPUT);
  for(i=2;i<10;i++){pinMode(i,OUTPUT);}//data pins
  digitalWrite(RSTPIN,HIGH);
  digitalWrite(CSPIN,HIGH);
  digitalWrite(RSPIN,HIGH);
  digitalWrite(WRPIN,HIGH);
  digitalWrite(RDPIN,HIGH);
  delay(5);
  digitalWrite(RSTPIN,LOW);
  delay(15);
  digitalWrite(RSTPIN,HIGH);//hard reset
  delay(15);
  digitalWrite(CSPIN,LOW);
  cmd8(0x0);    //sw reset
  cmd8(0x1);
  delay(120);
  cmd8(0x0);
  cmd8(0x28);   //display off
  cmd8(0x0);
  cmd8(0x3A);   //pixel format
  data8(0x55);  //16bpp
  cmd8(0x0);
  cmd8(0x3A);
  data8(0x55);
  cmd8(0x0);    
  cmd8(0x11);   //exit sleep
  delay(120);
  cmd8(0x0);
  cmd8(0x29);   //display on
  cmd8(0x0);
  cmd8(0xB6);   //display function control
  data8(0x0);
  data8(0x22);
  data8(0x3B);
  cmd8(0x0);
  cmd8(0x36);   //Memory access control
  data8(0x8);   //sets orientation/scan direction/flip
  cmd8(0x0);
  cmd8(0x2A);   //set column start/end
  data8(0x0);
  data8(0x0);   //from 0
  data8(0x1);
  data8(0x3F);  //to 319
  cmd8(0x0);
  cmd8(0x2B);   //set row start/end
  data8(0x0);
  data8(0x0);   //from 0
  data8(0x1);
  data8(0xDF);  //to 479
  cmd8(0x0);
  cmd8(0x33);   //vscroll
  data8(0x0);
  data8(0x0);
  data8(0x1);   //480 lines
  data8(0xE0);
  data8(0x0);
  data8(0x0);
  cmd8(0x0);
  cmd8(0x37);   //vscroll start
  data8(0x0);
  data8(0x0);   //line 0
  cmd8(0x0);    
  cmd8(0x13);   //normal mode
  cmd8(0x0);
  cmd8(0x20);   //not inverted
  cmd8(0x0);
}

void setrotation(byte r){
  switch(r){
    case 0:
      rotation=0;     //portrait 1
      width=320;
      height=480;
      cmd8(0x0);
      cmd8(0x36);   //Memory access control
      data8(8);   //sets orientation/scan direction/flip
      setarea(0,0,width-1,height-1);
      break;
    case 1:
      rotation=1;     //landscape 1
      width=480;
      height=320;
      cmd8(0x0);
      cmd8(0x36);   //Memory access control
      data8(104);   //sets orientation/scan direction/flip
      setarea(0,0,width-1,height-1);
      break;
    case 2:
      rotation=2;     //portrait reversed
      width=320;
      height=480;
      cmd8(0x0);
      cmd8(0x36);   //Memory access control
      data8(200);   //sets orientation/scan direction/flip
      setarea(0,0,width-1,height-1);
      break;
    case 3:
      rotation=3;     //landscape reversed
      width=480;
      height=320;
      cmd8(0x0);
      cmd8(0x36);   //Memory access control
      data8(168);   //sets orientation/scan direction/flip
      setarea(0,0,width-1,height-1);
      break;
  }
}

void drawbox(int x0,int y0,int x1,int y1,unsigned int c){
  int t,x,y;
  if(x1<x0){int t=x0;x0=x1;x1=t;}   //sort x
  if(y1<y0){int t=y0;y0=y1;y1=t;}   //sort y
  setarea(x0,y0,x1,y1);
  x1++;
  y1++;
  for(y=y0;y<y1;y++){
    for(x=x0;x<x1;x++){
      data8(c>>8);
      data8(c);      
    }
  }
}

void setarea(int x0,int y0,int x1,int y1){
  int t;
  if(rotation==1){y0=height-1-y0;y1=height-1-y1;}           //change areas to suit rotations
  if(rotation==2){y0=height-1-y0;y1=height-1-y1;x0=width-1-x0;x1=width-1-x1;}
  if(rotation==3){x0=width-1-x0;x1=width-1-x1;}
  if(x1<x0){int t=x0;x0=x1;x1=t;}   //sort x
  if(y1<y0){int t=y0;y0=y1;y1=t;}   //sort y
  cmd8(0);
  cmd8(0x2A);   //set column start/end
  data8(x0>>8); 
  data8(x0);    //start
  data8(x1>>8);
  data8(x1);    //end
  cmd8(0);
  cmd8(0x2B);   //set row start/end
  data8(y0>>8);
  data8(y0);    //start
  data8(y1>>8);
  data8(y1);    //end
  cmd8(0);
  cmd8(0x2C);   //draw!
}

void clear(unsigned int c){
  int x,y;
  setarea(0,0,width-1,height-1);
  for(x=0;x<320;x++){
    for(y=0;y<480;y++){
      data8(c>>8);
      data8(c);
    }
  }
}

void data8(byte d){
  byte i;
  //for(i=2;i<10;i++){digitalWrite(i,d&(1<<(i%8)));}   //slow, works on any
  //digitalWrite(WRPIN,LOW);digitalWrite(WRPIN,HIGH);   //toggle clock
  PORTD=(PORTD&3)|(d&252); PORTB=(PORTB&252)|(d&3); //fast, but only works on uno
  PORTC&=253;PORTC|=2;                              //toggle clock, uno only
}

void cmd8(byte d){
  digitalWrite(RSPIN,LOW);
  data8(d);
  digitalWrite(RSPIN,HIGH);  
}

void character(int x, int y, char c, unsigned int f, unsigned int b){
  byte v,u;
  unsigned int d;
  c=c-32;   //array starts at ascii 32
  if(c<0){return;}
  if(c>95){return;}
  setarea(x,y,x+11,y+15);
  for(v=0;v<16;v++){
    for(u=0;u<12;u++){
      d=pgm_read_word(&font[c][u]);
      if((1<<v)&d){
        data8(f>>8); data8(f);
      }else{
        data8(b>>8); data8(b);        
      }
    }
  }
}

void characterarray(int x, int y, char *c, unsigned long f, unsigned long b){
  while(*c){
    character(x,y,*c++,f,b);
    x=x+12;
    if(x>width-12){x=0;y=y+16;}      //wrap around (will probably look ugly, but better than nothing)
  }    
}

void point(int x, int y, unsigned int c){
  setarea(x,y,x,y);
  data8(c>>8);
  data8(c);      
}

int getTouchX(){
  int t;
  pinMode(TOUCHXDIG,OUTPUT);      //x-axis voltage divider
  pinMode(TOUCHXAN,OUTPUT);
  digitalWrite(TOUCHXDIG,LOW);
  digitalWrite(TOUCHXAN,HIGH);
  pinMode(TOUCHYAN,INPUT_PULLUP);//y-axis to read 
  pinMode(TOUCHYDIG,INPUT_PULLUP);
  analogRead(TOUCHYAN);   //ignore first read
  t=analogRead(TOUCHYAN);
  pinMode(TOUCHYAN,OUTPUT);// return to outputs
  pinMode(TOUCHYDIG,OUTPUT);
  return t;
}

int getTouchY(){
  int t;
  pinMode(TOUCHYDIG,OUTPUT);      //x-axis voltage divider
  pinMode(TOUCHYAN,OUTPUT);
  digitalWrite(TOUCHYDIG,LOW);
  digitalWrite(TOUCHYAN,HIGH);
  pinMode(TOUCHXAN,INPUT_PULLUP);//y-axis to read 
  pinMode(TOUCHXDIG,INPUT_PULLUP);
  analogRead(TOUCHXAN);   //ignore first read
  t=analogRead(TOUCHXAN);
  pinMode(TOUCHXAN,OUTPUT);// return to outputs
  pinMode(TOUCHXDIG,OUTPUT);
  return t;
}

void line(int x1,int y1,int x2,int y2, unsigned long c){
  int steps,stepsx,stepsy,xinc,yinc,x,y,d;
  stepsx=abs(x1-x2);
  stepsy=abs(y1-y2);
  steps=max(stepsx,stepsy)+1;   //if start and end are the same, there's still 1 point
  xinc=constrain(x2-x1,-1,1);
  yinc=constrain(y2-y1,-1,1);
  x=x1;
  y=y1;  
  if(stepsx>stepsy){
    d=stepsx/2;
    for(int i=0;i<steps;i++){
      point(x,y,c);
      x=x+xinc;
      d=d+stepsy;
      if(d>stepsx){d=d-stepsx;y=y+yinc;}
    }
  }else{
    d=stepsy/2;
    for(int i=0;i<steps;i++){
      point(x,y,c);
      y=y+yinc;
      d=d+stepsx;
      if(d>stepsy){d=d-stepsy;x=x+xinc;}
    } 
  }  
}

