#define INPUT_1 -128
#define INPUT_2 -127
#define INPUT_3 -126
#define INPUT_4 -125

typedef struct {
  signed char temp1, temp2, min_or_max;
} minormax_t;

typedef struct {
  signed char min, max;
} minmax_t;

typedef struct {
  minormax_t plus, minus;
} diff_input_t;

typedef enum { first, min, max, avg } input_comb_t;

typedef struct {
  unsigned char num, denom;
} fraction_8_8_t;

typedef struct {
  unsigned short num;
  unsigned char denom;
} fraction_16_8_t;

typedef struct {
    diff_input_t inputs;
    minmax_t temp_range;
} input_temp_t;

typedef enum { exp_1, exp_sqrt, exp_cubert, exp_2, exp_3 } exp_t;

typedef struct {
    // TO TEST
    fraction_16_8_t PWM_Hz;
    unsigned char duty_hyst; // not used
    minmax_t duty_range;
    input_temp_t input_temp[2];
    unsigned short SVC_mV;
    unsigned char input_comb:2;
    unsigned char exp:3;
    unsigned char slave_to:2;
    unsigned char disabled:1;
    unsigned char ramp_ms_per_pct;
} output_t;

typedef struct {
    unsigned short on_mV, off_mV, cooldown_min_mV;
    unsigned short sleep_ms /*unused*/, cooldown_s, cooldown_delay, cooldown_min_on_time;
    unsigned char cooldown_comp_low_pct, cooldown_comp_high_pct;
} supply_t;

typedef struct {
  supply_t supply;
  output_t outputs[4];
  unsigned char input_config1; // lower 4 bits is input enables, upper 4 bits is NTC (0) or DS18B20 (1)
  unsigned char input_config2; // 4 x 2 bit settings for DS18B20 (00=9 bit ... 11=12 bit)
  unsigned char led_function;  // unused
} config_t;

typedef struct {
  unsigned short supply_mV;
  unsigned short temp_dC[4];
} overrides_t;

typedef enum { mode_sleep, mode_active, mode_cooldown } mode_t;

typedef struct {
  unsigned short supply_mV;
  signed short input_temp_dC[4];
  unsigned char out_duty[4];
  unsigned char LED_duty, SVC_pct;
  mode_t cur_mode;
  unsigned short mode_timer;
} status_t;

typedef union {
    config_t cfg;
    unsigned char buf[128];
} active_config_t;
extern active_config_t active_config;
extern config_t pending_config;
extern overrides_t overrides;
extern status_t status;
