/* 
 * File:   functions.c
 * Author: Mike
 *
 * This file contains all the useful functions to be used by the main application
 * 
 * Created on November 1, 2017, 4:59 PM
 */

#pragma switch auto

#include "mcc_generated_files/mcc.h"
#include "functions.h"

uint8_t digit1 = 1;
uint8_t digit1val = 1;
uint8_t digit2 = 2;
uint8_t digit2val = 7;
uint8_t digit3 = 3;
uint8_t digit3val = 0;
uint8_t digit4 = 4;
uint8_t digit4val = 0;
uint8_t delaytime = 10;
volatile uint8_t mathSign = 0;
uint16_t firstNum = 2;
uint16_t secondNum = 3;
uint8_t firstNumEntered = 0;            // This variable indicates if the first number has been entered
uint8_t maxNumbers = 4;

volatile uint8_t currentdigit = 0;
volatile uint8_t currentdigitval = 1;
volatile uint8_t digits[4];
volatile uint8_t calcstate = 1;

uint8_t minutes = 8;
uint8_t tenminutes = 0;
uint8_t hours = 7;
uint8_t tenhours = 1;

uint8_t maxseconds = 60;
uint8_t maxminutes = 10;
uint8_t maxtenminutes = 6;
uint8_t maxhours = 10;
uint8_t maxtenhours = 3;


uint8_t displayNumber(uint16_t number) {
        
//    clrNumber();
    
//    SEGL1L2_SetHigh();
    
    switch(number) {
        case 0x0:           // a,b,c,d,e,f
            SEGA_SetHigh();
            SEGB_SetHigh();
            SEGC_SetHigh();
            SEGD_SetHigh();
            SEGE_SetHigh();
            SEGF_SetHigh();
            SEGG_SetLow();
            break;
        
        case 0x1:            // b,c
            SEGA_SetLow();
            SEGB_SetHigh();
            SEGC_SetHigh();
            SEGD_SetLow();
            SEGE_SetLow();
            SEGF_SetLow();
            SEGG_SetLow();
            break;

        case 0x2:            // a,b,g,e,d
            SEGA_SetHigh();
            SEGB_SetHigh();
            SEGC_SetLow();
            SEGD_SetHigh();
            SEGE_SetHigh();
            SEGF_SetLow();
            SEGG_SetHigh();
            break;

        case 0x3:            // a,b,g,c,d
            SEGA_SetHigh();
            SEGB_SetHigh();
            SEGC_SetHigh();
            SEGD_SetHigh();
            SEGE_SetLow();
            SEGF_SetLow();
            SEGG_SetHigh();
            break;
        
        case 0x4:            //f,b,g,c
            SEGA_SetLow();
            SEGB_SetHigh();
            SEGC_SetHigh();
            SEGD_SetLow();
            SEGE_SetLow();
            SEGF_SetHigh();
            SEGG_SetHigh();
            break;
        
        case 0x5:            // a,f,g,c,d
            SEGA_SetHigh();
            SEGB_SetLow();
            SEGC_SetHigh();
            SEGD_SetHigh();
            SEGE_SetLow();
            SEGF_SetHigh();
            SEGG_SetHigh();
            break;
         
        case 0x6:            // a,f,g,e,c,d
            SEGA_SetHigh();
            SEGB_SetLow();
            SEGC_SetHigh();
            SEGD_SetHigh();
            SEGE_SetHigh();
            SEGF_SetHigh();
            SEGG_SetHigh();
            break;

        case 0x7:            // a,b,c
            SEGA_SetHigh();
            SEGB_SetHigh();
            SEGC_SetHigh();
            SEGD_SetLow();
            SEGE_SetLow();
            SEGF_SetLow();
            SEGG_SetLow();
            break;

        case 0x8:            // a,b,c,d,e,f,g
            SEGA_SetHigh();
            SEGB_SetHigh();
            SEGC_SetHigh();
            SEGD_SetHigh();
            SEGE_SetHigh();
            SEGF_SetHigh();
            SEGG_SetHigh();
            break;

        case 0x9:            // a,b,f,g,c
            SEGA_SetHigh();
            SEGB_SetHigh();
            SEGC_SetHigh();
            SEGD_SetLow();
            SEGE_SetLow();
            SEGF_SetHigh();
            SEGG_SetHigh();
            break;
            
        case 0xA:            // Displays equals sign, g,d
            break;
            
        case 0xB:            // Displays clr sign, C => a,f,d
            break;
        
        case 0xC:            // Displays Multiply, * => a,b,c,e,f
            mathSign = 1;
            calcstate = 2;
            break;
            
        case 0xD:            // Displays Divide, / => a,g,d 
            mathSign = 2;
            calcstate = 2;
            break;
            
        case 0xE:            // Displays Minus, - => g
            mathSign = 3;
            calcstate = 2;
            break;
            
        case 0xF:            // Displays Addition, + => b,c,g
            mathSign = 4;
            calcstate = 2;
            break;
            
        case 0x10:            // show E for ERROR a,f,g,e,d
            SEGA_SetHigh();
            SEGB_SetLow();
            SEGC_SetLow();
            SEGD_SetHigh();
            SEGE_SetHigh();
            SEGF_SetHigh();
            SEGG_SetHigh();
            break;
            
        case 0x11:            // show r for ERROR a,f,g,e,d
            SEGA_SetLow();
            SEGB_SetLow();
            SEGC_SetLow();
            SEGD_SetLow();
            SEGE_SetHigh();
            SEGF_SetLow();
            SEGG_SetHigh();
            break;
            
        case 0x12:            // Show nothing
            SEGA_SetLow();
            SEGB_SetLow();
            SEGC_SetLow();
            SEGD_SetLow();
            SEGE_SetLow();
            SEGF_SetLow();
            SEGG_SetLow();
            break;
            
        default:            // show E for ERROR a,f,g,e,d
            SEGA_SetHigh();
            SEGB_SetLow();
            SEGC_SetLow();
            SEGD_SetHigh();
            SEGE_SetHigh();
            SEGF_SetHigh();
            SEGG_SetHigh();
            break;
                     }
    
    return 1;
}


uint8_t displayNumberFast(uint16_t number) {
    
    switch(number) {
        case 0x0:           // a,b,c,d,e,f
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 1;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 1;     // SEGD
            LATCbits.LATC4 = 1;     // SEGE
            LATCbits.LATC0 = 1;     // SEGF
            LATBbits.LATB5 = 0;     // SEGG
            break;
        
        case 0x1:            // b,c
            LATBbits.LATB4 = 0;     // SEGA
            LATBbits.LATB6 = 1;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 0;     // SEGD
            LATCbits.LATC4 = 0;     // SEGE
            LATCbits.LATC0 = 0;     // SEGF
            LATBbits.LATB5 = 0;     // SEGG
            break;

        case 0x2:            // a,b,d,e,g
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 1;     // SEGB
            LATCbits.LATC2 = 0;     // SEGC
            LATCbits.LATC6 = 1;     // SEGD
            LATCbits.LATC4 = 1;     // SEGE
            LATCbits.LATC0 = 0;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;

        case 0x3:            // a,b,c,d,g
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 1;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 1;     // SEGD
            LATCbits.LATC4 = 0;     // SEGE
            LATCbits.LATC0 = 0;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;
        
        case 0x4:            // b,c,f,g
            LATBbits.LATB4 = 0;     // SEGA
            LATBbits.LATB6 = 1;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 0;     // SEGD
            LATCbits.LATC4 = 0;     // SEGE
            LATCbits.LATC0 = 1;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;
        
        case 0x5:            // a,c,d,f,g
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 0;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 1;     // SEGD
            LATCbits.LATC4 = 0;     // SEGE
            LATCbits.LATC0 = 1;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;
         
        case 0x6:            // a,c,d,e,f,g
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 0;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 1;     // SEGD
            LATCbits.LATC4 = 1;     // SEGE
            LATCbits.LATC0 = 1;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;

        case 0x7:            // a,b,c
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 1;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 0;     // SEGD
            LATCbits.LATC4 = 0;     // SEGE
            LATCbits.LATC0 = 0;     // SEGF
            LATBbits.LATB5 = 0;     // SEGG
            break;

        case 0x8:            // a,b,c,d,e,f,g
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 1;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 1;     // SEGD
            LATCbits.LATC4 = 1;     // SEGE
            LATCbits.LATC0 = 1;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;

        case 0x9:            // a,b,c,f,g
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 1;     // SEGB
            LATCbits.LATC2 = 1;     // SEGC
            LATCbits.LATC6 = 0;     // SEGD
            LATCbits.LATC4 = 0;     // SEGE
            LATCbits.LATC0 = 1;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;
            
        case 0xA:            // Displays equals sign, g,d
            break;
            
        case 0xB:            // Displays clr sign, C => a,f,d
            break;
        
        case 0xC:            // Displays Multiply, * => a,b,c,e,f
            mathSign = 1;
            break;
            
        case 0xD:            // Displays Divide, / => a,g,d 
            mathSign = 2;
            break;
            
        case 0xE:            // Displays Minus, - => g
            mathSign = 3;
            break;
            
        case 0xF:            // Displays Addition, + => b,c,g
            mathSign = 4;
            break;
            
        case 0x10:            // show E for ERROR a,d,e,f,g 
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 0;     // SEGB
            LATCbits.LATC2 = 0;     // SEGC
            LATCbits.LATC6 = 1;     // SEGD
            LATCbits.LATC4 = 1;     // SEGE
            LATCbits.LATC0 = 1;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;
            
        case 0x11:            // show r for ERROR e,g
            LATBbits.LATB4 = 0;     // SEGA
            LATBbits.LATB6 = 0;     // SEGB
            LATCbits.LATC2 = 0;     // SEGC
            LATCbits.LATC6 = 0;     // SEGD
            LATCbits.LATC4 = 1;     // SEGE
            LATCbits.LATC0 = 0;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;
            
        case 0x12:            // Show nothing
            LATBbits.LATB4 = 0;     // SEGA
            LATBbits.LATB6 = 0;     // SEGB
            LATCbits.LATC2 = 0;     // SEGC
            LATCbits.LATC6 = 0;     // SEGD
            LATCbits.LATC4 = 0;     // SEGE
            LATCbits.LATC0 = 0;     // SEGF
            LATBbits.LATB5 = 0;     // SEGG
            break;
            
        default:            // show E for ERROR a,f,g,e,d
            LATBbits.LATB4 = 1;     // SEGA
            LATBbits.LATB6 = 0;     // SEGB
            LATCbits.LATC2 = 0;     // SEGC
            LATCbits.LATC6 = 1;     // SEGD
            LATCbits.LATC4 = 1;     // SEGE
            LATCbits.LATC0 = 1;     // SEGF
            LATBbits.LATB5 = 1;     // SEGG
            break;
    }
    
    return 1;
}

uint8_t clrNumber(void) {
    SEGA_SetLow();
    SEGB_SetLow();
    SEGC_SetLow();
    SEGD_SetLow();
    SEGE_SetLow();
    SEGF_SetLow();
    SEGG_SetLow();
    SEGL1L2_SetLow();
    
    return 1;
}

uint8_t clrNumberFast(void) {
    LATBbits.LATB4 = 0;     // SEGA
    LATBbits.LATB6 = 0;     // SEGB
    LATCbits.LATC2 = 0;     // SEGC
    LATCbits.LATC6 = 0;     // SEGD
    LATCbits.LATC4 = 0;     // SEGE
    LATCbits.LATC0 = 0;     // SEGF
    LATBbits.LATB5 = 0;     // SEGG
    LATCbits.LATC1 = 0;     // SEGL1L2
    
    return 1;
}


uint8_t displayDigit(uint8_t digit, uint16_t number) {
    // Need a function that selects a digit and a number and displays them
    
//    clearDigits();
    displayNumber(number);
//    CDL1L2_SetHigh();
    
    switch(digit) {
        case 0: 
            CD1_SetLow();
            CD2_SetHigh();
            CD3_SetHigh();
            CD4_SetHigh();
            break;
        case 1: 
            CD1_SetHigh();
            CD2_SetLow();
            CD3_SetHigh();
            CD4_SetHigh();
            break;
        case 2: 
            CD1_SetHigh();
            CD2_SetHigh();
            CD3_SetLow();
            CD4_SetHigh();
            break;
        case 3: 
            CD1_SetHigh();
            CD2_SetHigh();
            CD3_SetHigh();
            CD4_SetLow();
            break;
        default: //clearDigits(); 
            break;
    }
    
    return 1;
}

uint8_t displayDigitFast(uint8_t digit, uint16_t number) {
    // Need a function that selects a digit and a number and displays them

    displayNumberFast(number);
    
    switch(digit) {
        case 0: 
            LATBbits.LATB7 = 0;     // CD1
            LATCbits.LATC7 = 1;     // CD2
            LATCbits.LATC5 = 1;     // CD3
            LATAbits.LATA5 = 1;     // CD4
            break;
        case 1: 
            LATBbits.LATB7 = 1;     // CD1
            LATCbits.LATC7 = 0;     // CD2
            LATCbits.LATC5 = 1;     // CD3
            LATAbits.LATA5 = 1;     // CD4
            break;
        case 2: 
            LATBbits.LATB7 = 1;     // CD1
            LATCbits.LATC7 = 1;     // CD2
            LATCbits.LATC5 = 0;     // CD3
            LATAbits.LATA5 = 1;     // CD4
            break;
        case 3: 
            LATBbits.LATB7 = 1;     // CD1
            LATCbits.LATC7 = 1;     // CD2
            LATCbits.LATC5 = 1;     // CD3
            LATAbits.LATA5 = 0;     // CD4
            break;
        default: //clearDigits(); 
            LATBbits.LATB7 = 1;     // CD1
            LATCbits.LATC7 = 1;     // CD2
            LATCbits.LATC5 = 1;     // CD3
            LATAbits.LATA5 = 1;     // CD4
            break;
    }
    
    return 1;
}
        
uint8_t clearDigits() {
    CD1_SetHigh();
    CD2_SetHigh();
    CD3_SetHigh();
    CD4_SetHigh();
    CDL1L2_SetHigh();
    
    return 1;
}

uint8_t updateDigits(void) {

    displayDigit(digit1, digit1val);
    __delay_us(10);
    displayDigit(digit2, digit2val);
    __delay_us(10);
    displayDigit(digit3, digit3val);
    __delay_us(10);
    displayDigit(digit4, digit4val);
    __delay_us(10);     
    
    return 1;
}

uint8_t updateTime(void) {
        
    minutes++;
    seconds = 0;
    
    if(minutes >= maxminutes) {
        tenminutes++;
        minutes = 0;
    }
    if(tenminutes >= maxtenminutes) {
        hours++;
        tenminutes = 0;
        minutes = 0;
    }
    if(hours >= maxhours) {
        tenhours++;
        hours = 0;
        tenminutes = 0;
        minutes = 0;
    } 
    if(((tenhours >= 2) && (hours >= 4)) || (tenhours > 2)) {
        tenhours = 0;
        hours = 0;
        tenminutes = 0;
        minutes = 0;
    }
    
    digit4val = minutes;
    digit3val = tenminutes;
    digit2val = hours;
    digit1val = tenhours;
    
    return 1;
}

uint16_t getKeyPress(uint16_t adcKeypadValue) {
    uint16_t retVal = 0x0;
    
    if (adcKeypadValue < 92) {
        // Display a 7
        retVal = 0x7;
    } else if ((adcKeypadValue >= 92) && (adcKeypadValue < 255)) {
        // Display a 8
        retVal = 0x8;
    } else if ((adcKeypadValue >= 255) && (adcKeypadValue < 370)) {
        // Display a 9
        retVal = 0x9;
    } else if ((adcKeypadValue >= 370) && (adcKeypadValue < 462)) {
        // Display a Multiply
        retVal = 0xC;
        if(!firstNumEntered) {
            mathSign = 1;
//            firstNumEntered = 1;
        }
    } else if ((adcKeypadValue >= 462) && (adcKeypadValue < 536)) {
        // Display a 4
        retVal = 0x4;
    } else if ((adcKeypadValue >= 536) && (adcKeypadValue < 585)) {
        // Display a 5
        retVal = 0x5;
    } else if ((adcKeypadValue >= 585) && (adcKeypadValue < 625)) {
        // Display a 6
        retVal = 0x6;
    } else if ((adcKeypadValue >= 625) && (adcKeypadValue < 661)) {
        // Display a Divide
        retVal = 0xD;
        if(!firstNumEntered) {
            mathSign = 2;
//            firstNumEntered = 1;
        }
    } else if ((adcKeypadValue >= 661) && (adcKeypadValue < 693)) {
        // Display a 1
        retVal = 0x1;
    } else if ((adcKeypadValue >= 693) && (adcKeypadValue < 716)) {
        // Display a 2
        retVal = 0x2;
    } else if ((adcKeypadValue >= 716) && (adcKeypadValue < 736)) {
        // Display a 3
        retVal = 0x3;
    } else if ((adcKeypadValue >= 736) && (adcKeypadValue < 756)) {
        // Display a Subtract
        retVal = 0xE;
        if(!firstNumEntered) {
            mathSign = 3;
//            firstNumEntered = 1;
        }
    } else if ((adcKeypadValue >= 756) && (adcKeypadValue < 773)) {
        // Display a Clear
        retVal = 0xB;
        calcstate = 1;
        asm ("reset");
    } else if ((adcKeypadValue >= 773) && (adcKeypadValue < 787)) {
        // Display a 0
        retVal = 0x0;
    } else if ((adcKeypadValue >= 787) && (adcKeypadValue < 801)) {
        // Display a Equals
        retVal = 0xA;
//        if(calcstate == 3) {
//            calcstate = 4;
//        }
    } else if ((adcKeypadValue >= 801) && (adcKeypadValue < 829)) {
        // Display a Plus
        retVal = 0xF;
        if(!firstNumEntered) {
            mathSign = 4;
//            firstNumEntered = 1;
        }
    } else {
        retVal = 1;
    }

    __delay_ms(500);
    
    return retVal;
}

void showADC(uint16_t adcVal) {
    uint16_t temp0 = 0;
    uint8_t temp1 = 0;
    uint8_t temp2 = 0;
    uint8_t temp3 = 0;
    uint8_t temp4 = 0;

    temp0 = adcVal;
    
    if(temp0 > 1000) {
        temp1 = 1;
        temp0 = temp0 - 1000;
    } else {
        temp1 = 0;
    }
    
    while(temp0 > 99) {
        temp2++;
        temp0 = temp0 - 100;
    }
    
    while(temp0 > 9) {
        temp3++;
        temp0 = temp0 - 10;
    }
    
    while (temp0 >= 1) {
        temp4++;
        temp0--;
    }
    
    digit1val = temp1;
    digit2val = temp2;
    digit3val = temp3;
    digit4val = temp4;
    
}

void setDigit(uint8_t digit, uint8_t value) {
    
    switch (digit) { 
        case 1: digit1val = value; break;
        case 2: digit2val = value; break;
        case 3: digit3val = value; break;
        case 4: digit4val = value; break;
        default: break;
    }
}

void getDisplayNumber(void) {    
    uint16_t answer = 0;
    uint8_t temp[4];
    temp[3] = digits[3];
    temp[2] = digits[2];
    temp[1] = digits[1];
    temp[0] = digits[0];
    
    for(uint8_t i = 0; i < 4; i++) {
        if(temp[i] > 9) {
            temp[i] = 0;
        }
    }
    
    answer = answer +  temp[3];
    answer = answer + (uint16_t)(10 * temp[2]);
    answer = answer + (uint16_t)(100 * temp[1]);
    answer = answer + (uint16_t)(1000 * temp[0]);
    
    if(firstNumEntered == 0) {
        firstNum = answer;
        firstNumEntered = 1;
        maxNumbers = 4;
    } else {
        secondNum = answer;
    }
}

void clrDisplay(void) {
    digits[0] = 0x12;           // Display Nothing
    digits[1] = 0x12;           // Display Nothing
    digits[2] = 0x12;           // Display Nothing
    digits[3] = 0x00;           // Display Nothing
}

/* 
 * Capture Code Flow
 * 
 * 
 *  1) Keep grabbing digits until 4 are captured or sign entered
 *  2) Grab Math sign
 *  3) Keep grabbing digits until 4 are captured or equals is entered
 * 
 * calcstate dictates state control
 *  1) Grab digits, shift left on display until 4 are captured or sign entered
 *  2) Sign has been entered - display something to indicate this
 *      Convert digits into full number
 *  3) Grab digits, shift left on display until 4 are captured or equals entered
 *  4) Display answer
 *      Convert digits into full number
 *      Using captured math sign, use first and second number and calculate answer
 * 
 * 
 */

uint16_t performMath(void) { 
    // This function performs the Mathematics required for the calculator
    
    uint16_t answer = 0;
    
//    firstNum = 15;
//    secondNum = 11;
    
    switch (mathSign) { 
        case 1:                                     // Multiply
            answer = firstNum * secondNum;
            break;           
        case 2:                                     // Divide
            if((firstNum > 0) && (secondNum > 0)) {
                answer = firstNum / secondNum;
            } else {
                displayError();
            }
            break;           
        case 3:                                     // Subtract
            if(firstNum > secondNum) {
                answer = firstNum - secondNum; 
            } else {
                displayError();
            }
            break;           
        case 4:                                     // Addition
            answer = firstNum + secondNum; 
            break;           
        default: break;
    }
    
    return answer;
}

void displayError(void) {
    // This function displays "Err" when something is out of bounds
    // This function works!
    
    digits[0] = 0x12;           // Display Nothing
    digits[1] = 0x10;           // Display 'E'
    digits[2] = 0x11;           // Display 'r'
    digits[3] = 0x11;           // Display 'r'
    
    calcstate = 4;    
}

void convertDisplayNum(uint16_t num) {
    // This function takes number from answer of equation and splits into four
    uint8_t thou = 0;
    uint8_t hun = 0;
    uint8_t ten = 0;  
    
    if(num > 9999) {
        displayError();
    } else {
        while (num >= 1000) {
            num = num - 1000;
            thou++;
        }
        while (num >= 100) {
            num = num - 100;
            hun++;
        }
        while (num >= 10) {
            num = num - 10;
            ten++;
        }
        
        if(thou == 0) {
            digits[0] = 0x12;
        } else {
            digits[0] = thou;
        }
        
        if((thou == 0) && (hun == 0)) {
            digits[1] = 0x12;
        } else {
            digits[1] = hun;
        }
        
        if((thou == 0) && (hun == 0) && (ten == 0)) {
            digits[2] = 0x12;
        } else {
            digits[2] = ten;
        }

        digits[3] = num;
    }
}

uint8_t pushToDisplay(uint8_t number) {
    uint8_t temp0;
    uint8_t temp1;
    uint8_t temp2;
    uint8_t temp3;
    
    if(maxNumbers == 4) {
        digits[3] = 0x12;
        digits[2] = 0x12;
        digits[1] = 0x12;
        digits[0] = 0x12;
    }
    
    if(maxNumbers > 0) { 
        // Store Current digits on display
        // Only store four digits on the display, ignore other key presses
        temp3 = digits[3];
        temp2 = digits[2];
        temp1 = digits[1];
        temp0 = digits[0];      // This is not necessary

        temp0 = temp1;
        temp1 = temp2;
        temp2 = temp3;
        temp3 = number;

        digits[3] = temp3;
        digits[2] = temp2;
        digits[1] = temp1;
        digits[0] = temp0;
        maxNumbers--;
    } else {
        maxNumbers = 0;     // this is not necessary
    }
    
    return 1;
}

void setMathSign(uint8_t num) {
    mathSign = num;
}