/**
 *******************************************************************
 * Lesson 3 - "Rotate"
 *
 * This lesson will introduce shifting instructions as well as bit-oriented skip operations to
 * move the LED display.
 *
 * LEDs rotate from right to left at a rate of 1.5s
 *
 * PIC: 16F1829
 * Compiler: XC8 v1.00
 * IDE: MPLABX v1.10
 *
 * Board: PICkit 3 Low Pin Count Demo Board
 * Date: 6.1.2012
 *
 * *******************************************************************
 * See Low Pin Count Demo Board User's Guide for Lesson Information*
 * ******************************************************************
 */

#include <htc.h>                                        //PIC hardware mapping
#define _XTAL_FREQ 500000                               //Used by the XC8 delay_ms(x) macro

//config bits that are part-specific for the PIC16F1829
//__CONFIG(FOSC_INTOSC & WDTE_OFF & PWRTE_OFF & MCLRE_OFF & CP_OFF & CPD_OFF & BOREN_ON & CLKOUTEN_OFF & IESO_OFF & FCMEN_OFF);
//__CONFIG(WRT_OFF & PLLEN_OFF & STVREN_OFF & LVP_OFF);

    /* -------------------LATC-----------------
     * Bit#:  -7---6---5---4---3---2---1---0---
     * LED:   ---------------|DS4|DS3|DS2|DS1|-
     *-----------------------------------------
     */

#include <htc.h>                                        //PIC hardware mapping
#define _XTAL_FREQ 500000                               //Used by the XC8 delay_ms(x) macro

#pragma config FOSC=INTOSC, WDTE=OFF, PWRTE=OFF, MCLRE=OFF, CP=OFF
#pragma config CPD=OFF, BOREN=ON, CLKOUTEN=OFF, IESO=OFF, FCMEN=OFF
#pragma config WRT=OFF, PLLEN=OFF, STVREN=OFF, LVP=OFF

void GetMyADC (void);
unsigned int flash_num = 5;

void main(void) {
    TRISA = 0;                                          //all pins are outputs
    OSCCON = 0b00111000;                                //500KHz clock speed
    LATA = 0b00000001;                                   //start the rotation by setting DS4 ON - rotate right to left

                                                    //setup ADC
    TRISAbits.TRISA4 = 1;                           //Potentiometer is connected to RA4...set as input
    ANSELAbits.ANSA4 = 1;                           //analog
    ADCON0 = 0b00001101;                            //select RA4 as source of ADC and enable the module (AN3)
    ADCON1 = 0b00010000;                            //left justified - FOSC/8 speed - Vref is Vdd
     
    while (1) {
            //__delay_ms(500);                      //delay 500ms

            GetMyADC();
            
            if(LATA == 2){
                for (int i = 0; i < flash_num; i++) {
                    __delay_ms(500);                //delay 500ms
                    LATAbits.LATA1 ^= 1;
                }
                LATA = 0b010;
            } else {
                __delay_ms(5000);                   //delay 500ms
            }
                                       
            if(LATAbits.LATA2 == 1){                //when the last LED is lit, restart the pattern
                LATA = 0b001;
            } else {
                LATA << = 1;                        //shift to the left by 1
            }
    }
}

void GetMyADC (void) {
    __delay_us(5);                              //wait for ADC charging cap to settle
    GO = 1;
    while (GO) continue;                        //wait for conversion to be finished
        flash_num = (ADRESH >> 4);              //grab the top 4 MSbs
}