/* 
 * File:   main.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 25 February 2014, 13:47
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18.h>
#include "config.h"
#include "lplc-adc.h"
#include "timers.h"
// Choose the appropriate header file
//#include "LCD-Graphic-ST7735S.h"
#include "LCD-Graphic-ILI9341.h"
#include "interrupts.h"
#include "hardware.h"
#include "lcd.h"
#include "pwm.h"

/*
 * 
 */
int main(int argc, char** argv)
{
    unsigned short lpy;
    unsigned char first_sample = 1;
    unsigned char *new_samples;
    unsigned char *old_samples;

    // Initialise any low level hardware features
    HardwareInit();

    // Initialise the Interrupt sub-system
    InterruptInit();

    // Initialise the Interrupt sub-system
    timer0Init();
    timer1Init();

    // Power up delay
    delayms(50);

    // Choose the appropriate graphics display init
    //LCDST7735sInit();
    LCDILI9341Init();
    
    LCD_Clear(BLACK);

    // Draw the oscilloscope 'screen'
    POINT_COLOR = GRAY;
    LCD_DrawLine(10,10,10,319);
    LCD_DrawLine(239,10,239,319);
    LCD_DrawLine(10,10,239,10);
    LCD_DrawLine(10,319,239,319);

    LCD_ShowString(0,120," 700us/div ");
    LCD_ShowString(6,0,"0");
    LCD_ShowString(75,0,"1");
    LCD_ShowString(144,0,"2");
    LCD_ShowString(213,0,"3");

    // And the graticule
    LINE_MASK = 0xCC;

    for (lpy = 10 + 40; lpy < 320; lpy += 40) {
        LCD_DrawLine(11,lpy,238,lpy);
    }
    LCD_DrawLine(79,11,79,318);
    LCD_DrawLine(148,11,148,318);
    LCD_DrawLine(217,11,217,318);

    POINT_COLOR = GREEN;
    LINE_MASK = 0xFF;

    /* Configure the ADC. Run from Fosc/64, 2*TAD. This gives sample+conversion time of 17.3us */
    adc_init(ADC_FOSC_64 & ADC_RIGHT_JUST & ADC_2_TAD, ADC_CH0 & ADC_INT_OFF & ADC_REF_VDD_VSS,
             0, ADC_0ANA);
    
    /* Configure a timer and capture compare module to give sample 'special event trigger' */
    /* FOSC/4, Prescale by 8, enable 16bit read/write, start timer */
    T3CON = 0x33;

    /* configure ECCP2 to use timer3 as a special event trigger to fire an ADC conversion */
    CCPTMRS0 &= ~0x38; /* Mask C2TSEL bits */
    CCPTMRS0 |= 0x08; /* Select TMR3 for ECCP2 */
    CCP2CON = 0x0B; /* Special Event Trigger mode, start */

    /* Adc sampling is now running. Interrupts are not yet being generated. */
    /* So set a period to sample at, and enable interrupts */
    CCPR2H = 0;
    CCPR2L = 100; /* 26 gives maximum sample rate */

    int_enable_adc();

    // user application - main loop
    // Code here is called either
    //    a) continuously
    //    b) once per interrupt, if the sleep instruction is present

    while (1) {
        // The sleep instruction will cause the processor to halt, and enter
        // a low power state. Timer1 interrupts will still wake the processor.
        // SLEEP();

        /* Wait for ADC samples to complete */
        while (!samples_ready)
            ; /* do nothing */

        if (current_buff) {
            old_samples = samples[1];
            new_samples = samples[0];
        } else {
            old_samples = samples[0];
            new_samples = samples[1];
        }

        /* erase the old waveform, if we have drawn one */
        if (!first_sample) {
            POINT_COLOR = BLACK;            
            LINE_MASK = 0xFF;
            for (lpy = 1; lpy < 308; lpy++) {
                LCD_DrawLine(old_samples[lpy-1], 10+lpy, old_samples[lpy], 11+lpy );
            }
            
            // And the graticule
            POINT_COLOR = GRAY;
            LINE_MASK = 0xCC;

            for (lpy = 10 + 40; lpy < 320; lpy += 40) {
                LCD_DrawLine(11,lpy,238,lpy);
            }
            LCD_DrawLine(79,11,79,318);
            LCD_DrawLine(148,11,148,318);
            LCD_DrawLine(217,11,217,318);
            
        } else
            first_sample = 0;

        POINT_COLOR = GREEN;
        LINE_MASK = 0xFF;

        for (lpy = 1; lpy < 308; lpy++) {
            LCD_DrawLine(new_samples[lpy-1], 10+lpy, new_samples[lpy], 11+lpy );
        }

        /* Are are done with the samples; let the ADC capture another set */
        samples_ready = 0;
    }

    // Should never reach this point
    return (EXIT_SUCCESS);
}

