    include <P18f27J13.INC>

	CONFIG WDTEN = OFF
	CONFIG XINST = OFF
	CONFIG IESO = OFF
	CONFIG FCMEN = OFF
	CONFIG DSWDTEN = OFF
	CONFIG OSC = INTOSCPLL
	CONFIG CFGPLLEN = ON
	CONFIG PLLDIV = 2
	CONFIG PLLSEL = PLL96
	
; RAM addresses of variables
delay_1s	EQU	0x00
	
; Constants
TMR0_COUNT_1S	EQU .3620	; TMR0 count start value for a 1s period
TMR0_CONF 		EQU 0x84	; timer is 16bit, FOSC/4 source, prescale by 32
TOGGLE_LED_TIME	EQU	.10		; time between toggling the LED - 10s
	
	
	; Set the code address to start of flash -
	; this is where the processor will start 
	; executing instructions from after a reset.
	org 0
	goto main
	
	; Interrupt routine entry address - always 0x0008
	org 8
	bcf 	INTCON, TMR0IF
	
	; only toggle the LED after 10 interrupts
	decfsz	delay_1s
	goto	int_exit	
	
	comf	LATB	; toggle all bits in PORTB
	
	; reset the 10s counter
	movlw	TOGGLE_LED_TIME
	movwf	delay_1s
	
int_exit:
	movlw	HIGH TMR0_COUNT_1S
	movwf	TMR0H
	movlw	LOW TMR0_COUNT_1S
	movwf	TMR0L
	retfie FAST
	
	
main:
	movlw   0x00	
	movwf   TRISB	; Set PORTB as an output
	movlw	0x70
	movwf	OSCCON	; Set processor to run at 48MHZ
	
	movlw	TOGGLE_LED_TIME
	movwf	delay_1s
	
	bcf 	INTCON, TMR0IF
	movlw	HIGH TMR0_COUNT_1S
	movwf	TMR0H
	movlw	LOW TMR0_COUNT_1S
	movwf	TMR0L
	movlw	TMR0_CONF
	movwf	T0CON	 	; Start the timer
	bsf     INTCON, TMR0IE
	bsf		INTCON, GIE
	bsf		OSCCON, IDLEN

loop:
	sleep
	goto    loop
	
	
	end
	