
#include "p33Fxxxx.h"
#include "mains_phase.h"

void __attribute__((__interrupt__,no_auto_psv)) _OC2Interrupt( void ) {
	IFS0bits.OC2IF = 0;
	LATAbits.LATA0 = 1;
}

void __attribute__((__interrupt__,no_auto_psv)) _T3Interrupt( void ) {
	IFS0bits.T3IF = 0;
	LATAbits.LATA0 = 0;
}

void init_led() {
    TRISAbits.TRISA0 = 0;
	LATAbits.LATA0 = 1;

	// set up timer 3 for LED PWM
	T3CONbits.TCKPS = 2; // divide master clock by 64
	TMR3 = 0;
    PR3 = 1024;
	T3CONbits.TON = 1;

	// set up output compare 2 for LED PWM
	OC2CONbits.OCTSEL = 1;
	OC2CONbits.OCM = 5;
	OC2R = 0;
	OC2RS = 512;

	IEC0bits.T3IE = 0;
   	IEC0bits.OC2IE = 0;
}
void led_on() {
	if( IEC0bits.T3IE ) {
		IEC0bits.T3IE = 0;
    	IEC0bits.OC2IE = 0;
	}
	LATAbits.LATA0 = 0;
}
void led_off() {
	if( IEC0bits.T3IE ) {
		IEC0bits.T3IE = 0;
    	IEC0bits.OC2IE = 0;
	}
	LATAbits.LATA0 = 1;
}
void set_led_brightness(unsigned char level) {
	if( !IEC0bits.T3IE ) {
		IEC0bits.T3IE = 1;
    	IEC0bits.OC2IE = 1;
		TMR3 = 0;
	}

	OC2RS = level*4;
//	if( TMR3 > OC2RS )
//		LATAbits.LATA0 = 1;
}
extern unsigned char memoryCardSystemUp;
void error_flash(unsigned char long_flashes, unsigned char short_flashes, unsigned char* interrupt, unsigned char interrupt_cmp) {
	unsigned char i;

	if( IEC0bits.T3IE ) {
		IEC0bits.T3IE = 0;
    	IEC0bits.OC2IE = 0;
	}

	LATAbits.LATA0 = 1;

	while(!interrupt || *interrupt != interrupt_cmp) {
		for( i = 0; i < long_flashes; ++i ) {
			LATAbits.LATA0 = 0;
			DelayMs(1000, interrupt, interrupt_cmp);
			LATAbits.LATA0 = 1;
			DelayMs(1000, interrupt, interrupt_cmp);
		}
		for( i = 0; i < short_flashes; ++i ) {
			LATAbits.LATA0 = 0;
			DelayMs(300, interrupt, interrupt_cmp);
			LATAbits.LATA0 = 1;
			DelayMs(200, interrupt, interrupt_cmp);
		}
		DelayMs(2000, interrupt, interrupt_cmp);
	}
}
