
#include <Windows.h>
#include "Sequence.h"
#include "DSP.h"


#define SETBRIGHTNESS_CANCELACTIONS    -1
#define SETBRIGHTNESS_INTERPOLATEDRAMP -2
#define SETBRIGHTNESS_RAMPUP           -3
#define SETBRIGHTNESS_RAMPDOWN         -4
#define SETBRIGHTNESS_PASTE            -5
#define SETBRIGHTNESS_INSERT           -6

typedef enum { LowToHigh, HighToLow, PingPong, Random } CascadeOrder;
typedef enum { Flash, Fade, Track } CascadeEffect;
typedef enum { RampUp, RampDown, Peak, Trough } CustomRampType;
typedef enum { Mono, LeftToRight, RightToLeft, LeftOnly, RightOnly, OneChannelOnly } SpectrumStereoType;
typedef enum { ScaleNeither, ScaleBrightness, ScaleDuration, ScaleBoth } SpectrumScaleType;
typedef struct { unsigned char Brightness, Duration; } SpectrumScaleFactors;

bool SetLightBrightness(HWND hWnd, int i, int start, int finish, int brightness, sequence* arg = (sequence*)NULL, bool bForce = false);
void SetSelectedLightBrightness(HWND hWnd, int brightness);
void SetSequenceLength(HWND hWnd, int new_length_ms);

bool Cascade(HWND hWnd, int start, int finish, CascadeOrder Order, CascadeEffect Effect, int Brightness, int Period, int OnTime, int RiseTime, int FallTime, unsigned long Lights, bool bMerge, bool bMix, int* TriggerPoints = (int*)NULL, SpectrumScaleFactors* TriggerPointScale = (SpectrumScaleFactors*)NULL);
void FinaliseCascade(HWND hWnd);
void CancelCascade(HWND hWnd);

bool CustomRamp(HWND hWnd, int start, int finish, CustomRampType Type, int InitialBrightness, int FinalBrightness, int PeakBrightness, int TroughBrightness, int StartDelay, int EndDelay, int PeakDelay, int TroughDelay, int Symmetry, bool bMerge, bool bMix);
void FinaliseCustomRamp(HWND hWnd);
void CancelCustomRamp(HWND hWnd);

bool BeatDetection(HWND hWnd, int start, int finish, int Sensitivity, int MinInterval, int Delay, CascadeEffect Effect, int Brightness, int OnTime, int RiseTime, int FallTime, CascadeOrder Order, unsigned long Lights, bool bMerge, bool bMix, bool bPreview);
void FinaliseBeatDetection(HWND hWnd, int start, int finish, int Sensitivity, int MinInterval, int Delay, CascadeEffect Effect, int Brightness, int OnTime, int RiseTime, int FallTime, CascadeOrder Order, unsigned long Lights, bool bMerge, bool bMix);
void CancelBeatDetection(HWND hWnd);

bool SpectrumAnalysis(HWND hWnd, int start, int finish, double lfLowerCornerFrequency, double lfUpperCornerFrequency, int NumBands, FrequencySpacing Spacing, SpectrumStereoType Stereo, CascadeOrder Order, CascadeEffect Effect, SpectrumScaleType ScaleType, int Brightness, int Sensitivity, int UpdateIntervalMilliseconds, int OnTime, int RiseTime, int FallTime, int Delay, int MinInterval, unsigned long Lights, bool bMerge, bool bMix, bool bPreview);
void FinaliseSpectrumAnalysis(HWND hWnd, int start, int finish, double lfLowerCornerFrequency, double lfUpperCornerFrequency, int NumBands, FrequencySpacing Spacing, SpectrumStereoType Stereo, CascadeOrder Order, CascadeEffect Effect, SpectrumScaleType ScaleType, int Brightness, int Sensitivity, int UpdateIntervalMilliseconds, int OnTime, int RiseTime, int FallTime, int Delay, int MinInterval, unsigned long Lights, bool bMerge, bool bMix);
void CancelSpectrumAnalysis(HWND hWnd);
