; UHF Transmitter using UHF transmitter module

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_ON & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	
; RAM 
TEMP			equ	H'20'	; temporary working register
STORE1			equ	H'21'	; delay counter	
STORE2			equ	H'22'	; delay counter
STORE3			equ	H'23'	; delay counter

; start at memory 0

	org		0			; reset vector
	goto	MAIN

	org 	5
MAIN
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00100001'	; pullups
	movwf	WPU
	movlw	B'00111101'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00000111'	; settings (pullups enabled) timer 0/ 256
	movwf	OPTION_REG
; calibrate internal oscillator
	call	H'3FF'	
	movwf	OSCCAL
; analog inputs, A/D
	movlw	B'01011000'	;  AN3 is an analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00001100'	; channel 3 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

; initial conditions
	movlw	B'00000000'	; port low, transmitter and LED off
	movwf	GPIO	

; test if GPIO,5 is low.
TEST
	btfss	GPIO,5
	goto	POWER_ON
; power off normally
; set GPIO,2 as output
	
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00111001'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	bsf		GPIO,2		; set high to drive transistor for power on
	goto	SEND_DATA

POWER_ON
; if GPIO,2 is low then switch is closed
	btfsc	GPIO,2 
	goto	TEST
	call	DELAY		; debounce switch
	btfsc	GPIO,2 		; test after delay
	goto	TEST

; Send Data
SEND_DATA
; start bits with gap for locking to data rate, encode value, 
; onoff code and stop bits

; find encode value from A/D

; set TEMP 
	call	ACQUIRE_AD
	movf	ADRESH,w
	sublw	D'51'		; if less than 51 then a low setting
	btfsc	STATUS,C	; if positive then less or equal to 51
	goto	SET_1
	movf	ADRESH,w
	sublw	D'102'		; if less than 102 then a next setting
	btfsc	STATUS,C	; if positive then less or equal to 102
	goto	SET_2 
	movf	ADRESH,w
	sublw	D'153'		; if less than 153 then a mid setting
	btfsc	STATUS,C	; if positive then less or equal to 153
	goto	SET_3
	movf	ADRESH,w
	sublw	D'204'		; if less than 204 then a next setting
	btfsc	STATUS,C	; if positive then less or equal to 204
	goto	SET_4  
	movlw	D'128'		; max setting
	goto	SEND_DATA1
SET_1
	movlw	D'8'	
	goto	SEND_DATA1
SET_2
	movlw	D'16'
	goto	SEND_DATA1
SET_3
	movlw	D'32'	
	goto	SEND_DATA1
SET_4
	movlw	D'64'

SEND_DATA1
	movwf	TEMP		; place in temp
; start bits with gap for locking to data rate

; send out a 1 to engage the receiver

	bsf		GPIO,1		; send a 1
	movlw	D'100'		; 50 ms
	call	DELAYXX		; ms
	bcf		GPIO,1		; send a zero
	movlw	D'10'		; 5 ms 
	call	DELAYXX		; ms

; send a reference gap

	bsf		GPIO,1		; a 1
	movlw	D'32'		; 16ms 
	call	DELAYXX		; extra length
	bcf		GPIO,1		; a 0		
	call	DELAY1

; start sending data
; encode 
; 8-bits
	movf	TEMP,w		; send encode 
	call	ROLL_8		; send out 

; on/ off code
; 8-bits
	movlw	D'120'		; on/ off
	call	ROLL_8
; stop bits
; 8-bits
	movlw	D'240'		; send stop bits 
	call	ROLL_8
OUT_XM
; transmit ended
; if power on mode
	btfss	GPIO,5		; when set power off mode
	goto	POWER_ON_MODE

; power off mode
	bcf		GPIO,1		; transmit input low
	bcf		GPIO,2		; power on latch off
	
ENDED
	movlw	D'140'
	call	DELAYXX		; 100ms
; if GPIO,0 is low then continue transmission if switch is on
	btfsc	GPIO,0		; retransmit link
	goto	ENDED	
	movlw	D'250'
	call	DELAYXX
	goto	TEST		; retransmit if power available

POWER_ON_MODE ; mode

	bcf		GPIO,1		; transmit input low
	movlw	D'140'
	call	DELAYXX		; 100ms
; if GPIO,0 is low then continue transmission if switch is on
	btfsc	GPIO,0		; retransmit link
	goto	WAIT_GP2	
	movlw	D'25'
	call	DELAYXX
	goto	TEST		; retransmit 
; wait for GP2 to go high
WAIT_GP2
	btfss	GPIO,2
	goto	WAIT_GP2
	movlw	D'140'
	call	DELAYXX		; 100ms	
	goto	TEST		; retransmit 

; ********************************************************************************
	
; Subroutines

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,GO_DONE; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,GO_DONE; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

; send out 8-bits
ROLL_8
	movwf	TEMP
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	return
SET_OUT
	btfss	STATUS,C	; if set send a 1
	goto	CLR_4
	bsf		GPIO,1
	call	DELAY1
	return
CLR_4	
	bcf		GPIO,1
	call	DELAY1
	return

; delay loops
DELAY
	movlw	D'10'		; 5 ms
	goto	DELAYXX		; ms

DELAY1
	movlw	D'2'		; delay value
DELAYXX
	movwf	STORE1		; STORE1 is number of loops value
LOOPA	
	movlw	D'165'
	movwf	STORE2		; STORE2 is internal loop value	
LOOPB
	decfsz	STORE2,f
	goto	LOOPB
	decfsz	STORE1,f
	goto	LOOPA		; decrease till STORE1 is zero
	return


	end
