                                      ; Listing 3.2

                                      ; I/O Schedule
                                      ; Sensors = Port A bits 0-2 (1 = active)
                                      ; Armed/Reset = Port A bit 3
                                      ; (1 = armed / 0 = reset)
                                      ; Output = Port B bit 0 (1 = triggered)

           include "16F627.PLC"       ; Defines PLC instructions

           ld      PORTA, 0           ; Load Sensor 1
           or      PORTA, 1           ; Or with Sensor 2
           or      PORTA, 2           ; Or with Sensor 3
           out     AUX0, 0            ; Output Alarm Sensor Status to AUX0, 0

           ld      AUX0, 0            ; Read Alarm Sensor status (Set input)
           latch   AUX0, 1, AUX0, 2   ; Latched Alarm Status to AUX0 bit 1
                                      ; Reset = AUX0 bit 2

           ld      AUX0, 1            ; Read Latched Alarm status
           timl    0, 0x05            ; Low Speed Timer 0 with 5 second timeout

           ld      TIML, 0            ; Read Alarm Timeout (1 = timeout reached)
           and_not AUX0, 0            ; Don't reset if active (* optional *)
           or_not  PORTA, 3           ; OR with inverted Arm/Disarm input
                                      ; (0 = disabled)
           out     AUX0, 2            ; Output Reset Alarm signal

           ld      AUX0, 1            ; Read Latched Alarm signal
           and_not TIML, 0            ; Disable if timed out (* optional *)
           out     PORTB, 0           ; Alarm output to buzzer / indicator

           endp                       ; Marks end of PLC program