/****************************************************************************
*
*   Module:     ps2keytest.c
*   Author:     Mike Hibbett
*   Date:       19/4/09
*   Purpose:    Example application using the PIC24 PS2 Keyboard Library.
*
****************************************************************************/

/**** INCLUDES *************************************************************/

#include "p24HJ128GP202.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <uart.h>

#include "PIC24ps2key.h"


/**** APPLICATION CONFIG SETTINGS ******************************************/

 _FOSC( POSCMD_HS );
 _FOSCSEL( FNOSC_PRIPLL );
 _FWDT( FWDTEN_OFF & WINDIS_OFF );
 _FICD( ICS_PGD1 & JTAGEN_OFF ); 

/**** CONSTANTS ************************************************************/
#define PLL_80MHZ       38


/**** VARIABLES ************************************************************/

char dspStr[38];


/**** FORWARD DECLARATIONS *************************************************/

extern volatile unsigned char keyBuffer[];

/**** CODE *****************************************************************/

/****************************************************************************
*
*   Function:   serialInit
*   inputs:     None
*   returns:    None
*   Purpose:    sets up a simple 9600 baud serial port on uart1
*
****************************************************************************/
void serialInit( void )
{    
    /* Put UART onto pins RP9 ( RXD ) and RP8 ( TXD ) */
    RPINR18bits.U1RXR = 9;
    RPOR4bits.RP8R = 0b00011;
    
    /* Init UART port, for debugging */
    OpenUART1(  UART_EN & UART_IDLE_CON & 
                UART_IrDA_DISABLE & UART_MODE_SIMPLEX &
                UART_UEN_00 & UART_DIS_WAKE &
                UART_DIS_LOOPBACK & UART_DIS_ABAUD &
                UART_BRGH_SIXTEEN & UART_NO_PAR_8BIT & 
                UART_1STOPBIT,
                UART_INT_TX_BUF_EMPTY &  
                UART_TX_ENABLE & UART_INT_RX_3_4_FUL &  
                UART_ADR_DETECT_DIS & UART_RX_OVERRUN_CLEAR & 
                UART_IrDA_POL_INV_ZERO & UART_SYNC_BREAK_DISABLED,
                259 );
}


/****************************************************************************
*
*   Function:   serialPuts
*   inputs:     string to display
*   returns:    None
*   Purpose:    outputs a null terminated string to the display
*
****************************************************************************/
void serialPuts( char *str )
{    
    while ( *str ) {
        putcUART1(*str);
        str++;
    }
    
}


/****************************************************************************
*
*   Function:   main
*   inputs:     none
*   returns:    exit code to OS environment
*   Purpose:    Main entry point of the sample application.
*
****************************************************************************/

int  main(void)
{
    unsigned char keyval;
        
    // Set processor to run at appropriate speed
    CLKDIVbits.PLLPOST = 0;
    PLLFBDbits.PLLDIV  = PLL_80MHZ;
    
    // Make digital pins I/O rather than analogue
    AD1PCFGL = 0xFFFF;    
    
    serialInit();               
        
    /* Initialise the keyboard interface */
    PIC24ps2keyInit();

    /* - test code - useful for displaying the code of keys pressed
    do {
        keyval = PIC24ps2keyGetByte();
        
        sprintf(dspStr,"%2.2X\r\n", keyval);
        serialPuts(dspStr);
 
    } while (1); // loop forever
    
    */   
    
    // Simple loop reading key presses from the keyboard
    // and echoing out to the serial port.
    do {
        keyval = PIC24ps2keyGetKey();
        
        putcUART1(keyval);
    } while (1); // loop forever

    
    return 0;
}
