; TEACHINF01.ASM 12JUN07 - TEACH IN 2008 PT6
; sound generatiom demo 1

#DEFINE BANK0 BCF STATUS,5    ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5    ; define STATUS register bit 5 set as BANK1

           list p=16f628      ; tell MPASM-type programmer to create a
                              ; list (LST) file

           __config  h'3F21'    ; external xtal (3.2768MHz)

           include p16f628.inc

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

STARTIT:
           movlw 7            ; needed by some PICs, including PIC16F628
           movwf CMCON        ; so that PORTA is treated as digital port

           BANK1
           movlw b'00000000'  ; all PORTA as output
           movwf TRISA        ; data direction register for PORTA
           movlw b'00000000'  ; all PORTB as output
           movwf TRISB        ; data direction register for PORTB
           BANK0

FREQ:      incf PORTA,F       ; inc PORTA
           goto FREQ

           END

