;*****************************************************************************        
;
;   Module:     mmc.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 28/07/06                                            
;
;               Functions to communicate with an MMC Card
;
;*****************************************************************************        



;*****************************************************************************        
;
;   Function :  sendCmd
;               Sends a command to the card
;
;   Input:      MMCCmd, MMCOp1, MMCOp2, MMCOp3, MMCOp4, MMCOp5
;               
;
;   Output:     None
;
;*****************************************************************************        
sendCmd
	movlw   0xFF
	call    TXRX_SPI
	
	movf    MMCCmd, W
	call    TXRX_SPI
	
	movf    MMCOp1, W
	call    TXRX_SPI
	
	movf    MMCOp2, W
	call    TXRX_SPI
	
	movf    MMCOp3, W
	call    TXRX_SPI
	
	movf    MMCOp4, W
	call    TXRX_SPI
	
	movf    MMCOp5, W
	call    TXRX_SPI
	
	movlw   0xFF                ; This one may be redundant; There are 0 .. 8 'nops'
	call    TXRX_SPI
	
	; Get the response code
	movlw   0xFF	
	call    TXRX_SPI
	
    return



;*****************************************************************************        
;
;   Function :  MMCReset
;               MMC Cards require a sequence of atleast 64 clock cycles - 74 
;               recommended - following a power-up. The data line
;               must be held high during this time. As there are 8 clocks per
;               SPI transfer, we do 10 transfers to cover this.
;
;   Input:      None
;               
;
;   Output:     None
;
;*****************************************************************************        
MMCReset  
    movlw   D'10'
    movwf   tmpCount
    
rmc001    
   	movlw   0xFF	
	call    TXRX_SPI
    decfsz  tmpCount, F
    goto    rmc001
    return



;*****************************************************************************        
;
;   Function :  MMCInit
;               Sends CMD0 to the card; a software reset
;
;   Input:      None
;               
;
;   Output:     None
;
;*****************************************************************************        
MMCInit    
    ; First, enable writes
    
    bcf     LATC, DEVICE_CS_BIT ; Enable chip
    
    nop                         ; Chip setup time delay
    nop
    
    movlw   0x40                ; CMD0
    movwf   MMCCmd
    movlw   0x00
    movwf   MMCOp1
    movlw   0x00
    movwf   MMCOp2
    movlw   0x00
    movwf   MMCOp3
    movlw   0x00
    movwf   MMCOp4
    movlw   0x95
    movwf   MMCOp5
    call    sendCmd
        
    bsf     LATC, DEVICE_CS_BIT ; Disable chip 
    
imc001    
    bcf     LATC, DEVICE_CS_BIT ; Enable chip
    
    nop                         ; Chip setup time delay
    nop
    
    movlw   0x41                ; CMD1
    movwf   MMCCmd
    movlw   0x00
    movwf   MMCOp1
    movlw   0x00
    movwf   MMCOp2
    movlw   0x00
    movwf   MMCOp3
    movlw   0x00
    movwf   MMCOp4
    call    sendCmd
        
    bsf     LATC, DEVICE_CS_BIT ; Disable chip 
    sublw   0x00
    btfss   STATUS, Z
    goto    imc001              ; Wait for card to become initialised

    return



;*****************************************************************************        
;
;   Function :  MMCReadBlock
;               Reads data from the card
;
;   Input:      None
;               
;
;   Output:     None
;
;*****************************************************************************        
MMCReadBlock
    ; Setup indirect register to point to the buffer
    lfsr    FSR0, BLOCK_BUFFER_ADDRESS

    bcf     LATC, DEVICE_CS_BIT ; Enable chip
    
    nop                         ; Chip setup time delay
    nop
    
    movlw   0x51                ; CMD17
    movwf   MMCCmd
    movlw   0x95
    movwf   MMCOp5
    call    sendCmd

xxdt000                         ; Wait for start block token ( fe for a single block read )
    sublw   0xFE
    btfsc   STATUS, Z
    goto    xxdt001
	movlw   0xFF  
	call    TXRX_SPI
    goto    xxdt000

xxdt001  
    ; what size is the block? We implement 1 or 512 bytes
    movf    blockSize, W
    sublw   0x01                ; 1 == 512
    btfsc   STATUS, Z
    goto    mdd512
    
    ; get a single byte and return
    movlw   0xFF
	call    TXRX_SPI
	movwf   POSTINC0
    goto    mddexit

mdd512    
    ; get 512 bytes
    clrf   tmpCount
    
mdd000    
	movlw   0xFF  
	call    TXRX_SPI
	movwf   POSTINC0
    decfsz  tmpCount, F
    goto    mdd000

    clrf   tmpCount
    
mdd001    
	movlw   0xFF  
	call    TXRX_SPI
	movwf   POSTINC0
    decfsz  tmpCount, F
    goto    mdd001
    
mddexit    
    bsf     LATC, DEVICE_CS_BIT ; Disable chip 
    
    return
    


;*****************************************************************************        
;
;   Function :  MMCWriteBlock
;               Writes data to the MMC card
;
;   Input:      None
;               
;
;   Output:     None
;
;*****************************************************************************        
MMCWriteBlock    
    ; Setup indirect register to point to the buffer
    lfsr    FSR0, BLOCK_BUFFER_ADDRESS

    bcf     LATC, DEVICE_CS_BIT ; Enable chip
    
    nop                         ; Chip setup time delay
    nop
    
    movlw   0x58        ; CMD24
    movwf   MMCCmd
;    movlw   0x00
;    movwf   MMCOp1
;    movlw   0x00
;    movwf   MMCOp2
;    movlw   0x00
;    movwf   MMCOp3
;    movlw   0x13
;    movwf   MMCOp4
    call    sendCmd

    ; Null bytes - ensure card is ready for write
	movlw   0xFF        
	call    TXRX_SPI
	movlw   0xFF        
	call    TXRX_SPI

	movlw   0xFE                ; Start Data block token  
	call    TXRX_SPI

    ; what size is the block? We implement 1 or 512 bytes
    movf    blockSize, W
    sublw   0x01                ; 1 == 512
    btfsc   STATUS, Z
    goto    mwd512
		
    ; Write the new byte
    movf    POSTINC0, W
	call    TXRX_SPI
    goto    mwdcrc
    
mwd512

    clrf   tmpCount
    
mwd000    
    movf    POSTINC0, W
	call    TXRX_SPI
    decfsz  tmpCount, F
    goto    mwd000

    clrf   tmpCount
    
mwd001    
    movf    POSTINC0, W
	call    TXRX_SPI
    decfsz  tmpCount, F
    goto    mwd001

mwdcrc	
    ; CRC bytes
	movlw   0xFF        
	call    TXRX_SPI
	movlw   0xFF        
	call    TXRX_SPI

    ; Response byte
	movlw   0xFF        
	call    TXRX_SPI

    bsf     LATC, DEVICE_CS_BIT ; Disable chip 
    return



;*****************************************************************************        
;
;   Function :  MMC1ByteBuff
;               Sets the data transfer to a single byte
;
;   Input:      None
;               
;
;   Output:     None
;
;*****************************************************************************        
MMC1ByteBuff    
    bcf     LATC, DEVICE_CS_BIT ; Enable chip
    
    nop                         ; Chip setup time delay
    nop
        
    movlw   0x50        ; CMD16
    movwf   MMCCmd
    movlw   0x00
    movwf   MMCOp1
    movlw   0x00
    movwf   MMCOp2
    movlw   0x00
    movwf   MMCOp3
    movlw   0x01
    movwf   MMCOp4
    call    sendCmd

    bsf     LATC, DEVICE_CS_BIT ; Disable chip 
    return
    
   
    
;*****************************************************************************        
;
;   Function :  MMC512ByteBuff
;               Sets the data transfer to 512 bytes at a time
;
;   Input:      None
;               
;
;   Output:     None
;
;*****************************************************************************        
MMC512ByteBuff
    
    ; First, enable writes
    
    bcf     LATC, DEVICE_CS_BIT ; Enable chip
    
    nop                         ; Chip setup time delay
    nop
        
    movlw   0x50        ; CMD16
    movwf   MMCCmd
    movlw   0x00
    movwf   MMCOp1
    movlw   0x00
    movwf   MMCOp2
    movlw   0x02
    movwf   MMCOp3
    movlw   0x00
    movwf   MMCOp4
    call    sendCmd

    bsf     LATC, DEVICE_CS_BIT ; Disable chip 
    return
   
   
   
;*****************************************************************************        
;
;   Function :  MMCDspType
;               Reads the device id from the mmc card
;
;   Input:      None
;               
;
;   Output:     None
;
;*****************************************************************************        
MMCDspType
    
    ; First, enable writes
    
    bcf     LATC, DEVICE_CS_BIT ; Enable chip
    
    nop                         ; Chip setup time delay
    nop
        
    movlw   0x4A        ; CMD10
    movwf   MMCCmd
    movlw   0x00
    movwf   MMCOp1
    movlw   0x00
    movwf   MMCOp2
    movlw   0x00
    movwf   MMCOp3
    movlw   0x00
    movwf   MMCOp4
    call    sendCmd
    
xdt000
    sublw   0xFE
    btfsc   STATUS, Z
    goto    xdt001
	movlw   0xFF  
	call    TXRX_SPI
    goto    xdt000
    
xdt001    
        
    ; Now read remaining data bytes: there are 16 in total
    DISPLAY_STR STR_CID
    
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
	movlw   0xFF  
	call    TXRX_SPI
    call    DspHexByte      
    
    bsf     LATC, DEVICE_CS_BIT ; Disable chip 

    return
        