VERSION 5.00
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#10.0#0"; "EPESERALIO.OCX"
Begin VB.Form TelescopeInterface 
   Caption         =   "Meade Telescope Interface V1.0 06JUN05"
   ClientHeight    =   6075
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7095
   Icon            =   "TelescopeInterface.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6075
   ScaleWidth      =   7095
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer Timer3 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   1920
      Top             =   3360
   End
   Begin VB.CommandButton LocalTime 
      BackColor       =   &H0000FF00&
      Caption         =   "Send GPRMC"
      Height          =   495
      Left            =   3000
      Style           =   1  'Graphical
      TabIndex        =   37
      ToolTipText     =   "Sends local time etc to PIC as GPS $GPRMC sentence"
      Top             =   2400
      Width           =   855
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      ItemData        =   "TelescopeInterface.frx":0442
      Left            =   3000
      List            =   "TelescopeInterface.frx":0444
      TabIndex        =   35
      Text            =   "9600"
      ToolTipText     =   "Shows selected Baud rate, click arrow to select another from the list shown"
      Top             =   840
      Width           =   855
   End
   Begin VB.CommandButton Notes 
      BackColor       =   &H00FFFF00&
      Caption         =   "Notes"
      Height          =   495
      Left            =   3000
      Style           =   1  'Graphical
      TabIndex        =   34
      ToolTipText     =   "Displays brief notes about this screen's use"
      Top             =   3000
      Width           =   855
   End
   Begin VB.CommandButton cmdAbort 
      BackColor       =   &H000080FF&
      Caption         =   "Abort"
      Height          =   375
      Left            =   6600
      Style           =   1  'Graphical
      TabIndex        =   33
      Top             =   0
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.CheckBox ListOn 
      Caption         =   "List On/Off"
      Height          =   255
      Left            =   5760
      TabIndex        =   32
      ToolTipText     =   "When ticked shows in list box telescope codes input from PIC"
      Top             =   3480
      Width           =   1095
   End
   Begin VB.CommandButton PICtest 
      BackColor       =   &H0000FF00&
      Caption         =   "Send Test Codes "
      Height          =   495
      Left            =   3000
      Style           =   1  'Graphical
      TabIndex        =   31
      ToolTipText     =   "Sends GPS test codes to PIC for viewing on its screen"
      Top             =   1800
      Width           =   855
   End
   Begin VB.Timer Timer2 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   1440
      Top             =   3360
   End
   Begin VB.CommandButton SaveSettings 
      BackColor       =   &H0000FFFF&
      Caption         =   "Save Settings"
      Height          =   375
      Left            =   5520
      Style           =   1  'Graphical
      TabIndex        =   28
      ToolTipText     =   "Saves settings in custom panel to disk for future recall"
      Top             =   2160
      Width           =   1215
   End
   Begin VB.CommandButton SendTime 
      BackColor       =   &H0000FF00&
      Caption         =   "Send To PIC"
      Height          =   375
      Left            =   4080
      Style           =   1  'Graphical
      TabIndex        =   25
      ToolTipText     =   "Sends custom codes plus time & date to PIC. Also saves settings to disk for future recall"
      Top             =   2160
      Width           =   1215
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Index           =   2
      Left            =   5880
      TabIndex        =   24
      Text            =   "+00"
      Top             =   1440
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Index           =   1
      Left            =   5880
      TabIndex        =   23
      Text            =   "W 001.54"
      Top             =   1200
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Index           =   0
      Left            =   5880
      TabIndex        =   22
      Text            =   "N 50.48"
      Top             =   960
      Width           =   855
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   1080
      Top             =   3360
   End
   Begin VB.ListBox List1 
      Height          =   2010
      Left            =   240
      TabIndex        =   3
      ToolTipText     =   "Used for additional display of telescope codes, and confirmation of custom codes sent to PIC"
      Top             =   3840
      Width           =   6615
   End
   Begin VB.OptionButton Port 
      Caption         =   "COM2"
      Height          =   220
      Index           =   1
      Left            =   3000
      TabIndex        =   2
      ToolTipText     =   "Selects COM2 port for data comms"
      Top             =   360
      Width           =   855
   End
   Begin VB.OptionButton Port 
      Caption         =   "COM1"
      Height          =   220
      Index           =   0
      Left            =   3000
      TabIndex        =   1
      ToolTipText     =   "Selects COM1 port for data comms"
      Top             =   120
      Value           =   -1  'True
      Width           =   855
   End
   Begin VB.CommandButton Start 
      BackColor       =   &H0000FF00&
      Caption         =   "Start Input"
      Height          =   495
      Left            =   3000
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "Starts input of data from PIC unit for display in left-hand panel"
      Top             =   1200
      Width           =   855
   End
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   2400
      Top             =   3240
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin VB.CommandButton StopIt 
      BackColor       =   &H000000FF&
      Caption         =   "Stop"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3000
      Style           =   1  'Graphical
      TabIndex        =   4
      ToolTipText     =   "Stops current running process. There may be a delay before response"
      Top             =   3000
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.Label Label12 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Greenwich Sidereal Time"
      Height          =   255
      Left            =   1680
      TabIndex        =   43
      Top             =   4800
      Width           =   1935
   End
   Begin VB.Label Label11 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   255
      Left            =   3600
      TabIndex        =   42
      Top             =   5040
      Width           =   1695
   End
   Begin VB.Label Label10 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Local Sidereal Time"
      Height          =   255
      Left            =   1680
      TabIndex        =   41
      Top             =   5040
      Width           =   1935
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Height          =   255
      Left            =   3600
      TabIndex        =   40
      Top             =   4800
      Width           =   1695
   End
   Begin VB.Label Label8 
      BackColor       =   &H00FFFF00&
      Height          =   255
      Left            =   1680
      TabIndex        =   39
      ToolTipText     =   "Current UTC (GMT) time and date (if your PC clock is correct!)"
      Top             =   4080
      Width           =   3615
   End
   Begin VB.Label Label7 
      BackColor       =   &H00FFFF00&
      Height          =   255
      Left            =   600
      TabIndex        =   38
      ToolTipText     =   "GPS sentence being sent to PIC"
      Top             =   4440
      Width           =   5895
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "Baud Rate"
      Height          =   255
      Left            =   3000
      TabIndex        =   36
      ToolTipText     =   "Shows selected Baud rate, click arrow to select another from the list shown"
      Top             =   600
      Width           =   855
   End
   Begin VB.Label DSTlabel 
      Caption         =   "0"
      Height          =   255
      Left            =   5880
      TabIndex        =   30
      Top             =   1800
      Width           =   615
   End
   Begin VB.Label Label6 
      Caption         =   "Daylight Saving Time = "
      Height          =   255
      Left            =   4080
      TabIndex        =   29
      ToolTipText     =   "This is automatically updated from the PC's system"
      Top             =   1800
      Width           =   1695
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Codes are input when PIC unit is connected to PC instead of to Meade telescope"
      ForeColor       =   &H00C00000&
      Height          =   615
      Left            =   360
      TabIndex        =   27
      Top             =   2520
      Width           =   2415
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "Also sends current time and calendar data to PIC"
      ForeColor       =   &H00C00000&
      Height          =   375
      Left            =   4200
      TabIndex        =   26
      Top             =   2760
      Width           =   2415
   End
   Begin VB.Label Custom 
      Caption         =   "UTC Offset +/- hours"
      Height          =   255
      Index           =   2
      Left            =   4080
      TabIndex        =   21
      ToolTipText     =   "Your timezone offset from Greenwich UK is entered to the right"
      Top             =   1440
      Width           =   1695
   End
   Begin VB.Label Custom 
      Caption         =   "Longitude W/E deg.min"
      Height          =   255
      Index           =   1
      Left            =   4080
      TabIndex        =   20
      ToolTipText     =   "Your local longitude is entered to the right"
      Top             =   1200
      Width           =   1695
   End
   Begin VB.Label Custom 
      Caption         =   "Latitude     N/S deg.min"
      Height          =   255
      Index           =   0
      Left            =   4080
      TabIndex        =   19
      ToolTipText     =   "Your local latitude is entered to the right"
      Top             =   960
      Width           =   1695
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   "Customised Data Codes"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   495
      Left            =   4200
      TabIndex        =   18
      Top             =   360
      Width           =   2415
   End
   Begin VB.Label GPRMC 
      Appearance      =   0  'Flat
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   5
      Left            =   1440
      TabIndex        =   17
      ToolTipText     =   "Your local offset from Greenwhich UK output for telescope"
      Top             =   1920
      Width           =   1335
   End
   Begin VB.Label GPRMCtext 
      Appearance      =   0  'Flat
      Caption         =   "UTC Offset   (incl DST)"
      ForeColor       =   &H80000008&
      Height          =   420
      Index           =   5
      Left            =   360
      TabIndex        =   16
      ToolTipText     =   "Your local offset from Greenwhich UK output for telescope"
      Top             =   1920
      Width           =   855
   End
   Begin VB.Label GPRMC 
      Appearance      =   0  'Flat
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   4
      Left            =   1440
      TabIndex        =   15
      ToolTipText     =   "Your local longitude output for telescope"
      Top             =   1680
      Width           =   1335
   End
   Begin VB.Label Label1 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   240
      TabIndex        =   14
      Top             =   3480
      Width           =   5295
   End
   Begin VB.Shape Shape2 
      BorderColor     =   &H00C00000&
      BorderWidth     =   2
      Height          =   3135
      Left            =   3960
      Shape           =   4  'Rounded Rectangle
      Top             =   240
      Width           =   2895
   End
   Begin VB.Shape Shape1 
      BorderColor     =   &H00C00000&
      BorderWidth     =   2
      Height          =   3135
      Left            =   240
      Shape           =   4  'Rounded Rectangle
      Top             =   240
      Width           =   2655
   End
   Begin VB.Label GPRMCtext 
      Appearance      =   0  'Flat
      Caption         =   "Date Local"
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   1
      Left            =   360
      TabIndex        =   13
      ToolTipText     =   "Your local date output for telescope"
      Top             =   1200
      Width           =   855
   End
   Begin VB.Label GPRMCtext 
      Appearance      =   0  'Flat
      Caption         =   "Longitude"
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   4
      Left            =   360
      TabIndex        =   12
      ToolTipText     =   "Your local longitude output for telescope"
      Top             =   1680
      Width           =   735
   End
   Begin VB.Label GPRMCtext 
      Appearance      =   0  'Flat
      Caption         =   "Latitude"
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   3
      Left            =   360
      TabIndex        =   11
      ToolTipText     =   "Your local latitude output for telescope"
      Top             =   1440
      Width           =   735
   End
   Begin VB.Label GPRMCtext 
      Appearance      =   0  'Flat
      Caption         =   "Time Local"
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   2
      Left            =   360
      TabIndex        =   10
      ToolTipText     =   "Your local time output for telescope"
      Top             =   960
      Width           =   855
   End
   Begin VB.Label GPRMC 
      Appearance      =   0  'Flat
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   11
      Left            =   2520
      TabIndex        =   9
      Top             =   2040
      Width           =   255
   End
   Begin VB.Label GPRMC 
      Appearance      =   0  'Flat
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   1
      Left            =   1440
      TabIndex        =   8
      ToolTipText     =   "Your local date output for telescope"
      Top             =   1200
      Width           =   1335
   End
   Begin VB.Label GPRMC 
      Appearance      =   0  'Flat
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   3
      Left            =   1440
      TabIndex        =   7
      ToolTipText     =   "Your local latitude output for telescope"
      Top             =   1440
      Width           =   1335
   End
   Begin VB.Label GPRMC 
      Appearance      =   0  'Flat
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   2
      Left            =   1440
      TabIndex        =   6
      ToolTipText     =   "Your local time output for telescope"
      Top             =   960
      Width           =   1335
   End
   Begin VB.Label GPRMC 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      Caption         =   "Codes Sent To Telescope "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   495
      Index           =   0
      Left            =   480
      TabIndex        =   5
      Top             =   360
      Width           =   2175
   End
End
Attribute VB_Name = "TelescopeInterface"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' EPE Meade Telescope Interface 06JUN05 Copyright John Becker

Dim sDataBlock                      As String
Dim OCXport As Integer
Dim A, B, C, E, F, L As Long
Dim D As Double
Dim TempA$, TempB$
Dim BaudVal
Dim bError                          As Boolean
Dim nBlockNumber                    As Integer
Dim TimeVal(12), DateInfo$, CheckSum
Dim DA$(10), Latitude$, Longitude$, MonthsVal(12), MonthName(12), AX(50)
Dim Secs, Mins, Hours, Days, Months, Years, Offset, DST, UTC$, Seconds
Dim Fname, CheckValue, AA$, AT$
Dim UTCSiderealHours As Double
Dim UTCSiderealMins As Double
Dim UTCSiderealSecs As Double
Dim LocalSiderealHours As Double
Dim LocalSiderealMins As Double
Dim LocalSiderealSecs As Double
Dim LMST As Double
Dim GMST As Double
Dim Dwhole As Double
Dim Dfrac As Double

Private Sub Combo1_click()
BaudVal = Combo1.Text
SendTime.SetFocus
End Sub

Private Sub Form_Load()
On Error GoTo ShowError

MonthsVal(1) = 31: MonthName(1) = "JAN"
MonthsVal(2) = 28: MonthName(2) = "FEB"
MonthsVal(3) = 31: MonthName(3) = "MAR"
MonthsVal(4) = 30: MonthName(4) = "APR"
MonthsVal(5) = 31: MonthName(5) = "MAY"
MonthsVal(6) = 30: MonthName(6) = "JUN"
MonthsVal(7) = 31: MonthName(7) = "JUL"
MonthsVal(8) = 31: MonthName(8) = "AUG"
MonthsVal(9) = 30: MonthName(9) = "SEP"
MonthsVal(10) = 31: MonthName(10) = "OCT"
MonthsVal(11) = 30: MonthName(11) = "NOV"
MonthsVal(12) = 31: MonthName(12) = "DEC"

Combo1.AddItem "19200"
Combo1.AddItem "9600"
Combo1.AddItem "4800"
Combo1.AddItem "2400"

Call DSTcheck: DSTlabel = DST

BaudVal = 9600
OCXport = 2

TempB$ = CurDir & "\TelescopeSettings.txt"
Open TempB$ For Input As #1
Input #1, TempA$: BaudVal = Val(TempA$)
Input #1, TempA$: OCXport = Val(TempA$)
Input #1, TempA$: Text1(0) = TempA$
Input #1, TempA$: Text1(1) = TempA$
Input #1, TempA$: Text1(2) = TempA$
Close
Combo1.Text = BaudVal
Port(OCXport - 1).Value = True
Exit Sub

ShowError:
Call SaveSettings_Click
Resume

End Sub

Private Sub Form_unLoad(Cancel As Integer)
End
End Sub

Private Sub Notes_Click()
Fname = "TelescopeNotes.txt"
ProcessID = Shell("Notepad " & Fname, vbNormalFocus)
End Sub

Private Sub Port_Click(Index As Integer)
OCXport = Index + 1
Call SaveSettings_Click
End Sub


Public Sub Start_Click()
GPRMC(0) = "Telescope Output Codes"
'Start.Visible = False
StopIt.Visible = True
Timer1.Enabled = True
SendTime.Enabled = False
SaveSettings.Enabled = False
Text1(0).Enabled = False
Text1(1).Enabled = False
Text1(2).Enabled = False
Combo1.Enabled = False
Start.Enabled = False
LocalTime.Enabled = False
Port(0).Enabled = False
Port(1).Enabled = False

Notes.Visible = False
List1.Clear
Label1.Caption = "Meade Codes Received as a Non-Sync Sentence"
    
    With EPESerial1
        .RxBlockSize = 2
        .RxMode = sioBlockMode
        .ComPort = OCXport
            
    Select Case BaudVal
    Case 19200
        .Speed = sio19200       ' Setup the COM port parameters
    Case 9600
        .Speed = sio9600       ' Setup the COM port parameters
    Case 4800
        .Speed = sio4800       ' Setup the COM port parameters
    Case 2400
        .Speed = sio2400       ' Setup the COM port parameters
    End Select
        
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False  ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 10      ' PIC must always respond within 10 seconds
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer ' Always do this after we open the port to make sure the buffer is really empty
        End With
        
End Sub
        
Private Sub GetBlock()
    With EPESerial1
 .RxBlockSize = 64       ' Reconfigure block size to accept actual data packets - 256 Bytes of data + CR+LF
 .ProgressEvents = True
 .TimeOut = 5           ' PIC must always respond within 5 seconds
   
  sDataBlock = .ReceiveText
  If sDataBlock = "" Then
  List1.AddItem "Signal not received"
  Exit Sub
  Else
If ListOn.Value = 1 Then List1.AddItem sDataBlock
  
D = 0: E = 2: For C = 1 To Len(sDataBlock)
If Mid$(sDataBlock, C, 1) = "#" Then
DA$(D) = Mid$(sDataBlock, E, C + 1 - E): E = C + 1
If ListOn.Value = 1 Then List1.AddItem DA$(D)
TempA$ = Left$(DA$(D), 3)

Select Case TempA$

Case ":SL"
GPRMC(2) = DA$(D)
Case ":SC"
GPRMC(1) = DA$(D)
Case ":St"
GPRMC(3) = DA$(D)
Case ":Sg"
GPRMC(4) = DA$(D)
Case ":SG"
GPRMC(5) = DA$(D)

End Select

D = D + 1
End If
Next
If ListOn.Value = 1 Then List1.AddItem ""

  End If
   End With

End Sub

Private Sub Timer1_Timer()
Call GetBlock
End Sub

Private Sub SendTime_Click()

List1.Clear

If Len(Text1(0)) <> 7 Then
TempB$ = "Latitude must be in the form N 50.48" & Chr(13) & Chr(10)
TempB$ = TempB$ & "7 characters long, starting N or S, followed by a space" & Chr(13) & Chr(10)
TempB$ = TempB$ & "then degrees as 2 digits, a decimal point, then minutes as 2 digits" & Chr(13) & Chr(10) & Chr(13)
TempB$ = TempB$ & "Data send has been aborted"
Beep
MsgBox TempB$, vbCritical
Exit Sub
End If

If Len(Text1(1)) <> 8 Then
TempB$ = "Longitude must be in the form W 001.54" & Chr(13) & Chr(10)
TempB$ = TempB$ & "8 characters long, starting W or E, followed by a space" & Chr(13) & Chr(10)
TempB$ = TempB$ & "then degrees as 3 digits, a decimal point, then minutes as 2 digits" & Chr(13) & Chr(10) & Chr(13)
TempB$ = TempB$ & "Data send has been aborted"
Beep
MsgBox TempB$, vbCritical
Exit Sub
End If

If Len(Text1(2)) <> 3 Then
TempB$ = "UTC offset must be in the form +00" & Chr(13) & Chr(10)
TempB$ = TempB$ & "3 characters long, starting + or - and followed by the" & Chr(13) & Chr(10)
TempB$ = TempB$ & "hours difference as 2 digits" & Chr(13) & Chr(10) & Chr(13)
TempB$ = TempB$ & "Data send has been aborted"
Beep
MsgBox TempB$, vbCritical
Exit Sub
End If

If Left$(Text1(0), 1) = "N" Then
Latitude$ = "+" & Mid$(Text1(0), 3)
Else
Latitude$ = "-" & Mid$(Text1(0), 3)
End If

If Left$(Text1(1), 1) = "W" Then
degrees = (Val(Mid$(Text1(1), 3, 1)) * 100) + (Val(Mid$(Text1(1), 4, 1)) * 10) + Val(Mid$(Text1(1), 5, 1))
minutes = Val(Mid$(Text1(1), 7, 1)) * 10 + Val(Mid$(Text1(1), 8, 1))
TempA$ = Right$("00" & degrees, 3)
TempB$ = Right$("0" & minutes, 2)
Longitude$ = TempA$ & "." & TempB$
Else
degrees = (Val(Mid$(Text1(1), 3, 1)) * 100) + (Val(Mid$(Text1(1), 4, 1)) * 10) + Val(Mid$(Text1(1), 5, 1))
minutes = Val(Mid$(Text1(1), 7, 1)) * 10 + Val(Mid$(Text1(1), 8, 1))
degrees = 360 - degrees
If minutes > 0 Then minutes = 60 - minutes: degrees = degrees - 1
If degrees >= 360 Then degrees = degrees - 360
TempA$ = Right$("00" & degrees, 3)
TempB$ = Right$("0" & minutes, 2)
Longitude$ = TempA$ & "." & TempB$
End If

Call DSTcheck

AA$ = Date$: AT$ = Time$

TimeVal(0) = Val(Mid$(AT$, 7, 1)) * 16 + Val(Mid$(AT$, 8, 1)) ' secs
TimeVal(1) = Val(Mid$(AT$, 4, 1)) * 16 + Val(Mid$(AT$, 5, 1)) ' mins
TimeVal(2) = Val(Mid$(AT$, 1, 1)) * 16 + Val(Mid$(AT$, 2, 1)) ' mins
TimeVal(3) = 0                                                ' weekday - not used
TimeVal(4) = Val(Mid$(AA$, 4, 1)) * 16 + Val(Mid$(AA$, 5, 1)) ' date (day)
TimeVal(5) = Val(Mid$(AA$, 1, 1)) * 16 + Val(Mid$(AA$, 2, 1)) ' month
TimeVal(6) = Val(Mid$(AA$, 9, 1)) * 16 + Val(Mid$(AA$, 10, 1)) ' year
TimeVal(7) = DST
Counter = 0

Call SaveSettings_Click
    
    bError = False
    With EPESerial1
        .RxBlockSize = 1
        .RxMode = sioBlockMode
        .ComPort = OCXport
    Select Case BaudVal
    Case 19200
        .Speed = sio19200       ' Setup the COM port parameters
    Case 9600
        .Speed = sio9600       ' Setup the COM port parameters
    Case 4800
        .Speed = sio4800       ' Setup the COM port parameters
    Case 2400
        .Speed = sio2400       ' Setup the COM port parameters
    End Select

        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False  ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 5  ' 1
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer ' Always do this after we open the port to make sure the buffer is really empty

        .SendText "T"       ' Tell the PIC to get ready to receive time data
        sDataBlock = .ReceiveText: If sDataBlock <> "R" Then GoTo ErrorHandler

TempA$ = ""
For A = 0 To 7
        .SendText Chr$(TimeVal(A))
        sDataBlock = .ReceiveText
        If sDataBlock <> Chr$(TimeVal(A)) Then GoTo ErrorHandler
TempA$ = TempA$ & TimeVal(A) & " "
Next: List1.AddItem TempA$: List1.Refresh

For A = 1 To 6
        .SendText Mid$(Latitude$, A, 1)
        sDataBlock = .ReceiveText
        If sDataBlock <> Mid$(Latitude$, A, 1) Then GoTo ErrorHandler
Next: List1.AddItem "Latitude Degrees " & Latitude$: List1.Refresh

For A = 1 To 6
        .SendText Mid$(Longitude$, A, 1)
        sDataBlock = .ReceiveText
        If sDataBlock <> Mid$(Longitude$, A, 1) Then GoTo ErrorHandler
Next: List1.AddItem "Longitude Degrees " & Longitude$: List1.Refresh
        
For A = 1 To 3
        .SendText Mid$(Text1(2), A, 1)
        sDataBlock = .ReceiveText
        If sDataBlock <> Mid$(Text1(2), A, 1) Then
        x = x
        GoTo ErrorHandler
        End If
Next

List1.AddItem "UTC Offset " & Text1(2): List1.Refresh
List1.AddItem "DST value " & DST
List1.AddItem ""
List1.AddItem "FINISHED DATA SEND"
        .PortStatus = sioPortClosed
Label1.Caption = "Settings sent to PIC"
        Exit Sub
    
ErrorHandler:
        Close
        Beep
TempA$ = "Handshake reply not received from PIC " & Chr(13) & Chr(10)
TempA$ = TempA$ & "Check your power and serial port connections"
    MsgBox TempA$, vbOKOnly + vbCritical
    EPESerial1.PortStatus = sioPortClosed
        
        End With
End Sub

Private Sub SaveSettings_Click()
Close
BaudVal = Combo1.Text
Open "TelescopeSettings.txt" For Output As #1
Print #1, BaudVal & " Baudrate"
Print #1, OCXport & " Comport val + 1"
Print #1, Text1(0)
Print #1, Text1(1)
Print #1, Text1(2)
Close

End Sub

Public Sub DSTcheck()
   
    Dim objTimeZone As TIME_ZONE_INFORMATION
    Dim lResult     As Long
    
    lResult = GetTimeZoneInformation&(objTimeZone)

    Select Case lResult
    Case 2 ' DST
'        MsgBox "DST in use"
        DST = 1
    
    Case Else
'        MsgBox "Standard Time in use"
        DST = 0
    End Select
End Sub

Private Sub ConvertToUTC()

If Len(Text1(0)) <> 7 Then
TempB$ = "Latitude must be in the form N 50.48" & Chr(13) & Chr(10)
TempB$ = TempB$ & "7 characters long, starting N or S, followed by a space" & Chr(13) & Chr(10)
TempB$ = TempB$ & "then degrees as 2 digits, a decimal point, then minutes as 2 digits" & Chr(13) & Chr(10) & Chr(13)
TempB$ = TempB$ & "Data send has been aborted"
Beep
MsgBox TempB$, vbCritical
Call StopIt_Click
Exit Sub
End If

If Len(Text1(1)) <> 8 Then
TempB$ = "Longitude must be in the form W 001.54" & Chr(13) & Chr(10)
TempB$ = TempB$ & "8 characters long, starting W or E, followed by a space" & Chr(13) & Chr(10)
TempB$ = TempB$ & "then degrees as 3 digits, a decimal point, then minutes as 2 digits" & Chr(13) & Chr(10) & Chr(13)
TempB$ = TempB$ & "Data send has been aborted"
Beep
MsgBox TempB$, vbCritical
Call StopIt_Click
Exit Sub
End If

If Len(Text1(2)) <> 3 Then
TempB$ = "UTC offset must be in the form +00" & Chr(13) & Chr(10)
TempB$ = TempB$ & "3 characters long, starting + or - and followed by the" & Chr(13) & Chr(10)
TempB$ = TempB$ & "hours difference as 2 digits" & Chr(13) & Chr(10) & Chr(13)
TempB$ = TempB$ & "Data send has been aborted"
Beep
MsgBox TempB$, vbCritical
Call StopIt_Click
Exit Sub
End If

If Left$(Text1(0), 1) = "N" Then
Latitude$ = "+" & Mid$(Text1(0), 3)
Else
Latitude$ = "-" & Mid$(Text1(0), 3)
End If

If Left$(Text1(1), 1) = "W" Then
degrees = (Val(Mid$(Text1(1), 3, 1)) * 100) + (Val(Mid$(Text1(1), 4, 1)) * 10) + Val(Mid$(Text1(1), 5, 1))
minutes = Val(Mid$(Text1(1), 7, 1)) * 10 + Val(Mid$(Text1(1), 8, 1))
TempA$ = Right$("00" & degrees, 3)
TempB$ = Right$("0" & minutes, 2)
Longitude$ = TempA$ & "." & TempB$
Else
degrees = (Val(Mid$(Text1(1), 3, 1)) * 100) + (Val(Mid$(Text1(1), 4, 1)) * 10) + Val(Mid$(Text1(1), 5, 1))
minutes = Val(Mid$(Text1(1), 7, 1)) * 10 + Val(Mid$(Text1(1), 8, 1))
degrees = 360 - degrees
If minutes > 0 Then minutes = 60 - minutes: degrees = degrees - 1
If degrees >= 360 Then degrees = degrees - 360
TempA$ = Right$("00" & degrees, 3)
TempB$ = Right$("0" & minutes, 2)
Longitude$ = TempA$ & "." & TempB$
End If

Call DSTcheck
AA$ = Date$: AT$ = Time$

Months = Val(Left$(AA$, 2)): Days = Val(Mid$(AA$, 4, 2)): Years = Val(Right$(AA$, 2))
Offset = Val(Mid$(Text1(2), 2, 2))

Hours = Val(Left$(AT$, 2)): Mins = Val(Mid$(AT$, 4, 2)): Secs = Val(Right$(AT$, 2))
Offset = DST + Val(Mid$(Text1(2), 2))
Hours = Hours - Offset

If Hours < 0 Then
Hours = Hours + 24: Days = Days - 1

If Days < 1 Then
Months = Months - 1
If Months < 1 Then Months = 12: Years = Years - 1
Days = MonthsVal(Months)
End If
End If

If Years / 4 = Years \ 4 Then MonthsVal(2) = 29

UTChours = Hours
UTC$ = Right$("0" & Hours, 2) & Right$("0" & Mins, 2) & Right$("0" & Secs, 2)
DateInfo$ = Right$("0" & Months, 2) & Right$("0" & Days, 2) & Right$("0" & Years, 2)

Latitude$ = Mid$(Text1(0), 3, 2) & Mid$(Text1(0), 6, 2)
Longitude$ = Mid$(Text1(1), 3, 3) & Mid$(Text1(1), 7, 2)

TempA$ = "$GPRMC," & UTC$ & ",A," & Latitude$ & ".000," & Left$(Text1(0), 1)
TempA$ = TempA$ & "," & Longitude$ & ".000," & Left$(Text1(1), 1)
TempA$ = TempA$ & ",000.0,000.0," & DateInfo$ & ",000.0,E"
CheckSum = 0

'TempA$ = "$GPRMC,102618,A,5048.349,N,00154.706,W,000.0,315.2,062905,003.8,W"
'TempA$ = "$GPRMC,182923,A,5122.921,N,00007.027,E,000.0,360.0,290603,003.1,W" ' *62

For A = 2 To Len(TempA$)
CheckSum = CheckSum Xor Asc(Mid$(TempA$, A, 1)): Next
TempA$ = TempA$ & "*" & Right$("0" & Hex$(CheckSum), 2)
  
   With EPESerial1
        .SendText TempA$
   End With

Label7 = " " & TempA$

TempA$ = " UTC = " & Right$("0" & Hours, 2) & ":" & Right$("0" & Mins, 2) & "." & Right$("0" & Secs, 2)
TempA$ = TempA$ & "  " & Right$("0" & Days, 2) & MonthName(Months) & Right$("0" & Years, 2)
TempA$ = TempA$ & "     PC time = " & AT$
Label8 = TempA$
Label7.Refresh
Label8.Refresh
'AA$ = Date$
AA$ = Right$("0" & Months, 2) & "-" & Right$("0" & Days, 2) & "-20" & Right$("0" & Years, 2)
AT$ = Right$("0" & Hours, 2) & ":" & Right$("0" & Mins, 2) & "." & Right$("0" & Secs, 2)
'Call SiderealTime_Click
Call SiderealNew
End Sub

Private Sub StopIt_Click()
PICtest.Enabled = True
Timer1.Enabled = False
Timer2.Enabled = False
Timer3.Enabled = False
List1.Visible = True
Notes.Visible = True
SendTime.Enabled = True
SaveSettings.Enabled = True
Text1(0).Enabled = True
Text1(1).Enabled = True
Text1(2).Enabled = True
Combo1.Enabled = True
Start.Enabled = True
LocalTime.Enabled = True
Port(0).Enabled = True
Port(1).Enabled = True
ListOn.Enabled = True

        With EPESerial1
     .PortStatus = sioPortClosed
     Close
   End With
Start.Enabled = True
StopIt.Visible = False
End Sub

Private Sub Timer2_Timer()
Call SendPic
End Sub

Private Sub PICtest_Click()
Label1.Caption = "Test codes sent to PIC"
Notes.Visible = False
StopIt.Visible = True
PICtest.Enabled = False
SendTime.Enabled = False
SaveSettings.Enabled = False
Text1(0).Enabled = False
Text1(1).Enabled = False
Text1(2).Enabled = False
Combo1.Enabled = False
Start.Enabled = False
LocalTime.Enabled = False
Port(0).Enabled = False
Port(1).Enabled = False
ListOn.Enabled = False

List1.Clear

A = 0: Open "GPSreceivedText.txt" For Input As #2
getit: If EOF(2) Then Close: GoTo SetPort
Line Input #2, TempA$
If Left$(TempA$, 1) = "$" And Left$(Right$(TempA$, 3), 1) = "*" Then
AX(A) = TempA$
List1.AddItem TempA$
A = A + 1:
End If
GoTo getit

SetPort:
    
    With EPESerial1
        .RxBlockSize = 1024
        .RxMode = sioBlockMode
        .ComPort = OCXport
    Select Case BaudVal
    Case 19200
        .Speed = sio19200       ' Setup the COM port parameters
    Case 9600
        .Speed = sio9600       ' Setup the COM port parameters
    Case 4800
        .Speed = sio4800       ' Setup the COM port parameters
    Case 2400
        .Speed = sio2400       ' Setup the COM port parameters
    End Select
        
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False  ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 5       ' PIC must always respond within 5 seconds
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer ' Always do this after we open the port to make sure the buffer is really empty
        End With
        
Timer2.Enabled = True

End Sub

Private Sub SendPic()
For B = 0 To A
    With EPESerial1
        .SendText AX(B)
        End With
Next

End Sub

Private Sub LocalTime_Click()
List1.Visible = False
Label1 = ""
Notes.Visible = False
StopIt.Visible = True
PICtest.Enabled = False
SendTime.Enabled = False
SaveSettings.Enabled = False
Text1(0).Enabled = False
Text1(1).Enabled = False
Text1(2).Enabled = False
Combo1.Enabled = False
Start.Enabled = False
LocalTime.Enabled = False
Port(0).Enabled = False
Port(1).Enabled = False
ListOn.Enabled = False
Timer3.Enabled = True

    bError = False
    With EPESerial1
        .RxBlockSize = 1
        .RxMode = sioBlockMode
        .ComPort = OCXport
    Select Case BaudVal
    Case 19200
        .Speed = sio19200       ' Setup the COM port parameters
    Case 9600
        .Speed = sio9600       ' Setup the COM port parameters
    Case 4800
        .Speed = sio4800       ' Setup the COM port parameters
    Case 2400
        .Speed = sio2400       ' Setup the COM port parameters
    End Select

        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False  ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 5  ' 1
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer ' Always do this after we open the port to make sure the buffer is really empty

        End With

End Sub

Private Sub Timer3_Timer()
Call ConvertToUTC
End Sub

Private Sub ShowGPS() ' NOT USED

CheckSum = Right$(TempA$, 2)
CheckValue = 0
For C = 2 To Len(TempA$) - 3
CheckValue = CheckValue Xor Asc(Mid$(TempA$, C, 1))
Next

If CheckValue = Val("&h" & CheckSum) Then
TempB$ = "OK"
Else
TempB$ = Hex$(CheckValue) & " Wrong"
End If

End Sub

Private Sub SiderealNew()
'-----------------------------------------------------------------
'Calculating mean and apparent sidereal time
'-----------------------------------------------------------------

'Finding the days since J2000.0
'------------------------------

'The formula below will find the days for any date after 1900 and before 2099.

'Year is y, month m, date in the month is dday, and UTC is in hrs, mins, seconds

'AA$ = "06:03:2005": AT$ = "22:59:58"
'aa$ = "06:04:2005": at$ = "12:00:33"
'AA$ = "06:04:2005": AT$ = "17:21:49"

'AA$ = "06:16:1994": AT$ = "18:00:00" '1994 June 16th at 18h UT.

y = Val(Right$(AA$, 4)): m = Val(Left$(AA$, 2))
dDay = Val(Mid$(AA$, 4, 2)): m = Val(Left$(AA$, 2))
h = Val(Left$(AT$, 2)): Mins = Val(Mid$(AT$, 4, 2)): Seconds = Val(Right$(AT$, 2))

Dwhole = 367 * y - Int(7 * (y + Int((m + 9) / 12)) / 4) + Int(275 * m / 9) + dDay - 730531.5
Dfrac = (h + Mins / 60 + Seconds / 3600) / 24: D = Dwhole + Dfrac

'dwhole is total number of days, dfrac is
'the fraction of a day worked out from the UTC hours, minutes and seconds.
'd is the total

'The mean sidereal time at zero longitude is often called
'Greenwich Mean sidereal Time or GMST. GST is in degrees
'Subtract multiples of 360 to bring the answer into the range 0 to 360 degrees.

GMST = 280.46061837 + 360.98564736629 * D
A = GMST \ 360: B = GMST - (A * 360): GMST = B: If GMST < 0 Then GMST = 360 + GMST
UTCSiderealHours = GMST \ 15: A = GMST / 15 - UTCSiderealHours
UTCSiderealMins = Int(A * 60)
If UTCSiderealMins < 0 Then UTCSiderealMins = 60 + UTCSiderealMins

B = (A * 60) - UTCSiderealMins: UTCSiderealSecs = Int(B * 60)

TempA$ = Right$("0" & UTCSiderealHours, 2) & ":" & Right$("0" & UTCSiderealMins, 2)
TempA$ = TempA$ & ":" & Right$("0" & UTCSiderealSecs, 2)
Label9 = TempA$

'To get the sidereal time at your longitude, known as Local Mean sidereal Time,
'just add your longitude in degrees, taking East as Positive
'Subtract multiples of 360 to bring the answer into the range 0 to 360 degrees.

Longitude = Val(Mid$(Text1(1), 3, 3)) + (Val(Mid$(Text1(1), 6, 2) / 360))
If UCase$(Left$(Text1(1), 1)) = "W" Then Longitude = 360 - Longitude

LMST = 280.46061837 + 360.98564736629 * D + Longitude - (DST * 15)
A = LMST \ 360: B = LMST - (A * 360): LMST = B: If LMST < 0 Then LMST = 360 + LMST

LocalSiderealHours = LMST \ 15: A = LMST / 15 - LocalSiderealHours ' 15 = degrees per hour
LocalSiderealMins = Int(A * 60)

B = (A * 60) - LocalSiderealMins:  LocalSiderealSecs = Int(B * 60)

TempA$ = Right$("0" & LocalSiderealHours, 2) & ":" & Right$("0" & LocalSiderealMins, 2)
TempA$ = TempA$ & ":" & Right$("0" & LocalSiderealSecs, 2)
Label11 = TempA$

'-----------------------------------------------------------------
' adapted from Keith Burnett's web info accessible via:
' Sidereal time formulas and spreadsheet to navigation accuracy.htm
'-----------------------------------------------------------------

End Sub
