; TELESCOPE241.ASM 10SEP05 - COPYRIGHT JOHN BECKER - TELESCOPE INTERFACE

;PIC16F876, 3.2768MHz, WDT OFF, POR ON, XTAL HS

;PROGRAM WRITTEN IN TASM - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC16F877 data sheet

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
#DEFINE BLOCK0 BCF H'03',7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF H'03',7 ; set   STATUS bit 7 (IRP)

        List P = PIC16F876, R=DEC;
        __CONFIG   h'3F31'

        include P16F876.inc

        CBLOCK


REGA0				;lsb
REGA1
REGA2
REGA3				;msb
REGB0                           ;lsb
REGB1
REGB2
REGB3                           ;msb

DSIGN				;Digit Sign. 0=positive,FF(or non zero)=negative
DIGIT1				;MSD
DIGIT2
DIGIT3
DIGIT4
DIGIT5				;Decimal digits
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10				;LSD
MTEMP
MCOUNT
DCOUNT

LOOP        ; loop counter
LOOPA       ; loop counter used by LCD
RSLINE      ; LCD command/data flag
CLKCNT      ; pre-counter for seconds
STORE
STORE1
GPSLOOP     ; temp loop for simulation with data in eeprom
CHECKSUM
VALIDITY
LETTER
LETTERCOUNT
STARTCOUNT
TIMEOUT
TIMEOUT2
TIMEOUT3
HRSMSB
HRSLSB
MINMSB
MINLSB
SECMSB
SECLSB
YRSMSB
YRSLSB
MTHMSB
MTHLSB
DAYMSB
DAYLSB
LNGDEGMSB
LNGDEGNSB
LNGDEGLSB
LNGMINMSB
LNGMINLSB
LATDEGMSB
LATDEGLSB
LATMINMSB
LATMINLSB
NORTH

CLKSEC
CLKMIN
CLKHRS
WKDAY
CLKDAY
MONTH
YEAR
BYTEOUT
DST

HRSBIN
DAYBIN
MTHBIN
YRSBIN
OFFSET
WEST
BAUDINDEX
LONGBORROW
SIGN
BACKLIGHT
PREVTIME

	ENDC

        CBLOCK H'70'
PROMVAL            ; vals in BANK1
BAUDRATE
	ENDC


MEM1:       EQU H'10'  ; first data memory location for Bank 2 (at H'120')

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

SDATA:      EQU 4        ; RTC data line (PORTC) 
TCLK:       EQU 3        ; RTC clk line (PORTC) 

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

TABLCD: addwf PCL,F        ;LCD initialisation table
        retlw B'00110011'  ;initialise lcd - first byte
        retlw B'00110011'  ;2nd byte (repeat of first)
        retlw B'00110010'  ;set for 4-bit operation
        retlw B'00101100'  ;set for 2 lines
        retlw B'00000110'  ;set entry mode to increment each address
        retlw B'00001100'  ;set display on, cursor off, blink off
        retlw B'00000001'  ;clear display
        retlw B'00000010'  ;return home, cursor & RAM to zero
                         ;end inititalisation table

MESSAG1: addwf PCL,F
        retlw 'W'
        retlw 'A'
        retlw 'I'
        retlw 'T'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'S'
        retlw 'I'
        retlw 'G'
        retlw 'N'
        retlw 'A'
        retlw 'L'
        retlw ' '
        retlw ' '

MESSAG2: addwf PCL,F
        retlw 'F'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw ' '
        retlw 'G'
        retlw 'P'
        retlw 'S'
        retlw ' '
        retlw 'M'
        retlw 'O'
        retlw 'D'
        retlw 'U'
        retlw 'L'
        retlw 'E'
        retlw ' '

MESSAG3: addwf PCL,F
        retlw 'W'
        retlw 'A'
        retlw 'I'
        retlw 'T'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'P'
        retlw 'C'
        retlw ' '
        retlw 'D'
        retlw 'A'
        retlw 'T'
        retlw 'A'
        retlw ' '

TABLELETTER: movf LETTERCOUNT,W
        addwf STARTCOUNT,W
        addwf PCL,F   ; sentence ID table
        retlw '$'
        retlw 'G'
	retlw 'P'
	retlw 'R'
	retlw 'M'
        retlw 'C'
        retlw '#'

MONTHDAYSBCD:
        movf MTHBIN,W
        addwf PCL,F
        retlw 31   ; 0    dec
        retlw 31   ; 1    jan
        goto LEAP  ; 2    feb
        retlw 31   ; 3    mar
        retlw 30   ; 4    apr
        retlw 31   ; 5    may
        retlw 30   ; 6    jun
        retlw 31   ; 7    jul
        retlw 31   ; 8    aug
        retlw 30   ; 9    sep
        retlw 31   ; 10   oct
        retlw 30   ; 11   nov
        retlw 31   ; 12   dec
        retlw 31   ; 13
        retlw 31   ; 14
        retlw 31   ; 15
        retlw 31   ; 16

BCDMSB: andlw 3
        addwf PCL,F
        retlw 0
        retlw 10
        retlw 20
        retlw 30

BINTOBCD:
        andlw 31
        addwf PCL,F
        retlw B'00000000'   ; 0
        retlw B'00000001'   ; 1
        retlw B'00000010'   ; 2
        retlw B'00000011'   ; 3
        retlw B'00000100'   ; 4
        retlw B'00000101'   ; 5
        retlw B'00000110'   ; 6
        retlw B'00000111'   ; 7
        retlw B'00001000'   ; 8
        retlw B'00001001'   ; 9

        retlw B'00010000'   ; 10
        retlw B'00010001'   ; 11
        retlw B'00010010'   ; 12
        retlw B'00010011'   ; 13
        retlw B'00010100'   ; 14
        retlw B'00010101'   ; 15
        retlw B'00010110'   ; 16
        retlw B'00010111'   ; 17
        retlw B'00011000'   ; 18
        retlw B'00011001'   ; 19

        retlw B'00100000'   ; 20
        retlw B'00100001'   ; 21
        retlw B'00100010'   ; 22
        retlw B'00100011'   ; 23
        retlw B'00100100'   ; 24
        retlw B'00100101'   ; 25
        retlw B'00100110'   ; 26
        retlw B'00100111'   ; 27
        retlw B'00101000'   ; 28
        retlw B'00101001'   ; 29

        retlw B'00110000'   ; 30
        retlw B'00110001'   ; 31

LEAP:   movf YRSLSB,W    ; get MSB digit val
        andlw B'00000011'
        btfss STATUS,Z  ;is year a multiple of 4?
        retlw 28        ;no, FEB = 28
        retlw 29        ;yes, FEB = 29

MESSAG4: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw 'B'
        retlw 'A'
        retlw 'U'
        retlw 'D'

MESSAG5: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw 'D'
        retlw 'S'
        retlw 'T'
        retlw ' '

MESSAG6: addwf PCL,F
        retlw 'O'
        retlw 'F'
        retlw 'F'
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw ' '

BAUDTABLE: andlw B'00000011'
        addwf PCL,F
        retlw 10       ; 19200 baud
        retlw 20       ; 9600
        retlw 42       ; 4800
        retlw 84       ; 2400

BAUDROUTE: addwf PCL,F
        goto BAUDTEXT0
        goto BAUDTEXT1
        goto BAUDTEXT2
        goto BAUDTEXT3

BAUDTEXT0: movf LOOP,W
        addwf PCL,F
        retlw '1'
        retlw '9'
        retlw '2'
        retlw '0'
        retlw '0'
        retlw ' '
        retlw ' '
        retlw ' '

BAUDTEXT1: movf LOOP,W
        addwf PCL,F
        retlw '9'
        retlw '6'
        retlw '0'
        retlw '0'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

BAUDTEXT2: movf LOOP,W
        addwf PCL,F
        retlw '4'
        retlw '8'
        retlw '0'
        retlw '0'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

BAUDTEXT3: movf LOOP,W
        addwf PCL,F
        retlw '2'
        retlw '4'
        retlw '0'
        retlw '0'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

;*******************

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA       ; initialise all port outputs to zero
        clrf PORTB
        clrf PORTC

        BANK1
        movlw B'11000000'     ; RB7, RB6 as input
        movwf TRISB
        movlw B'00000001'     ; RA0 as input
        movwf TRISA
        movlw B'00000110'     ; set for digital RA, RE 
        movwf ADCON1
        movlw B'10100111'     ; bits 3,4 as output for serial eeprom, 6 as RS232 out
        movwf TRISC
        movlw B'00000111'     ; set timer ratio 1:256, pull-ups on
        movwf OPTION_REG
        BANK0

        clrf INTCON
        call PAUSIT
        call LCDSET
        clrf INTCON
        call PAUSIT

        call SETCGRAM

        clrf VALIDITY
        clrf TIMEOUT
        clrf TIMEOUT2
        movlw 254
        movwf TIMEOUT3

        movlw 20
        movwf BACKLIGHT  ; turn on backlight
        bsf PORTA,2

        movlw 20
        call PRMGET        
        movwf BAUDINDEX
        call BAUDTABLE
        movwf BAUDRATE
        call SETBAUD

        movf BAUDRATE,W
        movwf PROMVAL
        movlw 21
        call SETPRM

        call CLRLINE1
        call CLRLINE2

        btfsc PORTA,0      ; is RA0 on?
        goto CHECK6        ; no
        btfss PORTB,6      ; is RB6 also on?
        goto CHECK06       ; yes
        call SELECTBAUD    ; no
        goto CHECK7

CHECK06:
        call SETOFFSET
        goto CHECK7

CHECK6: btfss PORTB,6
        call SETDST

CHECK7: btfsc PORTB,7
        goto AUTOMATIC

        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMSG: movf LOOP,W
        call MESSAG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMSG

        clrf LOOP
        call LCD21
        bsf RSLINE,4
SHOWMSG2: movf LOOP,W
        call MESSAG2
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMSG2

; *************** START OF MAIN PROG ***********

MAIN:   call FlushRXBuffer      ; Make sure that the RX buffer is empty
        clrf STARTCOUNT
        call GETSENTENCE

        movlw MEM1
        addlw 7
        movwf FSR
        movwf GPSLOOP
        call DECODEGPRMC
        goto MAIN

;*****************

SUMIT:  bcf RCSTA,CREN    ; turn off reception
        clrf CHECKSUM
        movlw MEM1
        addlw 1
        movwf FSR

CHECKIT: BLOCK1           ; do checksum
        movf INDF,W
        BLOCK0
        xorlw '*'
        btfsc STATUS,Z
        goto CHECK2
        xorwf CHECKSUM,F
        incf FSR,F
        movf FSR,W
        xorlw H'6F'
        btfss STATUS,Z
        goto CHECKIT
        goto EOFPROBLEM

CHECK2: incf FSR,F
        BLOCK1
        movf INDF,W       ; get first digit of checksum
        BLOCK0
        movwf PROMVAL     ; and convert to decimal, storing full conversion in PROMVAL
        movlw 48          
        subwf PROMVAL,F
        movf PROMVAL,W    ; is val >9?
        addlw 247
        btfss STATUS,C
        goto CHECKV1      ; no
        movlw 7           ; yes (it's between A and F)
        subwf PROMVAL,F   ; subtract 7 

CHECKV1: incf FSR,F
        BLOCK1
        movf INDF,W       ; get 2nd digit of checksum
        BLOCK0
        movwf STORE
        movlw 48
        subwf STORE,F
        movf STORE,W      ; is val >9?
        addlw 247
        btfss STATUS,C
        goto CHECKV2      ; no
        movlw 7           ; yes (it's between A and F)
        subwf STORE,F     ; subtract 7 

CHECKV2: swapf PROMVAL,W
        addwf STORE,W
        movwf PROMVAL

        movf CHECKSUM,W   ; compare actual checksum with expected (in PROMVAL)
        xorwf PROMVAL,W   ; are both vals equal?
        btfss STATUS,Z
        goto CHECKSUMPROBLEM      ; no
        return

;********** LCD CONTROL SECTION *********

LCD1:   movlw B'10000000'
        goto LCDLIN
LCD9:   movlw B'10001001'
        goto LCDLIN

LCD10:  movlw B'10001010'
        goto LCDLIN

LCD16:  movlw B'10010000'
        goto LCDLIN

LCD21:  movlw B'11000000'
        goto LCDLIN
LCD28:  movlw B'11001000'
        goto LCDLIN

LCD30:  movlw B'11001010'
        goto LCDLIN

LCD210: movlw B'11001001'
        goto LCDLIN

LCD29:  movlw B'11001001'
        goto LCDLIN

LCD216: movlw B'11010000'
        goto LCDLIN

LCDOUT: movwf STORE1    ; temp store value that will be output to LCD
        movlw 255       ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT     ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ; swap byte nibbles
        movf STORE1,W   ; get nibble (MSB)
        andlw 15        ; AND to isolate nibble
        iorwf RSLINE,W  ; OR the RS bit
        movwf PORTB     ; output the byte
        nop
        bsf PORTB,5     ; set E high
        nop
        bcf PORTB,5     ; set E low
        return

LCDLIN: bcf RSLINE,4    ; sets LCD command/line
        call LCDOUT     ; and outputs cmmand code to LCD
        bsf RSLINE,4    ; set RS flag
        return

PAUSIT: movlw 5         ; 1/5th sec wait set  ; 14
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:  btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

SETCGRAM: movlw B'01000000'  ;set address for CG RAM write to 0
        call LCDLIN
        bsf RSLINE,4

        movlw B'00011100'    ; put degree symbol into CGRAM 0
        call LCDOUT
        movlw B'00010100'
        call LCDOUT
        movlw B'00011100'
        call LCDOUT
	movlw 0
        call LCDOUT
	movlw 0
        call LCDOUT
	movlw 0
        call LCDOUT
	movlw 0
        call LCDOUT
	movlw 0
        call LCDOUT
	return

; ***************        

SETBAUD:

        bcf STATUS,RP1
        bsf STATUS,RP0
;        movlw   d'42'           ; 4800 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
;        movlw   d'47'           ; 4800 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)

;        movlw 23                ; 9600 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
;        movlw 20                ; 9600 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)

        movf BAUDRATE,W         ; user selected BAUD rate with 3.2768MHz XTAL
	movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed) & ASYNC transmission
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call 	FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Receive a character from RS232
; (This routine does not return until a character has been received)
; The received character is in the W register

RecLoop: nop
        incfsz TIMEOUT,F
        goto Rec2
        incfsz TIMEOUT2,F
        goto Rec2
        incfsz TIMEOUT3,F
        goto Rec2
        call TIMEOUTMSG

Rec2:   btfss   PIR1,RCIF       ; Check for any RX'd data
        goto RecLoop
        clrf TIMEOUT
        clrf TIMEOUT2
        movlw 254
        movwf TIMEOUT3
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

; Send byte to output

TxByte:
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

CHECKSUMPROBLEM:
        movlw 10
        movwf BACKLIGHT
        bsf PORTA,2

        call LCD21
;        call CHECKP2
;        return

CHECKP2: movlw 'C'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw '!'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
;        return
        goto MAIN

EOFPROBLEM: call LCD21
        call EOF2
        call LCD216
        call EOF2
        return

EOF2:   movlw 'N'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'F'
        movlw '!'
        call LCDOUT
        movlw ' '
        call LCDOUT
        goto MAIN

; ************* GET DATA SENTENCE FROM GPS *********

GETSENTENCE:

WAIT1:  movlw MEM1
        movwf FSR               ; set FSR to address of MEM1
        clrf LETTERCOUNT
        call TABLELETTER
        movwf LETTER
        bsf RCSTA,CREN          ; turn on reception
        call FlushRXBuffer      ; Make sure that the RX buffer is empty

WAIT2:  call RecLoop            ; Wait and read from serial - character returned in W
        BLOCK1
        movwf INDF              ; store received byte to INDF
        BLOCK0
        subwf LETTER,W          ; is this the required letter?
        btfss STATUS,Z
        goto Wait1              ; no, so start afresh

        incf FSR,F              ; yes, get next byte
        incf LETTERCOUNT,F      ; inc lettercount, is it = 6?
        call TABLELETTER
        movwf LETTER
        movf LETTERCOUNT,W
        xorlw 6
        btfss STATUS,Z
        goto WAIT2

GETTEXT: call RecLoop           ; Wait and read from serial - character returned in W
        BLOCK1
        movwf INDF              ; store received byte to INDF
        BLOCK0
        movwf STORE
        incf FSR,F
        movf FSR,W              ; has FSR reached max? (unlikely, but possible event)
        xorlw H'6F'
        btfsc STATUS,Z
        goto DOCHECKSUM         ; yes

        movf STORE,W
        sublw 13                ; Is this 13 ?
        btfss STATUS,Z
        goto GETTEXT            ; Not 13

DOCHECKSUM: call SUMIT
        movlw MEM1
        addlw 7
        movwf FSR
        movwf GPSLOOP
        return

; *************

TIMEOUTMSG:

        movlw 10
        movwf BACKLIGHT
        bsf PORTA,2

        clrf LOOP
        call LCD1
        bsf RSLINE,4
TIMEMSG: movf LOOP,W
        call MESSAG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto TIMEMSG

        clrf LOOP
        call LCD16
        bsf RSLINE,4
TIMEMSG2: movf LOOP,W
        call MESSAG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto TIMEMSG2
        return

;************ DECODE GPRMC SENTENCE AND SEND REQUIRED DATA TO RS232 ****

DECODEGPRMC: ; call LCD1
GtimeP: BLOCK1                  ; get time (UTC)
        movf INDF,W
        BLOCK0
        movwf HRSMSB
	
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf HRSLSB
        incf FSR,F

        BLOCK1
        movf INDF,W
        BLOCK0
        movwf MINMSB

        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf MINLSB
        incf FSR,F

        BLOCK1
        movf INDF,W
        BLOCK0
        movwf SECMSB

        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf SECLSB
        incf FSR,F              ; inc to bypass comma

GAcheckP: incf FSR,F             ; Validity check
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf VALIDITY
        incf FSR,F              ; inc to bypass comma

GlatP:  call LCD10               ; show latitude
        incf FSR,F               ; show latitude
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf LATDEGMSB

        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf LATDEGLSB
        incf FSR,F

Glat3P: BLOCK1
        movf INDF,W
        BLOCK0
        movwf LATMINMSB
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf LATMINLSB
        incf FSR,F

Glat4P: BLOCK1     
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfsc STATUS,Z
        goto GNSP                ; yes, equals comma
        incf FSR,F
        goto Glat4P

GNSP:   incf FSR,F            ; inc to bypass comma
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf NORTH
        movlw '+'             ; set N/S N=78, S=83 thus bit 0 = 0 or 1
        btfsc NORTH,0
        movlw '-'
        movwf NORTH
        incf FSR,F            ; inc to bypass comma

GlongP: incf FSR,F             ; get longitude
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf LNGDEGMSB
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf LNGDEGNSB
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf LNGDEGLSB
        incf FSR,F

Glong3P: BLOCK1
        movf INDF,W
        BLOCK0
        movwf LNGMINMSB
        incf FSR,F

        BLOCK1
        movf INDF,W
        BLOCK0
        movwf LNGMINLSB
        incf FSR,F

Glong4P: BLOCK1     
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfsc STATUS,Z
        goto GWEP                ; yes, equals comma
        incf FSR,F
        goto Glong4P

GWEP:   incf FSR,F            ; inc to bypass comma
        BLOCK1
        movf INDF,W
        BLOCK0
	movwf WEST
        incf FSR,F            ; inc to bypass comma

KnotsP: incf FSR,F
        BLOCK1                  ; bypass speed
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfss STATUS,Z
        goto KnotsP

CourseP: incf FSR,F              ; inc to bypass comma
        BLOCK1                  ; bypass course
        movf INDF,W
        BLOCK0
        sublw 44                ; check for comma
        btfss STATUS,Z
        goto CourseP

GdateP: incf FSR,F              ; yes, equals comma
        BLOCK1                  ; show date
        movf INDF,W
        BLOCK0
        movwf DAYMSB

        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf DAYLSB
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf MTHMSB
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf MTHLSB
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf YRSMSB
        incf FSR,F
        BLOCK1
        movf INDF,W
        BLOCK0
        movwf YRSLSB

        call UTCtoLOCAL    ; correct UTC to local
        call LONG360       ; correct logitude for 360^

        call SHOWTIME
        call SHOWLAT
        call SENDTIMELAT
        return

SENDTIMELAT:
        btfsc PORTA,0
        return

        movlw 10
        movwf BACKLIGHT
        bsf PORTA,2

        movlw ':'        ; send time conversion
        call TXBYTE
        movlw 'S'
        call TXBYTE
        movlw 'L'
        call TXBYTE
        movlw ' '
        call TXBYTE
        movf HRSMSB,W
        call TXBYTE
        movf HRSLSB,W
        call TXBYTE
        movlw ':'
        call TXBYTE
        movf MINMSB,W
        call TXBYTE
        movf MINLSB,W
        call TXBYTE
        movlw ':'
        call TXBYTE
        movf SECMSB,W
        call TXBYTE
        movf SECLSB,W
        call TXBYTE
        movlw '#'
        call TXBYTE

        movlw ':'        ; send date conversion
        call TXBYTE
        movlw 'S'
        call TXBYTE
        movlw 'C'
        call TXBYTE
        movlw ' '
        call TXBYTE
        movf MTHMSB,W
        call TXBYTE
        movf MTHLSB,W
        call TXBYTE
        movlw ':'
        call TXBYTE
        movf DAYMSB,W
        call TXBYTE
        movf DAYLSB,W
        call TXBYTE
        movlw ':'
        call TXBYTE
        movf YRSMSB,W
        call TXBYTE
        movf YRSLSB,W
        call TXBYTE
        movlw '#'
        call TXBYTE

        movlw ':'        ; send longitude conversion
        call TXBYTE
        movlw 'S'
        call TXBYTE
        movlw 'g'
        call TXBYTE
        movlw ' '
        call TXBYTE
        movf LNGDEGMSB,W
        call TXBYTE
        movf LNGDEGNSB,W
        call TXBYTE
        movf LNGDEGLSB,W
        call TXBYTE
        movlw '*'
        call TXBYTE
        movf LNGMINMSB,W
        call TXBYTE
        movf LNGMINLSB,W
        call TXBYTE
        movlw '#'
        call TXBYTE

        movlw ':'        ; send latitude conversion
        call TXBYTE
        movlw 'S'
        call TXBYTE
        movlw 't'
        call TXBYTE
        movlw ' '
        call TXBYTE

        movf NORTH,W     ; +/- sign
        call TXBYTE
        movf LATDEGMSB,W
        call TXBYTE
        movf LATDEGLSB,W
        call TXBYTE
        movlw '*'
        call TXBYTE
        movf LATMINMSB,W
        call TXBYTE
        movf LATMINLSB,W
        call TXBYTE
        movlw '#'
        call TXBYTE

        movlw ':'        ; send offset conversion
        call TXBYTE
        movlw 'S'
        call TXBYTE
        movlw 'G'
        call TXBYTE
        movlw ' '
        call TXBYTE
        movlw 13         ; get OFFSET sign
        call PRMGET        
        call TXBYTE
        movlw 14         ; get OFFSET MSB
        call PRMGET
        andlw 15
        movwf STORE
        swapf STORE,F    ; make val the MSB
        movlw 15         ; get OFFSET LSB
        call PRMGET
        andlw 15
        addwf STORE,F    ; add LSB
        movlw 0          ; get DST
        call PRMGET        
        addwf STORE,F    ; add DST
        movf STORE,W     ; is val > 9 ?
        addlw 6
        btfsc STATUS,DC
        movwf STORE      ; yes
        swapf STORE,W    ; send MSB
        andlw 15
        iorlw 48
        call TXBYTE
        movf STORE,W     ; send LSB
        andlw 15
        iorlw 48
        call TXBYTE
        movlw '#'
        call TXBYTE

        return

; ************  REAL TIME CLOCK SECTION *********

RTCLOCK:

; ********* WRITE TO RT CLOCK

        bsf PORTC,SDATA
        bsf PORTC,TCLK

        BANK1
        bcf TRISC,TCLK
        BANK0

        call SETSTOP
        call SETSTART

        movlw B'11010000'   ; set RTC for write mode & wait ACK
        call RTCCLKOUT

        movlw B'00000000'
        call RTCCLKOUT    ; set RTC for address 0 & wait ACK
        movf CLKSEC,W
        call RTCCLKOUT    ; send secs to RTC & wait ACK
        movf CLKMIN,W
        call RTCCLKOUT    ; send mins to RTC & wait ACK
        movf CLKHRS,W
        call RTCCLKOUT    ; send hrs to RTC & wait ACK
        movf WKDAY,W
        call RTCCLKOUT    ; send wkday to RTC & wait ACK
        movf CLKDAY,W
        call RTCCLKOUT    ; send dateday to RTC & wait ACK
        movf MONTH,W
        call RTCCLKOUT    ; send month to RTC & wait ACK
        movf YEAR,W
        call RTCCLKOUT    ; send year to RTC & wait ACK
        call SETSTOP

; ************* READ FROM RT CLOCK

READRTC: BANK1
        bcf TRISC,TCLK
        BANK0

        call SETSTOP
        call SETSTART

        movlw B'11010000'   ; set RTC for write mode & wait ACK
        call RTCCLKOUT    ; 

        movlw B'00000000'
        call RTCCLKOUT    ; set RTC for address 0 & wait ACK 

        call SETSTOP

; 1 ****** WRITE TO SET RTC FOR READ MODE

        call SETSTART

        movlw B'11010001'   ; bit 0 = 1 direction read & wait ACK
        call RTCCLKOUT

; 4 *********** READ BYTES

        BANK1
        bsf TRISC,SDATA   ; SDATA as input
        BANK0

GETRTCVALUE:
        call RTCCLKREAD   ; read 1 byte
        call SENDACKREAD  ; send ACK
        movf STORE,W
        andlw 127
        movwf CLKSEC

        call RTCCLKREAD   ; read 1 byte
        call SENDACKREAD  ; send ACK
        movf STORE,W
        andlw 127
        movwf CLKMIN

        call RTCCLKREAD   ; read 1 byte
        call SENDACKREAD  ; send ACK
        movf STORE,W
        andlw 63
        movwf CLKHRS

        call RTCCLKREAD    ; read 1 byte
        call SENDACKREAD   ; send ACK
        movf STORE,W
        andlw 7
        movwf WKDAY

        call RTCCLKREAD    ; read 1 byte
        call SENDACKREAD   ; send ACK
        movf STORE,W
        andlw 63
        movwf CLKDAY

        call RTCCLKREAD    ; read 1 byte
        call SENDACKREAD   ; send ACK
        movf STORE,W
        andlw 31
        movwf MONTH

        call RTCCLKREAD    ; read 1 byte
        call SENDNOTACKREAD   ; send NOT-ACK
        movf STORE,W
        andlw 127
        movwf YEAR

        BANK1
        bcf TRISC,SDATA    ; SDATA as output
        BANK0

        movf CLKHRS,W
        call BIN2HEX
        movf DIGIT9,W
        movwf HRSMSB
        movf DIGIT10,W
        movwf HRSLSB

        movf CLKMIN,W
        call BIN2HEX
        movf DIGIT9,W
        movwf MINMSB
        movf DIGIT10,W
        movwf MINLSB

        movf CLKSEC,W
        call BIN2HEX
        movf DIGIT9,W
        movwf SECMSB
        movf DIGIT10,W
        movwf SECLSB

        movf CLKDAY,W
        call BIN2HEX
        movf DIGIT9,W
        movwf DAYMSB
        movf DIGIT10,W
        movwf DAYLSB

        movf MONTH,W
        call BIN2HEX
        movf DIGIT9,W
        movwf MTHMSB
        movf DIGIT10,W
        movwf MTHLSB

        movf YEAR,W
        call BIN2HEX
        movf DIGIT9,W
        movwf YRSMSB
        movf DIGIT10,W
        movwf YRSLSB
        return

GETLAT: movlw 2                   ; get latitude
        call PRMGET
        movwf LATDEGMSB
        movlw 3
        call PRMGET
        movwf LATDEGLSB
        movlw 5
        call PRMGET
        movwf LATMINMSB
        movlw 6
        call PRMGET
        movwf LATMINLSB
        movlw 1
        call PRMGET
        movwf NORTH

GETLNG: movlw 7                    ; get longitude
        call PRMGET
        movwf LNGDEGMSB
        movlw 8
        call PRMGET
        movwf LNGDEGNSB
        movlw 9
        call PRMGET
        movwf LNGDEGLSB
        movlw 10           ; colon
        call PRMGET
        movlw 11
        call PRMGET
        movwf LNGMINMSB
        movlw 12
        call PRMGET
        movwf LNGMINLSB
        return

; ********* RTC CLOCK OUT

RTCCLKOUT: movwf BYTEOUT
        movlw 8
        movwf LOOP

CLK1:   rlf BYTEOUT,F       ; MSB first
        bcf PORTC,SDATA     ; clear SDATA
        btfsc STATUS,C      ; is CARRY set ?
        bsf PORTC,SDATA     ; yes, set SDATA
        bsf PORTC,TCLK      ; clk up
        bcf PORTC,TCLK      ; clk down
        decfsz LOOP,F
        goto CLK1
        call WAITACKRTC
        return

; ******** WAIT ACK FROM RTC

WAITACKRTC: BANK1
        bsf TRISC,SDATA    ; SDATA as input
        BANK0
        bsf PORTC,TCLK     ; take clk high
wait1R:  btfsc PORTC,SDATA  ; wait ACK
        goto WAIT1R
        bcf PORTC,TCLK     ; take clk low

        BANK1
        bcf TRISC,SDATA    ; SDATA as output (with TCLK low)
        BANK0
        return

SENDACKREAD:
        BANK1
        bcf TRISC,SDATA    ; SDATA as output
        BANK0
        bcf PORTC,SDATA    ; SDATA low as ACK
        bsf PORTC,TCLK     ; take clk high
        bcf PORTC,TCLK     ; take clk low
        BANK1
        bsf TRISC,SDATA    ; SDATA as input
        BANK0
        return

SENDNOTACKREAD:
        BANK1
        bcf TRISC,SDATA    ; SDATA as output
        BANK0
        bsf PORTC,SDATA    ; SDATA high as NOT-ACK
        bsf PORTC,TCLK     ; take clk high
        bcf PORTC,TCLK     ; take clk low
        BANK1
        bsf TRISC,SDATA   ; SDATA as input
        BANK0

        return

SETSTOP: bcf PORTC,SDATA  ; take data low while clk is low
        bsf PORTC,TCLK    ; take clk high while data is low
        bsf PORTC,SDATA   ; take data high while clk is high
        return

SETSTART:                 ; TCLK & SDATA assumed to be high
        bcf PORTC,SDATA   ; take data low while clk is high
        bcf PORTC,TCLK    ; take clk low while data is low
        return

RTCCLKREAD:
        clrf STORE
        movlw 8
        movwf LOOP

RTCREAD2: bsf PORTC,TCLK   ; TCLK high
        bcf STATUS,C
        rlf STORE,F
        btfsc PORTC,SDATA  ; get data bit
        bsf STORE,0
        bcf PORTC,TCLK     ; TCLK low
        decfsz LOOP,F
        goto RTCREAD2
        return

RECEIVETIME:

; 'T' has been received - Confirm ready state back to PC
        movlw   'R'
        call    TxByte

        call TIMEX
        movwf CLKSEC
        call    TxByte

        call TIMEX
        movwf CLKMIN
        call    TxByte

        call TIMEX
        movwf CLKHRS
        call    TxByte

        call TIMEX           
        movwf WKDAY
        call    TxByte

        call TIMEX
        movwf CLKDAY
        call    TxByte

        call TIMEX
        movwf MONTH
        call    TxByte

        call TIMEX
        movwf YEAR
        call    TxByte

        clrf LOOP
FACTS:  call TIMEX
        movwf PROMVAL
        call    TxByte
        movf LOOP,W
        call SETPRM
        incf LOOP,F
        movf LOOP,W
        xorlw 16
        btfss STATUS,Z
        goto FACTS
        call RTCLOCK
        return

TIMEX:  btfss   PIR1,RCIF       ; Check for any RX'd data
        goto TIMEX              ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; *************** CONVERT BYTE TO HEX & SHOW IT ******

BIN2HEX: movwf STORE
        swapf STORE,W   ;get most significant nibble
        andlw 15
        movwf DIGIT9
        addlw 6
        btfss STATUS,DC
        goto BIN2
        movf DIGIT9,W
        addlw 55        ;set as alpha
        goto BIN3
BIN2:   movf DIGIT9,W
        iorlw 48        ;set as numeral
BIN3:   movwf DIGIT9
        movf STORE,W    ;get least significant nibble
        andlw 15
        movwf DIGIT10
        addlw 6
        btfss STATUS,DC
        goto BIN4
        movf DIGIT10,W
        addlw 55        ;set as alpha
        goto BIN5
BIN4:   movf DIGIT10,W
        iorlw 48        ;set as numeral
BIN5:   movwf DIGIT10
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        MOVF PROMVAL,W  ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw H'55'       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw H'AA'       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

; ********** START OF AUTOMATIC PATH *********
; sends data to output from internal RTC & lat/long data, while listening
; for any updated data from PC

AUTOMATIC: call CLRLINE1
        call CLRLINE2

MAINX:  btfss PORTB,6
        call GETTIMEDATA

        call READRTC

;        call TEMPORARYDATA
;        call UTCtoLOCAL

        movf SECLSB,W        ; is time same as prev time?
        xorwf PREVTIME,W
        btfsc STATUS,Z
        goto MAINX           ; yes

        movf SECLSB,W        ; no
        movwf PREVTIME

        call GETLAT
        call SHOWTIME
        call SHOWLAT
        call SENDTIMELAT
        goto MAINX

; *************

SHOWTIME: call LCD1
        movf HRSMSB,W
        call LCDOUT
        movf HRSLSB,W
        call LCDOUT
        movlw ':'
        call LCDOUT
        movf MINMSB,W
        call LCDOUT
        movf MINLSB,W
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf SECMSB,W
        call LCDOUT
        movf SECLSB,W
        call LCDOUT
        movlw 'L'               ; local time
        call LCDOUT
        movlw ' '
        call LCDOUT

        call LCD21              ; show date
        movf DAYMSB,W
        call LCDOUT
        movf DAYLSB,W
        call LCDOUT
        movlw ':'
        call LCDOUT
        movf MTHMSB,W
        call LCDOUT
        movf MTHLSB,W
        call LCDOUT
        movlw ':'
        call LCDOUT
        movf YRSMSB,W
        call LCDOUT
        movf YRSLSB,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

SHOWLAT: call LCD10             ; show latitude
        movf LATDEGMSB,W
        call LCDOUT
        movf LATDEGLSB,W
        call LCDOUT
        movlw 0                 ; degrees symbol
        call LCDOUT
        movf LATMINMSB,W
        call LCDOUT
        movf LATMINLSB,W
        call LCDOUT
        movf NORTH,W
        call LCDOUT

        call LCD30  ;210                 ; show longitude
        movf LNGDEGMSB,W
        call LCDOUT
        movf LNGDEGNSB,W
        call LCDOUT
        movf LNGDEGLSB,W
        call LCDOUT
        movlw 0
        call LCDOUT                 ; degrees symbol
        movf LNGMINMSB,W
        call LCDOUT
        movf LNGMINLSB,W
        call LCDOUT

        movf BACKLIGHT,F  ; is backlight on?
        btfsc STATUS,Z
        return            ; no
        decfsz BACKLIGHT,F  ; yes, dec timing counter, is it 0
        return            ; no
        bcf PORTA,2       ; yes turn it off
        return

LCDSET: clrf LOOP        ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOP,W      ;get table address
        call TABLCD      ;get set-up instruction
        call LCDOUT      ;perform it
        incf LOOP,F      ;inc loop
        btfss LOOP,3     ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        return

; *****************

UTCtoLOCAL:              ; convert UTC to local time

        movlw 14         ; get OFFSET MSB
        call PRMGET        
        call BCDMSB
        movwf OFFSET
        movlw 15         ; get OFFSET LSB
        call PRMGET        
        andlw 15
        addwf OFFSET,F

        movlw 13         ; get OFFSET sign
        call PRMGET        
        xorlw '-'
        btfss STATUS,Z
        goto UTC2

;  ******* FOR NEGATIVE OFFSET ********

UTC1:   movlw 0          ; get DST
        call PRMGET        
        movwf DST

        comf OFFSET,W
        addlw 1
        addwf DST,F      ; add to DST
        btfsc STATUS,Z   ; is answer = 0 ?
        return           ; yes

DOHRS:  movf HRSLSB,W    ; get MSB digit val
        andlw 15
        movwf HRSBIN
        movf HRSMSB,W    ; get MSB digit val
        call BCDMSB
        addwf HRSBIN,W
        addwf DST,W
        movwf HRSBIN

        addlw 232        ; is answer >= 24 hours?
        btfss STATUS,C
        goto ENDHRS      ; no

        movf HRSBIN,W    ; yes
        addlw 24         ; add 24
        movwf HRSBIN     ; yes

DODAYS: movf DAYLSB,W    ; get MSB digit val
        andlw 15
        movwf DAYBIN
        movf DAYMSB,W    ; get MSB digit val
        call BCDMSB
        addwf DAYBIN,W
        movwf DAYBIN
        decfsz DAYBIN,F
        goto ENDDAYS

DOMONTHS: movf MTHLSB,W    ; get MSB digit val
        andlw 15
        movwf MTHBIN
        movf MTHMSB,W    ; get MSB digit val
        call BCDMSB
        addwf MTHBIN,W
        movwf MTHBIN
        decf MTHBIN,F
        call MONTHDAYSBCD
        movwf DAYBIN
        movf MTHBIN,F
        btfss STATUS,Z
        goto ENDMONTH
        movlw 12
        movwf MTHBIN

DOYEARS: movf YRSLSB,W    ; get MSB digit val
        andlw 15
        movwf YRSBIN
        movf YRSMSB,W    ; get MSB digit val
        call BCDMSB
        addwf YRSBIN,F
        decf YRSBIN,F

        goto ENDYEARS

ENDYEARS: movf YRSBIN,W
        call BINTOBCD
        movwf STORE
        andlw 15
        iorlw 48
        movwf YRSLSB
        swapf STORE,W
        andlw 15
        iorlw 48
        movwf YRSMSB

ENDMONTH: movf MTHBIN,W
        call BINTOBCD
        movwf STORE
        andlw 15
        iorlw 48
        movwf MTHLSB
        swapf STORE,W
        andlw 15
        iorlw 48
        movwf MTHMSB

ENDDAYS: movf DAYBIN,W
        call BINTOBCD
        movwf STORE
        andlw 15
        iorlw 48
        movwf DAYLSB
        swapf STORE,W
        andlw 15
        iorlw 48
        movwf DAYMSB

ENDHRS: movf HRSBIN,W
        call BINTOBCD
        movwf STORE
        andlw 15
        iorlw 48
        movwf HRSLSB
        swapf STORE,W
        andlw 15
        iorlw 48
        movwf HRSMSB
        return

;  ******* FOR POSITIVE OFFSET ********

UTC2:   movlw 0          ; get DST
        call PRMGET        
        movwf DST
        movf OFFSET,W
        addwf DST,F      ; add to DST
        btfsc STATUS,Z   ; is answer = 0
        return           ; yes

DOHRS2: movf HRSLSB,W    ; get MSB digit val
        andlw 15
        movwf HRSBIN
        movf HRSMSB,W    ; get MSB digit val
        call BCDMSB
        addwf HRSBIN,W
        addwf DST,W
        movwf HRSBIN

        addlw 232        ; is answer >= 24 hours?
        btfss STATUS,C
        goto ENDHRS      ; no

        movlw 24         ; sub 24
        subwf HRSBIN,F    ; yes

DODAYS2: movf DAYLSB,W    ; get MSB digit val
        andlw 15
        movwf DAYBIN
        movf DAYMSB,W    ; get MSB digit val
        call BCDMSB
        addwf DAYBIN,W
        movwf DAYBIN
        incf DAYBIN,F
        call MONTHDAYSBCD
        movwf STORE
        decf DAYBIN,W    ; are days -1 = days in month?
        xorwf STORE,W
        btfss STATUS,Z
        goto ENDDAYS     ; no
        movlw 1          ; yes, set days to 1
        movwf DAYBIN

DOMONTHS2: movf MTHLSB,W    ; get MSB digit val
        andlw 15
        movwf MTHBIN
        movf MTHMSB,W    ; get MSB digit val
        call BCDMSB
        addwf MTHBIN,W
        movwf MTHBIN
        incf MTHBIN,F

        movf MTHBIN,W     ; is month = 13 ?
        xorlw 13
        btfss STATUS,Z
        goto ENDMONTH     ; no
        movlw 1
        movwf MTHBIN

DOYEARS2: movf YRSLSB,W    ; get MSB digit val
        andlw 15
        movwf YRSBIN
        movf YRSMSB,W    ; get MSB digit val
        call BCDMSB
        addwf YRSBIN,F
        incf YRSBIN,F

        goto ENDYEARS

TEMPORARYDATA:
        movlw '0'        ; temporary set UTC mins
        movwf MINMSB
        movlw '0'
        movwf MINLSB

        movlw '0'        ; temporary set UTC hrs
        movwf HRSMSB
        movlw '2'
        movwf HRSLSB

        movlw '2'
        movwf DAYMSB     ; temp set day
        movlw '1'
        movwf DAYLSB     ;

        movlw '0'
        movwf MTHMSB     ; temp set months
        movlw '5'
        movwf MTHLSB     ;

        movlw '0'
        movwf YRSMSB     ; temp set years
        movlw '5'
        movwf YRSLSB     ;
        return

GETTIMEDATA:
        movlw 10
        movwf BACKLIGHT
        bsf PORTA,2

        call CLRLINE1
        call CLRLINE2
        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMSG3: movf LOOP,W
        call MESSAG3
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMSG3

        call LCD21
        clrf LOOP
        call BAUD1     ; show BAUD rate

        movlw ' '
        call LCDOUT
        movlw 'B'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'D'
        call LCDOUT

GT2:    btfss   PIR1,RCIF       ; Check for any RX'd data
        goto GT2                ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        sublw   'T'             ; Is this a 'T' for Time ?
        btfss   STATUS,Z
        goto GT2   
        call RECEIVETIME        ; yes
        call CLRLINE1
        call LCD1
        movlw 'D'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw ' '
        call LCDOUT

        movlw 'O'
        call LCDOUT
        movlw 'K'
        call LCDOUT

GT3:    btfss PORTB,6
        goto GT3
        call CLRLINE1
        call CLRLINE2
        call PAUSIT

        return

SETDST: call CLRLINE1
        call CLRLINE2
        clrf DST
        call LCD1
        bsf RSLINE,4
SHOWMSG5: movf LOOP,W
        call MESSAG5
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto SHOWMSG5

        clrf DST
DST2:   call LCD21
        incf DST,F
        bcf DST,1
        movf DST,W
        iorlw 48
        call LCDOUT

        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        btfss PORTB,6
        goto DST2

        movf DST,W
        movwf PROMVAL
        movlw 0
        call SETPRM
        goto BAUDEND2

SELECTBAUD: call CLRLINE1
        call CLRLINE2
        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMSG4: movf LOOP,W
        call MESSAG4
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto SHOWMSG4

        call LCD21
        clrf LOOP
        call BAUD1

BAUD3:  call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        clrf LOOP
        call LCD21

BAUD4:  btfsc PORTA,0
        goto BAUDEND
        incf BAUDINDEX,F
        bcf BAUDINDEX,2
        call BAUD1
        goto BAUD3

BAUDEND: movf BAUDINDEX,W
        movwf PROMVAL
        movlw 20
        call SETPRM
        movf BAUDINDEX,W
        call BAUDTABLE
        movwf BAUDRATE
        call SETBAUD

BAUDEND2: call LCD28
        movlw 'S'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        return

; *******

BAUD1:  movf BAUDINDEX,W
        call BAUDROUTE
        call LCDOUT
        incf LOOP,F
        movf LOOP,W
        xorlw 5
        btfss STATUS,Z
        goto BAUD1
        return

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F
        return

; **************

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by chksgna, multiply, divide, mod, bin2dec, dec2bin

NEGATEA: movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;*** 32 BIT SIGNED DECIMAL TO BINARY ***
;Decimal DIGIT1 thro DIGIT(X) & DSIGN -> REGA
;Set DSIGN = 0 for positive, DSIGN = 1 for negative values
;Most significant digit in DIGIT1
;Enter this routine with digit count in w register
;Return carry set if overflow
;Uses FSR register

dec2bin	movwf	MTEMP		;Save digit count

	movlw	D'32'		;Outer bit loop counter
	movwf	MCOUNT

d2blp1	movlw	DIGIT1-1	;Set up pointer to MSD
	movwf	FSR
	movf	MTEMP,w		;Inner digit loop counter
	movwf	DCOUNT

	movlw	D'10'
	clrc			;Bring in '0' bit into MSD

d2blp2	incf	FSR,f
	skpnc
	addwf	INDF,f		;Add 10 if '1' bit from prev digit
	rrf	INDF,f		;Shift out LSB of digit

	decfsz	DCOUNT,f	;Next L.S. Digit
	goto	d2blp2

	rrf	REGA3,f		;Shift in carry from digits
	rrf	REGA2,f
	rrf	REGA1,f
	rrf	REGA0,f

	decfsz	MCOUNT,f	;Next bit
	goto	d2blp1

	movf	INDF,w		;Check for overflow
	addlw	0xFF
	skpc
	rlf	REGA3,w
	skpnc
	return

	btfsc	DSIGN,0		;Check result sign
	call	negatea		;Negative
	return

;*** SIGNED SUBTRACT ***
;REGA - REGB -> REGA   ;Return carry set if overflow

subtract:
        call    negateb         ;Negate and add
	skpnc
	return			;Overflow

;*** SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add:    movf    REGA3,w         ;Compare signs
	xorwf	REGB3,w
	movwf	MTEMP

	call	addba		;Add REGB to REGA

	clrc			;Check signs
	movf	REGB3,w		;If signs are same
	xorwf	REGA3,w		;so must result sign
	btfss	MTEMP,7		;else overflow
	addlw	0x80
	return

;Add REGB to REGA (Unsigned)
;Used by add, multiply,

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incfsz	REGB3,w
	addwf	REGA3,f
	return

;Negate REGB
;Used by chksgnb, subtract, multiply, divide, mod

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return

; *************

LONG360: movf WEST,W      ; is WEST = E ?
        xorlw 'E'
        btfss STATUS,Z
        return            ; no

        clrf LONGBORROW   ; yes
        movf LNGMINMSB,W  ; subtract E longitude minutes from 60
        andlw 15
        movwf DIGIT1   
        movf LNGMINLSB,W
        andlw 15
        movwf DIGIT2   
        movlw 2
        call DEC2BIN      ; convert to binary
        movf REGA0,W
        btfsc STATUS,Z
        goto DEG360

        movf REGA0,W
        movwf REGB0
        movlw 60
        movwf REGA0
        clrf REGA1
        clrf REGA2
        clrf REGA3
        clrf REGB2
        clrf REGB3
        call SUBTRACT     ; subtract from 60
        bsf LONGBORROW,0  ; set borrow in respect of DEG correction

        clrf REGA1
        clrf REGA2
        clrf REGA3

        call BIN2DEC      ; convert minutes back to BCD
        movf DIGIT9,W
        iorlw 48
        movwf LNGMINMSB
        movf DIGIT10,W
        iorlw 48
        movwf LNGMINLSB

DEG360: movf LNGDEGMSB,W  ; subtract E longitude from 360
        andlw 15
        movwf DIGIT1   
        movf LNGDEGNSB,W
        andlw 15
        movwf DIGIT2
        movf LNGDEGLSB,W
        andlw 15
        movwf DIGIT3
        movlw 3
        call DEC2BIN      ; convert to binary

        movf LONGBORROW,W ; add borrow to DEG
        addwf REGA0,F

        btfsc STATUS,C    ; is there a carry ?
        incf REGA1,F      ; yes

        movf REGA0,W      ; is total value zero?
        iorwf REGA1,W
        btfsc STATUS,Z
        goto END360       ; yes

        movf REGA0,W      ; no, subtract from 360
        movwf REGB0
        movf REGA1,W
        movwf REGB1
        movlw HIGH 360
        movwf REGA1
        movlw LOW 360
        movwf REGA0
        clrf REGA2
        clrf REGA3
        clrf REGB2
        clrf REGB3
        call SUBTRACT     ; subtract from 360

END360: clrf REGA2
        clrf REGA3

        call BIN2DEC      ; convert degrees back to BCD
        movf DIGIT8,W
        iorlw 48
        movwf LNGDEGMSB
        movf DIGIT9,W
        iorlw 48
        movwf LNGDEGNSB
        movf DIGIT10,W
        iorlw 48
        movwf LNGDEGLSB
        return

SETOFFSET:
        call CLRLINE1
        call CLRLINE2
        call LCD1
        bsf RSLINE,4
SHOWMSG6: movf LOOP,W
        call MESSAG6
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto SHOWMSG6

OFF1:   movlw '+'
        movwf SIGN
        clrf OFFSET
OFF2:   call LCD21
        movf SIGN,W
        call LCDOUT
        swapf OFFSET,W
        andlw 15
        iorlw 48
        call LCDOUT
        movf OFFSET,W
        andlw 15
        iorlw 48
        call LCDOUT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        btfsc PORTB,6
        goto OFFEND
        incf OFFSET,F        
        movf OFFSET,W
        addlw 6
        btfsc STATUS,DC
        movwf OFFSET
        movf OFFSET,W
        xorlw B'00010011'
        btfss STATUS,Z
        goto OFF2
        clrf OFFSET

OFF3:   movlw '-'
        movwf SIGN
        clrf OFFSET
OFF4:   call LCD21
        movf SIGN,W
        call LCDOUT

        swapf OFFSET,W
        andlw 15
        iorlw 48
        call LCDOUT
        movf OFFSET,W
        andlw 15
        iorlw 48
        call LCDOUT

        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        btfsc PORTB,6
        goto OFFEND
        incf OFFSET,F        
        movf OFFSET,W
        addlw 6
        btfsc STATUS,DC
        movwf OFFSET
        movf OFFSET,W
        xorlw B'00010011'
        btfss STATUS,Z
        goto OFF4
        clrf OFFSET
        goto OFF1

OFFEND: movf SIGN,W
        movwf PROMVAL
        movlw 13
        call SETPRM
        swapf OFFSET,W
        andlw 15
        iorlw 48
        movwf PROMVAL
        movlw 14         ; OFFSET MSB
        call SETPRM
        movf OFFSET,W
        andlw 15
        iorlw 48
        movwf PROMVAL
        movlw 15         ; OFFSET LSB
        call SETPRM
        call BAUDEND2

OFF5:   btfss PORTA,0
        goto OFF5
        call PAUSIT
        return


; **************

        org H'2100'      ; data eeprom address

        DE  H'01'  ;  1        0 DST
        DE  H'2B'  ;  "+"      1
        DE  H'35'  ;  "5"      2
        DE  H'30'  ;  "0"      3
        DE  H'2E'  ;  "."      4
        DE  H'34'  ;  "4"      5
        DE  H'38'  ;  "8"      6
        DE  H'33'  ;  "3"      7
        DE  H'35'  ;  "5"      8
        DE  H'39'  ;  "9"      9
        DE  H'2E'  ;  "."      10
        DE  H'35'  ;  "5"      11
        DE  H'33'  ;  "3"      12
        DE  H'2B'  ;  "+"      13
        DE  H'30'  ;  "0"      14
        DE  H'30'  ;  "0"      15
        DE  H'00'  ;  0        16
        DE  H'00'  ;  0        17
        DE  H'00'  ;  0        18
        DE  H'00'  ;  0        19
        DE  H'01'  ;  1        20  ; baud SPRG table address value for 9600 baud

        END

