;*****************************************************************************        
;
;   Module:     rxstate.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 21/6/05                                                  
;
;               GPS data state machine
;               called by the interrupt routine to
;               process incoming data from the GPS module
;
;*****************************************************************************        


    ORG 0x1110
    
;*****************************************************************************        
;
;   Function :  RxStateMachine
;               Interrupt routine that handles the incoming nmea data, looking
;               for lat/long data and the valid flag.
;               This function is called once per incoming character
;
;   Input:      character received in W. state in rxState
;
;   Output:     Once the Valid flag has been recieved, it sets or clears the
;               INLOCKFLAG2 bit
;           
;               If the above flag is set, then NEWDATAFLAG2 bit is set,
;               indicating that the application should look at the
;               iLatxxxx and iLongxxxx variables
;
;*****************************************************************************        
RxStateMachine
    movwf   inChar
    movlw   high RxStateMachine
    movwf   PCLATH
    movf    rxState, W
    addwf   rxState, W
    addwf   rxState, W
    addwf   rxState, W
    addwf   PCL, F
    goto    rxs00       ;0  ; awaiting $
    goto    rxs01       ;1  ; awaiting G
    goto    rxs02       ;2  ; awaiting P
    goto    rxs03       ;3  ; awaiting G or R
    goto    rxs04       ;4  ; awaiting G
    goto    rxs05       ;5  ; awaiting A

    goto    rxs17       ;6 ; loop until ,
    goto    rxs17       ;7 ; loop until ,

    goto    rxs07       ;8  ; awaiting latitude : ddmm.mmmm
    goto    rxs08       ;9   ; awaiting ,
    goto    rxs09       ;10 ; awaiting N/S character
    goto    rxs10       ;11 ; awaiting ,
    goto    rxs11       ;12 ; awaiting longitude : dddmm.mmmm
    goto    rxs12       ;13 ; awaiting ,
    goto    rxs13       ;14 ; awaiting E/W character
    goto    rxs14       ;15 ; awaiting ,
    goto    rxs15       ;16 ; awaiting valid flag
    goto    rxs16       ;17 ; awaiting ,
    goto    rxs17       ;18 ; loop until , ( discard # of satelites in view )
    goto    rxs17a      ;19 ; loop until , ( discard DOP )
    goto    rxs18       ;20 ; loop until . ( build up altitude, whole digits only )
    
    ; Process RMC message to get ground speed
    goto    rxs19       ;21 ; awaiting M 
    goto    rxs20       ;22 ; awaiting C 
    goto    rxs16       ;23 ; awaiting ,
    goto    rxs17       ;24 ; loop until , ( discard h.h field )
    goto    rxs17       ;25 ; loop until , ( discard T )
    goto    rxs17       ;26 ; loop until , ( discard m.m )
    goto    rxs17       ;27 ; loop until , ( discard M )
    goto    rxs17       ;28 ; loop until , ( discard s.s )
    goto    rxs17s      ;29 ; loop until , ( discard N )
    goto    rxs21       ;30 ; loop until . ( build up speed field, in knots )
    goto    rxs17       ;31 ; loop until ,
    goto    rxs18h      ;32 ; loop until . ( build up direction, whole digits only )
rxStateMachine_end
    

    
    IF ( (RxStateMachine & 0x0FF) >= (rxStateMachine_end & 0x0FF) )
        MESSG   "Table rxStateMachine overflow"
    ENDIF

rxs00
    movf    inChar, W
    sublw   '$'
    btfss   STATUS,Z
    return
    incf    rxState,F
    return   
    
rxs01
    clrf    rxState
    movf    inChar, W
    sublw   'G'
    btfss   STATUS,Z
    return
    movlw   0x02
    movwf   rxState
    return   

rxs02
    clrf    rxState
    movf    inChar, W
    sublw   'P'
    btfss   STATUS,Z
    return
    movlw   0x03
    movwf   rxState
    return   
    
rxs03
    clrf    rxState
    movf    inChar, W
    sublw   'G'
    btfss   STATUS,Z
    goto    rxs03a
    movlw   0x04
    movwf   rxState
    return   

rxs03a
    movf    inChar, W
    sublw   'R'
    btfss   STATUS,Z        
    return
    movlw   D'21'
    movwf   rxState
    return   

rxs04
    clrf    rxState
    movf    inChar, W
    sublw   'G'
    btfss   STATUS,Z
    return
    movlw   0x05
    movwf   rxState
    return   

rxs05
    clrf    rxState
    movf    inChar, W
    sublw   'A'
    btfss   STATUS,Z
    return
    btfsc   flags2,NEWDATAFLAG2
    return              ; No point sending a postion if last not yet processed
    
    movlw   0x06
    movwf   rxState
    movlw   0x09        ; number of characters to parse in later state
    movwf   rxSubState
    return   
      
rxs07                   ; latitude. ddmm.mmmm
    movlw   0x09
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs07001
    
    movf    inChar, W
    movwf   latText+1, BANKED
    
    movlw   0x30
    subwf   inChar, W
    movwf   iLatDeg
    bra     rxs07exit
    
rxs07001    
    movlw   0x08
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs07002
    
    movf    inChar, W
    movwf   latText+2, BANKED
    
    ; multiply iLatDeg by 10, then add in digit
    bcf     STATUS, C
    rlcf    iLatDeg, F
    rlcf    iLatDeg, W
    movwf   iTmp
    rlcf    iTmp, W
    addwf   iLatDeg, F
    movlw   0x30
    subwf   inChar, W
    addwf   iLatDeg, F
    bra     rxs07exit               ; We now have degrees in iLatDeg
    
rxs07002
    movlw   0x07
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs07003

    movf    inChar, W
    movwf   latText+4, BANKED
    
    ; preserve the PRODH/L bytes
    movf    PRODH, W
    movwf   tmp1H
    movf    PRODL, W
    movwf   tmp1L
    ; store first minute digit , * 10
    movlw   0x30
    subwf   inChar, W
    mullw   0x0A
    movf    PRODL, W
    movwf   tmpL
    movf    PRODH, W
    movwf   tmpM
    clrf    tmpH
    ; restore the PRODH/L bytes
    movf    tmp1H, W
    movwf   PRODH
    movf    tmp1L, W
    movwf   PRODL
    
    bra     rxs07exit
    
rxs07003
    movlw   0x06
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs07004
    
    movf    inChar, W
    movwf   latText+5, BANKED

    ; store second minute digit 
    ; add ascii digit and * 10
    ; add in m2
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    addwfc  tmpM,F
    addwfc  tmpH,F

    ; preserve the PRODH/L bytes
    movf    PRODH, W
    movwf   tmp1H
    movf    PRODL, W
    movwf   tmp1L
    ; Multiply iLatDeg by 60. iLatDeg unchanged
    movf    iLatDeg, W
    mullw   D'60'
    ; Now add this into tmpL/M/H
    movf    PRODL, W
    addwf   tmpL, F
    movf    PRODH, W
    addwfc  tmpM, F
    movlw   0
    addwfc  tmpH, F
    ; restore the PRODH/L bytes
    movf    tmp1H, W
    movwf   PRODH
    movf    tmp1L, W
    movwf   PRODL   
     
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; So thats x2
    movf    tmpL, W
    movwf   tmp1L
    movf    tmpM, W
    movwf   tmp1M
    movf    tmpH, W
    movwf   tmp1H
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movf    tmp1L, W
    addwf   tmpL, F
    movf    tmp1M, W
    addwfc  tmpM, F
    movf    tmp1H, W
    addwfc  tmpH, F
    
    bra     rxs07exit
    
rxs07004
    movlw   0x05
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs07004a

    movf    inChar, W
    movwf   latText+6, BANKED

    ; skip the . character
    bra     rxs07exit
    
rxs07004a
    movlw   0x04
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs07005

    movf    inChar, W
    movwf   latText+7, BANKED

; add ascii digit and * 10
    
    ; add in m3
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    addwfc  tmpM,F
    addwfc  tmpH,F

    
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; So thats x2
    movf    tmpL, W
    movwf   tmp1L
    movf    tmpM, W
    movwf   tmp1M
    movf    tmpH, W
    movwf   tmp1H
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movf    tmp1L, W
    addwf   tmpL, F
    movf    tmp1M, W
    addwfc  tmpM, F
    movf    tmp1H, W
    addwfc  tmpH, F
    bra     rxs07exit
    
rxs07005
    movlw   0x03
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs07exit

    movf    inChar, W
    movwf   latText+8, BANKED
    
    ; add in m4
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    addwfc  tmpM,F
    addwfc  tmpH,F
    
rxs07exit
    decfsz  rxSubState, F
    return
    incf    rxState, F
    return  
     
rxs08
    incf    rxState, F  ; skip the , character
    return  
     
rxs09
    movf    inChar, W
    movwf   latText+0x0a, BANKED
    
    movlw   'S'
    subwf   inChar, W
    btfss   STATUS, Z
    bra     rxs09exit
    
    ; negate the binary value.
    ; ie, invert the bits and add 1
    comf    tmpL, F
    comf    tmpM, F
    comf    tmpH, F
    movlw   1    
    addwf   tmpL, F
    movlw   0
    addwfc  tmpM,F
    addwfc  tmpH,F

rxs09exit
    ; Now store tmp into iLatmmhh
    movf    tmpH, W
    movwf   iLatmmhh
    movf    tmpM, W
    movwf   iLatmmhh + 1
    movf    tmpL, W
    movwf   iLatmmhh + 2

    incf    rxState, F 
    return   
    
rxs10
    incf    rxState, F  ; skip the , character
    movlw   0x0A        ; number of characters to parse in next state
    movwf   rxSubState
    return   
    
rxs11
    ; read  the longitude values
    movlw   0x0A
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs11001
    
    movf    inChar, W
    movwf   longText, BANKED
    
    movlw   0x30
    subwf   inChar, W
    movwf   iLongDeg
    bra     rxs11exit    

rxs11001
    movlw   0x09
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs11002
    
    movf    inChar, W
    movwf   longText+1, BANKED

    bcf     STATUS, C
    rlcf     iLongDeg, F
    rlcf     iLongDeg, W
    movwf   iTmp
    rlcf     iTmp, W
    addwf   iLongDeg, F
    movlw   0x30
    subwf   inChar, W
    addwf   iLongDeg, F
    bra     rxs11exit              

rxs11002
    movlw   0x08
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs11003
    
    movf    inChar, W
    movwf   longText+2, BANKED

    bcf     STATUS, C
    rlcf     iLongDeg, F
    rlcf     iLongDeg, W
    movwf   iTmp
    rlcf     iTmp, W
    addwf   iLongDeg, F
    movlw   0x30
    subwf   inChar, W
    addwf   iLongDeg, F
    bra     rxs11exit               ; We now have degrees in iLongDeg

rxs11003
    movlw   0x07
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs11004
    
    movf    inChar, W
    movwf   longText+4, BANKED

    ; store first minute digit 
    movlw   0x30
    subwf   inChar, W
    movwf   tmpL
    clrf    tmpM
    clrf    tmpH

    ; todo : This lot can be improved using the multiply instruction. But not much
    
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; So thats x2
    movf    tmpL, W
    movwf   tmp1L
    movf    tmpM, W
    movwf   tmp1M
    movf    tmpH, W
    movwf   tmp1H
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movf    tmp1L, W
    addwf   tmpL, F
    movf    tmp1M, W
    addwfc  tmpM, F
    movf    tmp1H, W
    addwfc  tmpH, F
 
    bra     rxs11exit    
    
rxs11004
    movlw   0x06
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs11005
    
    movf    inChar, W
    movwf   longText+5, BANKED

    ; store second minute digit 
    ; add ascii digit and * 10
    ; add in m2
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    addwfc  tmpM,F
    addwfc  tmpH,F

    ; Multiply iLongDeg by 60. iLongDeg unchanged, result in tmpL/M/H

    ; preserve the PRODH/L bytes
    movf    PRODH, W
    movwf   tmp1H
    movf    PRODL, W
    movwf   tmp1L
    ; Multiply iLatDeg by 60. iLatDeg unchanged
    movf    iLongDeg, W
    mullw   D'60'
    ; Now add this into tmpL/M/H
    movf    PRODL, W
    addwf   tmpL, F
    movf    PRODH, W
    addwfc  tmpM, F
    movlw   0
    addwfc  tmpH, F
    ; restore the PRODH/L bytes
    movf    tmp1H, W
    movwf   PRODH
    movf    tmp1L, W
    movwf   PRODL   
     
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; So thats x2
    movf    tmpL, W
    movwf   tmp1L
    movf    tmpM, W
    movwf   tmp1M
    movf    tmpH, W
    movwf   tmp1H
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movf    tmp1L, W
    addwf   tmpL, F
    movf    tmp1M, W
    addwfc  tmpM, F
    movf    tmp1H, W
    addwfc  tmpH, F
    
    bra     rxs11exit
    
rxs11005
    movlw   0x05                ; the . character
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs11005a

    movf    inChar, W
    movwf   longText+6, BANKED

    bra     rxs11exit
    
    
rxs11005a
    movlw   0x04                
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs11006
    
; add ascii digit and * 10
    movf    inChar, W
    movwf   longText+7, BANKED
    
    ; add in m3
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    addwfc  tmpM,F
    addwfc  tmpH,F
    
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; So thats x2
    movf    tmpL, W
    movwf   tmp1L
    movf    tmpM, W
    movwf   tmp1M
    movf    tmpH, W
    movwf   tmp1H
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlcf     tmpL,F
    rlcf     tmpM,F
    rlcf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movf    tmp1L, W
    addwf   tmpL, F
    movf    tmp1M, W
    addwfc  tmpM, F
    movf    tmp1H, W
    addwfc  tmpH, F
    bra     rxs11exit
    
rxs11006
    movlw   0x03
    subwf   rxSubState,W
    btfss   STATUS, Z
    bra     rxs11exit 
 
    movf    inChar, W
    movwf   longText+8, BANKED

    ; add in m4
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    addwfc  tmpM,F
    addwfc  tmpH,F
 
rxs11exit
    decfsz  rxSubState, F
    return
    incf    rxState, F
    return   
    
rxs12
    incf    rxState, F  ; skip the , character
    return   
    
rxs13
    movf    inChar, W
    movwf   longText+0x0A, BANKED

    movlw   'W'
    subwf   inChar, W
    btfss   STATUS, Z
    bra     rxs13exit

    ; negate the binary value.
    ; ie, invert the bits and add 1
    comf    tmpL, F
    comf    tmpM, F
    comf    tmpH, F
    movlw   1    
    addwf   tmpL, F
    movlw   0
    addwfc  tmpM,F
    addwfc  tmpH,F
    
rxs13exit
    ; Now store tmp into iLongmmhh
    movf    tmpH, W
    movwf   iLongmmhh
    movf    tmpM, W
    movwf   iLongmmhh + 1
    movf    tmpL, W
    movwf   iLongmmhh + 2
    incf    rxState, F 
    return   

rxs14
    incf    rxState, F  ; skip the , character
    return   

rxs15
    ; If valid flag is set, set INLOCKFLAG flag
    incf    rxState, F 
    bcf     flags2, INLOCKFLAG2
    movf    inChar, W
    sublw   '0'
    btfss   STATUS,Z
    bsf     flags2, INLOCKFLAG2
    btfss   STATUS,Z
    bsf     flags2, NEWDATAFLAG2        ; Signal to forground that we have data

    return   


rxs17
    ; loop until ',' received. Then inc rxstate
    movf    inChar, W
    sublw   ','
    btfss   STATUS,Z
    return
    ; rxs16 placed here to save a bit of code
rxs16
    incf    rxState, F  
    return   


rxs17a
    ; loop until ',' received. Then inc rxstate
    movf    inChar, W
    sublw   ','
    btfss   STATUS,Z
    return
    
    btfsc   flags2, NEWALTDATAFLAG2
    goto    rxs17End

    incf    rxState, F  
    
    clrf    iAlt1
    clrf    iAlt2
    clrf    iAlt3
    clrf    iAlt4
    return   
    

rxs17s
    ; loop until ',' received. Then inc rxstate
    movf    inChar, W
    sublw   ','
    btfss   STATUS,Z
    return

    btfsc   flags2, NEWSPEEDDATAFLAG2
    goto    rxs17End
    
    incf    rxState, F  
    
    clrf    iHead1, BANKED
    clrf    iHead2, BANKED
    clrf    iHead3, BANKED
    clrf    iSpeedH
    clrf    iSpeedL
    return   


rxs17End
    ; last data not yet processed - ignore this message        
    clrf    rxState
    return

        
rxs18
    movf    inChar, W
    sublw   '.'
    btfss   STATUS,Z
    goto    rxs18a

rxs18x    
    clrf    rxState
    bsf     flags2, NEWALTDATAFLAG2
    return
    
rxs18a

    movf    inChar, W
    sublw   ','
    bz      rxs18x
    
    movf    inChar, W
    tstfsz  iAlt1
    bra     rxs18a1
    
    ; Ignore leading zeros
    sublw   '0'
    bnz     rxs18a0
    return
    
rxs18a0    
    movf    inChar, W
    movwf   iAlt1
    return
 
rxs18a1    
    tstfsz  iAlt2
    bra     rxs18a2
    movwf   iAlt2
    return

rxs18a2    
    tstfsz  iAlt3
    bra     rxs18a3
    movwf   iAlt3
    return
    
rxs18a3    
    movwf   iAlt4
    return
    
    
rxs18h
    movf    inChar, W
    sublw   '.'
    btfss   STATUS,Z
    goto    rxs18ha

rxs18ha0    
    clrf    rxState
    bsf     flags2, NEWSPEEDDATAFLAG2
    return
    
rxs18ha
    ; Heuristic - a , means we have a null entry
    movf    inChar, W
    sublw   ','
    bz      rxs18ha0

rxs18ha000    
    ; Heuristic - if we have filled the 3 digits, end
    movf    iHead3, W, BANKED
    bnz     rxs18ha0

rxs18ha00           
    movf    inChar, W
    tstfsz  iHead1, BANKED
    bra     rxs18ha1
    movwf   iHead1, BANKED
    return
 
rxs18ha1    
    tstfsz  iHead2, BANKED
    bra     rxs18ha2
    movwf   iHead2, BANKED
    return

rxs18ha2    
    movwf   iHead3, BANKED
    return
            
    
rxs19
    clrf    rxState
    movf    inChar, W
    sublw   'M'
    btfss   STATUS,Z
    return
    movlw   D'22'
    movwf   rxState
    return   


rxs20
    clrf    rxState
    movf    inChar, W
    sublw   'C'
    btfss   STATUS,Z
    return
    movlw   D'23'
    movwf   rxState
    return   
    
    
rxs21
    movf    inChar, W
    sublw   '.'
    btfss   STATUS,Z
    goto    rxs21a

rxs21x       
    incf    rxState, F
    return
    
rxs21a

    movf    inChar, W
    sublw   ','
    bz      rxs21x

    ; preserve the PRODH/L bytes
    movf    PRODH, W
    movwf   tmpH
    movf    PRODL, W
    movwf   tmpL
    
    movlw   0x0A
    mulwf   iSpeedH
    movf    PRODL, W    
    movwf   iSpeedH 
    movlw   0x0A
    mulwf   iSpeedL
    movf    PRODL, W
    movwf   iSpeedL
    movf    PRODH, W
    addwf   iSpeedH, F

    movlw   '0'
    subwf   inChar, W
    addwf   iSpeedL, F
    movlw   0
    addwfc  iSpeedH, F

    ; restore the PRODH/L bytes
    movf    tmpH, W
    movwf   PRODH
    movf    tmpL, W
    movwf   PRODL

    return
    
    
    
    