;*****************************************************************************        
;
;   Module:     math.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 27/6/05                                                  
;
;               Various fixed point math routines
;               The functions FXM2424U and FXM2416U are from Microchips 
;               excellent application note AN617.
;               Other bits are mine.
;
;*****************************************************************************        





;**********************************************************************************************
;       
;       24x16 Bit Unsigned Fixed Point Multiply 24 x 16 -> 40
;
;       Input:  24 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2
;               16 bit unsigned fixed point multiplier in BARGB0, BARGB1
;
;       Use:    CALL    FXM2416U
;
;       Output: 40 bit unsigned fixed point product in AARGB0, AARGB1, 
;               AARGB2, AARGB3, AARGB4
;
;       Result: AARG  <--  AARG * BARG
;
;       Max Timing:     40 clks
;
;       Min Timing:     40 clks
;
;       PM: 39              DM: 8
;
;
FXM2416U	
        MOVfF	AARGB2,TEMPB2	
		MOVF	AARGB2,W
		MULWF	BARGB1
		MOVFF	PRODH,AARGB3
		MOVFF	PRODL,AARGB4
		
		MOVF	AARGB1,W
		MULWF	BARGB0
		MOVFF	PRODH,AARGB1
		MOVFF	PRODL,AARGB2

		MULWF	BARGB1
		MOVF	PRODL,W
		ADDWF	AARGB3,F
		MOVF	PRODH,W
		ADDWFC	AARGB2,F
		movlw   0
		ADDWFC	AARGB1,F

		MOVF	TEMPB2,W
		MULWF	BARGB0
		MOVF	PRODL,W
		ADDWF	AARGB3,F
		MOVF	PRODH,W
		ADDWFC	AARGB2,F
		movlw   0
		ADDWFC	AARGB1,F
	
		MOVF	AARGB0,W
		MULWF	BARGB1
		MOVF	PRODL,W
		ADDWF	AARGB2,F
		MOVF	PRODH,W
		ADDWFC	AARGB1,F
		MOVF	AARGB0,W
		MULWF	BARGB0
		CLRF	AARGB0,W
		ADDWFC	AARGB0,F
		MOVF	PRODL,W
		ADDWF	AARGB1,F
		MOVF	PRODH,W
		ADDWFC	AARGB0,F
	
		RETURN



;*****************************************************************************        
;
;   Function :  calcCosineL
;               This function returns the low byte of a 16bit fixed point
;               cosine value.
;
;   Input:      degrees in LatDeg
;
;   Output:     low byte of cosine in W
;
;*****************************************************************************        
calcCosineL
    movlw   high calcCosineL
    movwf   PCLATH
    movf    LatDeg, W
    addwf   LatDeg, W
    addwf   PCL ,F

	retlw	0xf6
	retlw	0xd8
	retlw	0xa6
	retlw	0x60
	retlw	0x06
	retlw	0x98
	retlw	0x17
	retlw	0x82
	retlw	0xd9
	retlw	0x1c
	retlw	0x4b
	retlw	0x67
	retlw	0x70
	retlw	0x65
	retlw	0x46
	retlw	0x15
	retlw	0xd0
	retlw	0x78
	retlw	0x0d
	retlw	0x8f
	retlw	0xff
	retlw	0x5b
	retlw	0xa6
	retlw	0xde
	retlw	0x03
	retlw	0x17
	retlw	0x19
	retlw	0x08
	retlw	0xe7
	retlw	0xb3
	retlw	0x6f
	retlw	0x19
	retlw	0xb3
	retlw	0x3b
	retlw	0xb3
	retlw	0x1b
	retlw	0x73
	retlw	0xbb
	retlw	0xf3
	retlw	0x1b
	retlw	0x34
	retlw	0x3e
	retlw	0x3a
	retlw	0x26
	retlw	0x04
	retlw	0xd5
	retlw	0x97
	retlw	0x4c
	retlw	0xf3
	retlw	0x8d
	retlw	0x1b
	retlw	0x9b
	retlw	0x10
	retlw	0x79
	retlw	0xd5
	retlw	0x27
	retlw	0x6d
	retlw	0xA8
	retlw	0xD9
	retlw	0x00
	retlw	0x1C
	retlw	0x2F
	retlw	0x38
	retlw	0x39
	retlw	0x30
	retlw	0x1F
	retlw	0x06
	retlw	0xE6
	retlw	0xBE
	retlw	0x8E
	retlw	0x58
	retlw	0x1B
	retlw	0xD8
	retlw	0x90
	retlw	0x41
	retlw	0xEE
	retlw	0x96
	retlw	0x39
	retlw	0xD8
	retlw	0x74
	retlw	0x0C
	retlw	0xA0
	retlw	0x32
	retlw	0xC2
	retlw	0x4F
	retlw	0xDB
	retlw	0x65
	retlw	0xEF
calcCosineL_end	
	retlw	0x77

    IF ( (calcCosineL & 0x0FF) >= (calcCosineL_end & 0x0FF) )
        MESSG   "Table calcCosineL overflow"
    ENDIF

 

    
    ; Add some padding bytes to make next routine fit in a 256 byte page.
    ; You could always move code in here instead, if need be.
    
    FILL  0, 30



;*****************************************************************************        
;
;   Function :  calcCosineH
;               This function returns the high byte of a 16bit fixed point
;               cosine value.
;
;   Input:      degrees in LatDeg
;
;   Output:     high byte of cosine in W
;
;*****************************************************************************        
calcCosineH
    movlw   high calcCosineH
    movwf   PCLATH
    movf    LatDeg, W
    addwf   LatDeg, W
    addwf   PCL ,F

	retlw	0xff
	retlw	0xff
	retlw	0xff
	retlw	0xff
	retlw	0xff
	retlw	0xfe
	retlw	0xfe
	retlw	0xfd
	retlw	0xfc
	retlw	0xfc
	retlw	0xfb
	retlw	0xfa
	retlw	0xf9
	retlw	0xf8
	retlw	0xf7
	retlw	0xf6
	retlw	0xf4
	retlw	0xf3
	retlw	0xf2
	retlw	0xf0
	retlw	0xee
	retlw	0xed
	retlw	0xeb
	retlw	0xe9
	retlw	0xe8
	retlw	0xe6
	retlw	0xe4
	retlw	0xe2
	retlw	0xdf
	retlw	0xdd
	retlw	0xdb
	retlw	0xd9
	retlw	0xd6
	retlw	0xd4
	retlw	0xd1
	retlw	0xcf
	retlw	0xcc
	retlw	0xc9
	retlw	0xc6
	retlw	0xc4
	retlw	0xc1
	retlw	0xbe
	retlw	0xbb
	retlw	0xb8
	retlw	0xb5
	retlw	0xb1
	retlw	0xae
	retlw	0xab
	retlw	0xa7
	retlw	0xa4
	retlw	0xa1
	retlw	0x9d
	retlw	0x9a
	retlw	0x96
	retlw	0x92
	retlw	0x8f
	retlw	0x8b
	retlw	0x87
	retlw	0x83
	retlw	0x80
	retlw	0x7C
	retlw	0x78
	retlw	0x74
	retlw	0x70
	retlw	0x6C
	retlw	0x68
	retlw	0x64
	retlw	0x5F
	retlw	0x5B
	retlw	0x57
	retlw	0x53
	retlw	0x4F
	retlw	0x4A
	retlw	0x46
	retlw	0x42
	retlw	0x3D
	retlw	0x39
	retlw	0x35
	retlw	0x30
	retlw	0x2C
	retlw	0x28
	retlw	0x23
	retlw	0x1F
	retlw	0x1A
	retlw	0x16
	retlw	0x11
	retlw	0x0D
	retlw	0x08
calcCosineH_end
	retlw	0x04

    IF ( (calcCosineH & 0x0FF) >= (calcCosineH_end & 0x0FF) )
        MESSG   "Table calcCosineH overflow"
    ENDIF



;**********************************************************************************************
;       
;       24x24 Bit Unsigned Fixed Point Multiply 24 x 24 -> 48
;
;       Input:  24 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2
;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2
;
;       Use:    CALL    FXM2424U
;
;       Output: 48 bit unsigned fixed point product in AARGB0, AARGB1, 
;               AARGB2, AARGB3, AARGB4, AARGB5
;
;       Result: AARG  <--  AARG * BARG
;
;       Max Timing:     65 clks
;
;       Min Timing:     65 clks
;
;       PM: 64              DM: 12
;
;

FXM2424U	
        MOVFF	AARGB0,TEMPB0	
		MOVFF	AARGB1,TEMPB1	
		MOVFF	AARGB2,TEMPB2	

		MOVF	AARGB2,W
		MULWF	BARGB2
		MOVFF	PRODH,AARGB4
		MOVFF	PRODL,AARGB5
		
		MOVF	AARGB1,W
		MULWF	BARGB1
		MOVFF	PRODH,AARGB2
		MOVFF	PRODL,AARGB3

		MULWF	BARGB2
		MOVF	PRODL,W
		ADDWF	AARGB4,F
		MOVF	PRODH,W
		ADDWFC	AARGB3,F
		MOVLW   0
		ADDWFC	AARGB2,F

		MOVF	TEMPB2,W
		MULWF	BARGB1
		MOVF	PRODL,W
		ADDWF	AARGB4,F
		MOVF	PRODH,W
		ADDWFC	AARGB3,F
		MOVLW   0
		ADDWFC	AARGB2,F
	
		MOVF	AARGB0,W
		MULWF	BARGB2
		MOVF	PRODL,W
		ADDWF	AARGB3,F
		MOVF	PRODH,W
		ADDWFC	AARGB2,F
		MOVF	AARGB0,W
		MULWF	BARGB1
		CLRF	AARGB1,W
		ADDWFC	AARGB1,F
		MOVF	PRODL,W
		ADDWF	AARGB2,F
		MOVF	PRODH,W
		ADDWFC	AARGB1,F

		MOVF	TEMPB2,W
		MULWF	BARGB0
		MOVF	PRODL,W
		ADDWF	AARGB3,F
		MOVF	PRODH,W
		ADDWFC	AARGB2,F
		CLRF	AARGB0,W
		ADDWFC	AARGB1,F
		ADDWFC	AARGB0,F

		MOVF	TEMPB1,W
		MULWF	BARGB0
		MOVF	PRODL,W
		ADDWF	AARGB2,F
		MOVF	PRODH,W
		ADDWFC	AARGB1,F
		MOVLW   0
		ADDWFC	AARGB0,F

		MOVF	TEMPB0,W
		MULWF	BARGB0
		MOVF	PRODL,W
		ADDWF	AARGB1,F
		MOVF	PRODH,W
		ADDWFC	AARGB0,F

		RETURN

     