;*****************************************************************************        
;
;   Module:     equates.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.0 5/10/03                                                  
;
;               equate statements for variables and constants
;
;*****************************************************************************        


DATA_BUS            EQU PORTC        ; LCD data lines interface
DATA_BUS_TRIS       EQU TRISC

CONTROL             EQU PORTA
CONTROL_TRIS        EQU TRISA
    
PROM_ADD_H          EQU PORTE
PROM_ADD_M          EQU PORTD
PROM_ADD_L          EQU PORTB
    
; PORTA bits
LCD_RS              EQU 0            ; LCD Register-Select control line
LCD_RW              EQU 4            ; LCD Read/Write control line
LCD_E               EQU 2            ; LCD Enable control line
ROM_OE              EQU 3
ROM_CE              EQU 1
ROM_WE              EQU 0
KEY_EN              EQU 5            ; Enable keyboard drivers


; Bank 0 RAM
lcdTmp              EQU 0x20        ; LCD subroutines internal use
delay1              EQU 0x21        ; Used bu 100us delay routine
delay2              EQU 0x22        
delay3              EQU 0x23        
lcdCtrl             EQU 0x24        ; LCD control lines interface mirror
lcdTmp2             EQU 0x25        ; Used by display.inc
promAddH            EQU 0x26
promAddM            EQU 0x27
promAddL            EQU 0x28
promData            EQU 0x29        ; Byte read from prom
dataBuffer          EQU 0x2A        ; 32 byte buffer
inStrLen            EQU 0x4A        ; Length of the search word
tmpVal              EQU 0x4B        
dspBuffer           EQU 0x4C        ; 32 byte display buffer, just for the word
optionMode          EQU 0x6C        ; Word or Anagram option chosen 0 == Word, 0xff == Anagram
position            EQU 0x6D        ; Cursor position
count               EQU 0x6E    

PCLATH_TEMP         EQU 0x7d        ; Exists in all banks
STATUS_TEMP         EQU 0x7e        ; Exists in all banks
W_TEMP              EQU 0x7f        ; Exists in all banks


KEY_LEFT            EQU 0x80
KEY_RIGHT           EQU 0x40
KEY_DO              EQU 0x10
KEY_SHIFT           EQU 0x20

KEY_LEFT_BIT        EQU 7   
KEY_RIGHT_BIT       EQU 6   
KEY_DO_BIT          EQU 4   
KEY_SHIFT_BIT       EQU 5   
