;*****************************************************************************        
;
;   Module:     ints.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 20/3/04                                                  
;
;               interrupt handler.
;               Manages incoming characters from the GPS module and
;               100ms timer, which handles the application timers
;
;*****************************************************************************        

INTERRUPT
    ; Save the current CPU status
    movwf   W_TEMP
    swapf   STATUS, W
    clrf    STATUS                     
    movwf   STATUS_TEMP    
    movfw   PCLATH
    movwf   PCLATH_TEMP
    clrf    PCLATH
    
    
    ; check for rx data
    btfss   PIR1, RCIF
    goto    tryKeys
    
    movfw   RCSTA
    andlw   0x06
    btfss   STATUS, Z
    goto    rxErr
    
    ; read serial port data
    movfw   RCREG
    
    ; Do something with it
    call    rxStateMachine
   
    goto    tryKeys
    
rxErr    
    movfw   RCREG               ; clear any frame errors
    bcf     RCSTA, CREN
    bsf     RCSTA, CREN
    
tryKeys        
    ; Check for Port B interrupts
    ; port B interupts are not used, but clear them if they occur
    btfss   INTCON, RBIF        
    goto    trytimerInt
    
    bcf     INTCON, RBIF                ; Must clear interrupt flag
    
    ; Do any other RB port interrupt stuff here
    ; In this design, nothing.
        
trytimerInt
    ; Check for timer1 ( 100ms ) interrupt
    btfss   PIR1, TMR1IF
    goto    intDone
    
    movlw   LOW TMR100MS                ; Timer interval 100ms
    movwf   TMR1L
    movlw   HIGH TMR100MS              
    movwf   TMR1H

    bcf     PIR1, TMR1IF                ; Must clear interrupt flag

    ; Do timer1 related stuff here.
    ; decrement the application defined 100ms counters
    movfw   ignoreRecBtnTmr
    btfsc   STATUS,Z
    goto    tmr1Done    
    decfsz  ignoreRecBtnTmr, F
    goto    tmr1Done    
    bsf     flags1, IGNORERECBTNTMRFLAG1
    
tmr1Done
    movfw   ignoreEraseBtnTmr
    btfsc   STATUS,Z
    goto    tmr2Done    
    decfsz  ignoreEraseBtnTmr, F
    goto    tmr2Done    
    bsf     flags1, IGNOREERASEBTNTMRFLAG1
    
tmr2Done
    movfw   recBeepTmr
    btfsc   STATUS,Z
    goto    tmr3Done    
    decfsz  recBeepTmr, F
    goto    tmr3Done    
    bsf     flags1, RECBEEPTMRFLAG1
    
tmr3Done
    movfw   eraseBeepTmr
    btfsc   STATUS,Z
    goto    tmr4Done    
    decfsz  eraseBeepTmr, F
    goto    tmr4Done    
    bsf     flags1, ERASEBEEPTMRFLAG1
    
tmr4Done
    movfw   pwrFlashOnTmr
    btfsc   STATUS,Z
    goto    tmr5Done    
    decfsz  pwrFlashOnTmr, F
    goto    tmr5Done    
    bsf     flags1, PWRFLASHONTMRFLAG1
    
tmr5Done
    movfw   pwrFlashOffTmr
    btfsc   STATUS,Z
    goto    tmr6Done    
    decfsz  pwrFlashOffTmr, F
    goto    tmr6Done    
    bsf     flags1, PWRFLASHOFFTMRFLAG1
    
tmr6Done
    movfw   warningBeepOnTmr
    btfsc   STATUS,Z
    goto    tmr7Done    
    decfsz  warningBeepOnTmr, F
    goto    tmr7Done    
    bsf     flags1, WARNINGBEEPONTMRFLAG1
    
tmr7Done
    movfw   warningBeepOffTmr
    btfsc   STATUS,Z
    goto    tmr8Done    
    decfsz  warningBeepOffTmr, F
    goto    tmr8Done    
    bsf     flags1, WARNINGBEEPOFFTMRFLAG1
    
tmr8Done

intDone        
    ; Restore the CPU status
    movfw   PCLATH_TEMP
    movwf   PCLATH
    swapf   STATUS_TEMP, W
    movwf   STATUS
    swapf   W_TEMP,F
    swapf   W_TEMP, W
    retfie
