;*****************************************************************************        
;
;   Module:     equates.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 12/1/04                                           
;
;               equate statements for variables and constants
;
;*****************************************************************************        


BAUD_19200_20MHZ        EQU 0x40            ; for 19200 baud, brgh =1
BAUD_4800_16MHZ         EQU 0x33            ; for 4800 baud, brgh = 0
BAUD_4800_20MHZ         EQU 0x40            ; for 4800 baud, brgh = 0
BAUDRATE                EQU BAUD_4800_20MHZ
                                    

TMR100MS_20MHZ          EQU 0xBDC           ; 100ms on timer1 at 20MHz
TMR100MS_16MHZ          EQU 0x3CB0          ; 100ms on timer1 at 16MHz
TMR100MS                EQU TMR100MS_20MHZ


; LED Set Points
; These 7 equates determine the distance from a camerapoint
; that each led represents. They are signed 16 bit numbers
; and can therefore have a postive value from 0 to 0x7fff

DIST_LED1               EQU 0x7fff  ; Any 'close' value sets first led
DIST_LED2               EQU 0x0af9  ; < 1000m
DIST_LED3               EQU 0x02a4  ; < 500m
DIST_LED4               EQU 0x01b9  ; < 400m
DIST_LED5               EQU 0x00e1  ; < 300m
DIST_LED6               EQU 0x0064  ; < 200m
DIST_LED7               EQU 0x0010  ; < 100m


; Various bit defines on ports
PWRLED                  EQU 0       ; of port B
LED1                    EQU 1       ; of port B
LED2                    EQU 2       ; of port B
LED3                    EQU 3       ; of port B
LED4                    EQU 4       ; of port B
LED5                    EQU 5       ; of port B
LED6                    EQU 6       ; of port B
LED7                    EQU 7       ; of port B

RECORDKEY               EQU 0x01       ; of port A
ERASEKEY                EQU 0x02       ; of port A


; Bit fields in flags1
IGNORERECBTNTMRFLAG1    EQU 0           
IGNOREERASEBTNTMRFLAG1  EQU 1
RECBEEPTMRFLAG1         EQU 2 
WARNINGBEEPONTMRFLAG1   EQU 3 
ERASEBEEPTMRFLAG1       EQU 4 
PWRFLASHONTMRFLAG1      EQU 5
PWRFLASHOFFTMRFLAG1     EQU 6
WARNINGBEEPOFFTMRFLAG1  EQU 7 

; Bit field combinations in flags1
BEEPSOURCES             EQU 0x1C

; Bit fields in flags2
INLOCKFLAG2             EQU 0
WARNINGFLAG2            EQU 1
NEWDATAFLAG2            EQU 2
NOWARNFLAG2             EQU 3
DUMPEEPROMFLAG2			EQU	4
FILLEEPROMFLAG2			EQU	5

; These define the audio frequency of the various sounds
RECORDBEEPFREQ          EQU 0x80
ERASEBEEPFREQ           EQU 0xA0
WARNINGBEEPFREQ         EQU 0xC0
NOSOUND                 EQU 0

; These are 100ms Tick Timer values
RECORDBEEPTIME          EQU 0x04
ERASEBEEPTIME           EQU 0x02
WARNINGONTIME           EQU 0x03
WARNINGOFFTIME          EQU 0x0A
PWRLEDONTIME            EQU 0x0A
PWRLEDOFFTIME           EQU 0x0A
IGNOREERASEKEYTIME      EQU 0x14
IGNORERECORDKEYTIME     EQU 0x14


; Bank 0 RAM
ignoreRecBtnTmr         EQU 0x20        
ignoreEraseBtnTmr       EQU 0x21        
recBeepTmr              EQU 0x22       
warningBeepOnTmr        EQU 0x23        
eraseBeepTmr            EQU 0x24        
pwrFlashOnTmr           EQU 0x25
pwrFlashOffTmr          EQU 0x26        
flags1                  EQU 0x27        ; Holds 8 100ms timers      
delay1                  EQU 0x28        ; Used bu 100us delay routine
delay2                  EQU 0x29        
delay3                  EQU 0x2A        
warningBeepOffTmr       EQU 0x2B
flags2                  EQU 0x2C     
rxState                 EQU 0x2D
inChar                  EQU 0x2E
rxSubState              EQU 0x2F   

portBCopy               EQU 0x30
eepAddH                 EQU 0x31
eepAddL                 EQU 0x32
eepData                 EQU 0x33
eepNum                  EQU 0x34

; Current Position, calculated in interrupt routine
iLatDeg                 EQU 0x35
iLatmmhh                EQU 0x36        ; 3 bytes
iLongDeg                EQU 0x39
iLongmmhh               EQU 0x3A        ; 3 bytes

; Foreground task's copy of the above
LatDeg                  EQU 0x3D
Latmmhh                 EQU 0x3E        ; 3 bytes
LongDeg                 EQU 0x41
Longmmhh                EQU 0x42        ; 3 bytes

iTmp                    EQU 0x45
tmpH                    EQU 0x46
tmpM                    EQU 0x47
tmpL                    EQU 0x48
tmp1H                   EQU 0x49
tmp1M                   EQU 0x4A
tmp1L                   EQU 0x4B

numEntriesH             EQU 0x4C
numEntriesL             EQU 0x4D
scanNumH                EQU 0x4E
scanNumL                EQU 0x4F
scanDist                EQU 0x50 ; 3 bytes
scanLat                 EQU 0x53 ; 3 bytes
scanLong                EQU 0x56 ; 3 bytes
cosineValueH            EQU 0x59 
cosineValueL            EQU 0x5A
range                   EQU 0x5B
maskPosH                EQU 0x5C
maskPosL                EQU 0x5D
spare2                  EQU 0x5E
dist                    EQU 0x5F ; 3 bytes
currentPosH             EQU 0x62
currentPosL             EQU 0x63          

;; The follow are storage for AN617's variables
TEMPB2                  EQU     0x64
TEMPB1                  EQU     0x65
TEMPB0                  EQU     0x66
TEMP                    EQU     0x66    ; temporary storage
;
;       binary operation arguments
;
AARGB7                  EQU     0x67
AARGB6                  EQU     0x68
AARGB5                  EQU     0x69
AARGB4                  EQU     0x6a
AARGB3                  EQU     0x6b
AARGB2                  EQU     0x6c
AARGB1                  EQU     0x6d
AARGB0                  EQU     0x6e
AARG                    EQU     0x6e    ; most significant byte of argument A
;
BARGB3                  EQU     0x6F
BARGB2                  EQU     0x70
BARGB1                  EQU     0x7a
BARGB0                  EQU     0x7b
BARG                    EQU     0x7b    ; most significant byte of argument B
;
;       Note that AARG and ACC reference the same storage locations

LOOPCOUNT               EQU     0x7c    ; loop counter

PCLATH_TEMP             EQU     0x7d        ; Exists in all banks
STATUS_TEMP             EQU     0x7e        ; Exists in all banks
W_TEMP                  EQU     0x7f        ; Exists in all banks
