#include "stdafx.h"
#include <conio.h>

#include "green\compplib.hpp"
#include "green\ibmkeys.h"
#include "green\filexfer.hpp"



GFComWin32		*sio = NULL;
GFSerial		*cp = NULL;
GFDataFormat	*df;
UINT			commPort = 0;
FILE			*fpIn;

// executable file image for writing to unit's bootloader
unsigned char binImage[128000];

char firmwareFilename[1024];



// read inhx32 format text file
unsigned long readHexFile( void )
{
	char str[256];
	char *res;
	unsigned int address;
	unsigned int byteCount;
	unsigned int lineType;
	unsigned int dataByte;
	unsigned int lp;
	unsigned int extendedAddress=0;
    unsigned long lastAddress;lastAddress;
    
	lastAddress = 0;

	do {
		res = fgets(str, 256, fpIn);

		if ( res ) {
			sscanf(str,":%2X%4X%2X",&byteCount,&address,&lineType);

			if ( (lineType == 0) &&  ( extendedAddress == 0 ) ) {
				if ( (address + byteCount - 1) > lastAddress )
					lastAddress = (address + byteCount - 1);
				
				if ( (address + byteCount - 1) < sizeof(binImage) ) {
					for (lp=0; lp < byteCount; lp++ ) {
						sscanf(str+9+(lp*2),"%2X",&dataByte);
						binImage[address+lp] = dataByte;
					}
				}
			} else if ( lineType == 4 ) {
				// extended address specified
				sscanf(str+9,"%4X",&extendedAddress);
			
			}
		}

    } while ( res );
    
    return lastAddress;
}



int main(int argc, char* argv[])
{
	int rxData,key, lp;
	int fileArgPos;

	unsigned long currentAddress,lastAddress;
	
	// parse the command line, giving some help text if no options given
	
	if ( argc < 3 ) {
	    printf("EPE PICnMIX Bootloader Utility\r\nV1.0 13/10/05 mike.hibbett@gmail.com\r\n\r\n");
	    printf("Run this program like this:\r\nBLOAD comport filename\r\nwhere comport is 0 or 1\r\n");
	    printf("If the filename or directory contains spaces, enclose it in double quotes.\r\n");
	    printf("eg  bload 0 \"C:\\program files\\myfiles\\main.hex\"\r\n");
        printf("Press any key to exit.\n");
    	key = getch();
		return -1;
	}


	if ( (argv[1][0] < '0') || (argv[1][0] > '4') ) {
		printf("The com port must be a number between 0 and 4\r\n");
        printf("Press any key to exit.\n");
    	key = getch();
		return -1;
	} else {
		commPort = argv[1][0] - '0';
	}

	// Did someone speficy the 's' option?
	if ( argc == 3 ) 
		fileArgPos = 2;
	else
		fileArgPos = 3;

	if ( strlen(argv[fileArgPos] ) < sizeof( firmwareFilename ) ) {
		sprintf(firmwareFilename,"%s", argv[fileArgPos] );
	} else {
		printf("The filename you specified is more than %d characters long,\r\n",sizeof( firmwareFilename ));
		printf("which is the largest number of characters you can use.\r\n");
		printf("Please specifiy a shorter filename!\r\n");
        printf("Press any key to exit.\n");
    	key = getch();
		return -1;
	}

    // Open the .hex file for reading, default text translation
	fpIn = fopen(firmwareFilename,"r");

    // If we couldn't open the file, exit. There is nothing else we can do.
	if ( fpIn == NULL ) {
		printf("Cannot open the hex file %s for reading.\r\n",firmwareFilename);
        printf("Press any key to exit.\r\n");
    	key = getch();
		return -1;
	}

    // Read the hex file, converting it into a binary data array binImage,
    // and recording the last used code address in lastAddress
	lastAddress = readHexFile();
    
	printf("Last program address read is 0x%X (%d).\r\n", lastAddress, lastAddress);

    fclose(fpIn);

	// Create the serial comms object
	sio = new GFComWin32( commPort );

	if ( !sio  ) {
		printf("Error Opening Comm Port.\r\n");
		if (sio)
			delete sio;
        printf("Press any key to exit.\r\n");
    	key = getch();
		return -1;
	}
		
	cp = new GFSerial( sio );

	GFDataFormat *df;
	df = cp->GetDataFormat();

	if (!df) {
		printf("Error Opening Comm Port.\r\n");

		if (cp)
			delete cp;
		if (sio)
			delete sio;
        printf("Press any key to exit.\r\n");
    	key = getch();
		return -1;
	}
	
	if ( fileArgPos == 2 )
		df->BaudRate( 115200 );
	else {
		printf("Running in slow mode, 38400 baud.\r\n");
		df->BaudRate( 38400 );
	}

	df->Parity( 'N' );
	df->DataLength( 8 );
	df->StopBits( 1 ); 
	
	// Flush the rx buffer
	do { 
		rxData = cp->GetChar(1000);
	} while ( rxData != GCPP_TIMEOUT );


	while ( kbhit() ) 
		getch();

	printf("Waiting for PIC to connect. Press a key to exit.\r\n");
	lp = 0;
	do {
		printf("listening... %d\r",lp);
		rxData = cp->GetChar(1000);
		lp++;
	} while ( (rxData != 'X') && !kbhit() );

	while ( kbhit() ) 
		getch();

	if (rxData != 'X') {
		printf("\r\nProgram stopped by user keypress.\r\n");
		
		if (cp)
			delete cp;
		
		if (sio)
			delete sio;

		printf("Press any key to exit.\n");
		key = getch();
		return -1;

	}
	cp->PutImm('X');
	rxData = cp->GetChar(1000);
	if (rxData != 'G') {
		printf("\r\nNo response from PIC. Please try again.\r\n");
		
		if (cp)
			delete cp;
		
		if (sio)
			delete sio;

		printf("Press any key to exit.\n");
		key = getch();
		return -1;
	}

	printf("\r\nSync'ed with PIC. Programming...\r\n");

	currentAddress = 0x600; // First address of application

	for ( currentAddress = 0x600; currentAddress <= (lastAddress+1); currentAddress+= 64 ) {
		unsigned char errCount=0;

		do {
			unsigned char check = 0; 
			cp->PutImm((unsigned char)((currentAddress >> 8) & 0xFF)); check += ((unsigned char)((currentAddress >> 8) & 0xFF));
			cp->GetChar(10);
			cp->PutImm((unsigned char)(currentAddress & 0xFF)); check += ((unsigned char)(currentAddress & 0xFF));
			cp->GetChar(10);

			for (lp=0; lp < 64; lp+=2) {
				cp->PutImm(binImage[currentAddress+lp]); check += (binImage[currentAddress+lp]);
				cp->GetChar(1);
				cp->PutImm(binImage[currentAddress+lp+1]); check += (binImage[currentAddress+lp+1]);
				cp->GetChar(1);
			}

			cp->PutImm(check);

			rxData = cp->GetChar(4000);

			printf("Address 0x%X\r",currentAddress);

		} while ( ( rxData != 'Y' ) && (errCount++ < 10));


		if ( errCount == 10 ) {
			printf("\r\nTimed out talking to unit. Please retry.");
			printf("Press any key to exit.\r\n");
			key = getch();
			return -1;
			break;
		}
	}

	printf("\r\n");

		// send 0x00 0x00 to terminate.
	cp->PutImm(0x00);
	cp->GetChar(10);
	cp->PutImm(0x00);

	rxData = cp->GetChar(1000);

	if ( rxData == 'Z' )
		printf("Finished ok.\r\n");
	else
		printf("Unit did not respond correctly.\nI suggest you reprogram it.\r\n");

	if (cp)
		delete cp;
	if (sio)
		delete sio;


    printf("Press any key to exit.\n");
	key = getch();
	
	return 0;
}

