VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#10.0#0"; "EPESERALIO.OCX"
Begin VB.Form PainMonitor 
   Caption         =   "EPE PAIN MONITOR V1.1  10JUN05"
   ClientHeight    =   3480
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8970
   Icon            =   "PainMonitor.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3480
   ScaleWidth      =   8970
   StartUpPosition =   2  'CenterScreen
   Begin VB.CheckBox SwitchDelay 
      Caption         =   "PIC Switch Delay On"
      Height          =   255
      Left            =   2280
      TabIndex        =   14
      ToolTipText     =   "If ticked turns 3 secs PIC switch delay on when time sent"
      Top             =   2880
      Width           =   1815
   End
   Begin VB.CommandButton SendTime 
      BackColor       =   &H00FFFF00&
      Caption         =   "Send Time"
      Height          =   495
      Left            =   3840
      Style           =   1  'Graphical
      TabIndex        =   13
      ToolTipText     =   "Sends current time to PIC"
      Top             =   960
      Width           =   855
   End
   Begin VB.CommandButton Abort 
      BackColor       =   &H0000FFFF&
      Caption         =   "Abort"
      Height          =   495
      Left            =   6960
      Style           =   1  'Graphical
      TabIndex        =   12
      ToolTipText     =   "Aborts PC PIC memory clearance prog (but PIC continues if started)"
      Top             =   2640
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.CommandButton ResetPIC 
      BackColor       =   &H000080FF&
      Caption         =   "Reset PIC"
      Height          =   495
      Left            =   4920
      Style           =   1  'Graphical
      TabIndex        =   11
      ToolTipText     =   "Starts PIC's memory clearance (if PIC unit connected)"
      Top             =   960
      Width           =   855
   End
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   255
      Left            =   720
      TabIndex        =   9
      Top             =   1680
      Width           =   4935
      _ExtentX        =   8705
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.CommandButton ExcelIt 
      BackColor       =   &H0000FF00&
      Caption         =   "View Data via Excel "
      Height          =   495
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   8
      ToolTipText     =   "Creates a file from the current named file suited to input by Excel having prefix ""PICelectXCL"""
      Top             =   2880
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Port COM 1"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   0
      Left            =   6720
      TabIndex        =   6
      ToolTipText     =   "Selects port COM1 address"
      Top             =   1920
      Value           =   -1  'True
      Width           =   1215
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Port COM 2"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   1
      Left            =   6720
      TabIndex        =   5
      ToolTipText     =   "Selects port COM2 address"
      Top             =   2160
      Width           =   1215
   End
   Begin VB.CommandButton ViewData 
      BackColor       =   &H00FFFF00&
      Caption         =   "View Data"
      Height          =   495
      Left            =   1680
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   "Calls in selected data file for viewing via Notepad/Wordpad"
      Top             =   960
      Width           =   855
   End
   Begin VB.CommandButton SerialInput 
      BackColor       =   &H0000FF00&
      Caption         =   "Download"
      Height          =   495
      Left            =   600
      Style           =   1  'Graphical
      TabIndex        =   2
      TabStop         =   0   'False
      ToolTipText     =   "Starts data download from PIC (if PIC unit connected)"
      Top             =   960
      Width           =   855
   End
   Begin VB.CommandButton Directory 
      BackColor       =   &H0000FFFF&
      Caption         =   "Directory"
      Height          =   495
      Left            =   2760
      Style           =   1  'Graphical
      TabIndex        =   0
      TabStop         =   0   'False
      ToolTipText     =   "Calls up file selection screen"
      Top             =   960
      Width           =   855
   End
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   6960
      Top             =   1320
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin VB.Label RecordingText 
      Alignment       =   2  'Center
      Caption         =   "Click Download button to start download from PIC unit's memory bank"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   615
      Left            =   720
      TabIndex        =   10
      Top             =   2160
      Width           =   4935
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "EPE PAIN MONITOR V1.1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   480
      TabIndex        =   7
      ToolTipText     =   "Copyright John Becker JAN 2005"
      Top             =   360
      Width           =   5415
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      Caption         =   "No File Selected Yet"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   735
      Left            =   6000
      TabIndex        =   4
      ToolTipText     =   "Current loaded file name"
      Top             =   960
      Width           =   2655
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Selected File Name"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   6000
      TabIndex        =   1
      ToolTipText     =   "Current loaded file name"
      Top             =   600
      Width           =   2655
   End
   Begin VB.Shape Shape3 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      Height          =   3015
      Left            =   240
      Shape           =   4  'Rounded Rectangle
      Top             =   240
      Width           =   8535
   End
End
Attribute VB_Name = "PainMonitor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Pain Monitor 04FEB05, "ID" changed to "PID" 09JUN05 as Excel does not like "ID"

Dim Pain$(5000)
Dim AbortPressed As Boolean

Private Sub Form_Load()
OCXport = 1: Option1(OCXport - 1).Value = True

Month$(1) = "Jan": Month$(2) = "Feb": Month$(3) = "Mar": Month$(4) = "Apr"
Month$(5) = "May": Month$(6) = "Jun": Month$(7) = "Jul": Month$(8) = "Aug"
Month$(9) = "Sep": Month$(10) = "Oct": Month$(11) = "Nov": Month$(12) = "Dec"

ExcelPath = "C:\MSOffice\Excel\EXCEL.EXE"

PainMonitor.Show

OpenFile = "An unknown problem exists right at the start of loading EPE Pain Monitor"
On Error GoTo FatalError: 'set error handler

NewUser = 0:
ErrorMessage$ = "This error has been intercepted by the PC System, not by the PIC Electric program."
ErrorMessage$ = ErrorMessage$ & "If the problem persists please report its details and circumstances of it occurring to John Becker at EPE"
DefaultError$ = ErrorMessage$
TempA$ = "No File Selected Yet"
InputFile(0) = TempA$: NamedFile(0) = TempA$: InputSize(0) = 0
InputFile(1) = TempA$: NamedFile(1) = TempA$: InputSize(1) = 0

DefaultDrive = "C:\"
DirComboText = "C:\"
DriveC$ = "C:\"
PainMonitorDIR.Combo1.Text = DirComboText

PicPath = 0: PrevPicPath = 2

On Error GoTo HistoryError
OpenFile = "Cannot find PainMonitorHistory.txt"
Open "PainMonitorHistory.txt" For Input As #1: Close

On Error GoTo SettingsError
OpenFile = "Cannot find PainMonitorSettings.txt"
Open "PainMonitorSettings.txt" For Input As #1: Close

GetSettings:

Open "PainMonitorSettings.txt" For Input As #1
Line Input #1, TempA$: DriveC$ = TempA$:
Line Input #1, TempA$: DirComboText = TempA$
Line Input #1, TempA$: InputFile(0) = TempA$
Line Input #1, TempA$: NamedFile(0) = TempA$
Line Input #1, TempA$: InputFile(1) = TempA$
Line Input #1, TempA$: NamedFile(1) = TempA$
Line Input #1, TempA$: PicPath = Val(TempA$)
Line Input #1, TempA$: OCXport = Val(TempA$)
Line Input #1, TempA$: SwitchDelay.Value = Val(TempA$)
Line Input #1, TempA$: ExcelPath = TempA$
Close

Option1(OCXport - 1).Value = True
If OCXport = 0 Then OCXport = 1

On Error GoTo showerror

Label9.Caption = NamedFile(PicPath)

OpenFile = "Problem trying to allocate default drive path"

DefaultDrive = DriveC$

If UCase$(Left$(DriveC$, 3)) <> DefaultDrive Then DriveC$ = DefaultDrive

OpenFile = "Cannot correctly access Directory Default Drive path  " & DefaultDrive

PainMonitorDIR.Drive1.Drive = DefaultDrive
OpenFile = "Cannot correctly access Directory (Drive C$) path  " & DriveC$
PainMonitorDIR.Dir1.Path = DriveC$

HistoryQ = 0:
OpenFile = "Cannot find PainMonitorHistory.txt file, or its data is corrupted"
Open "PainMonitorHistory.txt" For Input As #1
getit3: If EOF(1) = 0 Then
  Line Input #1, TempA$
  If TempA$ <> "" And TempA$ <> History(HistoryQ) Then
  HistoryQ = HistoryQ + 1: History(HistoryQ) = TempA$
  PainMonitorDIR.Combo1.AddItem TempA$
  End If
GoTo getit3
End If
OpenFile = ""
PainMonitorDIR.Combo1.Text = DirComboText
PainMonitorDirPath(PicPath) = DirComboText
Close

On Error GoTo NewUserError: 'set error handler used to check if prog has been run before
Open "ClearPainMonitor.txt" For Input As #1: Close

On Error GoTo 0

Exit Sub

'.............

NewUserError:
Close: Open "ClearPainMonitor.txt" For Output As #2
Print #2, "PainMonitor first loaded " & Date$ & " " & Time$: Close
DriveC$ = "C:\": NewUser = 1
Close:
Open "PainMonitorHistory.txt" For Output As #2: Print #2, "C:\": Close
Call SaveDefaults
PainMonitorDIR.Combo1.Text = DirComboText: PainMonitorDirPath(PicPath) = DirComboText
Resume Next

SettingsError:
Close: Call SaveDefaults
Resume Next

HistoryError:
Close: Open "PainMonitorHistory.txt" For Output As #2: Print #2, "C:\": Close
PainMonitorDIR.Combo1.Text = DirComboText: PainMonitorDirPath(PicPath) = DirComboText
Resume Next

showerror:
Close: Call PainMonitorShowError.waitresponse
Resume enderror
enderror:
Exit Sub

FatalError:
Beep
TempB$ = "A non-recoverable error has occurred during program loading and involves the following PIC-Electric Mk2 generated statement:"
TempB$ = TempB$ & Chr(13) & Chr(13) & OpenFile
TempB$ = TempB$ & Chr(13) & Chr(13) & "Please check that all the PIC-Electric Mk2 files are in the same folder (directory) as the program you are now trying to run. The folder must be on the Hard Drive."
TempB$ = TempB$ & Chr(13) & Chr(13) & "If the data is corrupted re-copy the file of the same name from your original disk or FTP download."
TempB$ = TempB$ & Chr(13) & Chr(13) & "If you cannot resolve the problem please advise John Becker of the details via the EPE Editorial Office (not via the Chat Zone)."
TempB$ = TempB$ & Chr(13) & Chr(13) & "The loading has been aborted and you will be returned to the previous screen."
MsgBox TempB$, vbCritical
End

End Sub

Public Sub SaveDefaults()
Close: Open "PainMonitorSettings.txt" For Output As #2
If Len(DriveC$) <> 3 Then DriveC$ = "C:\"

Print #2, DriveC$
Print #2, PainMonitorDIR.Combo1.Text
Print #2, InputFile(0): Print #2, NamedFile(0)
Print #2, InputFile(1): Print #2, NamedFile(1)
Print #2, PicPath
Print #2, OCXport & " OCX port value"
Print #2, SwitchDelay.Value
Print #2, ExcelPath

Close
End Sub

Private Sub Drive1_Change()
PicPath = 0: FileName = "*.XLS":
DefaultDrive = UCase$(Drive1.Drive) & "\"
DriveC$ = DefaultDrive
PainMonitorDIR.Combo1.AddItem DriveC$
PainMonitorDIR.Drive1.Drive = Drive1.Drive
PainMonitorDIR.Dir1.Path = DriveC$
PrevPicPath = 0
Call SaveDefaults
PicPath = 0: FileName = DriveC$ & "*.XLS":
PainMonitorDIR.Show
Call PainMonitorDIR.dirshow
Label9.Caption = NamedFile(PicPath)
End Sub

Private Sub Directory_Click()

On Error GoTo showerror

FileName = "*.XLS"
If PainMonitorDIR.Combo1.ListCount = 0 Then
PainMonitorDIR.Combo1.Clear
For A = 1 To HistoryQ: PainMonitorDIR.Combo1.AddItem History(A): Next
PainMonitorDIR.Combo1.Text = DirComboText
End If

If PainMonitorDirPath(PicPath) = "" Then PainMonitorDirPath(PicPath) = DefaultDrive
OpenFile = PainMonitorDirPath(PicPath)

PainMonitorDIR.Show
If PicPath <> PrevPicPath Then
If PainMonitorDirPath(PicPath) <> DefaultDrive Then PainMonitorDIR.Dir1.Path = PainMonitorDirPath(PicPath)
Call PainMonitorDIR.dirshow
PrevPicPath = PicPath: FilePath = InputFile(PicPath)
End If
Exit Sub

showerror:
If Err.Number = 68 Or Err.Number = 71 Or Err.Number = 76 Then
ErrorMessage = "Drive not ready for" & Chr(13) & OpenFile
Style = vbRetryCancel + vbExclamation
Response = MsgBox(ErrorMessage, Style)
  If Response = vbCancel Then
  PainMonitorDirPath(PicPath) = DefaultDrive
  OpenFile = PainMonitorDirPath(PicPath)
  Resume here
here:   Exit Sub
  End If

Resume
  Beep
  End If

PainMonitorShowError.Show
Call PainMonitorShowError.waitresponse
Resume enderror
enderror:
PainMonitorDIR.Hide

End Sub

Private Sub AllFilesDir_Click()
PainMonitorDIR.Show
End Sub

Private Sub Option1_Click(Index As Integer)
OCXport = Index + 1
Call SaveDefaults
End Sub

Private Sub ResetPIC_Click()

    Dim bError                          As Boolean
    Dim nBlockNumber                    As Integer
    Dim sDataBlock                      As String
    Dim A, B, C, D, E, F, L As Long

If OCXport = 1 Then TempA$ = "h3F8 (COM1)" Else TempA$ = "h278 (COM2)"
    
SerialInput.Visible = False
ViewData.Visible = False
Directory.Visible = False
ResetPIC.Visible = False
SendTime.Visible = False
RecordingText.Caption = "Clearing 32768 bytes of PIC memory"
'Abort.Visible = True

PainMonitor.Refresh

AbortPressed = False

D = 0
ProgressBar1.Min = 0
ProgressBar1.Max = 129
ProgressBar1.Value = 0

    bError = False
    With EPESerial1
        .RxBlockSize = 1
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .Speed = sio9600       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False  ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 5
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer ' Always do this after we open the port to make sure the buffer is really empty
        .SendText "R"       ' Tell the PIC to reset serial EEPROM

100:
DoEvents
If (AbortPressed) Then
Abort.Visible = False
GoTo endclear
End If
        
        
        sDataBlock = .ReceiveText
        If sDataBlock <> "R" Then GoTo ErrorHandler
        D = D + 1: ProgressBar1.Value = D
        If D < 128 Then
        GoTo 100
        End If

endclear:

        .PortStatus = sioPortClosed

SerialInput.Visible = True
ViewData.Visible = True
Directory.Visible = True
RecordingText.Caption = "Click Start button to start download from PIC unit's memory bank"
Abort.Visible = False
ResetPIC.Visible = True
SendTime.Visible = True
ProgressBar1.Value = 0
End With
Exit Sub

ErrorHandler:
        Close
        Beep
        AbortPressed = False
        Abort.Visible = False
'        Abort.Refresh
TempA$ = "Handshake reply not received from PIC " & Chr(13) & Chr(10)
TempA$ = TempA$ & "Check your power and serial port connections"
    MsgBox TempA$, vbOKOnly + vbCritical
    On Error Resume Next
        GoTo endclear

End Sub

Private Sub SwitchDelay_Click()
Call SaveDefaults
End Sub

Public Sub ViewData_Click()

On Error GoTo showerror

Fname = InputFile(PicPath)
If Fname = "No File Selected Yet" Then
Beep
MsgBox Fname, vbExclamation
Exit Sub
End If

OpenFile = Fname: Close

Open Fname For Input As #1: Close
ProcessID = Shell("Notepad " & Fname, vbNormalFocus)
OpenFile = ""

Exit Sub

showerror:
PainMonitorShowError.Show
Call PainMonitorShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub Form_Unload(Cancel As Integer)
Close
Unload PainMonitorDIR
End
End Sub

Private Sub ExcelIt_Click()
Exit Sub

' PATH NOT YET WORKING

On Error GoTo showerror

ExcelPath = "C:\MSOffice\Excel\EXCEL.exe"
Fname = InputFile(PicPath)
Fname = "PainMonitorTest.XLS"

OpenFile = ExcelPath & "\" & Fname
If Fname = "No File Selected Yet" Then
Beep
MsgBox Fname, vbExclamation
Exit Sub
End If

ProcessID = Shell(OpenFile, vbNormalFocus)
OpenFile = ""

Exit Sub

showerror:
PainMonitorShowError.Show
Call PainMonitorShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub abort_Click()
AbortPressed = True
End Sub

Private Sub SerialInput_Click()

    Dim bError                          As Boolean
    Dim nBlockNumber                    As Integer
    Dim sDataBlock                      As String
    Dim A, B, C, D, E, F, L As Long

PainMonitor.ProgressBar1.Value = 0
PainMonitor.ProgressBar1.Max = 1030
AbortPressed = False

aa$ = Date$: at$ = Time$
A = Val(Left$(Date$, 2))
ab$ = Mid$(aa$, 4, 2) & Month$(A) & Right$(aa$, 2) & " "
ab$ = ab$ & Left$(at$, 2) & "-" & Mid$(at$, 4, 2) & "-" & Right$(at$, 2)

File$ = "PainMonitor " & ab$ & ".XLS"
Label9.Visible = False

If OCXport = 1 Then TempA$ = "COM1" Else TempA$ = "COM2"
PainMonitor.RecordingText.Caption = "Waiting for data from PIC via serial port " & TempA$
PainMonitor.RecordingText.Visible = True
PainMonitor.RecordingText.Refresh: Close

    Open "store.txt" For Output As #1
    
    bError = False
    With EPESerial1
        .RxBlockSize = 10
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .Speed = sio9600       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False  ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 5
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer ' Always do this after we open the port to make sure the buffer is really empty
        .SendText "S" ' Set ' Tell the PIC to get ready to send

D = 1000: ' wait to let PIC end its current routine
delay11: T = Int(Timer): If D > 0 Then D = D - 1: GoTo delay11
        
        .ClearReceiveBuffer ' Always do this after we open the port to make sure the buffer is really empty
        .SendText "G" ' Go ' Tell the PIC to send

DoEvents
If (AbortPressed) Then
 .PortStatus = sioPortClosed
  Close

GoTo endclear

End If
       
        sDataBlock = .ReceiveText

        If Left$(sDataBlock, 7) = "PICelec" Then
        chipcount = Val(Mid$(sDataBlock, 8, 1))
        
If chipcount = 0 Then
  Beep
 .PortStatus = sioPortClosed
  Close

PainMonitor.MousePointer = vbDefault
TempA$ = "You do not appear to have any memory chips installed" & Chr(13) & Chr(13) & Chr(10)
TempA$ = TempA$ & "Download has been aborted" & Chr(13) & Chr(13) & Chr(10)
MsgBox TempA$, vbCritical

Exit Sub
End If

 .RxBlockSize = 258      ' Reconfigure block size to accept actual data packets - 256 Bytes of data + CR+LF
 .ProgressEvents = True
 .TimeOut = 2            ' PIC must always respond within 2 seconds

PainMonitor.RecordingText.Caption = "Inputting data from PIC via serial port " & TempA$
PainMonitor.RecordingText.Refresh

n = 128 * chipcount: PainMonitor.ProgressBar1.Max = n + 1

PainMonitor.RecordingText.Refresh
For nBlockNumber = 1 To n
  .SendText "B"  ' Tell the PIC to send a block
   
DoEvents
If (AbortPressed) Then
 .PortStatus = sioPortClosed
  Close
GoTo endclear
End If
   
   sDataBlock = .ReceiveText ' Load sDataBlock with the 258 bytes of data
   If Len(sDataBlock) <> 258 Then
     bError = True
     MsgBox "For some reason, we didn't receive a complete block of data", vbOKOnly + vbCritical
     Exit For
   End If
             
 If Right$(sDataBlock, 2) <> vbCr & vbLf Then
   bError = True
   MsgBox "We didn't get the <CR> + <LF> at the end of the packet", vbOKOnly + vbCritical
   Exit For
   Close
   Label9.Visible = True
   End If
                
   PainMonitor.ProgressBar1.Value = nBlockNumber
   Print #1, Left$(sDataBlock, 256);
   Next nBlockNumber: Print #1, ""
        
   Else
    Beep
     bError = True
        PainMonitor.MousePointer = vbDefault
     MsgBox "Handshake not received from PIC... Check that the PIC is connected and running !", vbOKOnly + vbCritical, "Receive 'Ready' time-out"
PainMonitor.RecordingText.Caption = "Click Start button to start download from PIC unit's memory bank"
        Label9.Visible = True
     Close
    .PortStatus = sioPortClosed
     Exit Sub
     End If
        
    .PortStatus = sioPortClosed
   End With
        
   Close

If bError = False Then
PainMonitor.ProgressBar1.Value = 0

bypass:
   B = 256
   Open "store.txt" For Binary As #1: L = LOF(1): 'bring in binary data from temp store
   TempA$ = Input$(L, 1): Close

PainMonitor.ProgressBar1.Max = L
XA$ = Chr(9)

PainMonitor.RecordingText.Caption = "Outputting data to " & File$
PainMonitor.RecordingText.Refresh

F = 0: G = 0: k = 1
Open "store.txt" For Input As #2: L = LOF(2)
PainMonitor.ProgressBar1.Value = 0
If L = 0 Then Close 2: GoTo StoreA
PainMonitor.ProgressBar1.Max = L

Open File$ For Output As #1:  ' file for final data
Print #1, "PID" & Chr(9) & "yy:mm:dd" & Chr(9) & "hh:mm:ss" & Chr(9) & "Event.A" & Chr(9) & "Event.B" & Chr(9) & "Event.C"
Print #1, ""

getit2: If EOF(2) Then Close 2: GoTo StoreA

Line Input #2, aa$
For A = 1 To (Len(aa$) - 512) Step 8
PainMonitor.ProgressBar1.Value = A

B = Asc(Mid$(aa$, A, 1)) - 48
If B > 0 Then

Pain$(k) = Right$(" " & Str$(Asc(Mid$(aa$, A, 1)) - 48), 2)
Pain$(k) = Left$(Pain$(k) & "       ", 7) & Chr(9)

F = Asc(Mid$(aa$, A + 1, 1)) - 48
T = F \ 16: u = F And 15
Pain$(k) = Pain$(k) & T & u & ":"

F = Asc(Mid$(aa$, A + 2, 1)) - 48
T = F \ 16: u = F And 15
Pain$(k) = Pain$(k) & T & u & ":"

F = Asc(Mid$(aa$, A + 3, 1)) - 48
T = F \ 16: u = F And 15
Pain$(k) = Pain$(k) & T & u & Chr(9)

F = Asc(Mid$(aa$, A + 4, 1)) - 48
T = F \ 16: u = F And 15
Pain$(k) = Pain$(k) & T & u & ":"

F = Asc(Mid$(aa$, A + 5, 1)) - 48
T = F \ 16: u = F And 15
Pain$(k) = Pain$(k) & T & u & ":"

F = Asc(Mid$(aa$, A + 6, 1)) - 48
T = F \ 16: u = F And 15
Pain$(k) = Pain$(k) & T & u & Chr(9)

D = (Asc(Mid$(aa$, A + 7, 1)) - 48) And 15
If D = 0 Then tempd$ = "  -" Else tempd$ = " " & Str$(D)
Pain$(k) = Pain$(k) & tempd$ & Chr(9)
D = (Asc(Mid$(aa$, A + 7, 1)) - 48) And 16
If D = 0 Then tempd$ = "  -" Else tempd$ = "  1"
Pain$(k) = Pain$(k) & tempd$ & Chr(9)
D = (Asc(Mid$(aa$, A + 7, 1)) - 48) And 32
If D = 0 Then tempd$ = "  -" Else tempd$ = "  1"
Pain$(k) = Pain$(k) & tempd$
k = k + 1: C = B
End If
Next

GoSub sort

For A = 0 To k:
If Pain$(A) <> "" Then
If Pain$(A) <> Pain$(A + 1) Then
Print #1, Pain$(A)
End If
If Val(Pain$(A)) <> Val(Pain$(A + 1)) Then Print #1, ""
End If

Next

StoreA:
End If

InputFile(PicPath) = File$: NamedFile(PicPath) = File$

PainMonitor.RecordingText.Caption = "Click Start button to start download from PIC unit's memory bank"
Label9.Visible = True
Abort.Visible = False
ProgressBar1.Value = 0
PainMonitor.Label9.Caption = NamedFile(PicPath)
PainMonitor.MousePointer = vbDefault

Call PainMonitor.SaveDefaults
Call PainMonitor.ViewData_Click
Exit Sub

' *************

sort:
num% = k: Span% = num% / 2
Do While Span% > 0: For I% = Span% To num% - 1: j% = I% - Span% + 1
For j% = (I% - Span% + 1) To 1 Step -Span%
If Pain$(j%) <= Pain(j% + Span%) Then Exit For
TempA$ = Pain$(j%): Pain$(j%) = Pain$(j% + Span%): Pain$(j% + Span%) = TempA$
Next j%: Next I%: Span% = Span% / 2: Loop:
Return

endclear:

Label9.Visible = True
SerialInput.Visible = True
ViewData.Visible = True
Directory.Visible = True
RecordingText.Caption = "Click Start button to start download from PIC unit's memory bank"
Abort.Visible = False
ResetPIC.Visible = True
ProgressBar1.Value = 0
Exit Sub

showerror:
Close: Call PainMonitorShowError.waitresponse
Resume enderror
enderror:
Exit Sub

    
ErrorHandler:
        Close
    MsgBox "An error occured - " & Err.Description, vbOKOnly + vbCritical
    On Error Resume Next
    EPESerial1.PortStatus = sioPortClosed

End Sub

Private Sub tmrBufferFillLevel_Timer()

    ' Have a 'peek' into the receive buffer and get the number
    ' of characters currently sitting there.
    ' Output this value on the top progress bar control.
    ' ProgressBar1.Value = Len(EPESerial1.PeekReceiveBuffer)
End Sub

Private Sub EPESerial2_CommunicationsEvent(EventCode As EPESerialControl.eCommsEvents, RXBufferContents As String)

End Sub

Private Sub EPESerial1_CommunicationsEvent(ByVal EventCode As EPESerialControl.eCommsEvents, ByVal RXBufferContents As String, ByVal BufferLength As Long)

    'Select Case EventCode
    'Case EPESerialControl.eCommsEvents.sioRxProgress
    '    ProgressBar1.Value = BufferLength
        
    'End Select
    
End Sub

Private Sub SendTime_Click()

    Dim bError                          As Boolean
    Dim nBlockNumber                    As Integer
    Dim sDataBlock                      As String
    Dim A, B, C, D, E, F, L As Long
    Dim TimeVal(12)

PainMonitor.ProgressBar1.Value = 0
PainMonitor.ProgressBar1.Max = 8
RecordingText = "Sending time and date to PIC"
RecordingText.Refresh
AbortPressed = False

aa$ = Date$: at$ = Time$

TimeVal(0) = Val(Mid$(at$, 7, 1)) * 16 + Val(Mid$(at$, 8, 1)) ' secs
TimeVal(1) = Val(Mid$(at$, 4, 1)) * 16 + Val(Mid$(at$, 5, 1)) ' mins
TimeVal(2) = Val(Mid$(at$, 1, 1)) * 16 + Val(Mid$(at$, 2, 1)) ' mins
TimeVal(3) = 0                                                ' weekday - not used
TimeVal(4) = Val(Mid$(aa$, 4, 1)) * 16 + Val(Mid$(aa$, 5, 1)) ' date (day)
TimeVal(5) = Val(Mid$(aa$, 1, 1)) * 16 + Val(Mid$(aa$, 2, 1)) ' month
TimeVal(6) = Val(Mid$(aa$, 9, 1)) * 16 + Val(Mid$(aa$, 10, 1)) ' year
TimeVal(7) = SwitchDelay.Value
Counter = 0
    
    bError = False
    With EPESerial1
        .RxBlockSize = 1
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .Speed = sio9600       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False  ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 5
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer ' Always do this after we open the port to make sure the buffer is really empty
        .SendText "T"       ' Tell the PIC to get ready to receive time data

        sDataBlock = .ReceiveText
        If sDataBlock <> "R" Then GoTo ErrorHandler
        .TimeOut = 1

For A = 0 To 7
ProgressBar1.Value = Counter: Counter = Counter + 1
        .SendText Chr$(TimeVal(A))
        sDataBlock = .ReceiveText
Next
ProgressBar1.Value = Counter: Counter = Counter + 1
        Abort.Visible = False
        .PortStatus = sioPortClosed
RecordingText.Caption = "Click Start button to start download from PIC unit's memory bank"
        Exit Sub
    
ErrorHandler:
        Close
        Beep
        AbortPressed = False
        Abort.Visible = False
TempA$ = "Handshake reply not received from PIC " & Chr(13) & Chr(10)
TempA$ = TempA$ & "Check your power and serial port connections"
    MsgBox TempA$, vbOKOnly + vbCritical
    On Error Resume Next
    EPESerial1.PortStatus = sioPortClosed
RecordingText.Caption = "Click Start button to start download from PIC unit's memory bank"
        
        End With
End Sub


