	list p = pic16f84 	;SK41-1
 				;CODE FOR PIC1

	pcl		equ 02h
	status		equ 03h
	porta		equ 05h
	portb		equ 06h
	trisa		equ 05h
	trisb		equ 06h
	intcon		equ 0Bh
	w		equ 00h
	f		equ 01h
	z		equ 02h
	delay0 		equ 0Ch
	delay1 		equ 0Dh
	delay2 		equ 0Eh
	pointer 	equ 0Fh
	bumps 		equ 10h
	motion	 	equ 11h
	wint 		equ 12h
	sint 		equ 13h
	aint 		equ 14h
	bint 		equ 15h

	goto start
 	org 0004h
 	goto isr	;Interrupt service routine.
 	org 0005h

seq3:	addwf pcl, f	;Saints dance.
 	retlw 0Ah	;Forward.
 	retlw 05h	;Reverse.
 	retlw 09h	;Spin left.
 	retlw 06h	;Spin right.
 	retlw 09h	;Spin left.
 	retlw 05h	;Reverse.
 	retlw 0Ah	;Forward.
 	retlw 06h	;Spin right.
 	retlw 05h	;Reverse.
 	retlw 0Ah	;Forward.
 
start:
	bsf status, 5	;Page 1.
 	clrf trisa	;Port A as outputs.
 	movlw 0C7h	;RB3-5 as outputs.
 	movwf trisb
 	clrwdt
 	bcf status, 5	;page0

 	clrf porta
 	clrf portb

wait1:

 	btfss portb, 6	;Wait for mark.
 	goto wait1
 	bsf portb, 5	;Send 'ready'.
 	movlw 08h
 	call pause2
 	bcf portb, 5	;End 'ready'.
 	clrf portb
 	btfss portb, 2	;Read select switch.
 	goto behave1	;Dancer.
 	goto behave2	;Talker.


behave1:
	clrf pointer	;Set pointer to start of dance.
wait2:	btfss portb, 6	;Wait for mark.
 	goto wait2
 	movf pointer, w
 	call seq3	;Get code in w.
 	movwf porta	;To motor control outputs.
 	movlw 020h	;1 s.
 	call pause2
 	clrf porta	;Stop motors.
 	incf pointer, f
	movf pointer, w	;Load pointer.
 	sublw 0Ah 	;Subtract 10 (beyond end of dance?)
 	btfss status, z	;z = 1 if dance is over.
 	goto wait2	;Next step.
 	goto behave1	;Next dance.

behave2:

 	bcf intcon, 7	;Disable interrupts (GIE = 0).
 	bsf intcon, 3	;Enable int on change (RBIE).
 	movf portb, w	;Read Port B.
 	bcf intcon, 0	;Clear int flag (RBIF).
 
 	clrf bumps

wander: call bumpers
 	movlw 0Ah	;Forward.
 	movwf porta
 	call talkon
 	movlw 080h	;300 mm
 	call pause2
 	clrf porta	;Stop.
 	movlw 0A0h
 	call pause2
 	call bumpers
 	movlw 05h	;Reverse.
 	movwf porta
 	call talkon
 	movlw 030h	;100 mm
 	call pause2
 	clrf porta	;Stop.
 	movlw 0A0h
 	call pause2
 	call bumpers
 	movlw 0Ah	;Forward.
 	movwf porta
 	call talkon
 	movlw 050h	;200 mm
 	call pause2
 	clrf porta	;Stop.
 	call talkon
 	movlw 0A0h
 	call pause2
 	call bumpers
 	bsf intcon, 7	;Enable interrupt.
 	movlw 09h	;Spin left.
 	movwf porta
 	call talkon
 	movlw 040h	;140 degrees.
 	call pause2
 	clrf porta	;Stop.
 	movlw 0A0h
 	call pause2
 	call bumpers
 	bcf intcon, 7	;Disable interrupt.
 	movlw 0Ah	;Forward.
 	movwf porta
 	call talkon
 	movlw 060h	;100 mm
 	call pause2
 	clrf porta	;Stop.
 	movlw 0A0h
 	call pause2
 	call bumpers
 	bsf intcon, 7	;Enable interrupt.
 	movlw 06h	;Spin right.
 	movwf porta
 	call talkon
 	movlw 060h	;140 degrees.
 	call pause2
 	clrf porta	;Stop.
 	bcf intcon, 7	;Disable interrupt.
 	movlw 0A0h
 	call pause2
 	goto wander
 
bumpers: 
	btfsc portb, 0	;Left bumper touched?
 	call backl
 	btfsc portb, 1	;Right bumper touched?
 	call backr
 	return

backl: 	movlw 05h	;Reverse.
 	movwf porta
 	movlw 050h	;200mm
 	call pause2
 	movlw 06h	;Spin right.
 	movwf porta
 	movlw 01Dh	;45 degrees.
 	call pause2
 	clrf porta	;Stop.
 	incf bumps, f	;Count bumps.
 	movlw 05h
 	subwf bumps, w
 	btfss status, z
 	return
 	movlw 010h
 	movwf portb	;Data '100' to PIC2.
 	movlw 0E0h
 	call pause2
 	clrf bumps	;Reset bumps.
 	return

backr: 	movlw 05h	;Reverse.
	movwf porta
 	movlw 050h	;200 mm
 	call pause2
 	movlw 09h	;Spin left.
 	movlw 01Dh	;45 degrees.
 	call pause2
 	clrf porta	;Stop.
 	incf bumps, f	;Count bumps.
 	movlw 05h
 	subwf bumps, w
 	btfss status, z
 	return
 	movlw 010h
 	movwf portb	;Data '100' to PIC2.
 	movlw 0A0h
 	call pause2
 	clrf bumps	;Reset bumps.
 	return


talkon:
 	clrf portb	;Clear data to PIC2.
 	movwf motion	;Motion code in w stored in code.
 	andlw 08h	;Pick out RA3 bit.
 	btfss status, z	;Set z if RA3 = 0
 	bsf portb, 3	;Set RB3 if RA3 = 1.
 	movf motion, w	;Code back to w.
 	andlw 02h	;Pick out RA1 bit.
 	btfss status, z	;Set z if RA1 = 0
 	bsf portb, 4	;Set RB4 if RA1 = 1.
 	movf motion, w	;Code back to w.
 	sublw 05h	;Subtract 'reverse' code.
 	btfss status, z	;Set z if code is 05h.
 	return
 	movlw 038h
 	movwf portb	;Set '111' if code is 05h (reverse).
 	return

isr:
 	movwf wint	;Push w.
 	movf status, w
 	movwf sint	;Push status.
 	movf porta, w
 	movwf aint	;Push Port A.
 	movf portb, w
 	movwf bint	;Push PortB.

 	btfss portb, 7	;Read input from light sensor.
 	goto dark	;If dark.
 	movlw 0Ah	;Forward.
 	movwf porta
 	movlw 028h
 	movwf portb	;Data '101' to PIC2.
 	movlw 0A0h
 	call pause2
 	goto endit
dark: 	movlw 09h	;Spin left.
 	movwf porta
 	movlw 030h
 	movwf portb	;Data '110' to PIC2.
 	movlw 0A0h
 	call pause2
endit:	clrf porta	;Stop motors
 	clrf portb	;End signal to PIC2.

 	movf sint, w
 	movwf status	;Restore status.
 	movf aint, w
 	movwf porta	;Restore Port A.
 	movf bint, w
 	movwf portb	;Restore Port B.
 	movf wint, w	;Restore w.
 	bcf intcon, 0	;Reset interrupt flag (RBIF).
 	retfie		;Return from interrupt.
 
pause2: 
 	movwf delay2	;Already has value in w.
dloop2: call pause1
 	decfsz delay2, f
 	goto dloop2
 	return
pause1: movlw 01h
 	movwf delay1
dloop1: call pause0
 	decfsz delay1, f
 	goto dloop1
 	return
pause0: movlw 080h
 	movwf delay0
dloop0: decfsz delay0, f
 	goto dloop0
 	return
	
	end

