;PIC-A-COLOUR - Nick Dossis 2003

; PIC16F84, RC clock, WDT off, POR off

; Written in TASM, needs translating by TK3 if to be used with MPASM/MPLAB


#DEFINE PAGE0 bcf STATUS,5
#DEFINE PAGE1 bsf STATUS,5

PCL:    .EQU $02        ;
INDF:   .EQU $00        ;register used when calling Indirect address
FSR:    .EQU $04        ;register which holds Indirect address
STATUS: .EQU $03        ;status flag
W:      .EQU 0          ;
F:      .EQU 1          ;
C:      .EQU 0          ;carry flag
Z:      .EQU 2          ;zero flag

TRISA:  .EQU $05        ;port assignments
PORTA:  .EQU $05        ;
TRISB:  .EQU $06        ;
PORTB:  .EQU $06        ;

LED:    .EQU 12         ;3mm LED store
TRI:    .EQU 13         ;Tri Colour LED store
SEG:    .EQU 14         ;7 Segment display store

DELAY:  .EQU 15         ;Delay store for switch de-bounce
TEMP1:  .EQU 16         ;temporary store for tri-colour guesses
SEGNUM: .EQU 17         ;7 segment display decimal number
RANDOM: .EQU 18         ;random number generator
MASTER: .EQU 19         ;master's random number
CORRECT:.EQU 20         ;stores the amount of correct colours
TEMP2:  .EQU 21         ;temporary store for tri-colour guesses
TEST:   .EQU 22         ;test store
TEMP3:  .EQU 23         ;temporary store for tri-colour manipulation
LOOP:   .EQU 24         ;used in program loops
GOES:   .EQU 25         ;stores the number of guesses
SEGGO:  .EQU 26         ;stores the number of guesses in bcd
WRONG:  .EQU 27         ;stores the number of colours in the wrong order
FLAG:   .EQU 28         ;review flag 
REV:    .EQU 29         ;review store
MCOLOUR: .EQU 30        ;start address for master's colours 30-34
PCOLOUR: .EQU 35        ;start address for player's colours 35-39
LIGHTS1: .EQU 60        ;delay variable for start up screen
LIGHTS2: .EQU 61        ;delay variable for start up screen
LIGHTS3: .EQU 62        ;delay variable for start up screen

        .ORG 4          ;
        .ORG 5          ;

        clrf RANDOM     ;clear the random number generator

SETUP:  clrf LED        ;clear variables
        clrf TRI        ;
        clrf SEG        ;
        clrf SEGNUM     ;
        clrf LOOP       ;
        clrf WRONG      ;

        clrf PORTA      ;
        clrf PORTB      ;
        PAGE1           ;
        movlw %00011000 ;Port A - 3 outputs & 2 Inputs
        movwf TRISA     ;
        clrf TRISB      ;Port B - 8 outputs
        PAGE0           ;
        goto BEGIN      ;avoid table details

TABLE:  addwf PCL,F     ;add to PCL
        retlw %11011011 ;0  seven segment codes
        retlw %01000001 ;1
        retlw %10011101 ;2
        retlw %11001101 ;3
        retlw %01000111 ;4
        retlw %11001110 ;5
        retlw %11011110 ;6
        retlw %11000001 ;7
        retlw %11011111 ;8
        retlw %11000111 ;9
        retlw %00011010 ;'L' for Lose

TABLE2: addwf PCL,F     ;add to PCL
        retlw %11000000 ;codes to clear tricolour variable
        retlw %00110000 ;when checking for correct answers
        retlw %00001100 ;
        retlw %00000011 ;

TABLE3: addwf PCL,F     ;add to PCL
        retlw 6         ;numbers used to test which colours
        retlw 4         ;are in the wrong order - denotes how
        retlw 2         ;many times the binary value is rotated
        retlw 0         ;to the right

TABLE4: addwf PCL,F     ;
        retlw %10101010 ;
        retlw %01010101 ;
        retlw %11111111 ;
        retlw %00000000 ;
        retlw %11110000 ;
        retlw %00001111 ;
        retlw %11001100 ;
        retlw %00110011 ;

TABLE5: addwf PCL,F     ;tri colour start up screen colours
        retlw %11111111 ;
        retlw %10101010 ;
        retlw %01010101 ;
        retlw %00000000 ;
        retlw %01010101 ;
        retlw %10101010 ;
        retlw %11111111 ;
        retlw %10101010 ;
        retlw %01010101 ;
        retlw %00000000 ;

TABLE6: addwf PCL,F     ;3mm led start up screen sequence
        retlw %00000000 ;
        retlw %00000001 ;
        retlw %00000010 ;
        retlw %00000100 ;
        retlw %00001000 ;
        retlw %10000000 ;
        retlw %00010000 ;
        retlw %01000000 ;
        retlw %00100000 ;
        retlw %00100000 ;

TABLE7: addwf PCL,F     ;7 segment start up screen sequence
        retlw %10100000 ;
        retlw %00100001 ;
        retlw %01100000 ;
        retlw %00101000 ;
        retlw %00110000 ;
        retlw %00100010 ;
        retlw %00100100 ;
        retlw %10100111 ;
        retlw %01111100 ;
        retlw %11111111 ;

BEGIN:  clrf TEMP1      ;clears all variables
        clrf TEMP2      ;
        clrf TEST       ;
        clrf GOES       ;
        clrf WRONG      ;
        clrf FLAG       ;
        clrf LOOP       ;
        clrf REV        ;
        clrf LIGHTS1    ;
        clrf LIGHTS2    ;
        clrf LIGHTS3    ;
        clrf MASTER     ;
        movf REV,W      ;Move start numbers to display variables
        call TABLE6     ;
        movwf LED       ;3mm led
        movf REV,W      ;
        call TABLE5     ;
        movwf TRI       ;tri-colour leds
        movf REV,W      ;
        call TABLE7     ;       
        movwf SEG       ;7-segment display
        movlw %11011011 ;
        movwf SEGGO     ;number of tries for the 7-segment display
        movlw 1         ;
        movwf DELAY     ;de-bounce store

;Flashing LED Start-up screen

STARTUP:movlw %00000001 ;3mm display
        movwf PORTA     ;activate multplex port
        movf LED,W      ;move led value to w
        movwf PORTB     ;move w to port b

SLOW1:  incf LOOP,F     ;delay routine
        movf LOOP,W     ;
        xorlw 25        ;
        btfsc STATUS,Z  ;
        goto SLOW2      ;
        goto START2     ;

SLOW2:  clrf LOOP       ;
        incf LIGHTS1,W  ;
        xorlw 10        ;
        btfsc STATUS,Z  ;
        goto SS3        ;
        incf LIGHTS1,F  ;
SS2:    movf LIGHTS1,W  ;
        call TABLE6     ;
        movwf LED       ;increment tri-colour store
        goto START2     ;

SS3:    clrf LIGHTS1    ;
        goto SS2        ;

START2: clrf PORTB      ;clear port b
        movlw %00000010 ;tricolour display
        movwf PORTA     ;activate multplex port
        movf TRI,W      ;move tri-colour value to w
        movwf PORTB     ;move w to port b

SLOW3:  incf TEMP1,F    ;delay routine
        movf TEMP1,W    ;
        xorlw 80        ;
        btfsc STATUS,Z  ;
        goto SLOW4      ;
        goto START3     ;

SLOW4:  clrf TEMP1      ;
        incf LIGHTS2,W  ;
        xorlw 10        ;
        btfsc STATUS,Z  ;
        goto S3         ;
        incf LIGHTS2,F  ;
S2:     movf LIGHTS2,W  ;
        call TABLE5     ;
        movwf TRI       ;increment tri-colour store
        goto START3     ;

S3:     clrf LIGHTS2    ;
        goto S2         ;

START3: incf RANDOM,F   ;increment random number
        clrf PORTB      ;clear port b
        movlw %00000100 ;Show 7-Segment display
        movwf PORTA     ;actvate multplex port
        movf SEG,W      ;move 7-segment value to w
        movwf PORTB     ;move w to port b

SLOW5:  incf TEMP2,F    ;delay routine
        movf TEMP2,W    ;
        xorlw 15        ;
        btfsc STATUS,Z  ;
        goto SLOW6      ;
        goto KEY        ;

SLOW6:  clrf TEMP2      ;
        incf LIGHTS3,W  ;
        xorlw 10        ;
        btfsc STATUS,Z  ;
        goto SSS3       ;
        incf LIGHTS3,F  ;
SSS2:   movf LIGHTS3,W  ;
        call TABLE7     ;
        movwf SEG       ;increment tri-colour store
        goto KEY        ;

SSS3:   clrf LIGHTS3    ;
        goto SSS2       ;

KEY:    clrf PORTB      ;clear port b
        btfsc PORTA,3   ;test Scroll key
        goto GAME       ;yes, start the game
        btfsc PORTA,4   ;test Enter key
        goto GAME       ;yes, start the game
        goto STARTUP    ;no continue to show the start-up sequence

;The Game Begins

GAME:   movf RANDOM,W   ;move the random number to w
        movwf MASTER    ;move w to the master store
        movlw %00000001 ;move start numbers to display variables
        movwf LED       ;3mm led
        ;movf MASTER,W   ;random number
        movlw %00000000 ;tricolour starts with all white leds
        movwf TRI       ;move random number to tri-colour store
        movlw %11011011 ;move 0 to 7-segment store
        movwf SEG       ;
        movlw 1         ;move 1 to w
        movwf DELAY     ;move value to de-bounce store
        clrf TEMP1      ;clears temp store
        clrf TEMP2      ;clears temp store
        clrf REV        ;clears review variable
        clrf LOOP       ;clears loop variable

DRECT:  movlw 40        ;this routine clears the memory of the 10 addresses
        movwf FSR       ;copy w into Indirect address reg
        movlw 10        ;move 10 into w
        movwf LOOP      ;move w into loop       
RSET:   movlw 0         ;moves 0 into w
        movwf INDF      ;moves w into indirect file
        incf FSR,F      ;increments fsr
        decfsz LOOP,F   ;has loop reached zero?
        goto RSET       ;no, loop round

;Multiplex program for the three displays

DISPLY: movlw %00000001 ;Show 3mm display
        movwf PORTA     ;activate multplex port a
        movf LED,W      ;move 3mm led value to w
        movwf PORTB     ;show it on port b
        incf RANDOM,F   ;random number generator for the next game
        incf RANDOM,F   ;random number generator for the next game
        incf RANDOM,F   ;random number generator for the next game
        clrf PORTB      ;switch port b off

DISPLY2:movlw %00000010 ;Show Tricolour display
        movwf PORTA     ;activate multplex port a
        movf TRI,W      ;move tri-colour value to w
        movwf PORTB     ;show it on port b
        incf RANDOM,F   ;random number generator for the next game
        incf RANDOM,F   ;random number generator for the next game
        incf RANDOM,F   ;random number generator for the next game
        clrf PORTB      ;switch port b off


DISPLY3:movlw %00000100 ;Show 7-Segment display
        movwf PORTA     ;activate multplex port a
        btfsc LED,7     ;test if 'correct' is illuminated
        goto DISP3A     ;yes, divert
        btfsc LED,6     ;test if 'wrong' is illuminated
        goto DISP3A     ;yes, divert
D:      movf SEGGO,W    ;no, move the number of tries to w
        movwf PORTB     ;move the value to port b
        incf RANDOM,F   ;random number generator for the next game
        incf RANDOM,F   ;random number generator for the next game
        incf RANDOM,F   ;random number generator for the next game
        clrf PORTB      ;switch off port b
        goto TESTK      ;go and test for keypresses

DISP3A: movf LED,W      ;move led file to w
        xorlw %11111111 ;see if all 3mm leds are lit
        btfsc STATUS,Z  ;
        goto D          ;yes, bypass
        movf SEG,W      ;move the value of the 'correct' or 'wrong'
        movwf PORTB     ;value to port b instead
        incf RANDOM,F   ;random number generator for the next game
        incf RANDOM,F   ;random number generator for the next game
        incf RANDOM,F   ;random number generator for the next game
        clrf PORTB      ;switch off port b

;test for keypresses

TESTK:  rlf DELAY,F     ;rotate the delay variable
        btfsc PORTA,3   ;test 'Scroll' key
        goto SCROLL     ;yes, divert
        btfsc PORTA,4   ;test 'Enter' key
        goto ENTER      ;yes, divert
        goto DISPLY     ;no, loop back to show the multiplex displays again


;de-bounce program for scroll key

SCROLL: movf DELAY,W    ;move de-bounce to w
        xorlw %10000000 ;has the bit reached last digit?
        btfsc STATUS,Z  ;test zero flag
        goto SCROLL1    ;yes, ok to proceed
        goto DISPLY     ;no, loop back to multiplex display for now

;increment scroll position

SCROLL1:movf LED,W      ;move led file to w
        xorlw %11111111 ;test if game is lost or won, all 3mm leds lit
        btfsc STATUS,Z  ;
        goto SETUP      ;yes, start a new game 
        movf LED,W      ;move led store to w
        xorlw %00010000 ;test if 'review' is illuminated
        btfsc STATUS,Z  ;test zero flag
        goto SCROLL3    ;yes, go and test the review flag
SCROLL2:movf LED,W      ;move led store to w
        xorlw %01000000 ;test if 'correct' is illuminated
        btfsc STATUS,Z  ;test zero flag
        goto LEDRST     ;yes, divert to reset 3mm led position
        movf LED,W      ;no, move led store to w
        xorlw %10000000 ;test if 'wrong' is illuminated
        btfsc STATUS,Z  ;test zero flag
        goto LEDRST     ;yes, divert to reset 3mm led position
        rlf LED,F       ;no, increment 3mm led position
        movf LED,W      ;move led store to w
        xorlw %01000000 ;has the answer reached the upper limit?
        btfsc STATUS,Z  ;test zero flag
        goto LEDRST     ;yes, divert to reset 3mm position
        goto DISPLY     ;no, go back to show the multiplex display
SCROLL3:btfsc FLAG,0    ;test review flag
        goto GUESS      ;reviewing, go and show the answers
        goto SCROLL2    ;not reviewing continue

LEDRST: movlw %00000001 ;reset the 3mm position
        movwf LED       ;move variable to the store
        goto DISPLY     ;go back to show the multiplex display

;de-bounce program for the enter key

ENTER:  movf DELAY,W    ;move de-bounce store to w
        xorlw %10000000 ;has the bit reached the last digit
        btfsc STATUS,Z  ;test zero flag
        goto ENTER1     ;yes, carry on
        goto DISPLY     ;no, loop back to show multiplex display for now

;increment enter position

ENTER1: movf LED,W      ;move led file to w
        xorlw %11111111 ;see if game is lost or won, all 3mm leds lit
        btfsc STATUS,Z  ;
        goto SETUP      ;yes, start a new game
        btfsc LED,0     ;test 3mm led pos
        call COL1       ;go to adjust tri-colour led 1
        btfsc LED,1     ;test 3mm led pos
        call COL2       ;go to adjust tri-colour led 2
        btfsc LED,2     ;test 3mm led pos
        call COL3       ;go to adjust tri-colour led 3
        btfsc LED,3     ;test 3mm led pos
        call COL4       ;go to adjust tri-colour led 4
        btfsc LED,4     ;test 3mm led pos
        goto REVIEW     ;show the last 'correct' & 'wrong' values
        btfsc LED,5     ;test 3mm led pos
        call GUESS      ;have a guess
        btfsc LED,6     ;test 3mm led pos
        goto CORRECT    ;show the last 'correct' & 'wrong' values
        btfsc LED,7     ;test 3mm led pos
        goto CORRECT    ;show the last 'correct' & 'wrong' values
        goto DISPLY     ;return to show the multiplex display

;user changing the colours of the tri-colour leds

COL1:   movf TRI,W      ;move tricolour led file to w
        andlw %00000011 ;remove all bits to leave the tricolour required
        movwf TEMP1     ;move answer to temp file
        incf TEMP1,F    ;change tricolour led colour
        movf TEMP1,W    ;move value to w
        andlw %00000011 ;remove all unwanted extra bits
        movwf TEMP1     ;move answer to temp file
        movf TRI,W      ;move complete tricolour led file to w
        andlw %11111100 ;clear one tricolour led
        movwf TRI       ;move answer to tricolour store
        movf TEMP1,W    ;move single colour to w
        iorwf TRI,F     ;merge the new colour with the original file
        clrf TEMP1      ;clear temp file for next time
        return          ;return 

COL2:   movf TRI,W      ;move tricolour led file to w
        andlw %00001100 ;remove all bits to leave the tricolour required
        movwf TEMP1     ;move answer to temp file
        rrf TEMP1,F     ;move the two bits to start of code
        rrf TEMP1,F     ;
        incf TEMP1,F    ;change tricolour led colour
        movf TEMP1,W    ;move answer to w
        andlw %00000011 ;remove all unwanted extra bits
        movwf TEMP1     ;move w to temp file
        rlf TEMP1,F     ;move the two bits back into the correct position
        rlf TEMP1,F     ;
        movf TRI,W      ;move complete tricolour file to w
        andlw %11110011 ;clear one tricolour led
        movwf TRI       ;move answer to w
        movf TEMP1,W    ;move single colour to w
        iorwf TRI,F     ;merge the new colour with the original file
        clrf TEMP1      ;clear temp file for next time
        return          ;return

COL3:   movf TRI,W      ;move tricolour led file to w
        andlw %00110000 ;remove all bits to leave the tricolour required
        movwf TEMP1     ;move answer to temp file
        rrf TEMP1,F     ;move the two bits to start of code
        rrf TEMP1,F     ;
        rrf TEMP1,F     ;
        rrf TEMP1,F     ;
        incf TEMP1,F    ;change tricolour led colour
        movf TEMP1,W    ;move temp file to w
        andlw %00000011 ;remove all unwanted extra bits
        movwf TEMP1     ;move answer to temp file
        rlf TEMP1,F     ;move the two bits back into the correct position
        rlf TEMP1,F     ;
        rlf TEMP1,F     ;
        rlf TEMP1,F     ;
        movf TRI,W      ;move complete tricolour file to w
        andlw %11001111 ;clear one tricolour led
        movwf TRI       ;move answer back into tricolour file
        movf TEMP1,W    ;move single led value to w
        iorwf TRI,F     ;merge the new colour with the original file
        clrf TEMP1      ;clear temp file
        return          ;return

COL4:   movf TRI,W      ;move tricolour led file to w
        andlw %11000000 ;remove all bits to leave the tricolour required
        movwf TEMP1     ;move answer to temp file
        rrf TEMP1,F     ;move the two bits to start of code
        rrf TEMP1,F     ;
        rrf TEMP1,F     ;
        rrf TEMP1,F     ;
        rrf TEMP1,F     ;
        rrf TEMP1,F     ;
        incf TEMP1,F    ;change tricolour led colour
        movf TEMP1,W    ;move temp file to w
        andlw %00000011 ;remove all unwanted extra bits
        movwf TEMP1     ;move back to file
        rlf TEMP1,F     ;move the two bits back into the correct position
        rlf TEMP1,F     ;
        rlf TEMP1,F     ;
        rlf TEMP1,F     ;
        rlf TEMP1,F     ;
        rlf TEMP1,F     ;
        movf TRI,W      ;move complete tricolour file to w
        andlw %00111111 ;clear one tricolour led
        movwf TRI       ;move answer to tricolour store
        movf TEMP1,W    ;move single led value to w
        iorwf TRI,F     ;merge the new colour with the original file
        clrf TEMP1      ;clear temp file for next time
        return          ;return

;

SEGMNT: incf SEGNUM,F   ;increment segment number file
        movf SEGNUM,W   ;move answer to w
        xorlw 10        ;test if 10 has occurred
        btfsc STATUS,Z  ;test zero flag
        clrf SEGNUM   ;yes, clear value
        movf SEGNUM,W   ;no, move value to w
        call TABLE      ;call 7 segment binary table
        movwf SEG       ;move answer to 7 segment store
        return          ;return
    
;the user has had a guess, need to establish 'correct' & 'wrong' values

GUESS:  clrf SEGNUM     ;clear 7 segment store
        clrf WRONG      ;clear the 'wrong' store
        clrf SEG        ;clear the 7 segment store
        btfss LED,4     ;test bit 4 of 3mm leds
        incf GOES,F     ;increment goes store
        movf GOES,W     ;
        xorlw 10        ;
        btfsc STATUS,Z  ;has the user has 10 guesses?
        goto ANSWER     ;yes, reveal answer

DIRECT: movlw MCOLOUR   ;this routine clears the memory of the 10 addresses
        movwf FSR       ;copy w into Indirect address reg
        movlw 10        ;move 10 into w
        movwf LOOP      ;move w into loop       
RESET:  movlw 0         ;moves 0 into w
        movwf INDF      ;moves w into indirect file
        incf FSR,F      ;increments fsr
        decfsz LOOP,F   ;has loop reached zero?
        goto RESET      ;no, loop round

;checks for 'correct' values

GUESS1: movf TRI,W      ;move tricolour value to w
        movwf TEMP1     ;move answer to temp 1 store
        movf MASTER,W   ;move masters value to w
        movwf TEMP2     ;move answer to temp 2 store

        movf TEST,W     ;move test value into w
        call TABLE2     ;call table binary value
        movwf TEMP3     ;move value to temp 3 store

        movf TEMP1,W    ;move tricolour value to w
        andwf TEMP3,W   ;use the table value to remove 3 tricolour values
        movwf TEMP1     ;move answer to temp 1 store

        movf TEMP2,W    ;move master value to w
        andwf TEMP3,W   ;use the table value to remove 3 led values
        movwf TEMP2     ;move answer to temp 2 store

        movf TEMP1,W    ;move single tricolour value to w
        xorwf TEMP2,W   ;check if it equals the value of the master's
        btfss STATUS,Z  ;has equality occurred?
        goto GUESS3     ;no, divert
        incf SEGNUM,F   ;yes, increment 7 segment value

GUESS2: incf TEST,W     ;increment test value
        xorlw 4         ;test if all 4 values have been checked
        btfsc STATUS,Z  ;test zero flag
        goto GETCODE    ;yes, divert and get 7 segment binary codes
        incf TEST,F     ;no, increment test value
        goto GUESS1     ;loop around and compare the other led values

;this section calculates the amount of colours in the wrong position

GUESS3: movf TEST,W     ;move test value to w
        call TABLE3     ;call rotation value from the lookup table
        movwf LOOP      ;move answer to loop
        movf LOOP,W     ;move loop to w
        xorlw 0         ;has 0 been called up?
        btfsc STATUS,Z  ;test zero flag
        goto GU1        ;yes, divert

;count the potential 'wrong' colours in the users code

GU:     rrf TEMP1,F     ;rotate users tricolour value
        decfsz LOOP,F   ;decrement loop until zero
        goto GU         ;no, keep rotating tricolour value
GU1:    movlw PCOLOUR   ;yes, move 35 to w
        addwf TEMP1,F   ;add the value of the colour to temp 1 store
        movf TEMP1,W    ;move answer to w
        movwf FSR       ;FSR relates to the value of the led colour
        incf INDF,F     ;increment direct file

        movf TEST,W     ;move test value to w
        call TABLE3     ;call rotation value from the lookup table
        movwf LOOP      ;move answer to loop
        movf LOOP,W     ;move loop to w
        xorlw 0         ;has 0 been called up?
        btfsc STATUS,Z  ;test zero flag
        goto GU3        ;yes, divert

;count the potential 'wrong' colours in the masters code

GU2:    rrf TEMP2,F     ;rotate users tricolour value
        decfsz LOOP,F   ;decrement loop until zero
        goto GU2        ;no, keep rotating tricolour value
GU3:    movlw MCOLOUR,W ;yes, move 30 to w
        addwf TEMP2,F   ;add value to temp 2 file
        movf TEMP2,W    ;move answer to w
        movwf FSR       ;FSR relates to the value of the led colour
        incf INDF,F     ;increment direct file
        goto GUESS2     ;return to check for 'correct' position values

;establishes the amount of colours in the 'wrong' order

GETCODE:movf SEGNUM,W   ;move number of correct numbers to w
        xorlw 4         ;are all 4 colours correct?
        btfsc STATUS,Z  ;
        goto ANSWER     ;yes go and show the answer
        movlw 30        ;no, move 30 to w
        movwf LOOP      ;move w to loop
GETCDE2:movf LOOP,W     ;move loop to w
        movwf FSR       ;put w into FSR
        movf INDF,W     ;move the indirect file to w
        movwf TEMP1     ;moves masters colour data into temp 1 file
        movlw 5         ;move 5 to w
        addwf LOOP,W    ;add 5 to loop value
        movwf FSR       ;put answer into FSR
        movf INDF,W     ;move the indirect file to w
        movwf TEMP2     ;move players colour data into temp 2 file
        movf TEMP2,W    ;move players data to w
        xorlw 0         ;is it zero?
        btfsc STATUS,Z  ;test zero flag
        goto GETCDE4    ;yes, divert
        movf TEMP1,W    ;move masters data to w
        xorlw 0         ;is it zero?
        btfsc STATUS,Z  ;test zero flag
        goto GETCDE4    ;yes, divert
        movf TEMP1,W    ;move masters data to w
        subwf TEMP2,W   ;calculate players - masters
        btfss STATUS,C  ;if answer is less than 0 then masters > players
        goto GETCDE3    ;no, divert
        movf TEMP1,W    ;yes, move master colour value to w
        addwf WRONG,F   ;add w to 'wrong' variable
        goto GETCDE4    ;bypass getcde3

GETCDE3:movf TEMP2,W    ;move players colour value to w
        addwf WRONG,F   ;add w to 'wrong' variable

GETCDE4:incf LOOP,W     ;increment loop
        xorlw 34        ;have all direct addresses been checked?
        btfsc STATUS,Z  ;test zero flag
        goto GETCDE5    ;yes, divert
        incf LOOP,F     ;no increment loop value
        goto GETCDE2    ;loop around to check other direct addresses

;prepares 7 segment values before returning to show the multiplex displays

GETCDE5:movf SEGNUM,W   ;move 7 segment value into w
        call TABLE      ;get 7 segment binary value
        movwf SEG       ;move w to segment variable
        movlw %10000000 ;3mm display to show 'correct' & 'review'
        movwf LED       ;move value to led variable
        movf GOES,W     ;move the number of guesses to w
        call TABLE      ;call 7 segment variable from table
        movwf SEGGO     ;move answer to 7 segment variable
        clrf TEMP1      ;clear all relevant files for next time around
        clrf TEMP2      ;
        clrf TEMP3      ;
        clrf TEST       ;
        clrf LOOP       ;
        clrf FLAG       ;
        btfsc LED,4     ;test if the 'review' led is lit
        goto DISPLY     ;yes, divert
        movf GOES,W     ;move the number of goes to w
        movwf REV       ;move w to review file
        movf GOES,W     ;move the number of goes to w
        addlw 40        ;add 40 to the figure
        movwf FSR       ;set direct file position
        movf TRI,W      ;move tricolour variable to w
        movwf INDF      ;
        goto DISPLY     ;return to show the multiplex display

;the user is able to review previous attempts

REVIEW: movf REV,W      ;move review file to w
        xorlw 0         ;
        btfsc STATUS,Z  ;is the review file still 0
        goto DISPLY     ;yes return to display
        bsf FLAG,0      ;set review flag
        decf REV,W      ;no, decrement review variable
        xorlw 0         ;test if it is 0
        btfsc STATUS,Z  ;
        goto REVW2      ;yes divert
        decf REV,F      ;no decrement file
REVW1:  movf REV,W      ;move review to w
        call TABLE      ;call 7 segment binary code
        movwf SEGGO     ;move it to display file
        movf REV,W      ;move review file to w
        addlw 40        ;add 40
        movwf FSR       ;move answer to direct file
        movf INDF,W     ;move direct file to w
        movwf TRI       ;move answer to tri colour display file
        goto DISPLY     ;return to display
REVW2:  movf GOES,W     ;move current number of goes to w
        movwf REV       ;move number to review file
        goto REVW1      ;continue as normal

;shows the 'correct' and 'wrong' results of the last guess

CORRECT:movf GOES,W     ;move the number of goes to w
        addlw 40        ;add 40 to the answer
CORECT1:movwf FSR       ;move value to indirect file
        movf INDF,W     ;move indirect file to w
        movwf TRI       ;move w to tricolour store
        btfsc LED,6     ;test 3mm led pos
        goto CORECT2    ;yes, divert to show the number of 'correct' colours 
        movf WRONG,W    ;no, move number of wrong colours to w 
        call TABLE      ;call 7 segment binary value from table
        movwf SEG       ;move it into the 7 segment store
        movlw %01000000 ;set the 3mm led positions
        movwf LED       ;move the value to the led variable
        goto DISPLY     ;return to show the multiplex display

CORECT2:movf SEGNUM,W   ;move 7 segment value into w
        call TABLE      ;get 7 segment binary value
        movwf SEG       ;move w to segment variable
        movlw %10000000 ;set the 3mm led positions
        movwf LED       ;move the value to the led variable
        goto DISPLY     ;return to show the multiplex display

ANSWER: movf GOES,W     ;move to w
        call TABLE      ;call 7 segment binary value
        movwf SEGGO     ;move answer to 7 segment varable
        movf MASTER,W   ;move pic's guess to w
        movwf TRI       ;move answer to w
        movlw %11111111 ;illuminate all 3mm leds
        movwf LED       ;
        goto DISPLY     ;go and show the variables

        .END            ;final statement

