VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#9.0#0"; "EPESeralIO.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Sample5 - Read Large Amounts Of Data From PIC"
   ClientHeight    =   5745
   ClientLeft      =   3885
   ClientTop       =   3075
   ClientWidth     =   6555
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5745
   ScaleWidth      =   6555
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   330
      Left            =   735
      TabIndex        =   2
      Top             =   330
      Width           =   1350
   End
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   105
      Top             =   210
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin MSComctlLib.ProgressBar ProgressBar2 
      Height          =   360
      Left            =   30
      TabIndex        =   1
      Top             =   1725
      Width           =   6465
      _ExtentX        =   11404
      _ExtentY        =   635
      _Version        =   393216
      Appearance      =   1
   End
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   360
      Left            =   30
      TabIndex        =   0
      Top             =   1110
      Width           =   6465
      _ExtentX        =   11404
      _ExtentY        =   635
      _Version        =   393216
      Appearance      =   1
      Max             =   258
   End
   Begin VB.Label Label8 
      BackStyle       =   0  'Transparent
      Caption         =   $"Form1.frx":0000
      Height          =   795
      Left            =   60
      TabIndex        =   10
      Top             =   4725
      Width           =   6195
   End
   Begin VB.Label Label7 
      BackStyle       =   0  'Transparent
      Caption         =   "This will help prevent receive buffer overruns even on the slowest of PC hardware."
      Height          =   390
      Left            =   60
      TabIndex        =   9
      Top             =   4230
      Width           =   5940
   End
   Begin VB.Label Label6 
      BackStyle       =   0  'Transparent
      Caption         =   "After the PC receives each block, it MUST tell the PIC to send the next block"
      Height          =   225
      Left            =   60
      TabIndex        =   8
      Top             =   3945
      Width           =   6210
   End
   Begin VB.Label Label5 
      BackStyle       =   0  'Transparent
      Caption         =   $"Form1.frx":011B
      Height          =   435
      Left            =   60
      TabIndex        =   7
      Top             =   3465
      Width           =   6210
   End
   Begin VB.Label Label4 
      BackStyle       =   0  'Transparent
      Caption         =   $"Form1.frx":01C4
      Height          =   825
      Left            =   60
      TabIndex        =   6
      Top             =   2610
      Width           =   6255
   End
   Begin VB.Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "This sample is designed to show a safe way of transferring large amounts of data from a PIC to the PC"
      Height          =   405
      Left            =   60
      TabIndex        =   5
      Top             =   2145
      Width           =   6300
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Total Blocks Received:"
      Height          =   195
      Left            =   30
      TabIndex        =   4
      Top             =   1515
      Width           =   1605
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Block Fill Level:"
      Height          =   195
      Left            =   75
      TabIndex        =   3
      Top             =   885
      Width           =   1065
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdStart_Click()

    Dim bError                          As Boolean
    Dim nBlockNumber                    As Integer
    Dim sDataBlock                      As String
    
    On Error GoTo ErrorHandler
    
    bError = False
    cmdStart.Enabled = False ' We don't want users to keep pressing this
    
    Screen.MousePointer = vbHourglass ' Signal were busy - this is going to take some time
    
    With EPESerial1
        ' We have choice here. We can use a pre-set block size
        ' or look for a line termination sequence (in this case CR+LF)
        ' We will use BlockMode as it's actually faster than Line mode since
        ' it's not always trying to identify the end of a line. Also, since we know
        ' exactly how many bytes are in a block, this was is safer.
        .RxBlockSize = 1        '258  ' 256 bytes of data + CR+LF
        .RxMode = sioBlockMode
    
        .Speed = sio19200       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False       ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 2            ' PIC must always respond within 2 seconds
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer     ' Always do this after we open the port to make sure the buffer is really empty
        '
        ' Tell the PIC to get ready to send
        .SendText "G" ' Go
        
        '
        ' Wait for a 'R' to be sent from the PIC (Indicates Ready)
        sDataBlock = .ReceiveText
        
        If sDataBlock = "R" Then
            ' 'R'eady received from PIC
            
            .RxBlockSize = 258      ' Reconfigure block size to accept actual data packets - 256 Bytes of data + CR+LF
            .ProgressEvents = True
                
            For nBlockNumber = 1 To 100 ' Were expecting 100 blocks
                .SendText "B"  ' Tell the PIC to send a block
                
                ' The program will now go off and receive 258 bytes of data
                sDataBlock = .ReceiveText ' Load sDataBlock with the 258 bytes of data
                ' 258 bytes of data should have been received at this point - or somethings wrong
                ' Lets see....
                If Len(sDataBlock) <> 258 Then
                     bError = True
                    MsgBox "For some reason, we didn't recevie a complete block of data", vbOKOnly + vbCritical
                    ' No point carring on
                    Exit For
                End If
                
                '
                ' Well, the data packet contains 258 bytes BUT is the packet terminator
                ' what we expect. This could be a checksum but in this case it's just <CR> + <LF>
                If Right$(sDataBlock, 2) <> vbCr & vbLf Then
                    bError = True
                    MsgBox "We didn't get the <CR> + <LF> at then end of the packet", vbOKOnly + vbCritical
                    ' Again, no point carring on
                    Exit For
                End If
                
                '
                ' At this point, the variable 'sDataBlock' contains 258 bytes of data
                ' Normally we would 'do something' with this, after all that's the
                ' point. But for our example, we will just throw it away.
                
                ProgressBar2.Value = nBlockNumber ' Update number of blocks received
                
            Next nBlockNumber
        
        Else
            bError = True
            MsgBox "'R'eady not received from PIC... Check that the PIC is connected and running !", vbOKOnly + vbCritical, "Receive 'Ready' time-out"
        
        End If
        '
        ' All done - tidy up.
        .PortStatus = sioPortClosed
    End With
        

    cmdStart.Enabled = True ' Ready to run again
    Screen.MousePointer = vbDefault
    
    If bError = False Then
        MsgBox "Data received without errors !"
    End If
    
    Exit Sub
    
ErrorHandler:
    MsgBox "An error occured - " & Err.Description, vbOKOnly + vbCritical
    '
    ' Attempt to tidy up
    On Error Resume Next ' We don't want to know about any further errors
    EPESerial1.PortStatus = sioPortClosed
    cmdStart.Enabled = True ' Let the user try again
End Sub

Private Sub tmrBufferFillLevel_Timer()

    ' Have a 'peek' into the receive buffer and get the number
    ' of characters currently sitting there.
    ' Output this value on the top progress bar control.
    ProgressBar1.Value = Len(EPESerial1.PeekReceiveBuffer)
End Sub



Private Sub EPESerial2_CommunicationsEvent(EventCode As EPESerialControl.eCommsEvents, RXBufferContents As String)

End Sub


Private Sub EPESerial1_CommunicationsEvent(ByVal EventCode As EPESerialControl.eCommsEvents, ByVal RXBufferContents As String, ByVal BufferLength As Long)

    Select Case EventCode
    Case EPESerialControl.eCommsEvents.sioRxProgress
        ProgressBar1.Value = BufferLength
        
    End Select
    
End Sub

