VERSION 5.00
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#9.0#0"; "EPESeralIO.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Sample3"
   ClientHeight    =   5445
   ClientLeft      =   3285
   ClientTop       =   1980
   ClientWidth     =   4020
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5445
   ScaleWidth      =   4020
   Begin VB.CheckBox Check1 
      Caption         =   "Receive Events"
      Height          =   285
      Left            =   345
      TabIndex        =   3
      Top             =   990
      Width           =   1725
   End
   Begin VB.ListBox List1 
      Height          =   1815
      Left            =   180
      TabIndex        =   2
      Top             =   1350
      Width           =   3615
   End
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   3435
      Top             =   450
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   405
      Left            =   165
      TabIndex        =   1
      Top             =   480
      Width           =   1530
   End
   Begin VB.Label Label4 
      BackStyle       =   0  'Transparent
      Caption         =   $"Form1.frx":0000
      Height          =   705
      Left            =   105
      TabIndex        =   6
      Top             =   4695
      Width           =   3555
   End
   Begin VB.Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "With 'Receive Events' off, a character MUST be recevied at least every 2 seconds to prevent a time-out."
      Height          =   630
      Left            =   90
      TabIndex        =   5
      Top             =   3990
      Width           =   3915
   End
   Begin VB.Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   $"Form1.frx":0088
      Height          =   675
      Left            =   105
      TabIndex        =   4
      Top             =   3315
      Width           =   3660
   End
   Begin VB.Label Label1 
      Caption         =   "Receive messages in groups of 5 characters"
      Height          =   255
      Left            =   225
      TabIndex        =   0
      Top             =   60
      Width           =   3495
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdStart_Click()
    
    On Error GoTo ErrorHandler
    
    cmdStart.Enabled = False
    Check1.Enabled = False
    
    List1.Clear
    
    With EPESerial1
        .ComPort = 1
        .Speed = sio19200
        .WordLength = sio8Bits
        .StopBits = sio1Bit
        .Parity = sioNoParity
        
        .RxBlockSize = 5        ' Set the block size to 5 characters
        .RxMode = sioBlockMode  ' Set block mode. This MUST be after the RxBlockSize property is set
        
        .PortStatus = sioPortOpen
        
        If Check1.Value = False Then
            ' Normal mode
            '
            ' In this mode, if a character is not received at least every 2 seconds,
            ' then a time-out will occure.
            '
            .RxEvents = False
            .TimeOut = 2 ' A character must be received at least every 2 seconds else we time-out.
            List1.AddItem "Done - Received:" & .ReceiveText ' Show the COMPLETE packet once received.
            
            EPESerial1.PortStatus = sioPortClosed
            Check1.Enabled = True
            cmdStart.Enabled = True
        Else
            ' Polled mode
            .RxEvents = True
            ' Show COMPLETE packets as they arrive. No time-outs.
        
        End If
        
    End With
    
    Exit Sub
    
ErrorHandler:
    MsgBox "An error has occured - " & Err.Description, vbOKOnly + vbCritical, "Application Error"
    
    '
    ' Attempt to tidy up
    On Error Resume Next ' Ignore any errors from now on
    
    EPESerial1.PortStatus = sioPortClosed
    cmdStart.Enabled = True
    Check1.Enabled = True
    
End Sub


Private Sub cmdStop_Click()

    With EPESerial1
        .PortStatus = sioPortClosed
    End With
    
End Sub




Private Sub EPESerial1_RXTimeOut()

End Sub


Private Sub EPESerial1_CommunicationsEvent(ByVal EventCode As EPESerialControl.eCommsEvents, ByVal RXBufferContents As String, ByVal BufferLength As Long)

    Select Case EventCode
    Case EPESerialControl.eCommsEvents.sioRxData
        ' A valid block has been received by the control.
        ' Show it to the user
        List1.AddItem RXBufferContents
    
    Case EPESerialControl.eCommsEvents.sioRxTimeOut
        ' This EventCode only occures when NOT in polled mode
        List1.AddItem "Timeout whilst waiting for read to complete"
        ' Whilst a complete block was not received, something might have been.
        ' Show it to the user - it might be helpful
        List1.AddItem "Buffer contained:" & RXBufferContents
        
        '
        ' Tidy up
        EPESerial1.PortStatus = sioPortClosed
        Check1.Enabled = True
        cmdStart.Enabled = True

    End Select

End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)

    EPESerial1.PortStatus = sioPortClosed
    
End Sub


