VERSION 5.00
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#9.0#0"; "EPESeralIO.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Sample2 - Test Application"
   ClientHeight    =   5055
   ClientLeft      =   4050
   ClientTop       =   2610
   ClientWidth     =   3825
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5055
   ScaleWidth      =   3825
   Begin VB.CommandButton cmdClear 
      Caption         =   "Clear"
      Height          =   330
      Left            =   2550
      TabIndex        =   7
      Top             =   945
      Width           =   1155
   End
   Begin VB.CheckBox chkMonitor 
      Caption         =   "Show DataMonitor"
      Height          =   270
      Left            =   150
      TabIndex        =   6
      Top             =   690
      Value           =   1  'Checked
      Width           =   1755
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   330
      Left            =   105
      TabIndex        =   5
      Top             =   105
      Width           =   1155
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   330
      Left            =   1635
      TabIndex        =   4
      Top             =   105
      Width           =   1155
   End
   Begin VB.ListBox List1 
      Height          =   2790
      Left            =   120
      TabIndex        =   1
      Top             =   2115
      Width           =   3570
   End
   Begin VB.TextBox txtText 
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   1365
      Width           =   3570
   End
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   2940
      Top             =   120
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin VB.Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "Response from PIC is shown here:"
      Height          =   345
      Left            =   150
      TabIndex        =   3
      Top             =   1875
      Width           =   2820
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Type characters into here:"
      Height          =   315
      Left            =   120
      TabIndex        =   2
      Top             =   1095
      Width           =   2025
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdClear_Click()

    txtText.Text = ""
    List1.Clear
    
End Sub

Private Sub cmdStart_Click()

    cmdStart.Enabled = False                 ' We don't want the button clicking when were busy
    cmdStop.Enabled = True                   ' Allow the user to stop the task if requried
    txtText.Text = ""
    txtText.Enabled = True                   ' Allow the user to enter into the Text control
    chkMonitor.Enabled = False               ' Can't change this setting once the program has started
    
    List1.Clear
    
    With EPESerial1
        .ShowMonitor chkMonitor.Value        ' Do we need to show the data monitor window
        
        .ComPort = 1                         ' Change this to your COM port no
        .Speed = sio19200                    ' Sets speed to 19200 baud
        .WordLength = sio8Bits               ' 8 Bits per word
        .StopBits = sio1Bit                  ' 1 stop bit
        .Parity = sioNoParity                ' No Parity
        
        .RxEndOfMessageMarker = "." & vbCr   ' We are looking for '.' and <CR> (2 bytes at end of line)
        .RxMode = sioLineMode                ' Set to Line mode - Wait for RxEndOfMessageMarker
        .IncludeRxEndOfMessageMarker = False ' We don't actually want the End Of Line (EOL) marker in data returned to us
                                             ' (the two bytes specifed with the RxEndOfMessageMarker property)
        
        .PortStatus = sioPortOpen            ' Open the serial port
        
        .RxEvents = True                     ' MUST be set after the PortOpen function else an error occures.
                                             ' We use RxEvents because we are expecting multiple lines to
                                             ' be returned in this example and we want an event to be raised
                                             ' every time a valid line is received from the PIC.
                                             ' (Saves us having to keep pooling and looking for valid data)
                                        
        .ClearReceiveBuffer                  ' Make sure that the RX buffer dosn't contain any rubbish
    End With
            
End Sub


Private Sub cmdStop_Click()

    cmdStart.Enabled = True
    cmdStop.Enabled = False
    txtText.Enabled = True      ' Prevent the user from typing things into the Text box control
    chkMonitor.Enabled = False
    
    
    With EPESerial1
        .PortStatus = sioPortClosed
    End With
    
End Sub





Private Sub EPESerial1_CommunicationsEvent(ByVal EventCode As EPESerialControl.eCommsEvents, ByVal RXBufferContents As String, ByVal BufferLength As Long)

    Select Case EventCode
    Case EPESerialControl.eCommsEvents.sioRxData
        List1.AddItem RXBufferContents
    
    End Select
    
End Sub

Private Sub txtText_KeyPress(KeyAscii As Integer)

    With EPESerial1
        .SendText Chr$(KeyAscii) ' Send a single character that represents the key that was just pressed
    End With
    
End Sub


