;Lightshow (this version uses interrupt to change patterns)		
;Andy Flind, 5/8/02		
;For PIC16F84		

__config H'3FF3'		;osc = RC, wdt = OFF,  put = ON

#DEFINE PAGE0 BCF STATUS,5		
#DEFINE PAGE1 BSF STATUS,5		

#DEFINE ON1 BCF PORTA,0		;output control statements
#DEFINE OFF1 BSF PORTA,0		;this allows them to be changed easily
#DEFINE ON2 BCF PORTB,7		;from pull-up to pull-down
#DEFINE OFF2 BSF PORTB,7		;and for their order to be changed
#DEFINE ON3 BCF PORTB,6		;to increase randomness
#DEFINE OFF3 BSF PORTB,6		;if desired
#DEFINE ON4 BCF PORTB,5		
#DEFINE OFF4 BSF PORTB,5
#DEFINE ON5 BCF PORTB,4
#DEFINE OFF5 BSF PORTB,4
#DEFINE ON6 BCF PORTB,3
#DEFINE OFF6 BSF PORTB,3
#DEFINE ON7 BCF PORTB,2
#DEFINE OFF7 BSF PORTB,2
#DEFINE ON8 BCF PORTB,1
#DEFINE OFF8 BSF PORTB,1
#DEFINE ON9 BCF PORTB,0
#DEFINE OFF9 BSF PORTB,0
#DEFINE ON10 BCF PORTA,3
#DEFINE OFF10 BSF PORTA,3
#DEFINE ON11 BCF PORTA,2
#DEFINE OFF11 BSF PORTA,2
#DEFINE ON12 BCF PORTA,1
#DEFINE OFF12 BSF PORTA,1		

STATUS:	.EQU $03	;general equates
PORTA:	.EQU $05	
PORTB:	.EQU $06	
TRISA:	.EQU $05	
TRISB:	.EQU $06	
PCL:	.EQU $02	
TMR0:	.EQU $01	
OPTION:	.EQU $01	
INTCON:	.EQU $0B	
F:	.EQU $01	
W:	.EQU $00	
Z:	.EQU $02	
C:	.EQU $00	

CTR1:	.EQU $0C	;program specific equates
EXOR:	.EQU $0D	
SR1:	.EQU $0E	
SR2:	.EQU $0F	
OUT1:	.EQU $10	
OUT2:	.EQU $11	
TM1:	.EQU $12	
TM2:	.EQU $13	
TM3:	.EQU $14	
TM4:	.EQU $15	
TM5:	.EQU $16	
TM6:	.EQU $17	
TM7:	.EQU $18	
TM8:	.EQU $19	
TM9:	.EQU $1A	
TM10:	.EQU $1B	
TM11:	.EQU $1C	
TM12:	.EQU $1D	
PTR:	.EQU $1E	;used to direct program after button press
SPEED:	.EQU $20	;used by 'dly' to set speed within program

	.ORG $0004	;interrupt vector
	GOTO BUTTON	;react to a button press
	.ORG $0005	;start of program

	PAGE1	;initilise for operation
	MOVLW %00010000	
	MOVWF TRISA	;first 4 bits of portA all output
	CLRF TRISB	;all of portB output
	MOVLW %00111000	
	MOVWF OPTION	
	PAGE0	
	MOVLW 255	;turn off all the outputs
	MOVWF PORTA	
	MOVWF PORTB	
	MOVLW 1	
	MOVWF PTR	;ensure correct operation for first button press
	CALL AOFF	;turn off all LEDs
	GOTO BUTTON	;this will set up the interrupts and direct to the correct routine
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~		
;Pattern program...		
PATTN:	CALL AOFF	;ensure start with all LEDs off
	MOVLW 80	
	MOVWF SPEED	
	CALL SOTD	;sweep on from top down
	CALL SOFFTD	;sweep off from top down
	CALL SOLR	;sweep on from left
	CALL SOFFLR	;sweep off from left
	CALL SOBU	;sweep on from bottom up
	CALL SOFFBU	;sweep off from bottom up
	CALL SORL	;sweep on from right
	CALL SOFFRL	;sweep off from right
	CALL SOTD	;sweep on from top down
	CALL SOFFRL	;sweep off from right
	CALL SOLR	;sweep on from left
	CALL SOFFTD	;sweep off from top down
	CALL SOBU	;sweep on from bottom up
	CALL SOFFLR	;sweep off from left
	CALL SORL	;sweep on from right
	CALL SOFFBU	;sweep off from bottom up
	MOVLW 3	
	MOVWF TM1	
RPTA:	CALL ROC	;rotate on clockwise
	CALL ROFFC	;rotate off clockwise
	DECFSZ TM1,F	
	GOTO RPTA	
	CALL ROC	;rotate on clockwise
	OFF1	;set up a pattern
	CALL DLY	
	OFF2	
	CALL DLY	
	OFF3	
	CALL DLY	
	OFF4	
	CALL DLY	
	OFF5	
	CALL DLY	
	OFF6	
	CALL DLY	
	OFF7	
	CALL DLY	
	OFF8	
	CALL DLY	
	MOVLW 8	;rotate it eight times
	MOVWF TM1	
RPTB:	CALL RPC	;rotate pattern clockwise once
	DECFSZ TM1,F	
	GOTO RPTB	
	ON1	;change the pattern
	OFF11	
	CALL DLY	
	ON2	
	OFF12	
	CALL DLY	
	ON3	
	OFF1	
	CALL DLY	
	ON4	
	OFF2	
	CALL DLY	
	MOVLW 120	
	MOVWF SPEED	
	MOVLW 8	;rotate it eight times
	MOVWF TM1	
RPTC:	CALL RPC	;rotate pattern clockwise once
	DECFSZ TM1,F	
	GOTO RPTC	
	CALL DLY	
	ON5	;close the pattern
	OFF3	
	CALL DLY	
	ON6	
	OFF4
	CALL DLY
	ON7
	OFF5
	CALL DLY
	ON8
	OFF6
	CALL DLY
	ON11
	OFF7
	CALL DLY
	ON12
	OFF8
	CALL DLY
	OFF9
	CALL DLY
	OFF10	
	CALL DLY	
	OFF11	
	CALL DLY	
	OFF12	
	CALL DLY	
	MOVLW 80	
	MOVWF SPEED	
	CALL SOTD	;sweep on from top down
	CALL SOFFTD	;sweep off from top down
	CALL SOLR	;sweep on from left
	CALL SOFFLR	;sweep off from left
	CALL SOBU	;sweep on from bottom up
	CALL SOFFBU	;sweep off from bottom up
	CALL SORL	;sweep on from right
	CALL SOFFRL	;sweep off from right
	CALL SOTD	;sweep on from top down
	CALL SOFFRL	;sweep off from right
	CALL SOLR	;sweep on from left
	CALL SOFFTD	;sweep off from top down
	CALL SOBU	;sweep on from bottom up
	CALL SOFFLR	;sweep off from left
	CALL SORL	;sweep on from right
	CALL SOFFBU	;sweep off from bottom up
	CALL ROC	;rotate on clockwise
	CALL ROFFC	;rotate off clockwise
	CALL ROC	;rotate on clockwise
	CALL ROFFC	;rotate off clockwise
	MOVLW 55	
	MOVWF SPEED	
	MOVLW 8	
	MOVWF TM1	
RPTD:	CALL SOTD	;sweep on from top down
	CALL SOFFTD	;sweep off from top down
	DECFSZ TM1,F	
	GOTO RPTD	
	MOVLW 150	
	MOVWF SPEED	
	CALL PSTC	;start pendulum lights clockwise
	MOVLW 3	
	MOVWF TM1	
RPTE:	CALL PSWC	;do a pendulum swing anticlockwise
	CALL PSWCC	;do a pendulum swing clockwise
	DECFSZ TM1,F	
	GOTO RPTE	
	CALL PSWC	;do a pendulum swing anticlockwise
	OFF3	
	CALL DLY	
	OFF2	
	CALL DLY	
	OFF1	
	CALL DLY	
	OFF12	
	CALL DLY	
	MOVLW 65	
	MOVWF SPEED	
	MOVLW 3	
	MOVWF TM1	
RPTF:	CALL ROCC	;rotate on anticlockwise
	CALL ROFFCC	;rotate off anticlockwise
	DECFSZ TM1,F	
	GOTO RPTF	
	GOTO PATTN	
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~		
;pattern generating subroutines	
;all on	
AON:	CLRF PORTA
	CLRF PORTB
	RETURN

;all off	
AOFF:	MOVLW 255
	MOVWF PORTA
	MOVWF PORTB
	RETURN

;rotate pattern clockwise once	
RPC:	MOVLW 12
	MOVWF TM2
RS1:	CALL CW
	CALL DLY
	DECFSZ TM2,F
	GOTO RS1
	RETURN

;rotate on clockwise	
ROC:	MOVLW 12
	MOVWF TM2
RS3:	ON1
	CALL DLY
	CALL CW
	DECFSZ TM2,F
	GOTO RS3
	RETURN

;rotate on anticlockwise	
ROCC:	MOVLW 12
	MOVWF TM2
RS4:	ON11
	CALL DLY
	CALL CCW
	DECFSZ TM2,F
	GOTO RS4
	RETURN

;rotate off clockwise	
ROFFC:	MOVLW 12
	MOVWF TM2
RS5:	OFF12
	CALL CW
	CALL DLY
	DECFSZ TM2,F
	GOTO RS5
	RETURN

;rotate off anticlockwise	
ROFFCC:	MOVLW 12
	MOVWF TM2
RS6:	OFF12
	CALL CCW
	CALL DLY
	DECFSZ TM2,F
	GOTO RS6
	RETURN

;start pendulum lights clockwise	
PSTC:	MOVLW 4
	MOVWF TM2
RS7:	ON1
	CALL DLY
	CALL CW
	DECFSZ TM2,F
	GOTO RS7
	CALL DLY
	MOVLW 7
	MOVWF TM2
RS8:	CALL CW
	CALL DLY
	DECFSZ TM2,F
	GOTO RS8
	RETURN

;do a pendulum swing anticlockwise	
PSWC:	MOVLW 9
	MOVWF TM2
RS9:	CALL CCW
	CALL DLY
	DECFSZ TM2,F
	GOTO RS9
	RETURN

;do a pendulum swing clockwise	
PSWCC:	MOVLW 9
	MOVWF TM2
RS10:	CALL CW
	CALL DLY
	DECFSZ TM2,F
	GOTO RS10
	RETURN

;sweep on from top down	
SOTD:	ON12
	CALL DLY
	ON11
	ON1
	CALL DLY
	ON10
	ON2
	CALL DLY
	ON9
	ON3
	CALL DLY
	ON8
	ON4
	CALL DLY
	ON7
	ON5
	CALL DLY
	ON6
	CALL DLY
	RETURN

;sweep on from bottom up	
SOBU:	ON6
	CALL DLY
	ON7
	ON5
	CALL DLY
	ON8
	ON4
	CALL DLY
	ON9
	ON3
	CALL DLY
	ON10
	ON2
	CALL DLY
	ON11
	ON1
	CALL DLY
	ON12
	CALL DLY
	RETURN

;sweep on from left	
SOLR:	ON9
	CALL DLY
	ON10
	ON8
	CALL DLY
	ON11
	ON7
	CALL DLY
	ON12
	ON6
	CALL DLY
	ON1
	ON5
	CALL DLY
	ON2
	ON4
	CALL DLY
	ON3
	CALL DLY
	RETURN

;sweep on from right	
SORL:	ON3
	CALL DLY
	ON2
	ON4
	CALL DLY
	ON1
	ON5
	CALL DLY
	ON12
	ON6
	CALL DLY
	ON11
	ON7
	CALL DLY
	ON10
	ON8
	CALL DLY
	ON9
	CALL DLY
	RETURN

;sweep off from top down	
SOFFTD:	OFF12
	CALL DLY
	OFF11
	OFF1
	CALL DLY
	OFF10
	OFF2
	CALL DLY
	OFF9
	OFF3
	CALL DLY
	OFF8
	OFF4
	CALL DLY
	OFF7
	OFF5
	CALL DLY
	OFF6
	CALL DLY
	RETURN

;sweep off from bottom up	
SOFFBU:	OFF6
	CALL DLY
	OFF7
	OFF5
	CALL DLY
	OFF8
	OFF4
	CALL DLY
	OFF9
	OFF3
	CALL DLY
	OFF10
	OFF2
	CALL DLY
	OFF11
	OFF1
	CALL DLY
	OFF12
	CALL DLY
	RETURN

;sweep off from left	
SOFFLR:	OFF9
	CALL DLY
	OFF10
	OFF8
	CALL DLY
	OFF11
	OFF7
	CALL DLY
	OFF12
	OFF6
	CALL DLY
	OFF1
	OFF5
	CALL DLY
	OFF2
	OFF4
	CALL DLY
	OFF3
	CALL DLY
	RETURN

;sweep off from right	
SOFFRL:	OFF3
	CALL DLY
	OFF2
	OFF4
	CALL DLY
	OFF1
	OFF5
	CALL DLY
	OFF12
	OFF6
	CALL DLY
	OFF11
	OFF7
	CALL DLY
	OFF10
	OFF8
	CALL DLY
	OFF9
	CALL DLY
	RETURN

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~		
;The random sequence generator...		
RANDOM:	CLRF OUT1	;initialise this register
	CLRF OUT2	;and this one

	MOVF SR1,F	;this section checks for all zero's state
	BTFSS STATUS,Z	;in the PRBS generator
	GOTO NON_Z	;jump out if first register not zero
	MOVF SR2,W	;2nd register
	ANDLW %0111111,W	;only check the first 7 bits
	BTFSS STATUS,Z	
	GOTO NON_Z	;jump out if 2nd register not zero
	MOVLW %01010101	;else preload this into sr1
	MOVWF SR1	

NON_Z	CALL OP1	;this initiates the outputs
	CALL SHFT	;and their delay counters
	CALL OP2	
	CALL SHFT	
	CALL OP3	
	CALL SHFT	
	CALL OP4	
	CALL SHFT	
	CALL OP5	
	CALL SHFT	
	CALL OP6	
	CALL SHFT	
	CALL OP7	
	CALL SHFT	
	CALL OP8	
	CALL SHFT	
	CALL OP9	
	CALL SHFT	
	CALL OP10	
	CALL SHFT	
	CALL OP11	
	CALL SHFT	
	CALL OP12	

LOOP:	CALL SHFT	;step the PRBS generator
	DECF TM1,F	;do a timer delay
	BTFSC STATUS,Z	;decrement delays counter
	CALL OP1	;if zero, call so, call associated output subroutine

	CALL SHFT	
	DECF TM2,F	
	BTFSC STATUS,Z	
	CALL OP2	

	CALL SHFT
	DECF TM3,F
	BTFSC STATUS,Z
	CALL OP3

	CALL SHFT
	DECF TM4,F
	BTFSC STATUS,Z
	CALL OP4

	CALL SHFT
	DECF TM5,F
	BTFSC STATUS,Z
	CALL OP5

	CALL SHFT
	DECF TM6,F
	BTFSC STATUS,Z
	CALL OP6

	CALL SHFT
	DECF TM7,F
	BTFSC STATUS,Z
	CALL OP7

	CALL SHFT
	DECF TM8,F
	BTFSC STATUS,Z
	CALL OP8

	CALL SHFT
	DECF TM9,F
	BTFSC STATUS,Z
	CALL OP9

	CALL SHFT
	DECF TM10,F
	BTFSC STATUS,Z
	CALL OP10

	CALL SHFT
	DECF TM11,F
	BTFSC STATUS,Z
	CALL OP11

	CALL SHFT
	DECF TM12,F
	BTFSC STATUS,Z	
	CALL OP12	

	GOTO LOOP	;and go do the whole lot again

OP1:	BTFSC SR2,6	;output subroutine, first of twelve
	ON1	;if it's set, turn on the output
	BTFSS SR2,6	
	OFF1	;if it's clear, turn off the output
	MOVF SR1,W	
	ANDLW %00000111	;add the first 3 bits of sr1 with 1
	ADDLW 1	;for value between 1 and 8
	MOVWF TM1	;for number of delays before next change
	RETURN	

OP2:	BTFSC SR2,6	
	ON2
	BTFSS SR2,6
	OFF2
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM2
	RETURN

OP3:	BTFSC SR2,6
	ON3
	BTFSS SR2,6
	OFF3
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM3
	RETURN

OP4:	BTFSC SR2,6
	ON4
	BTFSS SR2,6
	OFF4
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM4
	RETURN

OP5:	BTFSC SR2,6
	ON5
	BTFSS SR2,6
	OFF5
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM5
	RETURN

OP6:	BTFSC SR2,6
	ON6
	BTFSS SR2,6
	OFF6
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM6
	RETURN

OP7:	BTFSC SR2,6
	ON7
	BTFSS SR2,6
	OFF7
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM7
	RETURN

OP8:	BTFSC SR2,6
	ON8
	BTFSS SR2,6
	OFF8
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM8
	RETURN

OP9:	BTFSC SR2,6
	ON9
	BTFSS SR2,6
	OFF9
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM9
	RETURN

OP10:	BTFSC SR2,6
	ON10
	BTFSS SR2,6
	OFF10
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM10
	RETURN

OP11:	BTFSC SR2,6
	ON11
	BTFSS SR2,6
	OFF11
	MOVF SR1,W
	ANDLW %00000111
	ADDLW 1
	MOVWF TM11	
	RETURN	

OP12:	BTFSC SR2,6	
	ON12	
	BTFSS SR2,6	
	OFF12	
	MOVF SR1,W	
	ANDLW %00000111	
	ADDLW 1	
	MOVWF TM12	
	RETURN	

SHFT:	CLRF EXOR	;15-bit PRBS generator
	BTFSC SR2,5	;a call to shft causes it to step
	INCF EXOR,F	
	BTFSC SR2,6	
	INCF EXOR,F	
	BCF STATUS,C	
	BTFSC EXOR,0	
	BSF STATUS,C	
	RLF SR1,F	;lower 8 bits in register sr1
	RLF SR2,F	;higher 7 bits in register sr2
	RETURN	

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~		
;general subroutines		
;rotate pattern clockwise one step		
CW:	SWAPF PORTA,W	;last four bits of portA... 
	MOVWF SR1	;... into first four of intermediate register
	RRF PORTA,F	;rotate A right
	RRF PORTB,F	;rotate B right
	RRF SR1,F	;rotate intermediate right
	SWAPF SR1,W	;first four of intermediate...
	MOVWF PORTA	;... into last four of A
	RETURN	

;rotate pattern anti-clockwise one step		
CCW:	SWAPF PORTA,W	;last 4 bits of portA...
	MOVWF SR1	;...into first four of SR1
	RLF SR1,F	;leftmost of them into carry
	RLF PORTB,F	;rotate it into port B
	RLF PORTA,F	;and the leftmost bit of portB into port A
	RETURN	

;delay used for overall rate control, set time with value in 'SPEED'		
DLY:	MOVF SPEED,W	
	MOVWF CTR1	
DL_1:	DECFSZ CTR1,F	
	GOTO DL_1	
	RETURN	

;switch between all on, patterns and random with button		
BUTTON:	CALL AOFF	;turn off any running LEDs

BUT1:	MOVLW 100	
	MOVWF CTR1	;debounce the button
BUT2:	BTFSS PORTA,4	
	GOTO BUT1	
	DECFSZ CTR1,F	
	GOTO BUT2	

	MOVLW 255	;set up and enable interrupt
	MOVWF TMR0	;pre-load TMR0
	BCF INTCON,2	;T0IF clear
	BSF INTCON,5	;T0IE enable
	BSF INTCON,7	;GIE enable

	BTFSC PTR,0	
	GOTO BUT3	;if it's set, go to random
	BTFSC PTR,1	
	GOTO BUT4	;if it's set, go to pattern
	BSF PTR,0	
	CALL AON	;else turn all LEDs on
STOP:	GOTO STOP	;and wait here
BUT3:	BCF PTR,0	
	BSF PTR,1	
	GOTO RANDOM	
BUT4:	BCF PTR,1	
	GOTO PATTN	

	.END
