; TK3TUT32.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2 (prev tut33)
                 
; EEPROM USE DETAILS

; THIS PROGRAM IS INCAPABLE OF BEING RUN AS IT STANDS
; IT NEEDS OTHER ROUTINES TO ACCESS IT
             
; it just shows the codes needed for eeprom data write and read
               
; BASIC INITIALISATION COMMANDS:

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

INDF            EQU 0			; indirect register
OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
FSR             EQU 4                   ; indirect register pointer
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
                 
STORE1          EQU H'20'               ;or any convenient address
                 
; obligatory initialisation of variables for eeprom read/write operation:
                 
EEDATA          EQU 8
EECON1          EQU 8
EEADR           EQU 9
EECON2          EQU 9
INTCON          EQU H'0B'
                 
WR              EQU 1                   ;eeprom write initiate flag
WREN            EQU 2                   ;eeprom write enable flag
RD              EQU 0                   ;eeprom read enable flag
                 
                                        ;...............
                 
                                        ;WRITE DATA TO EEPROM ROUTINE:
                 
                                        ;This routine is entered with W holding
                                        ;the eeprom byte address at which data
                                        ;is to be stored. The data to be stored
                                        ;is held in STORE1.

SETPRM          movwf EEADR             ;Now copy W into EEADR to set eeprom address
                BANK1 
                bsf EECON1,WREN         ;enable write flag
                BANK0 
                movf STORE1,W           ;get data value from STORE1 and hold in W
                movwf EEDATA            ;copy W into eeprom data byte register
                 
MANUAL          BANK1                   ;these next 12 lines are according to
                movlw H'55'             ;Microchip manual dictated factors
                movwf EECON2            ;they cause the action required by
                movlw H'AA'             ;by the eeprom to store the data in EEDATA
                movwf EECON2            ;at the address held by EEADR.
                bsf EECON1,WR           ;set the ``perform write'' flag
                 
CHKWRT          btfss EECON1,4          ;wait until bit 4 of EECON1 is set
                goto CHKWRT
                bcf EECON1,WREN         ;disable write
                bcf EECON1,4            ;clear bit 4 of EECON1
                BANK0 
                bcf INTCON,6            ;clear bit 6 of INTCON
                return                  ;and return
                 
                                        ;..........
                 
                                        ;READ DATA FROM EEPROM ROUTINE:
                 
                                        ;This routine is entered with W holding
                                        ;the eeprom byte address to be read.

GETPRM          movwf EEADR             ;Now copy W into EEADR to set eeprom address
                BANK1                   ;
                bsf EECON1,RD           ;enable read flag
                BANK0 
                movf EEDATA,W           ;read eeprom data now in EEDATA into W
                return                  ;and return


		END
