; TK3TUTLCD.INC 15FEB03

; ******* definitions required in main ASM program ****
;         change values to suit ASM prog

#DEFINE LCDELINEHI bsf PORTB,5  ; E line for LCD
#DEFINE LCDELINELO bcf PORTB,5  ; E line for LCD
#DEFINE OUTLCDPORT movwf PORTB  ; port to which LCD connected
#DEFINE LCDDELAY movlw 60       ; delay used in LCDOUT routine
                                ; (60 seems ok for most LCDs/XTAL rate)
#DEFINE PAUSEDELAY movlw 5      ; sets initial pause before LCD is initialised
                                ; value must be set so delay is 1/5th sec minimum
                                ; in relation TMR0 setting and XTAL rate  
        CBLOCK
RSLINE
LCDSTORE
LCDCLKCNT
LCDLOOP
LOOP
        ENDC

; ******** START OF LCD ROUTINES **********

LCD1    movlw B'10000000'  ; calling these sets the LCD cell at which
        goto LCDLIN        ; next character is displayed
LCD2    movlw B'10000001'
        goto LCDLIN
LCD3    movlw B'10000010'
        goto LCDLIN
LCD4    movlw B'10000011'
        goto LCDLIN
LCD5    movlw B'10000100'
        goto LCDLIN
LCD6    movlw B'10000101'
        goto LCDLIN
LCD7    movlw B'10000110'
        goto LCDLIN
LCD8    movlw B'10000111'
        goto LCDLIN
LCD9    movlw B'10001000'
        goto LCDLIN
LCD10   movlw B'10001001'
        goto LCDLIN
LCD11   movlw B'10001010'
        goto LCDLIN
LCD12   movlw B'10001011'
        goto LCDLIN
LCD13   movlw B'10001100'
        goto LCDLIN
LCD14   movlw B'10001101'
        goto LCDLIN
LCD15   movlw B'10001110'
        goto LCDLIN
LCD16   movlw B'10001111'
        goto LCDLIN

LCD21   movlw B'11000000'
        goto LCDLIN
LCD22   movlw B'11000001'
        goto LCDLIN
LCD23   movlw B'11000010'
        goto LCDLIN
LCD24   movlw B'11000011'
        goto LCDLIN
LCD25   movlw B'11000100'
        goto LCDLIN
LCD26   movlw B'11000101'
        goto LCDLIN
LCD27   movlw B'11000110'
        goto LCDLIN
LCD28   movlw B'11000111'
        goto LCDLIN
LCD29   movlw B'11001000'
        goto LCDLIN
LCD2A   movlw B'11001001'
        goto LCDLIN
LCD2B   movlw B'11001010'
        goto LCDLIN
LCD2C   movlw B'11001011'
        goto LCDLIN
LCD2D   movlw B'11001100'
        goto LCDLIN
LCD2E   movlw B'11001101'
        goto LCDLIN
LCD2F   movlw B'11001110'
        goto LCDLIN
LCD216  movlw B'11001111'

LCDLIN  BCF RSLINE,4

; ********* MAIN SEND TO LCD ROUTINE ********

LCDOUT  movwf LCDSTORE   ; temp store value that will be output to LCD
        LCDDELAY         ; set minimum time between sending full bytes to
        movwf LCDLOOP    ; LCD delay between sending commands
DELAY   decfsz LCDLOOP,F 
        goto DELAY
        call SENDIT      ; send MSB, then (by default) send LSB

SENDIT  swapf LCDSTORE,F ; swap byte nibbles
        movf LCDSTORE,W  ; get nibble (MSB)
        andlw 15         ; AND to isolate nibble
        iorwf RSLINE,W   ; OR the RS bit
        OUTLCDPORT       ; must be defined - e.g. #DEFINE OUTLCDPORT movwf PORTB
        LCDELINEHI       ; must be defined - e.g. #DEFINE LCDELINEHI bsf PORTB,5
        LCDELINELO       ; must be defined - e.g. #DEFINE OUTLCDPORT movwf PORTB
        return

; ************* routines for full clearing of an LCD line *****

CLRLINE1  call LCD1      ; set address for line 1 cell 1
        bsf RSLINE,4     ; set RS for data send
        clrf LOOP        
CLRL1   movlw ' '        ; clear cell
        call LCDOUT      
        incf LOOP,F      ; inc loop
        btfss LOOP,4     ; has last LCD letter been sent?
        goto CLRL1       ; no
        return

CLRLINE2  call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2     movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

; ************** LCD INITIALISATION *********

LCDPAUSIT PAUSEDELAY     ; 1/5th sec wait after power on before setting up LCD
        movwf LCDCLKCNT
        clrf INTCON      ; clear interupt flag
LCDPAUSE                 ; initial 1/5th sec wait before setting up LCD
        btfss INTCON,2   ; has a timer time-out been detected?
        goto LCDPAUSE    ; no
        BCF INTCON,2     ; yes
        decfsz LCDCLKCNT,F ; dec loop, is it zero?
        goto LCDPAUSE    ; no
        return           ; yes

LCDSETUP
        call LCDPAUSIT
        clrf RSLINE     ; clear RS line for instruction send
        movlw %00110011 ;initialise lcd - first byte
        call LCDOUT
        movlw %00110011 ;2nd byte (repeat of first)
        call LCDOUT
        movlw %00110010 ;set for 4-bit operation
        call LCDOUT
        movlw %00101100 ;set for 2 lines
        call LCDOUT
        movlw %00000110 ;set entry mode to increment each address
        call LCDOUT
        movlw %00001100 ;set display on, cursor off, blink off
        call LCDOUT
        movlw %00000001 ;clear display
        call LCDOUT
        movlw %00000010 ;return home, cursor & RAM to zero
        bsf RSLINE,4    ; set RS for data send
        call LCDPAUSIT
        return
                        ;end inititalisation table
