; TK3TUT8.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; using single switch on Port A to increment Port B LED count
 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
COUNT           EQU H'20'               ; name location H'20' as variable called COUNT

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5
                 
                clrf PORTA              ; clear Port A data register
                clrf PORTB              ; clear Port B data register
                BANK1                   ; BANK 1
                movlw B'00000001'       ; this binary value shows which bits are set to 1
                                        ; in this case, only bit 0 is set to 1 and the value
                movwf TRISA             ; is used to set Port A with pin RA0 as input
                                        ; and pins RA1, RA2, RA3 and RA4 as outputs
                                        ; (but will not be used in this example)
                clrf TRISB              ; Port B is set with all pins as outputs as before
                BANK0                   ; BANK 0
                 
BEGIN           clrf COUNT              ; clear counter
LOOP            movf PORTA,W            ; copy the value of PORTA into W
                andlw B'00000001'       ; the value is ANDed with binary 1 so that only
                                        ; the status of the first bit (bit 0) of Port A will
                                        ; have any effect
                addwf COUNT,F           ; the value of Port A bit 0 is added to the counter
                                        ; if switch is pressed bit 0 = 1;
                                        ; if switch is unpressed bit 0 = 0
                movf COUNT,W            ; copy the value of COUNT into W
                movwf PORTB             ; and set Port B to that value
                goto LOOP               ; in this example, the loop is repeated endlessly
                 
                end                     ; final statement
