; TK3TUT35.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2 (prev tut36)
; A simple program which makes use of an externally switch generated
; interrupt to increment a count on PORTA is as follows:
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
                 
                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO INTRPT             ; go to interrupt routine
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA
                movlw B'00000001'
                movwf TRISB
                movlw B'11000111'       ; set timer to max (1:256 = TMR0 value)
                movwf OPTION_REG        ; (light pull-ups off - bit 7 high)
                BANK0

                movlw B'10010000'
                movwf INTCON
                 
START           nop 
                goto START
                 
INTRPT          movlw 2
		addwf PORTB,F
                bcf INTCON,1
                retfie 
                 
                end 
