; TK3TUT30.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; as TK3TUT29 but shorter looped code
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

INDF            EQU 0			; indirect register
OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
FSR             EQU 4                   ; indirect register pointer
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag
                 
LOOP            EQU H'20'               ; loop counter 1 - general
CLKCNT          EQU H'21'               ; pre-counter for CLOCK
CLKSEC          EQU H'22'               ; CLOCK main counter - secs
CLKMIN          EQU H'23'               ; CLOCK - mins
CLKHRS          EQU H'24'               ; CLOCK - hours
STORE1          EQU H'25'               ; general store 1
STORE2          EQU H'26'               ; general store 2
RSLINE          EQU H'27'               ; RS line flag for LCD
LOOPA           EQU H'28'               ; loop counter for LCD

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                clrf TRISA              ; Port A0-A4 as output
                clrf TRISB		; PORTB as output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)

                goto SETUP
                 
TABLCD          addwf PCL,F             ; LCD initialisation table
                retlw B'00110011'       ; initialise lcd - first byte
                retlw B'00110011'       ; 2nd byte (repeat of first)
                retlw B'00110010'       ; set for 4-bit operation
                retlw B'00101100'       ; set for 2 lines
                retlw B'00000110'       ; set entry mode to increment each address
                retlw B'00001100'       ; set display on, cursor off, blink off
                retlw B'00000001'       ; clear display
                retlw B'00000010'       ; return home, cursor & RAM to zero
                                        ; end inititalisation table
                 
MESSAG          addwf PCL,F
                retlw 'T'
                retlw 'I'
                retlw 'M'
                retlw 'E'
                retlw ' '
                retlw 'N'
                retlw 'O'
                retlw 'W'
                 
CHKVAL          addwf PCL,F             ; table for max count for time values
                retlw B'01011001'       ; 59 secs max
                retlw B'01011001'       ; 59 mins max
                retlw B'00100011'       ; 23 hours max
                 
SETUP           call PAUSIT             ; 1st 1/5th sec delay
LCDSET          clrf LOOP               ; clear LCD set-up loop
                clrf RSLINE             ; clear RS line for instruction send
LCDST2          movf LOOP,W             ; get table address
                call TABLCD             ; get set-up instruction
                call LCDOUT             ; perform it
                incf LOOP,F             ; inc loop
                btfss LOOP,3            ; has last LCD set-up instruction now been done?
                goto LCDST2             ; no
                call PAUSIT		; 1/5th sec delay
                 
LCDMSG          clrf LOOP               ; clear loop
                bsf RSLINE,4            ; set RS for data send
LCDMS2          movf LOOP,W             ; get table address
                call MESSAG             ; get message letter
                call LCDOUT             ; show it
                incf LOOP,F             ; inc loop
                btfss LOOP,3            ; has last LCD letter been sent?
                goto LCDMS2             ; no, repeat for next
                 
                clrf CLKSEC             ; clear seconds counter
                clrf CLKMIN             ; clear minutes counter
                clrf CLKHRS             ; clear hours counter
                 
                movlw 25                ; initial basic CLKCNT val for secs timing
                movwf CLKCNT
                 
MAIN            btfss INTCON,2          ; has a timer time-out been detected?
                goto MAIN               ; no
                bcf INTCON,2            ; yes
                call CLKADD             ; update time
                goto MAIN
                 
CLKADD          decfsz CLKCNT,F         ; increment system clock counter. Is it = 0?
                return                  ; no
                 
                movlw 25                ; yes, reset start value of CLKCNT
                movwf CLKCNT
                movlw CLKSEC            ; get address of CLKSEC
                movwf FSR               ; move it into Indirect address reg
                movlw 3                 ; set loop for 3
                movwf LOOP
                clrf STORE1             ; clear STORE1 (table address counter)
                 
ADDCLK          incf INDF,F             ; inc time units - all in BCD, via Indirect reg,
                                        ; byte accessed depends on loop value
                movlw 6                 ; check units >9
                addwf INDF,W            ; if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf INDF              ; yes, store new value
ADDCL2          movf STORE1,W           ; now check if value > allowed value
                call CHKVAL             ; get max val for time byte
                movwf STORE2            ; temp store it
                movf INDF,W             ; get value now in time byte
                subwf STORE2,F          ; is count =<  than allowed?
                                        ; (subtract time byte from max val in STORE)
                btfsc STATUS,C          ; is Carry bit set
                goto CLKSHW             ; yes
                clrf INDF               ; no, so time val is greater than max, so clear it
                incf STORE1,F           ; and add 1 to max val loop
                incf FSR,F              ; inc indirect address by 1 byte
                decfsz LOOP,F           ; dec loop, is it zero?
                goto ADDCLK             ; no, so repeat for next time byte
                 
CLKSHW          movlw B'11000000'       ; show time
                call LCDLIN             ; set address for line 2 cell 0
                movf CLKHRS,W           ; get hrs
                call LCDFRM             ; format and sent it to LCD
                movlw ':'               ; colon
                call LCDOUT             ; send to LCD
                movf CLKMIN,W           ; get mins
                call LCDFRM             ; format and send to LCD
                movlw '.'               ; decimal point
                call LCDOUT             ; send to LCD
                movf CLKSEC,W           ; get secs
                call LCDFRM             ; format and send to LCD
		return                 

LCDFRM          movwf STORE2            ; split & format decimal byte for LCD
                swapf STORE2,W          ; swap byte into W to get tens
                andlw 15                ; AND to get nibble
                iorlw 48                ; OR with 48 to make ASCII value
                call LCDOUT             ; send to LCD
                movf STORE2,W           ; get units
                andlw 15                ; AND to get nibble
                iorlw 48                ; OR with 48 to make ASCII value
		call LCDOUT		; send to LCD
		return
                 
LCDOUT          movwf STORE1            ; temp store value that will be output to LCD
                movlw 50                ; set minimum time between sending full bytes to
                movwf LOOPA             ; LCD - value of 50 seems OK for this prog with
DELAY           decfsz LOOPA,F          ; XTAL clk of upto 5MHz, possibly 5.5MHz
                goto DELAY
                call SENDIT             ; send MSB, then (by default) send LSB
                 
SENDIT          swapf STORE1,F          ; swap byte nibbles
                movf STORE1,W           ; get nibble (MSB)
                andlw 15                ; AND to isolate nibble
                iorwf RSLINE,W          ; OR the RS bit
                movwf PORTB             ; output the byte
                bsf PORTB,5             ; set E high
                bcf PORTB,5             ; set E low
                return 
                 
LCDLIN          bcf RSLINE,4            ; sets LCD command/line
                call LCDOUT             ; and outputs cmmand code to LCD
                bsf RSLINE,4            ; set RS flag
                return 
                 
PAUSIT          movlw 5                 ; 1/5th sec wait set
                movwf CLKCNT
                clrf INTCON             ; clear interupt flag
PAUSE                                   ; initial 1/5th sec wait before setting up LCD
                btfss INTCON,2          ; has a timer time-out been detected?
                goto PAUSE              ; no
                bcf INTCON,2            ; yes
                decfsz CLKCNT,F         ; dec loop, is it zero?
                goto PAUSE              ; no
                return                  ; yes
                 
                end                     ; final line
