; TK3TUT18.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; 4 switches on RA0-RA3 cause one of 4 notes on RA4
; also shows use of a Table and PCL to selectively route program flow
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
PCL             EQU 2                   ; Program Counter
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
                 
NOTE1           EQU H'20'               ; note 1 counter
NOTE2           EQU H'21'               ; note 2 counter
NOTE3           EQU H'22'               ; note 3 counter
NOTE4           EQU H'23'               ; note 4 counter
FREQ1           EQU H'24'               ; note 1 tuning value
FREQ2           EQU H'25'               ; note 2 tuning value
FREQ3           EQU H'26'               ; note 3 tuning value
FREQ4           EQU H'27'               ; note 4 tuning value

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00001111'       ; RA4 as output, RA0-RA3 as input
                movwf TRISA
                clrf TRISB
                BANK0

                goto PRESET             ; bypass Table and go to PRESET
                 
TABLE           andlw B'00001111'       ; AND switch val with 00001111
                addwf PCL,F             ; add answer to the Program counter
                return                  ; 0 - if val = 0 return with no note action
                goto PLAY1              ; 1 - if val = 1 go and play Note 1
                goto PLAY2              ; 2 - if val = 2 go and play Note 2
                return                  ; 3 - if val = 3 return with no note action
                goto PLAY3              ; 4 - if val = 4 go and play Note 3
                return                  ; 5
                return                  ; 6
                return                  ; 7
                goto PLAY4              ; 8 - if val = 8 go and play Note 4
                return                  ; 9
                return                  ; 10
                return                  ; 11
                return                  ; 12
                return                  ; 13
                return                  ; 14
                return                  ; 15
                 
PRESET          movlw 80                ; freq val for NOTE1/FREQ1
                movwf NOTE1
                movwf FREQ1
                movlw 110               ; freq val for NOTE2/FREQ2
                movwf NOTE2
                movwf FREQ2
                movlw 140               ; freq val for NOTE3/FREQ3
                movwf NOTE3
                movwf FREQ3
                movlw 160               ; freq val for NOTE4/FREQ4
                movwf NOTE4
                movwf FREQ4
                 
GETKEY          movf PORTA,W
                call TABLE              ; route program flow depending on switch val
                goto GETKEY
                 
PLAY1           decfsz NOTE1,F          ; decrement NOTE1, is it = 0?
                return                  ; no
                movf FREQ1,W            ; yes, get val in FREQ1
                movwf NOTE1             ; and copy it into NOTE1 as its reset val
                goto OUTPUT             ; go to OUTPUT
                 
PLAY2           decfsz NOTE2,F          ; as for NOTE1
                return 
                movf FREQ2,W
                movwf NOTE2
                goto OUTPUT
                 
PLAY3           decfsz NOTE3,F          ; as for NOTE1
                return 
                movf FREQ3,W
                movwf NOTE3
                goto OUTPUT
                 
PLAY4           decfsz NOTE4,F          ; as for NOTE1
                return 
                movf FREQ4,W
                movwf NOTE4             ; observe absence of GOTO command here
                 
OUTPUT          movlw B'00010000'       ; move 16 into W (00010000)
                addwf PORTA,F           ; increment Port A bit 4
                return                  ; go back to calling point within GETKEY
                 
                end                     ; final statement
